/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.rc4;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.util.SocketWrapperSocket;
import rice.environment.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptedSocket<Identifier>
extends SocketWrapperSocket<Identifier, Identifier> {
    public Cipher encryptCipher;
    public Cipher decryptCipher;
    SecretKey key;
    byte[] encryptedBytes;
    ByteBuffer encryptedWriteBuffer;

    public EncryptedSocket(Identifier identifier, P2PSocket<Identifier> socket, Logger logger, Map<String, Object> options, Cipher encryptCipher, Cipher decryptCipher, int writeBufferSize) {
        super(identifier, socket, logger, options);
        this.encryptedBytes = new byte[writeBufferSize];
        this.encryptedWriteBuffer = ByteBuffer.wrap(this.encryptedBytes);
        this.encryptedWriteBuffer.limit(0);
        this.encryptCipher = encryptCipher;
        this.decryptCipher = decryptCipher;
    }

    @Override
    public long read(ByteBuffer output) throws IOException {
        ByteBuffer input = ByteBuffer.allocate(output.remaining());
        long ret = this.socket.read(input);
        if (ret < 0L) {
            return ret;
        }
        input.flip();
        try {
            return this.decryptCipher.update(input, output);
        }
        catch (ShortBufferException sbe) {
            this.logger.logException("We got a short buffer exception reading. This indicates a bug in the implementation. " + this, sbe);
            this.socket.close();
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer srcs) throws IOException {
        long ret;
        ByteBuffer byteBuffer = this.encryptedWriteBuffer;
        synchronized (byteBuffer) {
            if (this.encryptedWriteBuffer.limit() != 0) {
                return 0L;
            }
            ret = this.writeHelper(srcs);
        }
        if (ret < 0L) {
            this.close();
        }
        return ret;
    }

    protected long writeHelper(ByteBuffer srcs) throws IOException {
        long ret;
        int len = Math.min(this.encryptedBytes.length - this.encryptedWriteBuffer.limit(), srcs.remaining());
        if (len == 0) {
            return 0L;
        }
        try {
            this.encryptCipher.update(srcs.array(), srcs.position(), len, this.encryptedBytes, this.encryptedWriteBuffer.limit());
            srcs.position(srcs.position() + len);
            this.encryptedWriteBuffer.limit(this.encryptedWriteBuffer.limit() + len);
            ret = this.socket.write(this.encryptedWriteBuffer);
        }
        catch (ShortBufferException sbe) {
            this.logger.logException("We got a short buffer exception reading. This indicates a bug in the implementation. " + this, sbe);
            return -1L;
        }
        if (ret < 0L) {
            return ret;
        }
        if (this.encryptedWriteBuffer.hasRemaining()) {
            this.socket.register(false, true, this);
            return len;
        }
        this.encryptedWriteBuffer.position(0);
        this.encryptedWriteBuffer.limit(0);
        if (srcs.hasRemaining()) {
            long recursiveLen = this.writeHelper(srcs);
            if (recursiveLen < 0L) {
                return recursiveLen;
            }
            return (long)len + recursiveLen;
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
        boolean registerToWrite = false;
        ByteBuffer byteBuffer = this.encryptedWriteBuffer;
        synchronized (byteBuffer) {
            if (canWrite && this.encryptedWriteBuffer.hasRemaining()) {
                long ret = socket.write(this.encryptedWriteBuffer);
                if (ret < 0L) {
                    this.receiveException(socket, (Exception)new ClosedChannelException("Socket was closed while writing buffered encrypted bytes."));
                    return;
                }
                if (this.encryptedWriteBuffer.hasRemaining()) {
                    registerToWrite = true;
                    canWrite = false;
                } else {
                    this.encryptedWriteBuffer.position(0);
                    this.encryptedWriteBuffer.limit(0);
                    canWrite = this.writer != null;
                }
            }
        }
        if (registerToWrite) {
            socket.register(false, true, this);
        }
        if (canRead || canWrite) {
            super.receiveSelectResult(socket, canRead, canWrite);
        }
    }
}

