/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.proximity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mpisws.p2p.transport.liveness.PingListener;
import org.mpisws.p2p.transport.liveness.Pinger;
import org.mpisws.p2p.transport.proximity.ProximityListener;
import org.mpisws.p2p.transport.proximity.ProximityProvider;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.time.TimeSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinRTTProximityProvider<Identifier>
implements ProximityProvider<Identifier>,
PingListener<Identifier> {
    public int PROX_TIMEOUT;
    Map<Identifier, EntityManager> managers;
    Pinger<Identifier> tl;
    Logger logger;
    TimeSource time;
    int pingThrottle = 5000;
    Collection<ProximityListener<Identifier>> listeners = new ArrayList<ProximityListener<Identifier>>();

    public MinRTTProximityProvider(Pinger<Identifier> tl, Environment env) {
        this.tl = tl;
        this.logger = env.getLogManager().getLogger(MinRTTProximityProvider.class, null);
        this.time = env.getTimeSource();
        tl.addPingListener(this);
        this.managers = new HashMap<Identifier, EntityManager>();
    }

    @Override
    public int proximity(Identifier i, Map<String, Object> options) {
        EntityManager manager = this.getManager(i);
        int ret = manager.proximity;
        if (ret == 3600000) {
            manager.ping(options);
        }
        return ret;
    }

    @Override
    public void pingResponse(Identifier i, int rtt, Map<String, Object> options) {
        this.getManager(i).markProximity(rtt, options);
    }

    @Override
    public void pingReceived(Identifier i, Map<String, Object> options) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearState(Identifier i) {
        Map<Identifier, EntityManager> map = this.managers;
        synchronized (map) {
            this.managers.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManager getManager(Identifier i) {
        Map<Identifier, EntityManager> map = this.managers;
        synchronized (map) {
            EntityManager manager = this.managers.get(i);
            if (manager == null) {
                manager = new EntityManager(i);
                if (this.logger.level <= 400) {
                    this.logger.log("Creating EM for " + i);
                }
                this.managers.put(i, manager);
            }
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProximityListener(ProximityListener<Identifier> listener) {
        Collection<ProximityListener<Identifier>> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeProximityListener(ProximityListener<Identifier> listener) {
        Collection<ProximityListener<Identifier>> collection = this.listeners;
        synchronized (collection) {
            return this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyProximityListeners(Identifier i, int prox, Map<String, Object> options) {
        ArrayList<ProximityListener<Identifier>> temp;
        Collection<ProximityListener<Identifier>> collection = this.listeners;
        synchronized (collection) {
            temp = new ArrayList<ProximityListener<Identifier>>(this.listeners);
        }
        for (ProximityListener proximityListener : temp) {
            proximityListener.proximityChanged(i, prox, options);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntityManager {
        protected Identifier identifier;
        protected int proximity;
        protected long lastPingTime = Integer.MIN_VALUE;

        public EntityManager(Identifier route) {
            if (route == null) {
                throw new IllegalArgumentException("route is null");
            }
            this.identifier = route;
            this.proximity = 3600000;
        }

        public void ping(Map<String, Object> options) {
            long now = MinRTTProximityProvider.this.time.currentTimeMillis();
            if (now - this.lastPingTime < (long)MinRTTProximityProvider.this.pingThrottle) {
                if (MinRTTProximityProvider.this.logger.level <= 500) {
                    MinRTTProximityProvider.this.logger.log("Dropping ping because pingThrottle." + ((long)MinRTTProximityProvider.this.pingThrottle - (now - this.lastPingTime)));
                }
                return;
            }
            this.lastPingTime = now;
            MinRTTProximityProvider.this.tl.ping(this.identifier, options);
        }

        public int proximity() {
            return this.proximity;
        }

        protected void markProximity(int proximity, Map<String, Object> options) {
            if (proximity < 0) {
                throw new IllegalArgumentException("proximity must be >= 0, was:" + proximity);
            }
            if (MinRTTProximityProvider.this.logger.level <= 400) {
                MinRTTProximityProvider.this.logger.log(this + ".markProximity(" + proximity + ")");
            }
            if (this.proximity > proximity) {
                if (MinRTTProximityProvider.this.logger.level <= 500) {
                    MinRTTProximityProvider.this.logger.log(this + " updating proximity to " + proximity);
                }
                this.proximity = proximity;
                MinRTTProximityProvider.this.notifyProximityListeners(this.identifier, proximity, options);
            }
        }

        public String toString() {
            return this.identifier.toString();
        }
    }
}

