/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.replay.record;

import rice.environment.logging.LogManager;
import rice.environment.time.TimeSource;
import rice.environment.time.simulated.DirectTimeSource;
import rice.selector.SelectorManager;
import rice.selector.TimerTask;

public class RecordSM
extends SelectorManager {
    DirectTimeSource simTime;
    TimeSource realTime;

    public RecordSM(String instance, TimeSource realTime, DirectTimeSource simTime, LogManager log) {
        super(instance, simTime, log);
        this.realTime = realTime;
        this.simTime = simTime;
    }

    protected synchronized void addTask(TimerTask task) {
        long now = this.timeSource.currentTimeMillis();
        if (task.scheduledExecutionTime() < now && this.timeSource instanceof DirectTimeSource) {
            if (this.logger.level <= 900) {
                this.logger.logException("Can't schedule a task in the past. " + task + " now:" + now + " task.execTime:" + task.scheduledExecutionTime(), new Exception("Stack Trace"));
            }
            throw new RuntimeException("Can't schedule a task in the past.");
        }
        super.addTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeDueTasks() {
        long now = this.realTime.currentTimeMillis();
        boolean done = false;
        while (!done) {
            TimerTask next = null;
            RecordSM recordSM = this;
            synchronized (recordSM) {
                if (this.timerQueue.size() > 0) {
                    next = (TimerTask)this.timerQueue.peek();
                    if (next.scheduledExecutionTime() <= now) {
                        this.timerQueue.poll();
                        this.simTime.setTime(next.scheduledExecutionTime());
                    } else {
                        done = true;
                    }
                } else {
                    done = true;
                }
            }
            if (done) continue;
            super.doInvocations();
            if (this.logger.level <= 500) {
                this.logger.log("executing task " + next);
            }
            if (!next.execute(this.simTime)) continue;
            recordSM = this;
            synchronized (recordSM) {
                this.timerQueue.add(next);
            }
        }
        this.simTime.setTime(now);
        super.doInvocations();
    }

    protected void doInvocations() {
    }
}

