/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview.history;

import java.io.IOException;
import org.mpisws.p2p.transport.peerreview.PeerReviewEvents;
import org.mpisws.p2p.transport.peerreview.history.Hash;
import org.mpisws.p2p.transport.peerreview.history.HashProvider;
import org.mpisws.p2p.transport.peerreview.history.IndexEntry;
import org.mpisws.p2p.transport.peerreview.history.IndexEntryFactory;
import org.mpisws.p2p.transport.peerreview.history.SecureHistory;
import org.mpisws.p2p.transport.peerreview.history.SecureHistoryFactory;
import org.mpisws.p2p.transport.peerreview.history.SecureHistoryImpl;
import rice.environment.Environment;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.util.RandomAccessFileIOBuffer;

public class SecureHistoryFactoryImpl
implements SecureHistoryFactory,
IndexEntryFactory,
PeerReviewEvents {
    Environment environment;
    HashProvider hashProv;

    public SecureHistoryFactoryImpl(HashProvider hashProv, Environment env) {
        this.hashProv = hashProv;
        this.environment = env;
    }

    public SecureHistory create(String name, long baseSeq, Hash baseHash) throws IOException {
        RandomAccessFileIOBuffer dataFile;
        if (name == null) {
            name = "peerReview." + this.environment.getTimeSource().currentTimeMillis() + "." + this.environment.getRandomSource().nextInt();
        }
        String indexName = name + ".index";
        String dataName = name + ".data";
        RandomAccessFileIOBuffer indexFile = new RandomAccessFileIOBuffer(indexName, "rw");
        try {
            dataFile = new RandomAccessFileIOBuffer(dataName, "rw");
        }
        catch (IOException ioe) {
            indexFile.close();
            throw ioe;
        }
        IndexEntry entry = new IndexEntry(baseSeq, 0L, 5, -1, this.hashProv.getEmpty(), baseHash);
        entry.serialize(indexFile);
        SecureHistoryImpl history = new SecureHistoryImpl(indexFile, dataFile, false, this.hashProv, this, this.environment.getLogManager().getLogger(SecureHistoryImpl.class, name));
        return history;
    }

    public SecureHistory open(String name, String mode) throws IOException {
        RandomAccessFileIOBuffer dataFile;
        boolean readOnly = false;
        if (!mode.equals("r")) {
            readOnly = true;
        } else if (mode.equals("w")) {
            return null;
        }
        String fileMode = readOnly ? "r" : "rw";
        RandomAccessFileIOBuffer indexFile = new RandomAccessFileIOBuffer(name + ".index", fileMode);
        try {
            dataFile = new RandomAccessFileIOBuffer(name + ".data", fileMode);
        }
        catch (IOException ioe) {
            indexFile.close();
            throw ioe;
        }
        return new SecureHistoryImpl(indexFile, dataFile, readOnly, this.hashProv, this, this.environment.getLogManager().getLogger(SecureHistoryImpl.class, name));
    }

    public IndexEntry build(InputBuffer buf) throws IOException {
        long seq = buf.readLong();
        long fileIndex = buf.readLong();
        int sizeInFile = buf.readInt();
        short type = buf.readShort();
        Hash contentHash = this.hashProv.build(buf);
        Hash nodeHash = this.hashProv.build(buf);
        return new IndexEntry(seq, fileIndex, type, sizeInFile, contentHash, nodeHash);
    }

    public int getSerializedSize() {
        return 22 + this.hashProv.getSerizlizedSize() * 2;
    }
}

