/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.networkinfo;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mpisws.p2p.transport.ClosedChannelException;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.networkinfo.CantVerifyConnectivityException;
import org.mpisws.p2p.transport.networkinfo.ConnectivityResult;
import org.mpisws.p2p.transport.networkinfo.InetSocketAddressLookup;
import org.mpisws.p2p.transport.networkinfo.NetworkInfoIOException;
import org.mpisws.p2p.transport.networkinfo.ProbeStrategy;
import org.mpisws.p2p.transport.networkinfo.Prober;
import org.mpisws.p2p.transport.simpleidentity.InetSocketAddressSerializer;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.util.InsufficientBytesException;
import org.mpisws.p2p.transport.util.MessageRequestHandleImpl;
import org.mpisws.p2p.transport.util.SocketInputBuffer;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Cancellable;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.util.AttachableCancellable;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkInfoTransportLayer
implements InetSocketAddressLookup,
Prober,
TransportLayer<InetSocketAddress, ByteBuffer>,
TransportLayerCallback<InetSocketAddress, ByteBuffer> {
    protected Logger logger;
    protected Environment environment;
    protected TransportLayerCallback<InetSocketAddress, ByteBuffer> callback;
    protected ErrorHandler<InetSocketAddress> errorHandler;
    protected TransportLayer<InetSocketAddress, ByteBuffer> tl;
    protected static final byte HEADER_PASSTHROUGH_BYTE = 0;
    protected static final byte HEADER_IP_ADDRESS_REQUEST_BYTE = 1;
    protected static final byte HEADER_PROBE_REQUEST_BYTE = 2;
    protected static final byte HEADER_PROBE_RESPONSE_BYTE = 3;
    protected static final byte HEADER_NODES_REQUEST_BYTE = 4;
    protected static final byte[] HEADER_PASSTHROUGH = new byte[]{0};
    protected static final byte[] HEADER_IP_ADDRESS_REQUEST = new byte[]{1};
    protected static final byte[] HEADER_NODES_REQUEST = new byte[]{4};
    InetSocketAddressSerializer addrSerializer = new InetSocketAddressSerializer();
    protected ProbeStrategy probeStrategy;
    Map<Long, ConnectivityResult> verifyConnectionRequests = new HashMap<Long, ConnectivityResult>();

    public NetworkInfoTransportLayer(TransportLayer<InetSocketAddress, ByteBuffer> tl, Environment env, ErrorHandler<InetSocketAddress> errorHandler) {
        this.logger = env.getLogManager().getLogger(NetworkInfoTransportLayer.class, null);
        this.environment = env;
        this.tl = tl;
        this.errorHandler = errorHandler;
        if (this.errorHandler == null) {
            this.errorHandler = new DefaultErrorHandler<InetSocketAddress>(this.logger);
        }
        tl.setCallback(this);
    }

    @Override
    public Cancellable getMyInetAddress(InetSocketAddress bootstrap, final Continuation<InetSocketAddress, IOException> c, Map<String, Object> options) {
        AttachableCancellable ret = new AttachableCancellable();
        ret.attach(this.openSocket(bootstrap, HEADER_IP_ADDRESS_REQUEST, new SocketCallback<InetSocketAddress>(){

            @Override
            public void receiveResult(SocketRequestHandle<InetSocketAddress> cancellable, P2PSocket<InetSocketAddress> sock) {
                final SocketInputBuffer sib = new SocketInputBuffer(sock);
                try {
                    new P2PSocketReceiver<InetSocketAddress>(){

                        @Override
                        public void receiveSelectResult(P2PSocket<InetSocketAddress> socket, boolean canRead, boolean canWrite) throws IOException {
                            try {
                                InetSocketAddress addr = NetworkInfoTransportLayer.this.addrSerializer.deserialize((InputBuffer)sib, null, null);
                                c.receiveResult(addr);
                            }
                            catch (InsufficientBytesException ibe) {
                                socket.register(true, false, this);
                            }
                            catch (IOException e) {
                                c.receiveException(e);
                            }
                        }

                        @Override
                        public void receiveException(P2PSocket<InetSocketAddress> socket, Exception ioe) {
                            if (ioe instanceof IOException) {
                                c.receiveException((IOException)ioe);
                            }
                            c.receiveException(new NetworkInfoIOException(ioe));
                        }
                    }.receiveSelectResult(sock, true, false);
                }
                catch (IOException ioe) {
                    c.receiveException(ioe);
                }
            }

            @Override
            public void receiveException(SocketRequestHandle<InetSocketAddress> s, Exception ex) {
                if (ex instanceof IOException) {
                    c.receiveException((IOException)ex);
                }
                c.receiveException(new NetworkInfoIOException(ex));
            }
        }, options));
        return ret;
    }

    @Override
    public Cancellable getExternalNodes(InetSocketAddress bootstrap, final Continuation<Collection<InetSocketAddress>, IOException> c, Map<String, Object> options) {
        AttachableCancellable ret = new AttachableCancellable();
        ret.attach(this.openSocket(bootstrap, HEADER_NODES_REQUEST, new SocketCallback<InetSocketAddress>(){

            @Override
            public void receiveResult(SocketRequestHandle<InetSocketAddress> cancellable, P2PSocket<InetSocketAddress> sock) {
                final SocketInputBuffer sib = new SocketInputBuffer(sock);
                try {
                    new P2PSocketReceiver<InetSocketAddress>(){

                        @Override
                        public void receiveSelectResult(P2PSocket<InetSocketAddress> socket, boolean canRead, boolean canWrite) throws IOException {
                            try {
                                ArrayList<InetSocketAddress> ret = new ArrayList<InetSocketAddress>();
                                int numAddrs = sib.readByte();
                                for (int ctr = 0; ctr < numAddrs; ++ctr) {
                                    InetSocketAddress addr = NetworkInfoTransportLayer.this.addrSerializer.deserialize((InputBuffer)sib, null, null);
                                    ret.add(addr);
                                }
                                c.receiveResult(ret);
                            }
                            catch (InsufficientBytesException ibe) {
                                socket.register(true, false, this);
                            }
                            catch (IOException e) {
                                c.receiveException(e);
                            }
                        }

                        @Override
                        public void receiveException(P2PSocket<InetSocketAddress> socket, Exception ioe) {
                            if (ioe instanceof IOException) {
                                c.receiveException((IOException)ioe);
                            }
                            c.receiveException(new NetworkInfoIOException(ioe));
                        }
                    }.receiveSelectResult(sock, true, false);
                }
                catch (IOException ioe) {
                    c.receiveException(ioe);
                }
            }

            @Override
            public void receiveException(SocketRequestHandle<InetSocketAddress> s, Exception ex) {
                if (ex instanceof IOException) {
                    c.receiveException((IOException)ex);
                }
                c.receiveException(new NetworkInfoIOException(ex));
            }
        }, options));
        return ret;
    }

    @Override
    public SocketRequestHandle<InetSocketAddress> openSocket(InetSocketAddress i, SocketCallback<InetSocketAddress> deliverSocketToMe, Map<String, Object> options) {
        if (this.logger.level <= 750) {
            this.logger.log("openSocket(" + i + "," + deliverSocketToMe + "," + options + ")");
        }
        return this.openSocket(i, HEADER_PASSTHROUGH, deliverSocketToMe, options);
    }

    public SocketRequestHandle<InetSocketAddress> openSocket(final InetSocketAddress i, final byte[] header, final SocketCallback<InetSocketAddress> deliverSocketToMe, Map<String, Object> options) {
        if (this.logger.level <= 300) {
            this.logger.log("openSocket(" + i + "," + header.length + ")");
        }
        if (deliverSocketToMe == null) {
            throw new IllegalArgumentException("deliverSocketToMe must be non-null!");
        }
        final SocketRequestHandleImpl<InetSocketAddress> cancellable = new SocketRequestHandleImpl<InetSocketAddress>(i, options, this.logger);
        cancellable.setSubCancellable(this.tl.openSocket(i, new SocketCallback<InetSocketAddress>(){

            @Override
            public void receiveResult(SocketRequestHandle<InetSocketAddress> c, final P2PSocket<InetSocketAddress> result) {
                if (cancellable.getSubCancellable() != null && c != cancellable.getSubCancellable()) {
                    throw new RuntimeException("c != cancellable.getSubCancellable() (indicates a bug in the code) c:" + c + " sub:" + cancellable.getSubCancellable());
                }
                cancellable.setSubCancellable(new Cancellable(){

                    public boolean cancel() {
                        result.close();
                        return true;
                    }
                });
                result.register(false, true, new P2PSocketReceiver<InetSocketAddress>(){
                    ByteBuffer buf;
                    {
                        this.buf = ByteBuffer.wrap(header);
                    }

                    @Override
                    public void receiveSelectResult(P2PSocket<InetSocketAddress> socket, boolean canRead, boolean canWrite) throws IOException {
                        if (canRead) {
                            throw new IOException("Never asked to read!");
                        }
                        if (!canWrite) {
                            throw new IOException("Can't write!");
                        }
                        long ret = socket.write(this.buf);
                        if (ret < 0L) {
                            socket.close();
                            return;
                        }
                        if (NetworkInfoTransportLayer.this.logger.level <= 300) {
                            NetworkInfoTransportLayer.this.logger.log("openSocket(" + i + "," + header.length + ") wrote " + ret + ".  Remaining:" + this.buf.remaining());
                        }
                        if (this.buf.hasRemaining()) {
                            socket.register(false, true, this);
                        } else {
                            deliverSocketToMe.receiveResult(cancellable, socket);
                        }
                    }

                    @Override
                    public void receiveException(P2PSocket<InetSocketAddress> socket, Exception e) {
                        deliverSocketToMe.receiveException(cancellable, e);
                    }
                });
            }

            @Override
            public void receiveException(SocketRequestHandle<InetSocketAddress> c, Exception exception) {
                if (cancellable.getSubCancellable() != null && c != cancellable.getSubCancellable()) {
                    throw new RuntimeException("c != cancellable.getSubCancellable() (indicates a bug in the code) c:" + c + " sub:" + cancellable.getSubCancellable());
                }
                deliverSocketToMe.receiveException(cancellable, exception);
            }
        }, options));
        return cancellable;
    }

    @Override
    public void incomingSocket(final P2PSocket<InetSocketAddress> s) throws IOException {
        if (this.logger.level <= 300) {
            this.logger.log("incomingSocket(" + s + ")");
        }
        new P2PSocketReceiver<InetSocketAddress>(){
            ByteBuffer bb = ByteBuffer.allocate(HEADER_PASSTHROUGH.length);

            @Override
            public void receiveSelectResult(P2PSocket<InetSocketAddress> socket, boolean canRead, boolean canWrite) throws IOException {
                long bytesRead = socket.read(this.bb);
                if (NetworkInfoTransportLayer.this.logger.level <= 300) {
                    NetworkInfoTransportLayer.this.logger.log("incomingSocket(" + s + "): bytesRead = " + bytesRead + " remaining:" + this.bb.remaining());
                }
                if (bytesRead < 0L) {
                    socket.close();
                    return;
                }
                if (this.bb.hasRemaining()) {
                    socket.register(true, false, this);
                    return;
                }
                byte[] ret = this.bb.array();
                if (ret.length > 1) {
                    throw new RuntimeException("Make this work over the array, implementation expectes header to be 1 byte.");
                }
                if (NetworkInfoTransportLayer.this.logger.level <= 300) {
                    NetworkInfoTransportLayer.this.logger.log("incomingSocket(" + s + "): type = " + ret[0]);
                }
                switch (ret[0]) {
                    case 0: {
                        NetworkInfoTransportLayer.this.callback.incomingSocket(socket);
                        return;
                    }
                    case 1: {
                        NetworkInfoTransportLayer.this.handleIpRequest(socket);
                        return;
                    }
                    case 4: {
                        NetworkInfoTransportLayer.this.handleNodesRequest(socket);
                        return;
                    }
                    case 2: {
                        NetworkInfoTransportLayer.this.handleProbeRequest(socket);
                        return;
                    }
                    case 3: {
                        NetworkInfoTransportLayer.this.handleProbeResponse(socket);
                        return;
                    }
                }
                NetworkInfoTransportLayer.this.errorHandler.receivedUnexpectedData(socket.getIdentifier(), ret, 0, socket.getOptions());
            }

            @Override
            public void receiveException(P2PSocket<InetSocketAddress> socket, Exception ioe) {
                NetworkInfoTransportLayer.this.errorHandler.receivedException(socket.getIdentifier(), ioe);
            }
        }.receiveSelectResult(s, true, false);
    }

    public void handleIpRequest(P2PSocket<InetSocketAddress> socket) throws IOException {
        SimpleOutputBuffer sob = new SimpleOutputBuffer();
        if (this.logger.level <= 800) {
            this.logger.log("HEADER_IP_ADDRESS_REQUEST_BYTE serializing " + socket.getIdentifier());
        }
        this.addrSerializer.serialize(socket.getIdentifier(), (OutputBuffer)sob);
        final ByteBuffer writeMe = sob.getByteBuffer();
        new P2PSocketReceiver<InetSocketAddress>(){

            @Override
            public void receiveSelectResult(P2PSocket<InetSocketAddress> socket, boolean canRead, boolean canWrite) throws IOException {
                if (socket.write(writeMe) < 0L) {
                    socket.close();
                }
                if (writeMe.hasRemaining()) {
                    socket.register(false, true, this);
                } else {
                    socket.close();
                }
            }

            @Override
            public void receiveException(P2PSocket<InetSocketAddress> socket, Exception ioe) {
            }
        }.receiveSelectResult(socket, false, true);
    }

    public void handleNodesRequest(P2PSocket<InetSocketAddress> socket) throws IOException {
        SimpleOutputBuffer sob = new SimpleOutputBuffer();
        Collection<InetSocketAddress> ret = this.probeStrategy.getExternalAddresses();
        if (this.logger.level <= 800) {
            this.logger.log("serializing " + ret.size() + " external addresses for " + socket.getIdentifier());
        }
        if (ret.size() > 20) {
            ArrayList<InetSocketAddress> temp = new ArrayList<InetSocketAddress>(20);
            int ctr = 0;
            for (InetSocketAddress foo : ret) {
                temp.add(foo);
                if (++ctr <= 20) continue;
                break;
            }
            ret = temp;
        }
        sob.writeByte(ret.size());
        for (InetSocketAddress foo : ret) {
            this.addrSerializer.serialize(foo, (OutputBuffer)sob);
        }
        final ByteBuffer writeMe = sob.getByteBuffer();
        new P2PSocketReceiver<InetSocketAddress>(){

            @Override
            public void receiveSelectResult(P2PSocket<InetSocketAddress> socket, boolean canRead, boolean canWrite) throws IOException {
                if (socket.write(writeMe) < 0L) {
                    socket.close();
                }
                if (writeMe.hasRemaining()) {
                    socket.register(false, true, this);
                } else {
                    socket.close();
                }
            }

            @Override
            public void receiveException(P2PSocket<InetSocketAddress> socket, Exception ioe) {
            }
        }.receiveSelectResult(socket, false, true);
    }

    public void handleProbeRequest(final P2PSocket<InetSocketAddress> socket) {
        try {
            new P2PSocketReceiver<InetSocketAddress>(){
                SocketInputBuffer sib;
                {
                    this.sib = new SocketInputBuffer(socket);
                }

                @Override
                public void receiveSelectResult(final P2PSocket<InetSocketAddress> socket2, boolean canRead, boolean canWrite) throws IOException {
                    try {
                        MultiInetSocketAddress addr = MultiInetSocketAddress.build(this.sib);
                        long uid = this.sib.readLong();
                        NetworkInfoTransportLayer.this.probeStrategy.requestProbe(addr, uid, new Continuation<Boolean, Exception>(){

                            @Override
                            public void receiveResult(Boolean result) {
                                this.returnResult(result);
                            }

                            @Override
                            public void receiveException(Exception exception) {
                                this.returnResult(false);
                            }

                            public void returnResult(boolean ret) {
                                final ByteBuffer writeMe = ByteBuffer.allocate(1);
                                writeMe.put(ret ? (byte)1 : 0);
                                writeMe.flip();
                                try {
                                    new P2PSocketReceiver<InetSocketAddress>(){

                                        @Override
                                        public void receiveSelectResult(P2PSocket<InetSocketAddress> socket, boolean canRead, boolean canWrite) throws IOException {
                                            long bytesWritten = socket.write(writeMe);
                                            if (bytesWritten < 0L) {
                                                socket.close();
                                                return;
                                            }
                                            if (writeMe.hasRemaining()) {
                                                socket.register(false, true, this);
                                            } else {
                                                socket.close();
                                            }
                                        }

                                        @Override
                                        public void receiveException(P2PSocket<InetSocketAddress> socket, Exception ioe) {
                                            socket.close();
                                        }
                                    }.receiveSelectResult((P2PSocket<InetSocketAddress>)socket2, false, true);
                                }
                                catch (IOException ioe) {
                                    socket2.close();
                                }
                            }
                        });
                    }
                    catch (InsufficientBytesException ibe) {
                        socket2.register(true, false, this);
                    }
                }

                @Override
                public void receiveException(P2PSocket<InetSocketAddress> socket2, Exception ioe) {
                    socket2.close();
                }
            }.receiveSelectResult(socket, true, false);
        }
        catch (IOException ioe) {
            this.errorHandler.receivedException(socket.getIdentifier(), ioe);
            socket.close();
        }
    }

    public void handleProbeResponse(final P2PSocket<InetSocketAddress> socket) {
        try {
            new P2PSocketReceiver<InetSocketAddress>(){
                SocketInputBuffer sib;
                {
                    this.sib = new SocketInputBuffer(socket);
                }

                @Override
                public void receiveSelectResult(P2PSocket<InetSocketAddress> socket2, boolean canRead, boolean canWrite) throws IOException {
                    try {
                        long uid = this.sib.readLong();
                        NetworkInfoTransportLayer.this.verifyConnectionRequests.get(uid).tcpSuccess(socket2.getIdentifier(), socket2.getOptions());
                    }
                    catch (InsufficientBytesException ibe) {
                        socket2.register(true, false, this);
                    }
                }

                @Override
                public void receiveException(P2PSocket<InetSocketAddress> socket2, Exception ioe) {
                }
            }.receiveSelectResult(socket, true, false);
        }
        catch (IOException ioe) {
            this.errorHandler.receivedException(socket.getIdentifier(), ioe);
            socket.close();
        }
    }

    @Override
    public void setCallback(TransportLayerCallback<InetSocketAddress, ByteBuffer> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<InetSocketAddress> handler) {
        if (handler == null) {
            this.errorHandler = new DefaultErrorHandler<InetSocketAddress>(this.logger);
            return;
        }
        this.errorHandler = handler;
    }

    @Override
    public void acceptMessages(boolean b) {
        this.tl.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.tl.acceptSockets(b);
    }

    @Override
    public InetSocketAddress getLocalIdentifier() {
        return this.tl.getLocalIdentifier();
    }

    @Override
    public MessageRequestHandle<InetSocketAddress, ByteBuffer> sendMessage(InetSocketAddress i, ByteBuffer m, final MessageCallback<InetSocketAddress, ByteBuffer> deliverAckToMe, Map<String, Object> options) {
        final MessageRequestHandleImpl<InetSocketAddress, ByteBuffer> ret = new MessageRequestHandleImpl<InetSocketAddress, ByteBuffer>(i, m, options);
        ByteBuffer passThrough = ByteBuffer.allocate(m.remaining() + 1);
        passThrough.put((byte)0);
        passThrough.put(m);
        passThrough.flip();
        MessageCallback<InetSocketAddress, ByteBuffer> myCallback = null;
        if (deliverAckToMe != null) {
            myCallback = new MessageCallback<InetSocketAddress, ByteBuffer>(){

                @Override
                public void ack(MessageRequestHandle<InetSocketAddress, ByteBuffer> msg) {
                    deliverAckToMe.ack(ret);
                }

                @Override
                public void sendFailed(MessageRequestHandle<InetSocketAddress, ByteBuffer> msg, Exception reason) {
                    deliverAckToMe.sendFailed(ret, reason);
                }
            };
        }
        ret.setSubCancellable(this.tl.sendMessage(i, passThrough, myCallback, options));
        return ret;
    }

    @Override
    public void messageReceived(InetSocketAddress i, ByteBuffer m, Map<String, Object> options) throws IOException {
        byte header = m.get();
        switch (header) {
            case 0: {
                this.callback.messageReceived(i, m, options);
                return;
            }
            case 3: {
                long uid = m.getLong();
                this.verifyConnectionRequests.get(uid).udpSuccess(i, null);
            }
        }
    }

    @Override
    public void destroy() {
        this.verifyConnectionRequests.clear();
        this.tl.destroy();
    }

    public void setProbeStrategy(ProbeStrategy probeStrategy) {
        this.probeStrategy = probeStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cancellable verifyConnectivity(final MultiInetSocketAddress local, final InetSocketAddress probeAddress, final ConnectivityResult deliverResultToMe, Map<String, Object> options) {
        AttachableCancellable ret = new AttachableCancellable();
        final long uid = this.environment.getRandomSource().nextLong();
        if (this.logger.level <= 500) {
            this.logger.log("verifyConnectivity(" + local + "," + probeAddress + "):" + uid);
        }
        Map<Long, ConnectivityResult> map = this.verifyConnectionRequests;
        synchronized (map) {
            this.verifyConnectionRequests.put(uid, deliverResultToMe);
        }
        SimpleOutputBuffer sob = new SimpleOutputBuffer();
        try {
            sob.writeByte((byte)2);
            local.serialize(sob);
            sob.writeLong(uid);
        }
        catch (IOException ioe) {
            Map<Long, ConnectivityResult> map2 = this.verifyConnectionRequests;
            synchronized (map2) {
                this.verifyConnectionRequests.remove(uid);
            }
            deliverResultToMe.receiveException(ioe);
            return null;
        }
        ret.attach(new Cancellable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel() {
                Map<Long, ConnectivityResult> map = NetworkInfoTransportLayer.this.verifyConnectionRequests;
                synchronized (map) {
                    NetworkInfoTransportLayer.this.verifyConnectionRequests.remove(uid);
                }
                return true;
            }
        });
        ret.attach(this.openSocket(probeAddress, sob.getBytes(), new SocketCallback<InetSocketAddress>(){

            @Override
            public void receiveResult(SocketRequestHandle<InetSocketAddress> cancellable, P2PSocket<InetSocketAddress> sock) {
                sock.register(true, false, new P2PSocketReceiver<InetSocketAddress>(){
                    ByteBuffer readMe = ByteBuffer.allocate(1);

                    @Override
                    public void receiveSelectResult(P2PSocket<InetSocketAddress> socket, boolean canRead, boolean canWrite) throws IOException {
                        long bytesRead = socket.read(this.readMe);
                        if (bytesRead < 0L) {
                            deliverResultToMe.receiveException(new ClosedChannelException("Channel closed before reporting success/failure"));
                            socket.close();
                            return;
                        }
                        if (this.readMe.hasRemaining()) {
                            socket.register(true, false, this);
                            return;
                        }
                        this.readMe.flip();
                        byte ret = this.readMe.get();
                        if (ret != 1) {
                            deliverResultToMe.receiveException(new CantVerifyConnectivityException(probeAddress + " can't verify our connectivity for address " + local));
                            return;
                        }
                    }

                    @Override
                    public void receiveException(P2PSocket<InetSocketAddress> socket, Exception ioe) {
                        deliverResultToMe.receiveException(ioe);
                    }
                });
            }

            @Override
            public void receiveException(SocketRequestHandle<InetSocketAddress> s, Exception ex) {
                deliverResultToMe.receiveException(ex);
            }
        }, options));
        return ret;
    }

    @Override
    public Cancellable probe(final InetSocketAddress addr, final long uid, final Continuation<Long, Exception> deliverResponseToMe, final Map<String, Object> options) {
        if (this.logger.level <= 500) {
            this.logger.log("probe(" + addr + "," + uid + "," + deliverResponseToMe + "," + options + ")");
        }
        final AttachableCancellable ret = new AttachableCancellable();
        ByteBuffer msg = ByteBuffer.allocate(9);
        msg.put((byte)3);
        msg.putLong(uid);
        msg.flip();
        final boolean[] success = new boolean[]{false, false};
        MessageCallback<InetSocketAddress, ByteBuffer> mc = null;
        if (deliverResponseToMe != null) {
            mc = new MessageCallback<InetSocketAddress, ByteBuffer>(){

                @Override
                public void ack(MessageRequestHandle<InetSocketAddress, ByteBuffer> msg) {
                    if (NetworkInfoTransportLayer.this.logger.level <= 400) {
                        NetworkInfoTransportLayer.this.logger.log("probe(" + addr + "," + uid + "," + deliverResponseToMe + "," + options + ").udpSuccess()");
                    }
                    success[0] = true;
                    if (success[1]) {
                        deliverResponseToMe.receiveResult(uid);
                    }
                }

                @Override
                public void sendFailed(MessageRequestHandle<InetSocketAddress, ByteBuffer> msg, Exception reason) {
                    if (NetworkInfoTransportLayer.this.logger.level <= 400) {
                        NetworkInfoTransportLayer.this.logger.log("probe(" + addr + "," + uid + "," + deliverResponseToMe + "," + options + ").udpFailure()");
                    }
                    ret.cancel();
                    deliverResponseToMe.receiveException(reason);
                }
            };
        }
        ret.attach(this.tl.sendMessage(addr, msg, mc, options));
        ByteBuffer writeMe = ByteBuffer.allocate(9);
        writeMe.put((byte)3);
        writeMe.putLong(uid);
        writeMe.flip();
        ret.attach(this.openSocket(addr, writeMe.array(), new SocketCallback<InetSocketAddress>(){

            @Override
            public void receiveResult(SocketRequestHandle<InetSocketAddress> cancellable, P2PSocket<InetSocketAddress> sock) {
                if (NetworkInfoTransportLayer.this.logger.level <= 400) {
                    NetworkInfoTransportLayer.this.logger.log("probe(" + addr + "," + uid + "," + deliverResponseToMe + "," + options + ").receiveResult(" + sock + ")");
                }
                success[1] = true;
                if (success[0]) {
                    deliverResponseToMe.receiveResult(uid);
                }
                sock.close();
            }

            @Override
            public void receiveException(SocketRequestHandle<InetSocketAddress> s, Exception ex) {
                if (NetworkInfoTransportLayer.this.logger.level <= 400) {
                    NetworkInfoTransportLayer.this.logger.log("probe(" + addr + "," + uid + "," + deliverResponseToMe + "," + options + ").tcpFailure2() " + ex);
                }
                if (deliverResponseToMe != null) {
                    deliverResponseToMe.receiveException(ex);
                }
            }
        }, options));
        return ret;
    }
}

