/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer.replay;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import org.mpisws.p2p.testing.transportlayer.replay.MyEntryDeserializer;
import org.mpisws.p2p.testing.transportlayer.replay.MyEvents;
import org.mpisws.p2p.testing.transportlayer.replay.MyScribeClient;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.direct.EventSimulator;
import org.mpisws.p2p.transport.peerreview.history.SecureHistory;
import org.mpisws.p2p.transport.peerreview.history.SecureHistoryFactoryImpl;
import org.mpisws.p2p.transport.peerreview.history.stub.NullHashProvider;
import org.mpisws.p2p.transport.peerreview.replay.BasicEntryDeserializer;
import org.mpisws.p2p.transport.peerreview.replay.EventCallback;
import org.mpisws.p2p.transport.peerreview.replay.inetsocketaddress.ISASerializer;
import org.mpisws.p2p.transport.peerreview.replay.playback.ReplayLayer;
import org.mpisws.p2p.transport.peerreview.replay.playback.ReplaySM;
import rice.environment.Environment;
import rice.environment.logging.LogManager;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.environment.random.RandomSource;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.NodeIdFactory;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.transport.TLPastryNode;

public class Replayer
implements MyEvents,
EventCallback {
    InetSocketAddress bootaddress;
    TLPastryNode node;
    MyScribeClient app;
    Logger logger;

    public Replayer(final Id id, final InetSocketAddress addr, InetSocketAddress bootaddress, long startTime, long randSeed) throws Exception {
        this.bootaddress = bootaddress;
        Environment env = ReplayLayer.generateEnvironment(id.toString(), startTime, randSeed);
        Parameters params = env.getParameters();
        params.setInt("pastry_socket_scm_max_open_sockets", params.getInt("org.mpisws.p2p.testing.transportlayer.replay_pastry_socket_scm_max_open_sockets"));
        params.setBoolean("pastry_socket_use_own_random", false);
        this.logger = env.getLogManager().getLogger(Replayer.class, null);
        Logger simLogger = env.getLogManager().getLogger(EventSimulator.class, null);
        final ArrayList replayers = new ArrayList();
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(new NodeIdFactory(){

            public Id generateNodeId() {
                return id;
            }
        }, addr.getPort(), env){

            @Override
            public NodeHandle getLocalHandle(TLPastryNode pn, NodeHandleFactory nhf) {
                SocketNodeHandle ret = (SocketNodeHandle)super.getLocalHandle(pn, nhf);
                this.logger.log(ret.toStringFull());
                return ret;
            }

            @Override
            protected RandomSource cloneRandomSource(Environment rootEnvironment, Id nodeId, LogManager lman) {
                return rootEnvironment.getRandomSource();
            }

            @Override
            protected TransportLayer<InetSocketAddress, ByteBuffer> getWireTransportLayer(InetSocketAddress innermostAddress, TLPastryNode pn) throws IOException {
                ISASerializer serializer = new ISASerializer();
                NullHashProvider hashProv = new NullHashProvider();
                SecureHistoryFactoryImpl shFactory = new SecureHistoryFactoryImpl(hashProv, pn.getEnvironment());
                String logName = "0x" + id.toStringFull().substring(0, 6);
                SecureHistory hist = shFactory.open(logName, "r");
                ReplayLayer<InetSocketAddress> replay = new ReplayLayer<InetSocketAddress>(serializer, hashProv, hist, addr, pn.getEnvironment());
                replay.registerEvent((EventCallback)Replayer.this, 1001, 1002, 1003);
                replayers.add(replay);
                return replay;
            }
        };
        this.node = (TLPastryNode)factory.newNode();
        this.app = new MyScribeClient(this.node);
        ReplaySM sim = (ReplaySM)env.getSelectorManager();
        ReplayLayer replay = (ReplayLayer)replayers.get(0);
        replay.makeProgress();
        sim.setVerifier(replay);
        sim.start();
        try {
            env.getTimeSource().sleep(55000L);
        }
        catch (InterruptedException ie) {
            return;
        }
        env.destroy();
    }

    public static void replayNode(Id id, InetSocketAddress addr, InetSocketAddress bootaddress, long startTime, long randSeed) throws Exception {
        Environment env = new Environment();
        if (env.getParameters().getBoolean("org.mpisws.p2p.testing.transportlayer.replay.Replayer_printlog")) {
            Replayer.printLog("0x" + id.toStringFull().substring(0, 6), env);
        }
        System.out.println(id.toStringFull() + " " + addr.getAddress().getHostAddress() + " " + addr.getPort() + " " + bootaddress.getPort() + " " + startTime + " " + randSeed);
        env.destroy();
        new Replayer(id, addr, bootaddress, startTime, randSeed);
    }

    public static void printLog(String arg, Environment env) throws IOException {
        BasicEntryDeserializer.printLog(arg, new MyEntryDeserializer(new ISASerializer()), env);
    }

    public static void main(String[] args) throws Exception {
        String hex = args[0];
        InetAddress a = InetAddress.getByName(args[1]);
        int startPort = Integer.decode(args[2]);
        int bootPort = Integer.decode(args[3]);
        InetSocketAddress addr = new InetSocketAddress(a, startPort);
        InetSocketAddress bootaddress = new InetSocketAddress(a, bootPort);
        long startTime = Long.decode(args[4]);
        long randSeed = Long.decode(args[5]);
        Replayer.replayNode(Id.build(hex), addr, bootaddress, startTime, randSeed);
    }

    public void replayEvent(short type, InputBuffer entry) {
        if (this.logger.level <= 500) {
            this.logger.log("replayEvent(" + type + ")");
        }
        switch (type) {
            case 1001: {
                this.node.getBootstrapper().boot(Collections.singletonList(this.bootaddress));
                break;
            }
            case 1002: {
                this.app.subscribe();
                break;
            }
            case 1003: {
                this.app.startPublishTask();
            }
        }
    }
}

