/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer.replay;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.mpisws.p2p.testing.transportlayer.replay.MyEntryDeserializer;
import org.mpisws.p2p.testing.transportlayer.replay.MyEvents;
import org.mpisws.p2p.testing.transportlayer.replay.MyScribeClient;
import org.mpisws.p2p.testing.transportlayer.replay.Replayer;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.peerreview.replay.BasicEntryDeserializer;
import org.mpisws.p2p.transport.peerreview.replay.inetsocketaddress.ISASerializer;
import org.mpisws.p2p.transport.peerreview.replay.record.RecordLayer;
import rice.environment.Environment;
import rice.environment.logging.LogManager;
import rice.environment.params.Parameters;
import rice.environment.params.simple.SimpleParameters;
import rice.environment.random.RandomSource;
import rice.environment.random.simple.SimpleRandomSource;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.pastry.Id;
import rice.pastry.NodeHandleFactory;
import rice.pastry.boot.Bootstrapper;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.standard.ProximityNeighborSelector;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.pastry.transport.NodeHandleAdapter;
import rice.pastry.transport.TLPastryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Recorder
implements MyEvents {
    ArrayList<MyScribeClient> apps = new ArrayList();
    final Map<Id, Long> storedRandSeed = new HashMap<Id, Long>();
    final Map<Node, RecordLayer<InetSocketAddress>> recorders = new HashMap<Node, RecordLayer<InetSocketAddress>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Recorder(int bindport, final InetSocketAddress bootaddress, int numNodes, Environment env) throws Exception {
        Parameters params = env.getParameters();
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        final SocketPastryNodeFactory factory = new SocketPastryNodeFactory(nidFactory, bindport, env){

            @Override
            public rice.pastry.NodeHandle getLocalHandle(TLPastryNode pn, NodeHandleFactory nhf) {
                SocketNodeHandle ret = (SocketNodeHandle)super.getLocalHandle(pn, nhf);
                if (this.logger.level <= 500) {
                    this.logger.log("getLocalHandle():" + ret.toStringFull());
                }
                return ret;
            }

            @Override
            protected RandomSource cloneRandomSource(Environment rootEnvironment, Id nodeId, LogManager lman) {
                long randSeed = rootEnvironment.getRandomSource().nextLong();
                if (this.logger.level <= 500) {
                    this.logger.log("RandSeed for " + nodeId + " " + randSeed);
                }
                Recorder.this.storedRandSeed.put(nodeId, randSeed);
                return new SimpleRandomSource(randSeed, lman);
            }

            @Override
            protected TransportLayer<InetSocketAddress, ByteBuffer> getWireTransportLayer(InetSocketAddress innermostAddress, TLPastryNode pn) throws IOException {
                RecordLayer<InetSocketAddress> ret = new RecordLayer<InetSocketAddress>(super.getWireTransportLayer(innermostAddress, pn), "0x" + pn.getNodeId().toStringBare(), new ISASerializer(), pn.getEnvironment());
                Recorder.this.recorders.put(pn, ret);
                return ret;
            }

            @Override
            protected Bootstrapper getBootstrapper(final TLPastryNode pn, NodeHandleAdapter tl, NodeHandleFactory handleFactory, ProximityNeighborSelector pns) {
                final Bootstrapper internal = super.getBootstrapper(pn, tl, handleFactory, pns);
                Bootstrapper ret = new Bootstrapper(){

                    public void boot(Collection bootaddresses) {
                        try {
                            Recorder.this.recorders.get(pn).logEvent((short)1001, new ByteBuffer[0]);
                        }
                        catch (IOException ioe) {
                            pn.getEnvironment().getLogManager().getLogger(Bootstrapper.class, null).logException("Error recording EVT_BOOT", ioe);
                        }
                        internal.boot(bootaddresses);
                    }
                };
                return ret;
            }
        };
        for (int curNode = 0; curNode < numNodes; ++curNode) {
            TLPastryNode node;
            final ArrayList nodeContainer = new ArrayList(1);
            env.getSelectorManager().invoke(new Runnable(){

                public void run() {
                    TLPastryNode node = (TLPastryNode)factory.newNode();
                    nodeContainer.add(node);
                    MyScribeClient app = new MyScribeClient(node);
                    Recorder.this.apps.add(app);
                    node.getBootstrapper().boot(Collections.singleton(bootaddress));
                }
            });
            ArrayList arrayList = nodeContainer;
            synchronized (arrayList) {
                while (nodeContainer.isEmpty()) {
                    nodeContainer.wait(500L);
                }
            }
            TLPastryNode tLPastryNode = node = (TLPastryNode)nodeContainer.get(0);
            synchronized (tLPastryNode) {
                while (!node.isReady() && !node.joinFailed()) {
                    node.wait(500L);
                    if (!node.joinFailed()) continue;
                    throw new IOException("Could not join the FreePastry ring.  Reason:" + node.joinFailedReason());
                }
            }
            System.out.println("Finished creating new node: " + node);
        }
        Iterator<MyScribeClient> i = this.apps.iterator();
        MyScribeClient app = i.next();
        env.getSelectorManager().invoke(new SubscribeInvokation(app));
        env.getSelectorManager().invoke(new PublishInvokation(app));
        while (i.hasNext()) {
            app = i.next();
            env.getSelectorManager().invoke(new SubscribeInvokation(app));
        }
        env.getTimeSource().sleep(5000L);
        Recorder.printTree(this.apps);
        env.getTimeSource().sleep(15000L);
        env.destroy();
        System.out.println("done recording");
        Thread.sleep(1000L);
        Iterator<MyScribeClient> mscI = this.apps.iterator();
        for (int playbackCtr = 0; playbackCtr < params.getInt("org.mpisws.p2p.testing.transportlayer.replay.num_playbacks") && mscI.hasNext(); ++playbackCtr) {
            app = mscI.next();
            Endpoint endpoint = app.endpoint;
            System.out.println("playing back " + app.node);
            if (params.getBoolean("org.mpisws.p2p.testing.transportlayer.replay.Recorder_printlog")) {
                this.printLog("0x" + endpoint.getId().toStringFull().substring(0, 6), new Environment());
            }
            SocketNodeHandle snh = (SocketNodeHandle)endpoint.getLocalNodeHandle();
            try {
                Replayer.replayNode((Id)snh.getId(), snh.getInetSocketAddress(), bootaddress, snh.getEpoch(), this.storedRandSeed.get(snh.getId()));
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            System.out.println("finished playing " + app.node);
        }
    }

    public void printLog(String arg, Environment env) throws IOException {
        BasicEntryDeserializer.printLog(arg, new MyEntryDeserializer(new ISASerializer()), env);
    }

    public static void printTree(ArrayList<MyScribeClient> apps) {
        Hashtable<NodeHandle, MyScribeClient> appTable = new Hashtable<NodeHandle, MyScribeClient>();
        for (MyScribeClient app : apps) {
            appTable.put(app.endpoint.getLocalNodeHandle(), app);
        }
        NodeHandle seed = apps.get((int)0).endpoint.getLocalNodeHandle();
        NodeHandle root = Recorder.getRoot(seed, appTable);
        Recorder.recursivelyPrintChildren(root, 0, appTable);
    }

    public static NodeHandle getRoot(NodeHandle seed, Hashtable appTable) {
        MyScribeClient app = (MyScribeClient)appTable.get(seed);
        if (app.isRoot()) {
            return seed;
        }
        NodeHandle nextSeed = app.getParent();
        return Recorder.getRoot(nextSeed, appTable);
    }

    public static void recursivelyPrintChildren(NodeHandle curNode, int recursionDepth, Hashtable appTable) {
        String s = "";
        for (int numTabs = 0; numTabs < recursionDepth; ++numTabs) {
            s = s + "  ";
        }
        s = s + curNode.getId().toString();
        System.out.println(s);
        MyScribeClient app = (MyScribeClient)appTable.get(curNode);
        NodeHandle[] children = app.getChildren();
        for (int curChild = 0; curChild < children.length; ++curChild) {
            Recorder.recursivelyPrintChildren(children[curChild], recursionDepth + 1, appTable);
        }
    }

    public static void main(String[] args) throws Exception {
        Parameters params = new SimpleParameters(Environment.defaultParamFileArray, null);
        if (params.getBoolean("org.mpisws.p2p.testing.transportlayer.replay.Recorder_logtofile")) {
            System.setOut(new PrintStream("replay.txt"));
            System.setErr(System.out);
        }
        Environment env = RecordLayer.generateEnvironment();
        params = env.getParameters();
        params.setInt("pastry_socket_scm_max_open_sockets", params.getInt("org.mpisws.p2p.testing.transportlayer.replay_pastry_socket_scm_max_open_sockets"));
        params.setBoolean("pastry_socket_use_own_random", false);
        params.setString("nat_search_policy", "never");
        try {
            int bindport = Integer.parseInt(args[0]);
            InetAddress bootaddr = InetAddress.getByName(args[1]);
            int bootport = Integer.parseInt(args[2]);
            InetSocketAddress bootaddress = new InetSocketAddress(bootaddr, bootport);
            int numNodes = Integer.parseInt(args[3]);
            Recorder dt = new Recorder(bindport, bootaddress, numNodes, env);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.scribe.ScribeTutorial localbindport bootIP bootPort numNodes");
            System.out.println("example java rice.tutorial.scribe.ScribeTutorial 9001 pokey.cs.almamater.edu 9001 10");
            throw e;
        }
    }

    public class PublishInvokation
    extends AppInvokation {
        public PublishInvokation(MyScribeClient app) {
            super(app);
        }

        public void doIt() throws IOException {
            Recorder.this.recorders.get(this.app.node).logEvent((short)1003, new ByteBuffer[0]);
            this.app.startPublishTask();
        }
    }

    public class SubscribeInvokation
    extends AppInvokation {
        public SubscribeInvokation(MyScribeClient app) {
            super(app);
        }

        public void doIt() throws IOException {
            Recorder.this.recorders.get(this.app.node).logEvent((short)1002, new ByteBuffer[0]);
            this.app.subscribe();
        }
    }

    public abstract class AppInvokation
    implements Runnable {
        MyScribeClient app;

        public AppInvokation(MyScribeClient app) {
            this.app = app;
        }

        public abstract void doIt() throws IOException;

        public void run() {
            try {
                this.doIt();
            }
            catch (IOException ioe) {
                this.app.node.getEnvironment().getLogManager().getLogger(Bootstrapper.class, null).logException("Error recording event", ioe);
            }
        }
    }
}

