/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mpisws.p2p.testing.transportlayer.TLTest;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.exception.NodeIsFaultyException;
import org.mpisws.p2p.transport.liveness.LivenessTransportLayerImpl;
import org.mpisws.p2p.transport.multiaddress.MultiInetAddressTransportLayerImpl;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.priority.PriorityTransportLayerImpl;
import org.mpisws.p2p.transport.priority.QueueOverflowException;
import org.mpisws.p2p.transport.proximity.MinRTTProximityProvider;
import org.mpisws.p2p.transport.wire.WireTransportLayerImpl;
import rice.environment.Environment;
import rice.environment.logging.CloneableLogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityTest
extends TLTest<InetSocketAddress> {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TLTest.setUpBeforeClass();
        logger = env.getLogManager().getLogger(PriorityTest.class, null);
        int startPort = 5009;
        InetAddress addr = InetAddress.getLocalHost();
        alice = PriorityTest.buildTL("alice", addr, startPort, env);
        bob = PriorityTest.buildTL("bob", addr, startPort + 1, env);
    }

    private static TransportLayer buildTL(String name, InetAddress addr, int port, Environment env) throws IOException {
        Environment env_a = new Environment(env.getSelectorManager(), env.getProcessor(), env.getRandomSource(), env.getTimeSource(), ((CloneableLogManager)env.getLogManager()).clone(name), env.getParameters(), env.getExceptionStrategy());
        env.addDestructable(env_a);
        InetSocketAddress addr_a = new InetSocketAddress(addr, port);
        LivenessTransportLayerImpl<MultiInetSocketAddress> ltli = new LivenessTransportLayerImpl<MultiInetSocketAddress>(new MultiInetAddressTransportLayerImpl(new MultiInetSocketAddress(addr_a), new WireTransportLayerImpl(addr_a, env_a, null), env_a, null, null), env_a, null, 5000);
        MinRTTProximityProvider<MultiInetSocketAddress> prox = new MinRTTProximityProvider<MultiInetSocketAddress>(ltli, env_a);
        return new PriorityTransportLayerImpl<MultiInetSocketAddress>(ltli, ltli, prox, env_a, 1024, 30, null);
    }

    @Test
    public void bogus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queueOverflow() throws IOException {
        MultiInetSocketAddress bogus = new MultiInetSocketAddress(this.getBogusIdentifier(null));
        final ArrayList dropped = new ArrayList(10);
        for (int ctr = 0; ctr < 40; ++ctr) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("OPTION_PRIORITY", -ctr);
            alice.sendMessage(bogus, ByteBuffer.wrap(new byte[ctr]), new MessageCallback<MultiInetSocketAddress, ByteBuffer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void sendFailed(MessageRequestHandle<MultiInetSocketAddress, ByteBuffer> msg, Exception reason) {
                    if (!(reason instanceof NodeIsFaultyException)) {
                        if (reason instanceof QueueOverflowException) {
                            ArrayList arrayList = dropped;
                            synchronized (arrayList) {
                                System.out.println("Dropped " + msg);
                                dropped.add(msg);
                                if (dropped.size() >= 10) {
                                    dropped.notify();
                                }
                            }
                        } else {
                            reason.printStackTrace();
                        }
                    }
                }

                @Override
                public void ack(MessageRequestHandle<MultiInetSocketAddress, ByteBuffer> msg) {
                    System.out.println("ack");
                }
            }, options);
        }
        System.out.println("sleeping");
        ArrayList arrayList = dropped;
        synchronized (arrayList) {
            if (dropped.size() < 10) {
                try {
                    dropped.wait(10000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        System.out.println("done sleeping" + dropped.size());
    }

    @Override
    public InetSocketAddress getBogusIdentifier(InetSocketAddress local) throws IOException {
        return new InetSocketAddress(InetAddress.getLocalHost(), 5007);
    }
}

