/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.testing.transportlayer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mpisws.p2p.testing.transportlayer.MagicNumberTest;
import org.mpisws.p2p.testing.transportlayer.TLTest;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.multiaddress.MultiInetAddressTransportLayerImpl;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.wire.WireTransportLayerImpl;
import org.mpisws.p2p.transport.wire.magicnumber.MagicNumberTransportLayer;
import rice.environment.Environment;
import rice.environment.logging.CloneableLogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EpochTest
extends TLTest<MultiInetSocketAddress> {
    public static final byte[] GOOD_HDR = new byte[]{-34, -83, -66, -17};

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TLTest.setUpBeforeClass();
        int startPort = 5009;
        logger = env.getLogManager().getLogger(MagicNumberTest.class, null);
        InetAddress addr = InetAddress.getLocalHost();
        alice = EpochTest.buildTL("alice", addr, startPort, env);
        bob = EpochTest.buildTL("bob", addr, startPort + 1, env);
    }

    private static TransportLayer buildTL(String name, InetAddress addr, int port, Environment env) throws IOException {
        Environment env_a = new Environment(env.getSelectorManager(), env.getProcessor(), env.getRandomSource(), env.getTimeSource(), ((CloneableLogManager)env.getLogManager()).clone(name), env.getParameters(), env.getExceptionStrategy());
        env.addDestructable(env_a);
        InetSocketAddress addr_a = new InetSocketAddress(addr, port);
        return new MultiInetAddressTransportLayerImpl(new MultiInetSocketAddress(addr_a), new MagicNumberTransportLayer<InetSocketAddress>(new WireTransportLayerImpl(addr_a, env_a, null), env_a, null, GOOD_HDR, 2000), env_a, null, null);
    }

    @Test
    public void bogus() {
    }

    @Test
    public void testFalseAddress() {
    }

    public void testFalseAddressBypass() {
    }

    @Override
    public MultiInetSocketAddress getBogusIdentifier(MultiInetSocketAddress local) throws IOException {
        return new MultiInetSocketAddress(new InetSocketAddress(InetAddress.getLocalHost(), 5007));
    }
}

