/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.filetransfer;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.mpisws.p2p.filetransfer.FileAllocationStrategy;

public class TempFileAllocationStrategy
implements FileAllocationStrategy {
    protected String prefix;
    protected String suffix;
    protected File dir;

    public TempFileAllocationStrategy() {
        this("FreePastry", null);
    }

    public TempFileAllocationStrategy(String prefix, String suffix) {
        this(prefix, suffix, null);
    }

    public TempFileAllocationStrategy(String prefix, String suffix, File directory) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.dir = directory;
    }

    public synchronized File getFile(ByteBuffer metadata, long offset, long length) throws IOException {
        File temp = File.createTempFile(this.prefix, this.suffix, this.dir);
        return temp;
    }

    public void fileCancelled(ByteBuffer metadata, File f, long offset, long downloadedLength, long requestedLength, Exception reason) {
        f.delete();
    }
}

