/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.transport;

import java.io.IOException;
import rice.environment.Environment;
import rice.environment.params.Parameters;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.boot.Bootstrapper;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.pns.PNSApplication;
import rice.pastry.routing.RoutingTable;
import rice.pastry.standard.ConsistentJoinProtocol;
import rice.pastry.standard.PeriodicLeafSetProtocol;
import rice.pastry.standard.ProximityNeighborSelector;
import rice.pastry.standard.RapidRerouter;
import rice.pastry.standard.StandardRouteSetProtocol;
import rice.pastry.transport.NodeHandleAdapter;
import rice.pastry.transport.TLDeserializer;
import rice.pastry.transport.TLPastryNode;

public abstract class TransportPastryNodeFactory
extends PastryNodeFactory {
    protected int leafSetMaintFreq;
    protected int routeSetMaintFreq;

    public TransportPastryNodeFactory(Environment env) {
        super(env);
        Parameters params = env.getParameters();
        this.leafSetMaintFreq = params.getInt("pastry_leafSetMaintFreq");
        this.routeSetMaintFreq = params.getInt("pastry_routeSetMaintFreq");
    }

    protected TLPastryNode nodeHandleHelper(Id nodeId, Environment environment, Object localNodeData) throws IOException {
        TLPastryNode pn = new TLPastryNode(nodeId, environment);
        NodeHandleFactory handleFactory = this.getNodeHandleFactory(pn);
        NodeHandle localhandle = this.getLocalHandle(pn, handleFactory, localNodeData);
        TLDeserializer deserializer = this.getTLDeserializer(handleFactory, pn);
        MessageDispatch msgDisp = new MessageDispatch(pn);
        RoutingTable routeTable = new RoutingTable(localhandle, this.rtMax, this.rtBase, pn);
        LeafSet leafSet = new LeafSet(localhandle, (int)this.lSetSize, routeTable);
        RapidRerouter router = new RapidRerouter((PastryNode)pn, msgDisp);
        pn.setElements(localhandle, msgDisp, leafSet, routeTable, router);
        NodeHandleAdapter nha = this.getNodeHanldeAdapter(pn, handleFactory, deserializer);
        PNSApplication pns = new PNSApplication(pn);
        pn.setSocketElements(localhandle, this.leafSetMaintFreq, this.routeSetMaintFreq, nha, nha, nha, deserializer, handleFactory, this.getBootstrapper(pn, nha, handleFactory, pns));
        pns.register();
        StandardRouteSetProtocol rsProtocol = new StandardRouteSetProtocol(pn, routeTable, environment);
        router.register();
        rsProtocol.register();
        PeriodicLeafSetProtocol lsProtocol = new PeriodicLeafSetProtocol((PastryNode)pn, localhandle, leafSet, routeTable);
        lsProtocol.register();
        ConsistentJoinProtocol jProtocol = new ConsistentJoinProtocol((PastryNode)pn, localhandle, routeTable, leafSet, lsProtocol);
        jProtocol.register();
        return pn;
    }

    protected TLDeserializer getTLDeserializer(NodeHandleFactory handleFactory, TLPastryNode pn) {
        TLDeserializer deserializer = new TLDeserializer(handleFactory, pn.getEnvironment());
        return deserializer;
    }

    protected abstract NodeHandle getLocalHandle(TLPastryNode var1, NodeHandleFactory var2, Object var3) throws IOException;

    protected abstract NodeHandleAdapter getNodeHanldeAdapter(TLPastryNode var1, NodeHandleFactory var2, TLDeserializer var3) throws IOException;

    protected abstract NodeHandleFactory getNodeHandleFactory(TLPastryNode var1) throws IOException;

    protected abstract Bootstrapper getBootstrapper(TLPastryNode var1, NodeHandleAdapter var2, NodeHandleFactory var3, ProximityNeighborSelector var4);
}

