/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.liveness.LivenessListener;
import org.mpisws.p2p.transport.liveness.LivenessProvider;
import org.mpisws.p2p.transport.proximity.ProximityListener;
import org.mpisws.p2p.transport.proximity.ProximityProvider;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import rice.environment.Environment;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.p2p.commonapi.exception.AppNotRegisteredException;
import rice.p2p.commonapi.exception.AppSocketException;
import rice.p2p.commonapi.exception.NoReceiverAvailableException;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.pastry.ExponentialBackoffScheduledMessage;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.PastryNode;
import rice.pastry.ScheduledMessage;
import rice.pastry.boot.Bootstrapper;
import rice.pastry.client.PastryAppl;
import rice.pastry.join.InitiateJoin;
import rice.pastry.leafset.InitiateLeafSetMaintenance;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.PJavaSerializedMessage;
import rice.pastry.messaging.PRawMessage;
import rice.pastry.routing.InitiateRouteSetMaintenance;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.transport.Deserializer;
import rice.pastry.transport.PMessageNotification;
import rice.pastry.transport.PMessageReceipt;
import rice.pastry.transport.PMessageReceiptImpl;
import rice.pastry.transport.SocketAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLPastryNode
extends PastryNode
implements TransportLayerCallback<NodeHandle, RawMessage>,
LivenessListener<NodeHandle>,
ProximityListener<NodeHandle> {
    public static final byte CONNECTION_UNKNOWN_ERROR = -1;
    public static final byte CONNECTION_UNKNOWN = -100;
    public static final byte CONNECTION_OK = 0;
    public static final byte CONNECTION_NO_APP = 1;
    public static final byte CONNECTION_NO_ACCEPTOR = 2;
    TransportLayer<NodeHandle, RawMessage> tl;
    ProximityProvider<NodeHandle> proxProvider;
    Deserializer deserializer;
    Bootstrapper bootstrapper;
    protected ScheduledMessage joinEvent;
    protected int leafSetMaintFreq;
    protected int routeSetMaintFreq;
    protected ScheduledMessage leafSetRoutineMaintenance = null;
    protected ScheduledMessage routeSetRoutineMaintenance = null;
    private NodeHandleFactory handleFactory;
    protected LivenessProvider<NodeHandle> livenessProvider;
    Collection<LivenessListener<NodeHandle>> livenessListeners = new ArrayList<LivenessListener<NodeHandle>>();

    public TLPastryNode(Id id, Environment e) {
        super(id, e);
    }

    @Override
    public void registerReceiver(int address, PastryAppl receiver) {
        if (this.logger.level <= 500) {
            this.logger.log("registerReceiver(" + address + "," + receiver + "):" + receiver.getDeserializer());
        }
        this.deserializer.setDeserializer(address, receiver.getDeserializer());
        super.registerReceiver(address, receiver);
    }

    @Override
    public NodeHandle coalesce(NodeHandle newHandle) {
        if (this.logger.level <= 400) {
            this.logger.log("coalesce(" + newHandle + ")");
        }
        return this.handleFactory.coalesce(newHandle);
    }

    @Override
    public SocketRequestHandle connect(NodeHandle i2, final AppSocketReceiver deliverSocketToMe, final PastryAppl appl, int timeout) {
        final SocketNodeHandle i = (SocketNodeHandle)i2;
        final SocketRequestHandleImpl<SocketNodeHandle> handle = new SocketRequestHandleImpl<SocketNodeHandle>(i, null);
        final ByteBuffer b = ByteBuffer.allocate(4);
        b.asIntBuffer().put(appl.getAddress());
        b.clear();
        handle.setSubCancellable(this.tl.openSocket(i, new SocketCallback<NodeHandle>(){

            @Override
            public void receiveResult(SocketRequestHandle<NodeHandle> c, P2PSocket<NodeHandle> result) {
                if (c != handle.getSubCancellable()) {
                    throw new RuntimeException("c != handle.getSubCancellable() (indicates a bug in the code) c:" + c + " sub:" + handle.getSubCancellable());
                }
                if (((TLPastryNode)TLPastryNode.this).logger.level <= 400) {
                    TLPastryNode.this.logger.log("openSocket(" + i + "):receiveResult(" + result + ")");
                }
                result.register(false, true, new P2PSocketReceiver<NodeHandle>(){

                    @Override
                    public void receiveSelectResult(P2PSocket<NodeHandle> socket, boolean canRead, boolean canWrite) throws IOException {
                        if (canRead || !canWrite) {
                            throw new IOException("Expected to write! " + canRead + "," + canWrite);
                        }
                        if (socket.write(b) == -1L) {
                            deliverSocketToMe.receiveException(new SocketAdapter(socket, TLPastryNode.this.getEnvironment()), new ClosedChannelException());
                            return;
                        }
                        if (b.hasRemaining()) {
                            socket.register(false, true, this);
                        } else {
                            final ByteBuffer answer = ByteBuffer.allocate(1);
                            socket.register(true, false, new P2PSocketReceiver<NodeHandle>(){

                                @Override
                                public void receiveSelectResult(P2PSocket<NodeHandle> socket, boolean canRead, boolean canWrite) throws IOException {
                                    if (socket.read(answer) == -1L) {
                                        deliverSocketToMe.receiveException(new SocketAdapter(socket, TLPastryNode.this.getEnvironment()), new ClosedChannelException());
                                        return;
                                    }
                                    if (!answer.hasRemaining()) {
                                        answer.clear();
                                        byte connectResult = answer.get();
                                        switch (connectResult) {
                                            case 0: {
                                                deliverSocketToMe.receiveSocket(new SocketAdapter(socket, TLPastryNode.this.getEnvironment()));
                                                return;
                                            }
                                            case 1: {
                                                deliverSocketToMe.receiveException(new SocketAdapter(socket, TLPastryNode.this.getEnvironment()), new AppNotRegisteredException(appl.getAddress()));
                                                return;
                                            }
                                            case 2: {
                                                deliverSocketToMe.receiveException(new SocketAdapter(socket, TLPastryNode.this.getEnvironment()), new NoReceiverAvailableException());
                                                return;
                                            }
                                        }
                                        deliverSocketToMe.receiveException(new SocketAdapter(socket, TLPastryNode.this.getEnvironment()), new AppSocketException("Unknown error " + connectResult));
                                        return;
                                    }
                                    socket.register(true, false, this);
                                }

                                @Override
                                public void receiveException(P2PSocket<NodeHandle> socket, IOException ioe) {
                                    deliverSocketToMe.receiveException(new SocketAdapter(socket, TLPastryNode.this.getEnvironment()), ioe);
                                }
                            });
                        }
                    }

                    @Override
                    public void receiveException(P2PSocket<NodeHandle> socket, IOException e) {
                        deliverSocketToMe.receiveException(new SocketAdapter(socket, TLPastryNode.this.getEnvironment()), e);
                    }
                });
            }

            @Override
            public void receiveException(SocketRequestHandle<NodeHandle> s, IOException ex) {
                deliverSocketToMe.receiveException(null, ex);
            }
        }, null));
        return handle;
    }

    @Override
    public void incomingSocket(P2PSocket<NodeHandle> s) throws IOException {
        final ByteBuffer appIdBuffer = ByteBuffer.allocate(4);
        s.register(true, false, new P2PSocketReceiver<NodeHandle>(){

            @Override
            public void receiveSelectResult(P2PSocket<NodeHandle> socket, boolean canRead, boolean canWrite) throws IOException {
                if (socket.read(appIdBuffer) == -1L) {
                    if (((TLPastryNode)TLPastryNode.this).logger.level <= 900) {
                        TLPastryNode.this.logger.log("AppId Socket from " + socket + " closed unexpectedly.");
                    }
                    return;
                }
                if (appIdBuffer.hasRemaining()) {
                    socket.register(true, false, this);
                } else {
                    appIdBuffer.clear();
                    final int appId = appIdBuffer.asIntBuffer().get();
                    socket.register(false, true, new P2PSocketReceiver<NodeHandle>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void receiveSelectResult(P2PSocket<NodeHandle> socket, boolean canRead, boolean canWrite) throws IOException {
                            PastryAppl acceptorAppl = TLPastryNode.this.getMessageDispatch().getDestinationByAddress(appId);
                            ByteBuffer toWrite = ByteBuffer.allocate(1);
                            boolean success = false;
                            if (acceptorAppl == null) {
                                if (((TLPastryNode)TLPastryNode.this).logger.level <= 900) {
                                    TLPastryNode.this.logger.log("Sending error to connecter " + socket + " " + new AppNotRegisteredException(appId));
                                }
                                toWrite.put((byte)1);
                                toWrite.clear();
                                socket.write(toWrite);
                                socket.close();
                            } else {
                                PastryAppl pastryAppl = acceptorAppl;
                                synchronized (pastryAppl) {
                                    if (acceptorAppl.canReceiveSocket()) {
                                        toWrite.put((byte)0);
                                        toWrite.clear();
                                        success = true;
                                    } else {
                                        if (((TLPastryNode)TLPastryNode.this).logger.level <= 900) {
                                            TLPastryNode.this.logger.log("Sending error to connecter " + socket + " " + new NoReceiverAvailableException());
                                        }
                                        toWrite.put((byte)2);
                                        toWrite.clear();
                                    }
                                    socket.write(toWrite);
                                    if (toWrite.hasRemaining()) {
                                        if (((TLPastryNode)TLPastryNode.this).logger.level <= 900) {
                                            TLPastryNode.this.logger.log("couldn't write 1 bite!!! " + toWrite);
                                        }
                                        socket.close();
                                        return;
                                    }
                                    if (success) {
                                        acceptorAppl.finishReceiveSocket(new SocketAdapter(socket, TLPastryNode.this.getEnvironment()));
                                    }
                                }
                            }
                        }

                        @Override
                        public void receiveException(P2PSocket<NodeHandle> socket, IOException ioe) {
                            if (((TLPastryNode)TLPastryNode.this).logger.level <= 900) {
                                TLPastryNode.this.logger.logException("incomingSocket(" + socket + ")", ioe);
                            }
                        }
                    });
                }
            }

            @Override
            public void receiveException(P2PSocket<NodeHandle> socket, IOException ioe) {
                if (((TLPastryNode)TLPastryNode.this).logger.level <= 900) {
                    TLPastryNode.this.logger.logException("incomingSocket(" + socket + ")", ioe);
                }
            }
        });
    }

    protected void acceptAppSocket(int appId) throws AppSocketException {
        PastryAppl acceptorAppl = this.getMessageDispatch().getDestinationByAddress(appId);
        if (acceptorAppl == null) {
            throw new AppNotRegisteredException(appId);
        }
        if (!acceptorAppl.canReceiveSocket()) {
            throw new NoReceiverAvailableException();
        }
    }

    public ExponentialBackoffScheduledMessage scheduleMsgExpBackoff(Message msg, long delay, long initialPeriod, double expBase) {
        ExponentialBackoffScheduledMessage sm = new ExponentialBackoffScheduledMessage(this, msg, this.getEnvironment().getSelectorManager().getTimer(), delay, initialPeriod, expBase);
        return sm;
    }

    @Override
    public void initiateJoin(NodeHandle[] bootstrap) {
        if (this.logger.level <= 700) {
            this.logger.log("initiateJoin(" + bootstrap + ")");
        }
        if (bootstrap == null || bootstrap[0] == null) {
            this.setReady();
        } else {
            this.joinEvent = this.scheduleMsgExpBackoff(new InitiateJoin(bootstrap), 0L, 15000L, 2.0);
        }
    }

    @Override
    public void nodeIsReady() {
        if (this.joinEvent != null) {
            this.joinEvent.cancel();
            this.joinEvent = null;
        }
    }

    @Override
    public int proximity(NodeHandle nh) {
        return this.proxProvider.proximity(nh);
    }

    @Override
    public ScheduledMessage scheduleMsg(Message msg, long delay) {
        ScheduledMessage sm = new ScheduledMessage(this, msg);
        this.getEnvironment().getSelectorManager().getTimer().schedule(sm, delay);
        return sm;
    }

    @Override
    public ScheduledMessage scheduleMsg(Message msg, long delay, long period) {
        ScheduledMessage sm = new ScheduledMessage(this, msg);
        this.getEnvironment().getSelectorManager().getTimer().schedule(sm, delay, period);
        return sm;
    }

    @Override
    public ScheduledMessage scheduleMsgAtFixedRate(Message msg, long delay, long period) {
        ScheduledMessage sm = new ScheduledMessage(this, msg);
        this.getEnvironment().getSelectorManager().getTimer().scheduleAtFixedRate(sm, delay, period);
        return sm;
    }

    @Override
    public PMessageReceipt send(NodeHandle handle, final Message msg, final PMessageNotification deliverAckToMe, Map<String, Integer> tempOptions) {
        if (tempOptions == null || !tempOptions.containsKey("OPTION_PRIORITY")) {
            tempOptions = tempOptions == null ? new HashMap<String, Integer>() : new HashMap<String, Integer>(tempOptions);
            tempOptions.put("OPTION_PRIORITY", msg.getPriority());
        }
        final Map<String, Integer> options = tempOptions;
        if (handle.equals(this.localhandle)) {
            this.receiveMessage(msg);
            PMessageReceipt ret = new PMessageReceipt(){

                @Override
                public boolean cancel() {
                    return false;
                }

                @Override
                public NodeHandle getIdentifier() {
                    return TLPastryNode.this.localhandle;
                }

                @Override
                public Map<String, Integer> getOptions() {
                    return options;
                }

                @Override
                public Message getMessage() {
                    return msg;
                }

                public String toString() {
                    return "TLPN$PMsgRecpt{" + msg + "," + TLPastryNode.this.localhandle + "}";
                }
            };
            if (deliverAckToMe != null) {
                deliverAckToMe.sent(ret);
            }
            return ret;
        }
        PRawMessage rm = msg instanceof PRawMessage ? (PRawMessage)msg : new PJavaSerializedMessage(msg);
        final PMessageReceiptImpl ret = new PMessageReceiptImpl(msg);
        ret.setInternal(this.tl.sendMessage(handle, rm, deliverAckToMe == null ? null : new MessageCallback<NodeHandle, RawMessage>(){

            @Override
            public void sendFailed(MessageRequestHandle<NodeHandle, RawMessage> msg, IOException reason) {
                if (ret.internal == null) {
                    ret.setInternal(msg);
                }
                deliverAckToMe.sendFailed(ret, reason);
            }

            @Override
            public void ack(MessageRequestHandle<NodeHandle, RawMessage> msg) {
                if (ret.internal == null) {
                    ret.setInternal(msg);
                }
                deliverAckToMe.sent(ret);
            }
        }, options));
        return ret;
    }

    @Override
    public void messageReceived(NodeHandle i, RawMessage m, Map<String, Integer> options) throws IOException {
        if (m.getType() == 0 && m instanceof PJavaSerializedMessage) {
            this.receiveMessage(((PJavaSerializedMessage)m).getMessage());
        } else {
            this.receiveMessage((Message)((Object)m));
        }
    }

    @Override
    public NodeHandle readNodeHandle(InputBuffer buf) throws IOException {
        return this.handleFactory.readNodeHandle(buf);
    }

    @Override
    public Bootstrapper getBootstrapper() {
        return this.bootstrapper;
    }

    public void setSocketElements(NodeHandle localhandle, int lsmf, int rsmf, TransportLayer<NodeHandle, RawMessage> tl, LivenessProvider<NodeHandle> livenessProvider, ProximityProvider<NodeHandle> proxProvider, Deserializer deserializer, NodeHandleFactory handleFactory, Bootstrapper boot) {
        this.localhandle = localhandle;
        this.leafSetMaintFreq = lsmf;
        this.routeSetMaintFreq = rsmf;
        this.handleFactory = handleFactory;
        this.proxProvider = proxProvider;
        this.bootstrapper = boot;
        proxProvider.addProximityListener(this);
        this.tl = tl;
        this.livenessProvider = livenessProvider;
        this.deserializer = deserializer;
        tl.setCallback(this);
        livenessProvider.addLivenessListener(this);
    }

    public void doneNode(Collection<NodeHandle> bootstrap) {
        if (this.logger.level <= 800) {
            this.logger.log("doneNode:" + bootstrap);
        }
        this.doneNode(bootstrap.toArray(new NodeHandle[1]));
    }

    public void doneNode(NodeHandle[] bootstrap) {
        if (this.logger.level <= 800) {
            this.logger.log("doneNode:" + bootstrap[0]);
        }
        if (this.routeSetMaintFreq > 0) {
            this.routeSetRoutineMaintenance = this.scheduleMsgAtFixedRate(new InitiateRouteSetMaintenance(), this.routeSetMaintFreq * 1000, this.routeSetMaintFreq * 1000);
            if (this.logger.level <= 700) {
                this.logger.log("Scheduling routeSetMaint for " + this.routeSetMaintFreq * 1000 + "," + this.routeSetMaintFreq * 1000);
            }
        }
        if (this.leafSetMaintFreq > 0) {
            this.leafSetRoutineMaintenance = this.scheduleMsgAtFixedRate(new InitiateLeafSetMaintenance(), this.leafSetMaintFreq * 1000, this.leafSetMaintFreq * 1000);
            if (this.logger.level <= 700) {
                this.logger.log("Scheduling leafSetMaint for " + this.leafSetMaintFreq * 1000 + "," + this.leafSetMaintFreq * 1000);
            }
        }
        this.initiateJoin(bootstrap);
    }

    @Override
    public String toString() {
        return "TLPastryNode" + this.localhandle;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.getEnvironment().getSelectorManager().isSelectorThread()) {
            this.tl.destroy();
        } else {
            this.getEnvironment().getSelectorManager().invoke(new Runnable(){

                public void run() {
                    TLPastryNode.this.tl.destroy();
                }
            });
        }
    }

    @Override
    public void livenessChanged(NodeHandle i, int val, Map<String, Integer> options) {
        if (val == 1) {
            i.update(NodeHandle.DECLARED_LIVE);
        } else if (val >= 3) {
            i.update(NodeHandle.DECLARED_DEAD);
        }
        this.notifyLivenessListeners(i, val, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLivenessListener(LivenessListener<NodeHandle> name) {
        Collection<LivenessListener<NodeHandle>> collection = this.livenessListeners;
        synchronized (collection) {
            this.livenessListeners.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLivenessListener(LivenessListener<NodeHandle> name) {
        Collection<LivenessListener<NodeHandle>> collection = this.livenessListeners;
        synchronized (collection) {
            return this.livenessListeners.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLivenessListeners(NodeHandle i, int val, Map<String, Integer> options) {
        ArrayList<LivenessListener<NodeHandle>> temp;
        if (this.logger.level <= 500) {
            this.logger.log("notifyLivenessListeners(" + i + "," + val + ")");
        }
        Collection<LivenessListener<NodeHandle>> collection = this.livenessListeners;
        synchronized (collection) {
            temp = new ArrayList<LivenessListener<NodeHandle>>(this.livenessListeners);
        }
        for (LivenessListener<NodeHandle> ll : temp) {
            ll.livenessChanged(i, val, options);
        }
    }

    @Override
    public boolean checkLiveness(NodeHandle i, Map<String, Integer> options) {
        return this.livenessProvider.checkLiveness(i, options);
    }

    @Override
    public int getLiveness(NodeHandle i, Map<String, Integer> options) {
        return this.livenessProvider.getLiveness(i, options);
    }

    @Override
    public void proximityChanged(NodeHandle i, int val, Map<String, Integer> options) {
        SocketNodeHandle handle = (SocketNodeHandle)i;
        handle.update(NodeHandle.PROXIMITY_CHANGED);
    }

    public LivenessProvider<NodeHandle> getLivenessProvider() {
        return this.livenessProvider;
    }

    public ProximityProvider<NodeHandle> getProxProvider() {
        return this.proxProvider;
    }

    public TransportLayer<NodeHandle, RawMessage> getTL() {
        return this.tl;
    }

    @Override
    public void clearState(NodeHandle i) {
        this.livenessProvider.clearState(i);
    }

    @Override
    public void addProximityListener(ProximityListener<NodeHandle> listener) {
        this.proxProvider.addProximityListener(listener);
    }

    @Override
    public boolean removeProximityListener(ProximityListener<NodeHandle> listener) {
        return this.proxProvider.removeProximityListener(listener);
    }
}

