/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.transport;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mpisws.p2p.transport.commonapi.RawMessageDeserializer;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.messaging.PRawMessage;
import rice.pastry.transport.Deserializer;

public class TLDeserializer
implements RawMessageDeserializer,
Deserializer {
    Map<Integer, MessageDeserializer> deserializers;
    NodeHandleFactory nodeHandleFactory;
    protected Environment environment;
    protected Logger logger;

    public TLDeserializer(NodeHandleFactory nodeHandleFactory, Environment env) {
        this.environment = env;
        this.nodeHandleFactory = nodeHandleFactory;
        this.deserializers = new HashMap<Integer, MessageDeserializer>();
        this.logger = this.environment.getLogManager().getLogger(TLDeserializer.class, null);
    }

    public RawMessage deserialize(InputBuffer buf) throws IOException {
        MessageDeserializer deserializer;
        int address = buf.readInt();
        boolean hasSender = buf.readBoolean();
        byte priority = buf.readByte();
        short type = buf.readShort();
        NodeHandle sender = null;
        if (hasSender) {
            sender = this.nodeHandleFactory.readNodeHandle(buf);
        }
        if ((deserializer = this.getDeserializer(address)) == null) {
            throw new IOException("Unknown address:" + address);
        }
        Message msg = deserializer.deserialize(buf, type, priority, sender);
        if (this.logger.level <= 400) {
            this.logger.log("deserialize():" + msg);
        }
        return (RawMessage)msg;
    }

    public void serialize(RawMessage m, OutputBuffer o) throws IOException {
        PRawMessage msg = (PRawMessage)m;
        int address = msg.getDestination();
        o.writeInt(address);
        NodeHandle sender = msg.getSender();
        boolean hasSender = sender != null;
        o.writeBoolean(hasSender);
        int priority = msg.getPriority();
        if (priority > 127) {
            throw new IllegalStateException("Priority must be in the range of -128 to 127.  Lower values are higher priority. Priority of " + msg + " was " + priority + ".");
        }
        if (priority < -128) {
            throw new IllegalStateException("Priority must be in the range of -128 to 127.  Lower values are higher priority. Priority of " + msg + " was " + priority + ".");
        }
        o.writeByte((byte)priority);
        short type = msg.getType();
        o.writeShort(type);
        if (hasSender) {
            msg.getSender().serialize(o);
        }
        msg.serialize(o);
    }

    public void clearDeserializer(int address) {
        this.deserializers.remove(address);
    }

    public MessageDeserializer getDeserializer(int address) {
        return this.deserializers.get(address);
    }

    public void setDeserializer(int address, MessageDeserializer md) {
        this.deserializers.put(address, md);
    }
}

