/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.transport;

import java.util.Collection;
import java.util.HashSet;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.sourceroute.manager.simple.NextHopStrategy;
import rice.pastry.leafset.LeafSet;
import rice.pastry.socket.SocketNodeHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafSetNHStrategy
implements NextHopStrategy<MultiInetSocketAddress> {
    LeafSet ls;

    public void setLeafSet(LeafSet ls) {
        this.ls = ls;
    }

    @Override
    public Collection<MultiInetSocketAddress> getNextHops(MultiInetSocketAddress destination) {
        if (this.ls == null) {
            return null;
        }
        Collection<MultiInetSocketAddress> ret = this.walkLeafSet(destination, 8);
        return ret;
    }

    private Collection<MultiInetSocketAddress> walkLeafSet(MultiInetSocketAddress destination, int numRequested) {
        HashSet<MultiInetSocketAddress> result = new HashSet<MultiInetSocketAddress>();
        LeafSet leafset = this.ls;
        for (int i = 1; i < leafset.maxSize() / 2; ++i) {
            SocketNodeHandle snh = (SocketNodeHandle)leafset.get(-i);
            if (snh != null && !snh.eaddress.equals(destination)) {
                result.add(snh.eaddress);
                if (result.size() >= numRequested) {
                    return result;
                }
            }
            if ((snh = (SocketNodeHandle)leafset.get(i)) == null || snh.eaddress.equals(destination)) continue;
            result.add(snh.eaddress);
            if (result.size() < numRequested) continue;
            return result;
        }
        return result;
    }
}

