/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import rice.environment.Environment;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;

public class MemoryTest {
    public static void testOneEnvironment() throws Exception {
        int startPort = 5438;
        int ringSize = 10;
        int numNodes = 100;
        LinkedList<PastryNode> nodes = new LinkedList<PastryNode>();
        Runtime run = Runtime.getRuntime();
        long memUsed = run.totalMemory() - run.freeMemory();
        System.out.println("Memory:" + memUsed);
        Environment env = new Environment();
        env.getParameters().setBoolean("pastry_factory_selectorPerNode", false);
        env.getParameters().setBoolean("pastry_factory_processorPerNode", false);
        env.getParameters().setInt("pastry_socket_srm_num_source_route_attempts", 0);
        env.getParameters().setInt("pastry_socket_scm_ping_delay", 500);
        env.getParameters().setInt("pastry_socket_scm_num_ping_tries", 5);
        env.getParameters().setInt("pastry_protocol_periodicLeafSet_ping_neighbor_period", 8000);
        env.getParameters().setInt("pastry_protocol_periodicLeafSet_lease_period", 10000);
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        InetAddress localAddress = InetAddress.getLocalHost();
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(nidFactory, localAddress, startPort, env, null);
        InetSocketAddress bootaddress = new InetSocketAddress(localAddress, startPort);
        for (int curNode = 0; curNode < numNodes; ++curNode) {
            long waitedFor;
            NodeHandle bootHandle = factory.getNodeHandle(bootaddress);
            PastryNode node = ((PastryNodeFactory)factory).newNode(bootHandle);
            long waitTime = env.getTimeSource().currentTimeMillis();
            while (!node.isReady()) {
                Thread.sleep(1000L);
                waitedFor = env.getTimeSource().currentTimeMillis() - waitTime;
            }
            waitedFor = env.getTimeSource().currentTimeMillis() - waitTime;
            memUsed = run.totalMemory() - run.freeMemory();
            System.out.println(curNode + "/" + numNodes + " Memory:" + memUsed + " leafset size:" + node.getLeafSet().size() + " " + node + " after " + waitedFor);
            bootaddress = ((SocketNodeHandle)node.getLocalHandle()).getInetSocketAddress();
            nodes.addLast(node);
            if (curNode <= ringSize) continue;
            PastryNode pn = (PastryNode)nodes.removeFirst();
            System.out.println("Destroying pastry node " + pn);
            pn.destroy();
        }
        env.destroy();
    }

    public static void testMultiEnvironment() {
    }

    public static void testDirect() {
    }

    public static void main(String[] args) throws Exception {
        System.setOut(new PrintStream(new FileOutputStream("mem.txt")));
        System.setErr(System.out);
        MemoryTest.testOneEnvironment();
        MemoryTest.testMultiEnvironment();
    }
}

