/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import rice.environment.Environment;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.dist.DistPastryNodeFactory;
import rice.pastry.standard.IPNodeIdFactory;
import rice.pastry.testing.PastryRegrTest;
import rice.pastry.testing.RegrTestApp;

public class DistPastryRegrTest
extends PastryRegrTest {
    private static int port = 5009;
    private static String bshost;
    private static int bsport;
    private static int numnodes;
    private static int protocol;
    private InetSocketAddress bsaddress;

    public DistPastryRegrTest(Environment env) throws IOException {
        super(env);
        this.pastryNodesSorted = Collections.synchronizedSortedMap(this.pastryNodesSorted);
        this.factory = DistPastryNodeFactory.getFactory(new IPNodeIdFactory(InetAddress.getLocalHost(), port, env), protocol, port, env);
        try {
            this.bsaddress = new InetSocketAddress(bshost, bsport);
        }
        catch (Exception e) {
            System.out.println("ERROR (init): " + e);
        }
    }

    protected NodeHandle getBootstrap(boolean firstNode) {
        if (firstNode) {
            return ((DistPastryNodeFactory)this.factory).getNodeHandle(this.bsaddress);
        }
        InetSocketAddress addr = null;
        try {
            addr = new InetSocketAddress(InetAddress.getLocalHost().getHostName(), port);
        }
        catch (UnknownHostException e) {
            System.out.println(e);
        }
        return ((DistPastryNodeFactory)this.factory).getNodeHandle(addr);
    }

    private static void doInitstuff(String[] args) {
        int i;
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-help")) continue;
            System.out.println("Usage: DistPastryRegrTest [-port p] [-protocol (rmi|wire|socket)] [-nodes n] [-bootstrap host[:port]] [-help]");
            System.exit(1);
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-port") || i + 1 >= args.length) continue;
            int p = Integer.parseInt(args[i + 1]);
            if (p <= 0) break;
            port = p;
            break;
        }
        bsport = port;
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-bootstrap") || i + 1 >= args.length) continue;
            String str = args[i + 1];
            int index = str.indexOf(58);
            if (index == -1) {
                bshost = str;
                bsport = port;
                break;
            }
            bshost = str.substring(0, index);
            bsport = Integer.parseInt(str.substring(index + 1));
            if (bsport > 0) break;
            bsport = port;
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-nodes") || i + 1 >= args.length) continue;
            int n = Integer.parseInt(args[i + 1]);
            if (n <= 0) break;
            numnodes = n;
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-protocol") || i + 1 >= args.length) continue;
            String s = args[i + 1];
            if (s.equalsIgnoreCase("socket")) {
                protocol = DistPastryNodeFactory.PROTOCOL_SOCKET;
                break;
            }
            System.out.println("ERROR: Unsupported protocol: " + s);
            break;
        }
    }

    protected void registerapp(PastryNode pn, RegrTestApp app) {
    }

    public boolean simulate() {
        return false;
    }

    public synchronized void pause(int ms) {
        System.out.println("Waiting " + ms + "ms...");
        try {
            this.wait(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isReallyAlive(NodeHandle nh) {
        return false;
    }

    protected void killNode(PastryNode pn) {
        pn.destroy();
        this.pause(50000);
    }

    public static void main(String[] args) throws IOException {
        DistPastryRegrTest.doInitstuff(args);
        DistPastryRegrTest pt = new DistPastryRegrTest(new Environment());
        DistPastryRegrTest.mainfunc(pt, args, numnodes, 1, 1, 20, 4);
    }

    static {
        bsport = 5009;
        numnodes = 10;
        protocol = DistPastryNodeFactory.PROTOCOL_DEFAULT;
        try {
            bshost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            System.out.println("Error determining local host: " + e);
        }
    }
}

