/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mpisws.p2p.transport.exception.NodeIsFaultyException;
import rice.p2p.commonapi.exception.AppNotRegisteredException;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.routing.BroadcastRouteRow;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.Router;
import rice.pastry.routing.RouterAddress;
import rice.pastry.transport.PMessageNotification;
import rice.pastry.transport.PMessageReceipt;

public class StandardRouter
extends PastryAppl
implements Router {
    MessageDispatch dispatch;
    protected int ROUTE_TABLE_PATCH_THROTTLE = 5000;
    protected Map<NodeHandle, Long> lastTimeSentRouteTablePatch = new HashMap<NodeHandle, Long>();

    public StandardRouter(final PastryNode thePastryNode, MessageDispatch dispatch) {
        super(thePastryNode, null, RouterAddress.getCode(), new MessageDeserializer(){

            public rice.p2p.commonapi.Message deserialize(InputBuffer buf, short type, int priority, rice.p2p.commonapi.NodeHandle sender) throws IOException {
                RouteMessage rm = RouteMessage.build(buf, thePastryNode, (byte)thePastryNode.getEnvironment().getParameters().getInt("pastry_protocol_router_routeMsgVersion"));
                return rm;
            }
        });
        this.dispatch = dispatch;
    }

    public void receiveMessage(Message msg) {
        if (this.logger.level <= 400) {
            this.logger.log("receiveMessage(" + msg + ")");
        }
        if (!(msg instanceof RouteMessage)) {
            throw new Error("message " + msg + " bounced at StandardRouter");
        }
        this.route((RouteMessage)msg);
    }

    public void route(RouteMessage rm) {
        if (this.logger.level <= 500) {
            this.logger.log("route(" + rm + ")");
        }
        if (!this.routeMessage(rm)) {
            this.receiveRouteMessage(rm);
        }
    }

    public boolean routeMessage(RouteMessage rm) {
        if (this.logger.level <= 400) {
            this.logger.log("routeMessage(" + rm + ")");
        }
        if (rm.getNextHop() == null) {
            return false;
        }
        rm.setSender(this.thePastryNode.getLocalHandle());
        NodeHandle handle = rm.getNextHop();
        rm.setNextHop(null);
        rm.setPrevNode(this.thePastryNode.getLocalHandle());
        if (this.thePastryNode.getLocalHandle().equals(handle)) {
            this.thePastryNode.receiveMessage(rm.internalMsg);
            rm.sendSuccess();
        } else {
            this.sendTheMessage(rm, handle);
        }
        return true;
    }

    protected void sendTheMessage(final RouteMessage rm, final NodeHandle handle) {
        if (this.logger.level <= 400) {
            this.logger.log("sendTheMessage(" + rm + "," + handle + ")");
        }
        rm.setTLCancellable(this.thePastryNode.send(handle, rm, new PMessageNotification(){

            public void sent(PMessageReceipt msg) {
                rm.sendSuccess();
            }

            public void sendFailed(PMessageReceipt msg, Exception reason) {
                if (rm.sendFailed(reason)) {
                    if (((StandardRouter)StandardRouter.this).logger.level <= 700) {
                        StandardRouter.this.logger.logException("sendFailed(" + rm + ")=>" + handle, reason);
                    }
                } else if (((StandardRouter)StandardRouter.this).logger.level <= 500) {
                    StandardRouter.this.logger.logException("sendFailed(" + rm + ")=>" + handle, reason);
                } else if (((StandardRouter)StandardRouter.this).logger.level <= 900) {
                    StandardRouter.this.logger.log("sendFailed(" + rm + ")=>" + handle + " " + reason);
                }
            }
        }, rm.getTLOptions()));
    }

    private void receiveRouteMessage(RouteMessage msg) {
        Id target;
        if (this.logger.level <= 400) {
            this.logger.log("receiveRouteMessage(" + msg + ")");
        }
        if ((target = msg.getTarget()) == null) {
            target = this.thePastryNode.getNodeId();
        }
        int cwSize = this.thePastryNode.getLeafSet().cwSize();
        int ccwSize = this.thePastryNode.getLeafSet().ccwSize();
        int lsPos = this.thePastryNode.getLeafSet().mostSimilar(target);
        if (lsPos == 0) {
            msg.setNextHop(this.thePastryNode.getLocalHandle());
        } else if (lsPos > 0 && (lsPos < cwSize || !this.thePastryNode.getLeafSet().get(lsPos).getNodeId().clockwise(target)) || lsPos < 0 && (-lsPos < ccwSize || this.thePastryNode.getLeafSet().get(lsPos).getNodeId().clockwise(target))) {
            if (this.logger.level <= 300) {
                this.logger.log("receiveRouteMessage(" + msg + "):1");
            }
            msg.setNextHop(this.getBestHandleFromLeafset(msg, lsPos));
            if (msg.getNextHop() == null) {
                return;
            }
            this.thePastryNode.getRoutingTable().put(msg.getNextHop());
        } else {
            msg.getOptions().setRerouteIfSuspected(true);
            if (this.logger.level <= 300) {
                this.logger.log("receiveRouteMessage(" + msg + "):2");
            }
            RouteSet rs = this.thePastryNode.getRoutingTable().getBestEntry(target);
            NodeHandle handle = null;
            if (rs == null || (handle = rs.closestNode(1)) == null) {
                if (rs != null) {
                    for (int index = 0; index < rs.size(); ++index) {
                        NodeHandle nh = rs.get(index);
                        if (nh.isAlive()) continue;
                        rs.remove(nh);
                        --index;
                    }
                }
                if ((handle = this.thePastryNode.getRoutingTable().bestAlternateRoute(1, target)) != null) {
                    if (this.logger.level <= 300) {
                        this.logger.log("receiveRouteMessage(" + msg + "):3");
                    }
                    Id.Distance altDist = handle.getNodeId().distance(target);
                    Id.Distance lsDist = this.thePastryNode.getLeafSet().get(lsPos).getNodeId().distance(target);
                    if (lsDist.compareTo(altDist) < 0) {
                        handle = this.getBestHandleFromLeafset(msg, lsPos);
                        msg.setNextHop(handle);
                        if (msg.getNextHop() == null) {
                            return;
                        }
                        this.thePastryNode.getRoutingTable().put(msg.getNextHop());
                    }
                } else {
                    handle = this.getBestHandleFromLeafset(msg, lsPos);
                    msg.setNextHop(handle);
                    if (msg.getNextHop() == null) {
                        return;
                    }
                    this.thePastryNode.getRoutingTable().put(msg.getNextHop());
                }
            }
            msg.setNextHop(handle);
        }
        this.checkForRouteTableHole(msg, msg.getNextHop());
        msg.setPrevNode(this.thePastryNode.getLocalHandle());
        this.deliverToApplication(msg);
    }

    public void deliverToApplication(RouteMessage msg) {
        PastryAppl appl = this.dispatch.getDestinationByAddress(msg.getAuxAddress());
        if (appl == null) {
            if (msg.sendFailed(new AppNotRegisteredException(msg.getAuxAddress()))) {
                if (this.logger.level <= 700) {
                    this.logger.log("Dropping message " + msg + " because the application address " + msg.getAuxAddress() + " is unknown.");
                }
            } else if (this.logger.level <= 900) {
                this.logger.log("Dropping message " + msg + " because the application address " + msg.getAuxAddress() + " is unknown.");
            }
            return;
        }
        appl.receiveMessage(msg);
    }

    /*
     * Enabled aggressive block sorting
     */
    private NodeHandle getBestHandleFromLeafset(RouteMessage msg, int lsPos) {
        NodeHandle handle;
        block9: {
            handle = this.thePastryNode.getLeafSet().get(lsPos);
            switch (handle.getLiveness()) {
                case 1: {
                    msg.getOptions().setRerouteIfSuspected(true);
                    return handle;
                }
                case 2: {
                    if (lsPos > 0) {
                        break;
                    }
                    for (int i = lsPos; i < 0; ++i) {
                        NodeHandle temp = this.thePastryNode.getLeafSet().get(i);
                        if (temp.getLiveness() >= 2) continue;
                        handle = temp;
                        break block9;
                    }
                    break block9;
                }
                default: {
                    if (msg.sendFailed(new NodeIsFaultyException(handle))) {
                        if (this.logger.level > 700) return null;
                        this.logger.log("Dropping " + msg + " because next hop: " + handle + " is dead but has lease.");
                        return null;
                    }
                    if (this.logger.level > 900) return null;
                    this.logger.log("Dropping " + msg + " because next hop: " + handle + " is dead but has lease.");
                    return null;
                }
            }
            for (int i = lsPos - 1; i > 0; --i) {
                NodeHandle temp = this.thePastryNode.getLeafSet().get(i);
                if (temp.getLiveness() >= 2) continue;
                handle = temp;
                break;
            }
        }
        if (handle.getLiveness() < 2) {
            msg.getOptions().setRerouteIfSuspected(true);
            return handle;
        }
        msg.getOptions().setRerouteIfSuspected(false);
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForRouteTableHole(RouteMessage msg, NodeHandle handle) {
        Id key;
        int index;
        NodeHandle prevNode;
        if (this.logger.level <= 300) {
            this.logger.log("checkForRouteTableHole(" + msg + "," + handle + ")");
        }
        if ((prevNode = msg.getPrevNode()) == null) {
            if (this.logger.level <= 400) {
                this.logger.log("No prevNode defined in " + msg);
            }
            return;
        }
        if (prevNode.equals(this.getNodeHandle())) {
            if (this.logger.level <= 400) {
                this.logger.log("prevNode is me in " + msg);
            }
            return;
        }
        LeafSet ls = this.thePastryNode.getLeafSet();
        if (ls.overlaps()) {
            return;
        }
        if (ls.member(prevNode) && (index = ls.getIndex(prevNode)) != ls.cwSize() && index != -ls.ccwSize()) {
            return;
        }
        Id prevId = prevNode.getNodeId();
        int diffDigit = prevId.indexOfMSDD(key = msg.getTarget(), this.thePastryNode.getRoutingTable().baseBitLength());
        if (diffDigit >= 0 && diffDigit == this.thePastryNode.getNodeId().indexOfMSDD(key, this.thePastryNode.getRoutingTable().baseBitLength())) {
            Map<NodeHandle, Long> map = this.lastTimeSentRouteTablePatch;
            synchronized (map) {
                long lastTime;
                if (this.lastTimeSentRouteTablePatch.containsKey(prevNode) && (lastTime = this.lastTimeSentRouteTablePatch.get(prevNode).longValue()) > this.thePastryNode.getEnvironment().getTimeSource().currentTimeMillis() - (long)this.ROUTE_TABLE_PATCH_THROTTLE) {
                    if (this.logger.level <= 800) {
                        this.logger.log("not sending route table patch to " + prevNode + " because throttled.  Last Time:" + lastTime);
                    }
                    return;
                }
                this.lastTimeSentRouteTablePatch.put(prevNode, this.thePastryNode.getEnvironment().getTimeSource().currentTimeMillis());
            }
            RouteSet[] row = this.thePastryNode.getRoutingTable().getRow(diffDigit);
            BroadcastRouteRow brr = new BroadcastRouteRow(this.thePastryNode.getLocalHandle(), row);
            if (prevNode.isAlive()) {
                if (this.logger.level <= 500) {
                    this.logger.log("Found hole in " + prevNode + "'s routing table. Sending " + brr.toStringFull());
                }
                this.thePastryNode.send(prevNode, brr, null, this.options);
            }
        }
    }

    public boolean deliverWhenNotReady() {
        return true;
    }

    public void messageForAppl(Message msg) {
        throw new RuntimeException("Should not be called.");
    }
}

