/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.mpisws.p2p.transport.liveness.LivenessListener;
import org.mpisws.p2p.transport.priority.QueueOverflowException;
import rice.p2p.commonapi.Cancellable;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.routing.RouteMessage;
import rice.pastry.standard.StandardRouter;
import rice.pastry.standard.TooManyRouteAttempts;
import rice.pastry.transport.PMessageNotification;
import rice.pastry.transport.PMessageReceipt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RapidRerouter
extends StandardRouter
implements LivenessListener<NodeHandle> {
    public static final int MAX_RETRIES = 10;
    Map<NodeHandle, Collection<RouterNotification>> pending = new HashMap<NodeHandle, Collection<RouterNotification>>();

    public RapidRerouter(PastryNode thePastryNode, MessageDispatch dispatch) {
        super(thePastryNode, dispatch);
        thePastryNode.addLivenessListener(this);
    }

    @Override
    protected void sendTheMessage(RouteMessage rm, NodeHandle handle) {
        if (rm.getOptions().multipleHopsAllowed() && rm.getOptions().rerouteIfSuspected()) {
            if (handle.getLiveness() >= 2) {
                super.sendTheMessage(rm, handle);
                return;
            }
            RouterNotification notifyMe = new RouterNotification(rm, handle);
            this.addToPending(notifyMe, handle);
            rm.setTLCancellable(notifyMe);
            notifyMe.setCancellable(this.thePastryNode.send(handle, rm, notifyMe, rm.getTLOptions()));
        } else {
            super.sendTheMessage(rm, handle);
        }
    }

    protected void rerouteMe(final RouteMessage rm, NodeHandle oldDest, Exception ioe) {
        if (this.logger.level <= 500) {
            this.logger.log("rerouteMe(" + rm + " oldDest:" + oldDest + ")");
        }
        ++rm.numRetries;
        if (rm.numRetries > 10) {
            boolean dontPrint = false;
            dontPrint = ioe == null ? rm.sendFailed(new TooManyRouteAttempts(rm, 10)) : rm.sendFailed(ioe);
            if (dontPrint) {
                if (this.logger.level <= 700) {
                    this.logger.log("rerouteMe() dropping " + rm + " after " + rm.numRetries + " attempts to (re)route.");
                }
            } else if (this.logger.level <= 900) {
                this.logger.log("rerouteMe() dropping " + rm + " after " + rm.numRetries + " attempts to (re)route.");
            }
            return;
        }
        this.thePastryNode.getEnvironment().getSelectorManager().invoke(new Runnable(){

            public void run() {
                rm.getOptions().setRerouteIfSuspected(true);
                RapidRerouter.this.route(rm);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToPending(RouterNotification notifyMe, NodeHandle handle) {
        if (this.logger.level <= 500) {
            this.logger.log("addToPending(" + notifyMe + " to:" + handle + ")");
        }
        Map<NodeHandle, Collection<RouterNotification>> map = this.pending;
        synchronized (map) {
            Collection<RouterNotification> c = this.pending.get(handle);
            if (c == null) {
                c = new HashSet<RouterNotification>();
                this.pending.put(handle, c);
            }
            c.add(notifyMe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFromPending(RouterNotification notifyMe, NodeHandle handle) {
        Map<NodeHandle, Collection<RouterNotification>> map = this.pending;
        synchronized (map) {
            Collection<RouterNotification> c = this.pending.get(handle);
            if (c == null) {
                if (this.logger.level <= 500) {
                    this.logger.log("removeFromPending(" + notifyMe + "," + handle + ") had no pending messages for handle.");
                }
                return false;
            }
            boolean ret = c.remove(notifyMe);
            if (c.isEmpty()) {
                this.pending.remove(handle);
            }
            if (!ret && this.logger.level <= 500) {
                this.logger.log("removeFromPending(" + notifyMe + "," + handle + ") msg was not there.");
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void livenessChanged(NodeHandle i, int val, Map<String, Integer> options) {
        if (val >= 2) {
            Collection<RouterNotification> rerouteMe;
            Map<NodeHandle, Collection<RouterNotification>> map = this.pending;
            synchronized (map) {
                rerouteMe = this.pending.remove(i);
            }
            if (rerouteMe != null) {
                if (this.logger.level <= 500) {
                    this.logger.log("removing all messages to:" + i);
                }
                for (RouterNotification rn : rerouteMe) {
                    rn.cancel();
                    this.rerouteMe(rn.rm, rn.dest, null);
                }
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.thePastryNode.removeLivenessListener(this);
    }

    class RouterNotification
    implements Cancellable,
    PMessageNotification {
        RouteMessage rm;
        NodeHandle dest;
        PMessageReceipt cancellable;

        public RouterNotification(RouteMessage rm, NodeHandle handle) {
            this.rm = rm;
            this.dest = handle;
            if (((RapidRerouter)RapidRerouter.this).logger.level <= 500) {
                RapidRerouter.this.logger.log("RN.ctor() " + rm + " to:" + this.dest);
            }
        }

        public void setCancellable(PMessageReceipt receipt) {
            this.cancellable = receipt;
        }

        public void sendFailed(PMessageReceipt msg, Exception reason) {
            this.cancellable = null;
            this.rm.setTLCancellable(null);
            if (reason instanceof QueueOverflowException) {
                if (this.rm.sendFailed(reason)) {
                    if (((RapidRerouter)RapidRerouter.this).logger.level <= 700) {
                        RapidRerouter.this.logger.logException("sendFailed(" + msg.getMessage() + ")=>" + msg.getIdentifier(), reason);
                    }
                } else if (((RapidRerouter)RapidRerouter.this).logger.level <= 500) {
                    RapidRerouter.this.logger.logException("sendFailed(" + msg.getMessage() + ")=>" + msg.getIdentifier(), reason);
                } else if (((RapidRerouter)RapidRerouter.this).logger.level <= 900) {
                    RapidRerouter.this.logger.log("sendFailed(" + msg.getMessage() + ")=>" + msg.getIdentifier() + " " + reason);
                }
                return;
            }
            if (RapidRerouter.this.removeFromPending(this, this.dest)) {
                if (((RapidRerouter)RapidRerouter.this).logger.level <= 900) {
                    RapidRerouter.this.logger.logException("Send failed on message " + this.rm + " to " + this.dest + " rerouting." + msg, reason);
                }
                RapidRerouter.this.rerouteMe(this.rm, this.dest, reason);
            } else if (this.rm.sendFailed(reason)) {
                if (((RapidRerouter)RapidRerouter.this).logger.level <= 700) {
                    RapidRerouter.this.logger.logException("sendFailed(" + msg.getMessage() + ")=>" + msg.getIdentifier(), reason);
                }
            } else if (((RapidRerouter)RapidRerouter.this).logger.level <= 900) {
                RapidRerouter.this.logger.logException("sendFailed(" + msg.getMessage() + ")=>" + msg.getIdentifier(), reason);
            }
        }

        public void sent(PMessageReceipt msg) {
            if (((RapidRerouter)RapidRerouter.this).logger.level <= 500) {
                RapidRerouter.this.logger.log("Send success " + this.rm + " to:" + this.dest + " " + msg);
            }
            this.cancellable = null;
            this.rm.setTLCancellable(null);
            RapidRerouter.this.removeFromPending(this, this.dest);
            this.rm.sendSuccess();
        }

        public boolean cancel() {
            if (((RapidRerouter)RapidRerouter.this).logger.level <= 500) {
                RapidRerouter.this.logger.log("cancelling " + this);
            }
            return this.cancellable.cancel();
        }

        public String toString() {
            return "RN{" + this.rm + "->" + this.dest + "}";
        }
    }
}

