/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.io.IOException;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import rice.environment.params.Parameters;
import rice.environment.random.RandomSource;
import rice.environment.random.simple.SimpleRandomSource;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.util.TimerWeakHashMap;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSet;
import rice.pastry.NodeSetEventSource;
import rice.pastry.NodeSetListener;
import rice.pastry.PastryNode;
import rice.pastry.ReadyStrategy;
import rice.pastry.ScheduledMessage;
import rice.pastry.client.PastryAppl;
import rice.pastry.leafset.BroadcastLeafSet;
import rice.pastry.leafset.InitiateLeafSetMaintenance;
import rice.pastry.leafset.LeafSet;
import rice.pastry.leafset.LeafSetProtocolAddress;
import rice.pastry.leafset.RequestLeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.PJavaSerializedDeserializer;
import rice.pastry.routing.RoutingTable;
import rice.pastry.standard.InitiatePingNeighbor;
import rice.selector.TimerTask;

public class PeriodicLeafSetProtocol
extends PastryAppl
implements ReadyStrategy,
NodeSetListener,
Observer {
    protected NodeHandle localHandle;
    protected PastryNode localNode;
    protected LeafSet leafSet;
    protected RoutingTable routeTable;
    protected Map lastTimeReceivedBLS;
    protected Map lastTimeSentBLS;
    public final int PING_NEIGHBOR_PERIOD;
    public final int LEASE_PERIOD;
    public final int BLS_THROTTLE;
    ScheduledMessage pingNeighborMessage;
    RandomSource random;
    boolean hasSetStrategy = false;
    NodeHandle lastLeft;
    NodeHandle lastRight;
    boolean ready = false;
    Map lastTimeRenewedLease;
    boolean destroyed = false;

    public PeriodicLeafSetProtocol(PastryNode ln, NodeHandle local, LeafSet ls, RoutingTable rt) {
        super(ln, null, LeafSetProtocolAddress.getCode(), new PLSPMessageDeserializer(ln));
        this.localNode = ln;
        Parameters params = ln.getEnvironment().getParameters();
        this.random = params.contains("pastry_periodic_leafset_protocol_use_own_random") && params.getBoolean("pastry_periodic_leafset_protocol_use_own_random") ? (params.contains("pastry_periodic_leafset_protocol_random_seed") && !params.getString("pastry_periodic_leafset_protocol_random_seed").equalsIgnoreCase("clock") ? new SimpleRandomSource(params.getLong("pastry_periodic_leafset_protocol_random_seed"), ln.getEnvironment().getLogManager(), "socket") : new SimpleRandomSource(ln.getEnvironment().getLogManager(), "periodic_leaf_set")) : ln.getEnvironment().getRandomSource();
        this.localHandle = local;
        this.leafSet = ls;
        for (NodeHandle nh : this.leafSet.asList()) {
            nh.addObserver(this, 50);
        }
        this.routeTable = rt;
        this.lastTimeReceivedBLS = new TimerWeakHashMap(ln.getEnvironment().getSelectorManager().getTimer(), 300000);
        this.lastTimeSentBLS = new TimerWeakHashMap(ln.getEnvironment().getSelectorManager().getTimer(), 300000);
        Parameters p = ln.getEnvironment().getParameters();
        this.PING_NEIGHBOR_PERIOD = p.getInt("pastry_protocol_periodicLeafSet_ping_neighbor_period");
        this.LEASE_PERIOD = p.getInt("pastry_protocol_periodicLeafSet_lease_period");
        this.BLS_THROTTLE = p.getInt("pastry_protocol_periodicLeafSet_request_lease_throttle");
        this.lastTimeRenewedLease = new TimerWeakHashMap(ln.getEnvironment().getSelectorManager().getTimer(), this.LEASE_PERIOD * 2);
        this.pingNeighborMessage = this.localNode.scheduleMsgAtFixedRate(new InitiatePingNeighbor(), this.PING_NEIGHBOR_PERIOD, this.PING_NEIGHBOR_PERIOD);
    }

    private void updateRecBLS(NodeHandle from, long time) {
        if (time == 0L) {
            return;
        }
        Long oldTime = (Long)this.lastTimeReceivedBLS.get(from);
        if (oldTime == null || oldTime < time) {
            this.lastTimeReceivedBLS.put(from, new Long(time));
            if (this.logger.level <= 500) {
                this.logger.log("PLSP.updateRecBLS(" + from + "," + time + ")");
            }
            if (this.hasSetStrategy) {
                this.isReady();
            }
        }
    }

    public void receiveMessage(Message msg) {
        if (msg instanceof BroadcastLeafSet) {
            BroadcastLeafSet bls = (BroadcastLeafSet)msg;
            if (bls.type() == 1) {
                this.leafSet.merge(bls.leafSet(), bls.from(), this.routeTable, false, null);
                this.broadcastAll();
            } else {
                int i;
                NodeSet set = this.leafSet.neighborSet(Integer.MAX_VALUE);
                for (i = 0; i < set.size(); ++i) {
                    if (!bls.leafSet().test(set.get(i))) continue;
                    set.get(i).checkLiveness();
                }
                set = bls.leafSet().neighborSet(Integer.MAX_VALUE);
                for (i = 0; i < set.size(); ++i) {
                    if (set.get(i).isAlive()) continue;
                    set.get(i).checkLiveness();
                }
                this.leafSet.merge(bls.leafSet(), bls.from(), this.routeTable, false, null);
            }
            if (bls.leafSet().get(1) == this.localHandle || bls.leafSet().get(-1) == this.localHandle) {
                this.updateRecBLS(bls.from(), bls.getTimeStamp());
            }
        } else if (msg instanceof RequestLeafSet) {
            RequestLeafSet rls = (RequestLeafSet)msg;
            if (rls.getTimeStamp() > 0L) {
                this.lastTimeRenewedLease.put(rls.returnHandle(), new Long(this.localNode.getEnvironment().getTimeSource().currentTimeMillis()));
                this.leafSet.put(rls.returnHandle());
                if (!rls.returnHandle().isAlive()) {
                    if (this.logger.level <= 800) {
                        this.logger.log("Issued lease to dead node:" + rls.returnHandle() + " initiating checkLiveness()");
                    }
                    rls.returnHandle().checkLiveness();
                }
            }
            this.thePastryNode.send(rls.returnHandle(), new BroadcastLeafSet(this.localHandle, this.leafSet, 0, rls.getTimeStamp()), null, this.options);
        } else if (msg instanceof InitiateLeafSetMaintenance) {
            NodeSet set = this.leafSet.neighborSet(Integer.MAX_VALUE);
            if (set.size() > 1) {
                NodeHandle handle = set.get(this.random.nextInt(set.size() - 1) + 1);
                this.thePastryNode.send(handle, new RequestLeafSet(this.localHandle, this.localNode.getEnvironment().getTimeSource().currentTimeMillis()), null, this.options);
                this.thePastryNode.send(handle, new BroadcastLeafSet(this.localHandle, this.leafSet, 0, 0L), null, this.options);
                NodeHandle check = set.get(this.random.nextInt(set.size() - 1) + 1);
                check.checkLiveness();
            }
        } else if (msg instanceof InitiatePingNeighbor) {
            NodeHandle left = this.leafSet.get(-1);
            NodeHandle right = this.leafSet.get(1);
            if (left != null) {
                this.sendBLS(left, !this.hasLease(left));
            }
            if (right != null) {
                this.sendBLS(right, !this.hasLease(right));
            }
        }
    }

    protected void broadcastAll() {
        BroadcastLeafSet bls = new BroadcastLeafSet(this.localHandle, this.leafSet, 2, 0L);
        NodeSet set = this.leafSet.neighborSet(Integer.MAX_VALUE);
        for (int i = 1; i < set.size(); ++i) {
            this.thePastryNode.send(set.get(i), bls, null, this.options);
        }
    }

    public void start() {
        if (!this.hasSetStrategy) {
            if (this.logger.level <= 800) {
                this.logger.log("PLSP.start(): Setting self as ReadyStrategy");
            }
            this.localNode.setReadyStrategy(this);
            this.hasSetStrategy = true;
            this.localNode.addLeafSetListener(this);
            this.isReady();
        }
    }

    public void stop() {
        if (this.hasSetStrategy) {
            if (this.logger.level <= 800) {
                this.logger.log("PLSP.start(): Removing self as ReadyStrategy");
            }
            this.hasSetStrategy = false;
            this.localNode.deleteLeafSetListener(this);
        }
    }

    public void nodeSetUpdate(NodeSetEventSource nodeSetEventSource, NodeHandle handle, boolean added) {
        NodeHandle newRight;
        NodeHandle newLeft = this.leafSet.get(-1);
        if (newLeft != null && this.lastLeft != newLeft) {
            this.lastLeft = newLeft;
            this.sendBLS(this.lastLeft, true);
        }
        if ((newRight = this.leafSet.get(1)) != null && this.lastRight != newRight) {
            this.lastRight = newRight;
            this.sendBLS(this.lastRight, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReady(boolean r) {
        if (this.ready != r) {
            PastryNode pastryNode = this.thePastryNode;
            synchronized (pastryNode) {
                this.ready = r;
            }
            this.thePastryNode.notifyReadyObservers();
        }
    }

    public boolean isReady() {
        boolean shouldBeReady = this.shouldBeReady();
        if (shouldBeReady != this.ready) {
            this.thePastryNode.setReady(shouldBeReady);
        }
        return shouldBeReady;
    }

    public boolean shouldBeReady() {
        NodeHandle left = this.leafSet.get(-1);
        NodeHandle right = this.leafSet.get(1);
        boolean ret = true;
        if (!this.hasLease(left)) {
            ret = false;
            this.sendBLS(left, true);
        }
        if (!this.hasLease(right)) {
            ret = false;
            this.sendBLS(right, true);
        }
        return ret;
    }

    public boolean hasLease(NodeHandle nh) {
        Long time;
        long curTime = this.localNode.getEnvironment().getTimeSource().currentTimeMillis();
        long leaseOffset = curTime - (long)this.LEASE_PERIOD;
        return nh == null || (time = (Long)this.lastTimeReceivedBLS.get(nh)) != null && time >= leaseOffset;
    }

    private boolean sendBLS(NodeHandle sendTo, boolean checkLiveness) {
        Long time = (Long)this.lastTimeSentBLS.get(sendTo);
        long currentTime = this.localNode.getEnvironment().getTimeSource().currentTimeMillis();
        if (time == null || time < currentTime - (long)this.BLS_THROTTLE) {
            if (this.logger.level <= 500) {
                this.logger.log("PeriodicLeafSetProtocol: Checking liveness on neighbor:" + sendTo + " " + time);
            }
            this.lastTimeSentBLS.put(sendTo, new Long(currentTime));
            this.thePastryNode.send(sendTo, new BroadcastLeafSet(this.localHandle, this.leafSet, 0, 0L), null, this.options);
            this.thePastryNode.send(sendTo, new RequestLeafSet(this.localHandle, currentTime), null, this.options);
            if (checkLiveness) {
                sendTo.checkLiveness();
            }
            return true;
        }
        return false;
    }

    public void messageForAppl(Message msg) {
        throw new RuntimeException("Should not be called.");
    }

    public boolean deliverWhenNotReady() {
        return true;
    }

    public void destroy() {
        if (this.logger.level <= 800) {
            this.logger.log("PLSP: destroy() called");
        }
        this.destroyed = true;
        if (this.pingNeighborMessage != null) {
            this.pingNeighborMessage.cancel();
        }
        this.pingNeighborMessage = null;
        this.lastLeft = null;
        this.lastRight = null;
        this.lastTimeReceivedBLS.clear();
        this.lastTimeRenewedLease.clear();
        this.lastTimeSentBLS.clear();
    }

    public void leafSetChange(NodeHandle nh, boolean wasAdded) {
        super.leafSetChange(nh, wasAdded);
        if (wasAdded) {
            nh.addObserver(this, 50);
            if (!nh.isAlive()) {
                this.removeFromLeafsetIfPossible(nh);
            }
        } else {
            if (this.logger.level <= 500) {
                this.logger.log("Removed " + nh + " from the LeafSet.");
            }
            nh.deleteObserver(this);
        }
    }

    public void update(Observable o, Object arg) {
        if (this.destroyed) {
            return;
        }
        if (arg == NodeHandle.DECLARED_DEAD) {
            this.removeFromLeafsetIfPossible((NodeHandle)o);
        }
    }

    public void removeFromLeafsetIfPossible(final NodeHandle nh) {
        if (nh.isAlive()) {
            return;
        }
        Long l_time = (Long)this.lastTimeRenewedLease.get(nh);
        if (l_time == null) {
            this.leafSet.remove(nh);
        } else {
            long now;
            long leaseExpiration = l_time + (long)this.LEASE_PERIOD;
            if (leaseExpiration > (now = this.thePastryNode.getEnvironment().getTimeSource().currentTimeMillis())) {
                if (this.logger.level <= 800) {
                    this.logger.log("Removing " + nh + " from leafset later." + (leaseExpiration - now));
                }
                this.thePastryNode.getEnvironment().getSelectorManager().getTimer().schedule(new TimerTask(){

                    public void run() {
                        if (((PeriodicLeafSetProtocol)PeriodicLeafSetProtocol.this).logger.level <= 500) {
                            PeriodicLeafSetProtocol.this.logger.log("removeFromLeafsetIfPossible(" + nh + ")");
                        }
                        PeriodicLeafSetProtocol.this.removeFromLeafsetIfPossible(nh);
                    }
                }, leaseExpiration - now);
            } else {
                this.leafSet.remove(nh);
            }
        }
    }

    public static class PLSPMessageDeserializer
    extends PJavaSerializedDeserializer {
        public PLSPMessageDeserializer(PastryNode pn) {
            super(pn);
        }

        public Message deserialize(InputBuffer buf, short type, int priority, NodeHandle sender) throws IOException {
            switch (type) {
                case 1: {
                    return new RequestLeafSet(sender, buf);
                }
                case 2: {
                    return new BroadcastLeafSet(buf, this.pn);
                }
            }
            return null;
        }
    }
}

