/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSetEventSource;
import rice.pastry.NodeSetListener;
import rice.pastry.PastryNode;
import rice.pastry.join.JoinRequest;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.selector.Timer;
import rice.selector.TimerTask;

public class PartitionHandler
extends TimerTask
implements NodeSetListener {
    PastryNode pastryNode;
    InetSocketAddress[] bootstraps;
    SocketPastryNodeFactory factory;
    Logger logger;
    double bootstrapRate;
    int maxGoneSize;
    int maxGoneAge;
    Map gone;
    Environment env;

    public PartitionHandler(PastryNode pn, SocketPastryNodeFactory factory, InetSocketAddress[] bootstraps) {
        this.pastryNode = pn;
        this.factory = factory;
        this.bootstraps = bootstraps;
        this.env = this.pastryNode.getEnvironment();
        this.gone = new HashMap();
        this.logger = pn.getEnvironment().getLogManager().getLogger(PartitionHandler.class, "");
        this.maxGoneSize = this.env.getParameters().getInt("partition_handler_max_history_size");
        this.maxGoneAge = this.env.getParameters().getInt("partition_handler_max_history_age");
        this.bootstrapRate = this.env.getParameters().getDouble("partition_handler_bootstrap_check_rate");
        this.pastryNode.getLeafSet().addNodeSetListener(this);
        this.pastryNode.getRoutingTable().addNodeSetListener(this);
    }

    private synchronized void doGoneMaintainence() {
        Iterator it = this.gone.values().iterator();
        long now = this.env.getTimeSource().currentTimeMillis();
        if (this.logger.level <= 500) {
            this.logger.log("Doing maintainence in PartitionHandler " + now);
        }
        if (this.logger.level <= 400) {
            this.logger.log("gone size 1 is " + this.gone.size() + " of " + this.maxGoneSize);
        }
        while (it.hasNext()) {
            GoneSetEntry g = (GoneSetEntry)it.next();
            if (now - g.timestamp > (long)this.maxGoneAge) {
                if (this.logger.level <= 300) {
                    this.logger.log("Removing " + g + " from gone due to expiry");
                }
                it.remove();
                continue;
            }
            if (g.nh.getLiveness() <= 3) continue;
            if (this.logger.level <= 300) {
                this.logger.log("Removing " + g + " from gone due to death");
            }
            it.remove();
        }
        if (this.logger.level <= 400) {
            this.logger.log("gone size 2 is " + this.gone.size() + " of " + this.maxGoneSize);
        }
        while (this.gone.size() > this.maxGoneSize) {
            Object key = this.gone.keySet().iterator().next();
            this.gone.remove(key);
        }
        if (this.logger.level <= 400) {
            this.logger.log("gone size 3 is " + this.gone.size() + " of " + this.maxGoneSize);
        }
    }

    private List getRoutingTableAsList() {
        RoutingTable rt = this.pastryNode.getRoutingTable();
        ArrayList<NodeHandle> rtHandles = new ArrayList<NodeHandle>(rt.numEntries());
        for (int r = 0; r < rt.numRows(); ++r) {
            RouteSet[] row = rt.getRow(r);
            for (int c = 0; c < rt.numColumns(); ++c) {
                RouteSet entry = row[c];
                if (entry == null) continue;
                for (int i = 0; i < entry.size(); ++i) {
                    NodeHandle nh = entry.get(i);
                    if (nh.equals(this.pastryNode.getLocalHandle())) continue;
                    rtHandles.add(nh);
                }
            }
        }
        return rtHandles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeHandle getGone() {
        int which;
        PartitionHandler partitionHandler = this;
        synchronized (partitionHandler) {
            which = this.env.getRandomSource().nextInt(this.maxGoneSize);
            if (this.logger.level <= 300) {
                this.logger.log("getGone choosing node " + which + " from gone or routing table");
            }
            Iterator it = this.gone.values().iterator();
            while (which > 0 && it.hasNext()) {
                --which;
                it.next();
            }
            if (it.hasNext()) {
                if (this.logger.level <= 300) {
                    this.logger.log("getGone chose node from gone " + which);
                }
                return ((GoneSetEntry)it.next()).nh;
            }
        }
        List rtHandles = this.getRoutingTableAsList();
        if (rtHandles.isEmpty()) {
            if (this.logger.level <= 800) {
                this.logger.log("getGone returning null; routing table is empty!");
            }
            return null;
        }
        which = this.env.getRandomSource().nextInt(rtHandles.size());
        if (this.logger.level <= 300) {
            this.logger.log("getGone choosing node " + which + " from routing table");
        }
        return (NodeHandle)rtHandles.get(which);
    }

    private void getNodeHandleToProbe(Continuation c) {
        if (this.env.getRandomSource().nextDouble() > this.bootstrapRate) {
            NodeHandle nh = this.getGone();
            if (this.logger.level <= 300) {
                this.logger.log("getGone chose " + nh);
            }
            if (nh != null) {
                c.receiveResult(nh);
                return;
            }
        }
        if (this.logger.level <= 300) {
            this.logger.log("getNodeHandleToProbe choosing bootstrap");
        }
        this.factory.getNodeHandle(this.bootstraps, c);
    }

    public void run() {
        if (this.logger.level <= 800) {
            this.logger.log("running partition handler");
        }
        this.doGoneMaintainence();
        this.getNodeHandleToProbe(new Continuation(){

            public void receiveResult(Object result) {
                if (result != null) {
                    JoinRequest jr = new JoinRequest(PartitionHandler.this.pastryNode.getLocalHandle(), PartitionHandler.this.pastryNode.getRoutingTable().baseBitLength());
                    RouteMessage rm = new RouteMessage(PartitionHandler.this.pastryNode.getLocalHandle().getNodeId(), jr, null, null, (byte)PartitionHandler.this.env.getParameters().getInt("pastry_protocol_router_routeMsgVersion"));
                    rm.setPrevNode(PartitionHandler.this.pastryNode.getLocalHandle());
                    rm.getOptions().setRerouteIfSuspected(false);
                    NodeHandle nh = PartitionHandler.this.pastryNode.coalesce((NodeHandle)result);
                    try {
                        nh.bootstrap(rm);
                    }
                    catch (IOException ioe) {
                        if (PartitionHandler.this.logger.level <= 900) {
                            PartitionHandler.this.logger.logException("Error bootstrapping.", ioe);
                        }
                    }
                } else if (PartitionHandler.this.logger.level <= 800) {
                    PartitionHandler.this.logger.log("getNodeHandleToProbe returned null");
                }
            }

            public void receiveException(Exception result) {
                if (PartitionHandler.this.logger.level <= 800) {
                    PartitionHandler.this.logger.logException("exception in PartitionHandler", result);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeSetUpdate(NodeSetEventSource nodeSetEventSource, NodeHandle handle, boolean added) {
        PartitionHandler partitionHandler;
        if (nodeSetEventSource.equals(this.pastryNode.getLeafSet()) && added) {
            partitionHandler = this;
            synchronized (partitionHandler) {
                this.gone.remove(handle.getId());
            }
        }
        if (!added) {
            partitionHandler = this;
            synchronized (partitionHandler) {
                if (handle.getLiveness() == 3) {
                    if (this.gone.containsKey(handle.getId())) {
                        if (this.logger.level <= 300) {
                            this.logger.log("PartitionHandler updating node " + handle);
                        }
                        ((GoneSetEntry)this.gone.get((Object)handle.getId())).nh = handle;
                    } else {
                        GoneSetEntry g = new GoneSetEntry(handle, this.env.getTimeSource().currentTimeMillis());
                        if (this.logger.level <= 300) {
                            this.logger.log("PartitionHandler adding node " + g);
                        }
                        this.gone.put(handle.getId(), g);
                    }
                }
            }
        }
    }

    public void start(Timer timer) {
        if (this.logger.level <= 800) {
            this.logger.log("installing partition handler");
        }
        timer.schedule(this, this.env.getParameters().getInt("partition_handler_check_interval"), this.env.getParameters().getInt("partition_handler_check_interval"));
    }

    private static class GoneSetEntry {
        public NodeHandle nh;
        public long timestamp;

        public GoneSetEntry(NodeHandle nh, long timestamp) {
            this.nh = nh;
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            GoneSetEntry other = (GoneSetEntry)o;
            return other.nh.getId().equals(this.nh.getId());
        }

        public String toString() {
            return this.nh.toString() + " " + this.timestamp;
        }
    }
}

