/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.commonapi.CommonAPITransportLayer;
import org.mpisws.p2p.transport.commonapi.CommonAPITransportLayerImpl;
import org.mpisws.p2p.transport.commonapi.IdFactory;
import org.mpisws.p2p.transport.commonapi.TransportLayerNodeHandle;
import org.mpisws.p2p.transport.exception.NodeIsFaultyException;
import org.mpisws.p2p.transport.identity.IdentityImpl;
import org.mpisws.p2p.transport.identity.IdentitySerializer;
import org.mpisws.p2p.transport.identity.LowerIdentity;
import org.mpisws.p2p.transport.identity.NodeChangeStrategy;
import org.mpisws.p2p.transport.identity.SanityChecker;
import org.mpisws.p2p.transport.identity.UpperIdentity;
import org.mpisws.p2p.transport.liveness.LivenessListener;
import org.mpisws.p2p.transport.liveness.LivenessTransportLayer;
import org.mpisws.p2p.transport.liveness.LivenessTransportLayerImpl;
import org.mpisws.p2p.transport.multiaddress.MultiInetAddressTransportLayer;
import org.mpisws.p2p.transport.multiaddress.MultiInetAddressTransportLayerImpl;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.priority.PriorityTransportLayer;
import org.mpisws.p2p.transport.priority.PriorityTransportLayerImpl;
import org.mpisws.p2p.transport.proximity.MinRTTProximityProvider;
import org.mpisws.p2p.transport.sourceroute.SourceRoute;
import org.mpisws.p2p.transport.sourceroute.SourceRouteTransportLayer;
import org.mpisws.p2p.transport.sourceroute.SourceRouteTransportLayerImpl;
import org.mpisws.p2p.transport.sourceroute.factory.MultiAddressSourceRouteFactory;
import org.mpisws.p2p.transport.sourceroute.manager.SourceRouteManager;
import org.mpisws.p2p.transport.sourceroute.manager.SourceRouteManagerImpl;
import org.mpisws.p2p.transport.sourceroute.manager.simple.SimpleSourceRouteStrategy;
import org.mpisws.p2p.transport.wire.WireTransportLayer;
import org.mpisws.p2p.transport.wire.WireTransportLayerImpl;
import org.mpisws.p2p.transport.wire.magicnumber.MagicNumberTransportLayer;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.CloneableLogManager;
import rice.environment.logging.LogManager;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.environment.processing.Processor;
import rice.environment.processing.simple.SimpleProcessor;
import rice.environment.random.RandomSource;
import rice.environment.random.simple.SimpleRandomSource;
import rice.environment.time.simulated.DirectTimeSource;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.boot.Bootstrapper;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketNodeHandleFactory;
import rice.pastry.socket.nat.NATHandler;
import rice.pastry.socket.nat.StubNATHandler;
import rice.pastry.standard.ProximityNeighborSelector;
import rice.pastry.transport.BogusNodeHandle;
import rice.pastry.transport.LeafSetNHStrategy;
import rice.pastry.transport.NodeHandleAdapter;
import rice.pastry.transport.TLDeserializer;
import rice.pastry.transport.TLPastryNode;
import rice.pastry.transport.TransportPastryNodeFactory;
import rice.selector.SelectorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketPastryNodeFactory
extends TransportPastryNodeFactory {
    public static final byte[] PASTRY_MAGIC_NUMBER = new byte[]{39, 64, 117, 58};
    private int port;
    protected NodeIdFactory nidFactory;
    protected RandomSource random;
    private InetAddress localAddress;
    InetAddress[] addressList;
    protected int testFireWallPolicy;
    protected int findFireWallPolicy;
    NATHandler natHandler;
    String firewallAppName;
    int firewallSearchTries;

    public SocketPastryNodeFactory(NodeIdFactory nf, int startPort, Environment env) throws IOException {
        this(nf, null, startPort, env, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketPastryNodeFactory(NodeIdFactory nf, InetAddress bindAddress, int startPort, Environment env, NATHandler handler) throws IOException {
        super(env);
        if (env.getTimeSource() instanceof DirectTimeSource) {
            throw new IllegalArgumentException("SocketPastryNodeFactory is not compatible with the DirectTimeSource in the environment.  Please use the SimpleTimeSource or an equivalent.");
        }
        this.environment = env;
        this.nidFactory = nf;
        this.port = startPort;
        Parameters params = env.getParameters();
        this.firewallSearchTries = params.getInt("nat_find_port_max_tries");
        this.firewallAppName = params.getString("nat_app_name");
        this.natHandler = handler;
        this.localAddress = bindAddress;
        if (this.localAddress == null && params.contains("socket_bindAddress")) {
            this.localAddress = params.getInetAddress("socket_bindAddress");
        }
        if (this.localAddress == null) {
            this.localAddress = InetAddress.getLocalHost();
            Socket temp = null;
            ServerSocket test2 = null;
            if (this.localAddress.isLoopbackAddress() && !params.getBoolean("pastry_socket_allow_loopback")) {
                try {
                    temp = new Socket(params.getString("pastry_socket_known_network_address"), params.getInt("pastry_socket_known_network_address_port"));
                    if (temp.getLocalAddress().equals(this.localAddress)) {
                        throw new IllegalStateException("Cannot bind to " + this.localAddress + ":" + this.port);
                    }
                    this.localAddress = temp.getLocalAddress();
                    temp.close();
                    temp = null;
                    if (this.logger.level <= 900) {
                        this.logger.log("Error binding to default IP, using " + this.localAddress + ":" + this.port);
                    }
                    try {
                        test2 = new ServerSocket();
                        test2.bind(new InetSocketAddress(this.localAddress, this.port));
                    }
                    catch (SocketException e2) {
                        throw new IllegalStateException("Cannot bind to " + this.localAddress + ":" + this.port, e2);
                    }
                }
                finally {
                    try {
                        if (test2 != null) {
                            test2.close();
                        }
                    }
                    catch (Exception e) {}
                    try {
                        if (temp != null) {
                            temp.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
        }
        if (this.natHandler == null) {
            if (params.contains("nat_handler_class")) {
                try {
                    Class<?> natHandlerClass = Class.forName(params.getString("nat_handler_class"));
                    Class[] args = new Class[]{Environment.class, InetAddress.class};
                    Constructor<?> constructor = natHandlerClass.getConstructor(args);
                    Object[] foo = new Object[]{this.environment, this.localAddress};
                    this.natHandler = (NATHandler)constructor.newInstance(foo);
                }
                catch (ClassNotFoundException e) {
                    if (this.logger.level <= 800) {
                        this.logger.log("Didn't find UPnP libs, skipping UPnP");
                    }
                    this.natHandler = new StubNATHandler(this.environment, this.localAddress);
                }
                catch (NoClassDefFoundError e) {
                    if (this.logger.level <= 800) {
                        this.logger.log("Didn't find UPnP libs, skipping UPnP");
                    }
                    this.natHandler = new StubNATHandler(this.environment, this.localAddress);
                }
                catch (Exception e) {
                    if (this.logger.level <= 900) {
                        this.logger.logException("Error constructing NATHandler.", e);
                    }
                    throw new RuntimeException(e);
                }
            } else {
                this.natHandler = new StubNATHandler(this.environment, this.localAddress);
            }
        }
        this.random = params.contains("pastry_socket_use_own_random") && params.getBoolean("pastry_socket_use_own_random") ? (params.contains("pastry_socket_random_seed") && !params.getString("pastry_socket_random_seed").equalsIgnoreCase("clock") ? new SimpleRandomSource(params.getLong("pastry_socket_random_seed"), env.getLogManager(), "socket") : new SimpleRandomSource(env.getLogManager(), "socket")) : env.getRandomSource();
    }

    @Override
    public NodeHandle getLocalHandle(TLPastryNode pn, NodeHandleFactory nhf, Object localNodeInfo) {
        SocketNodeHandleFactory pnhf = (SocketNodeHandleFactory)nhf;
        MultiInetSocketAddress proxyAddress = (MultiInetSocketAddress)localNodeInfo;
        return pnhf.getNodeHandle(proxyAddress, this.environment.getTimeSource().currentTimeMillis(), pn.getNodeId());
    }

    @Override
    public NodeHandleFactory getNodeHandleFactory(TLPastryNode pn) {
        return new SocketNodeHandleFactory(pn);
    }

    @Override
    public NodeHandleAdapter getNodeHanldeAdapter(TLPastryNode pn, NodeHandleFactory handleFactory2, TLDeserializer deserializer) throws IOException {
        MultiInetSocketAddress localAddress;
        Environment environment = pn.getEnvironment();
        SocketNodeHandle localhandle = (SocketNodeHandle)pn.getLocalHandle();
        SocketNodeHandleFactory handleFactory = (SocketNodeHandleFactory)handleFactory2;
        MultiInetSocketAddress proxyAddress = localAddress = localhandle.eaddress;
        WireTransportLayer wtl = this.getWireTransportLayer(localAddress.getInnermostAddress(), pn);
        TransportLayer<InetSocketAddress, ByteBuffer> mntl = this.getMagicNumberTransportLayer(wtl, pn);
        MultiInetAddressTransportLayerImpl etl = new MultiInetAddressTransportLayerImpl(localAddress, mntl, environment, null, null);
        MultiAddressSourceRouteFactory esrFactory = this.getMultiAddressSourceRouteFactory(pn);
        SourceRouteTransportLayer<MultiInetSocketAddress> srl = this.getSourceRouteTransportLayer(etl, pn, esrFactory);
        IdentityImpl<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress, ByteBuffer, SourceRoute<MultiInetSocketAddress>> identity = this.getIdentityImpl(pn, handleFactory);
        LowerIdentity<SourceRoute<MultiInetSocketAddress>, ByteBuffer> lowerIdentityLayer = this.getLowerIdentityLayer(srl, pn, identity);
        LivenessTransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> ltl = this.getLivenessTransportLayer(lowerIdentityLayer, pn);
        SourceRouteManager<MultiInetSocketAddress> srm = this.getSourceRouteManagerLayer(ltl, pn, proxyAddress, esrFactory);
        PriorityTransportLayer<MultiInetSocketAddress> priorityTL = this.getPriorityTransportLayer(srm, pn);
        UpperIdentity<TransportLayerNodeHandle<MultiInetSocketAddress>, ByteBuffer> upperIdentityLayer = this.getUpperIdentityLayer(priorityTL, pn, identity, srm);
        CommonAPITransportLayer<TransportLayerNodeHandle<MultiInetSocketAddress>> commonAPItl = this.getCommonAPITransportLayer(upperIdentityLayer, pn, deserializer);
        NodeHandleAdapter nha = new NodeHandleAdapter(commonAPItl, upperIdentityLayer, upperIdentityLayer);
        return nha;
    }

    protected WireTransportLayer getWireTransportLayer(InetSocketAddress innermostAddress, TLPastryNode pn) throws IOException {
        Environment environment = pn.getEnvironment();
        WireTransportLayerImpl wtl = new WireTransportLayerImpl(innermostAddress, environment, null);
        return wtl;
    }

    protected TransportLayer<InetSocketAddress, ByteBuffer> getMagicNumberTransportLayer(WireTransportLayer wtl, TLPastryNode pn) {
        Environment environment = pn.getEnvironment();
        MagicNumberTransportLayer<InetSocketAddress> mntl = new MagicNumberTransportLayer<InetSocketAddress>(wtl, environment, null, PASTRY_MAGIC_NUMBER, 5000);
        return mntl;
    }

    protected MultiAddressSourceRouteFactory getMultiAddressSourceRouteFactory(TLPastryNode pn) {
        return new MultiAddressSourceRouteFactory();
    }

    protected SourceRouteTransportLayer<MultiInetSocketAddress> getSourceRouteTransportLayer(MultiInetAddressTransportLayer etl, TLPastryNode pn, MultiAddressSourceRouteFactory esrFactory) {
        Environment environment = pn.getEnvironment();
        SourceRouteTransportLayerImpl<MultiInetSocketAddress> srl = new SourceRouteTransportLayerImpl<MultiInetSocketAddress>(esrFactory, etl, environment, null);
        return srl;
    }

    protected IdentityImpl<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress, ByteBuffer, SourceRoute<MultiInetSocketAddress>> getIdentityImpl(final TLPastryNode pn, final SocketNodeHandleFactory handleFactory) throws IOException {
        Environment environment = pn.getEnvironment();
        SocketNodeHandle localhandle = (SocketNodeHandle)pn.getLocalHandle();
        IdentitySerializer<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress, SourceRoute<MultiInetSocketAddress>> serializer = new IdentitySerializer<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress, SourceRoute<MultiInetSocketAddress>>(){

            @Override
            public TransportLayerNodeHandle<MultiInetSocketAddress> deserialize(InputBuffer buf, SourceRoute<MultiInetSocketAddress> i) throws IOException {
                long epoch = buf.readLong();
                Id nid = Id.build(buf);
                return (TransportLayerNodeHandle)((Object)handleFactory.coalesce(new SocketNodeHandle(i.getLastHop(), epoch, nid, pn)));
            }

            @Override
            public void serialize(OutputBuffer buf, TransportLayerNodeHandle<MultiInetSocketAddress> i) throws IOException {
                long epoch = i.getEpoch();
                Id nid = (Id)i.getId();
                buf.writeLong(epoch);
                nid.serialize(buf);
            }

            @Override
            public MultiInetSocketAddress translateDown(TransportLayerNodeHandle<MultiInetSocketAddress> i) {
                return i.getAddress();
            }

            @Override
            public TransportLayerNodeHandle<MultiInetSocketAddress> translateUp(MultiInetSocketAddress i) {
                return handleFactory.lookupNodeHandle(i);
            }
        };
        SimpleOutputBuffer buf = new SimpleOutputBuffer();
        serializer.serialize(buf, localhandle);
        byte[] localHandleBytes = new byte[buf.getWritten()];
        System.arraycopy(buf.getBytes(), 0, localHandleBytes, 0, localHandleBytes.length);
        IdentityImpl<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress, ByteBuffer, SourceRoute<MultiInetSocketAddress>> identity = new IdentityImpl<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress, ByteBuffer, SourceRoute<MultiInetSocketAddress>>(localHandleBytes, serializer, new NodeChangeStrategy<TransportLayerNodeHandle<MultiInetSocketAddress>, SourceRoute<MultiInetSocketAddress>>(){

            @Override
            public boolean canChange(TransportLayerNodeHandle<MultiInetSocketAddress> oldDest, TransportLayerNodeHandle<MultiInetSocketAddress> newDest, SourceRoute<MultiInetSocketAddress> i) {
                return newDest.getAddress().equals(i.getLastHop()) && newDest.getEpoch() > oldDest.getEpoch();
            }
        }, new SanityChecker<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress>(){

            @Override
            public boolean isSane(TransportLayerNodeHandle<MultiInetSocketAddress> upper, MultiInetSocketAddress middle) {
                return upper.getAddress().equals(middle);
            }
        }, environment);
        return identity;
    }

    private LowerIdentity<SourceRoute<MultiInetSocketAddress>, ByteBuffer> getLowerIdentityLayer(SourceRouteTransportLayer<MultiInetSocketAddress> srl, TLPastryNode pn, IdentityImpl<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress, ByteBuffer, SourceRoute<MultiInetSocketAddress>> identity) {
        identity.initLowerLayer(srl, null);
        LowerIdentity<SourceRoute<MultiInetSocketAddress>, ByteBuffer> lowerIdentityLayer = identity.getLowerIdentity();
        return lowerIdentityLayer;
    }

    protected LivenessTransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> getLivenessTransportLayer(TransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> tl, TLPastryNode pn) {
        Environment environment = pn.getEnvironment();
        int checkDeadThrottle = environment.getParameters().getInt("pastry_socket_srm_check_dead_throttle");
        LivenessTransportLayerImpl<SourceRoute<MultiInetSocketAddress>> ltl = new LivenessTransportLayerImpl<SourceRoute<MultiInetSocketAddress>>(tl, environment, null, checkDeadThrottle);
        return ltl;
    }

    protected SourceRouteManager<MultiInetSocketAddress> getSourceRouteManagerLayer(LivenessTransportLayer<SourceRoute<MultiInetSocketAddress>, ByteBuffer> ltl, TLPastryNode pn, MultiInetSocketAddress proxyAddress, MultiAddressSourceRouteFactory esrFactory) {
        Environment environment = pn.getEnvironment();
        LeafSetNHStrategy nhStrategy = new LeafSetNHStrategy();
        nhStrategy.setLeafSet(pn.getLeafSet());
        SimpleSourceRouteStrategy<MultiInetSocketAddress> srStrategy = new SimpleSourceRouteStrategy<MultiInetSocketAddress>(proxyAddress, esrFactory, nhStrategy, environment);
        MinRTTProximityProvider prox = new MinRTTProximityProvider(ltl, environment);
        SourceRouteManagerImpl<MultiInetSocketAddress> srm = new SourceRouteManagerImpl<MultiInetSocketAddress>(esrFactory, ltl, ltl, ltl, prox, environment, srStrategy);
        return srm;
    }

    protected PriorityTransportLayer<MultiInetSocketAddress> getPriorityTransportLayer(SourceRouteManager<MultiInetSocketAddress> srm, TLPastryNode pn) {
        Environment environment = pn.getEnvironment();
        PriorityTransportLayerImpl<MultiInetSocketAddress> priorityTL = new PriorityTransportLayerImpl<MultiInetSocketAddress>(srm, srm, environment, environment.getParameters().getInt("pastry_socket_writer_max_msg_size"), environment.getParameters().getInt("pastry_socket_writer_max_queue_length"), null);
        return priorityTL;
    }

    protected UpperIdentity<TransportLayerNodeHandle<MultiInetSocketAddress>, ByteBuffer> getUpperIdentityLayer(PriorityTransportLayer<MultiInetSocketAddress> priorityTL, TLPastryNode pn, IdentityImpl<TransportLayerNodeHandle<MultiInetSocketAddress>, MultiInetSocketAddress, ByteBuffer, SourceRoute<MultiInetSocketAddress>> identity, SourceRouteManager<MultiInetSocketAddress> srm) {
        SocketNodeHandle localhandle = (SocketNodeHandle)pn.getLocalHandle();
        identity.initUpperLayer(localhandle, priorityTL, srm, srm);
        UpperIdentity<TransportLayerNodeHandle<MultiInetSocketAddress>, ByteBuffer> upperIdentityLayer = identity.getUpperIdentity();
        return upperIdentityLayer;
    }

    protected CommonAPITransportLayer<TransportLayerNodeHandle<MultiInetSocketAddress>> getCommonAPITransportLayer(UpperIdentity<TransportLayerNodeHandle<MultiInetSocketAddress>, ByteBuffer> upperIdentity, TLPastryNode pn, TLDeserializer deserializer) {
        final Environment environment = pn.getEnvironment();
        IdFactory idFactory = new IdFactory(){

            public rice.p2p.commonapi.Id build(InputBuffer buf) throws IOException {
                return Id.build(buf);
            }
        };
        CommonAPITransportLayerImpl<TransportLayerNodeHandle<MultiInetSocketAddress>> commonAPItl = new CommonAPITransportLayerImpl<TransportLayerNodeHandle<MultiInetSocketAddress>>(upperIdentity, idFactory, deserializer, new ErrorHandler<TransportLayerNodeHandle<MultiInetSocketAddress>>(){
            Logger logger;
            {
                this.logger = environment.getLogManager().getLogger(SocketPastryNodeFactory.class, null);
            }

            @Override
            public void receivedUnexpectedData(TransportLayerNodeHandle<MultiInetSocketAddress> id, byte[] bytes, int location, Map<String, Integer> options) {
                if (this.logger.level <= 900) {
                    String s = "";
                    int numBytes = 8;
                    if (bytes.length < numBytes) {
                        numBytes = bytes.length;
                    }
                    for (int i = 0; i < numBytes; ++i) {
                        s = s + bytes[i] + ",";
                    }
                    this.logger.log("Unexpected data from " + id + " " + s);
                }
            }

            @Override
            public void receivedException(TransportLayerNodeHandle<MultiInetSocketAddress> i, Throwable error) {
                if (this.logger.level <= 800 && error instanceof NodeIsFaultyException) {
                    NodeIsFaultyException nife = (NodeIsFaultyException)error;
                    this.logger.log("Dropping message " + nife.getAttemptedMessage() + " to " + nife.getIdentifier() + " because it is faulty.");
                }
            }
        }, environment);
        return commonAPItl;
    }

    @Override
    protected Bootstrapper getBootstrapper(TLPastryNode pn, NodeHandleAdapter tl, NodeHandleFactory handleFactory, ProximityNeighborSelector pns) {
        TLBootstrapper bootstrapper = new TLBootstrapper(pn, tl.getTL(), (SocketNodeHandleFactory)handleFactory, pns);
        return bootstrapper;
    }

    public NodeHandle getNodeHandle(InetSocketAddress bootstrap, int i) {
        return this.getNodeHandle(bootstrap);
    }

    public NodeHandle getNodeHandle(InetSocketAddress bootstrap) {
        return new BogusNodeHandle(bootstrap);
    }

    public void getNodeHandle(InetSocketAddress[] bootstraps, Continuation c) {
        c.receiveResult(this.getNodeHandle(bootstraps, 0));
    }

    public NodeHandle getNodeHandle(InetSocketAddress[] bootstraps, int int1) {
        return new BogusNodeHandle(bootstraps);
    }

    @Override
    public PastryNode newNode(NodeHandle bootstrap) {
        return this.newNode(bootstrap, this.nidFactory.generateNodeId());
    }

    public PastryNode newNode(NodeHandle bootstrap, InetSocketAddress proxy) {
        return this.newNode(bootstrap, this.nidFactory.generateNodeId(), proxy);
    }

    @Override
    public PastryNode newNode(NodeHandle bootstrap, Id nodeId) {
        return this.newNode(bootstrap, nodeId, null);
    }

    public PastryNode newNode(NodeHandle nodeHandle, Id id, InetSocketAddress proxyAddress) {
        PastryNode n = this.newNode(id, proxyAddress);
        if (nodeHandle == null) {
            n.getBootstrapper().boot(null);
        } else {
            BogusNodeHandle bnh = (BogusNodeHandle)nodeHandle;
            n.getBootstrapper().boot(bnh.addresses);
        }
        return n;
    }

    public synchronized PastryNode newNode(Id nodeId, InetSocketAddress pAddress) {
        try {
            return this.newNode(nodeId, pAddress, true);
        }
        catch (BindException e) {
            if (this.logger.level <= 900) {
                this.logger.log("Warning: " + e);
            }
            if (this.environment.getParameters().getBoolean("pastry_socket_increment_port_after_construction")) {
                ++this.port;
                try {
                    return this.newNode(nodeId, pAddress);
                }
                catch (StackOverflowError soe) {
                    if (this.logger.level <= 1000) {
                        this.logger.log("SEVERE: SocketPastryNodeFactory: Could not bind on any ports!" + soe);
                    }
                    throw soe;
                }
            }
            if (this.environment.getParameters().getBoolean("pastry_factory_multipleNodes")) {
                this.environment.destroy();
            }
            throw new RuntimeException(e);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected synchronized PastryNode newNode(Id nodeId, InetSocketAddress pAddress, boolean throwException) throws IOException {
        if (!throwException) {
            return this.newNode(nodeId, pAddress);
        }
        Environment environment = this.environment;
        if (this.environment.getParameters().getBoolean("pastry_factory_multipleNodes") && this.environment.getLogManager() instanceof CloneableLogManager) {
            LogManager lman = ((CloneableLogManager)this.environment.getLogManager()).clone("0x" + nodeId.toStringBare());
            SelectorManager sman = this.environment.getSelectorManager();
            Processor proc = this.environment.getProcessor();
            if (this.environment.getParameters().getBoolean("pastry_factory_selectorPerNode")) {
                sman = new SelectorManager(nodeId.toString() + " Selector", this.environment.getTimeSource(), lman);
            }
            if (this.environment.getParameters().getBoolean("pastry_factory_processorPerNode")) {
                proc = new SimpleProcessor(nodeId.toString() + " Processor");
            }
            environment = new Environment(sman, proc, this.environment.getRandomSource(), this.environment.getTimeSource(), lman, this.environment.getParameters(), this.environment.getExceptionStrategy());
            this.environment.addDestructable(environment);
        }
        long epoch = this.random.nextLong();
        MultiInetSocketAddress localAddress = null;
        MultiInetSocketAddress proxyAddress = null;
        proxyAddress = localAddress = this.getEpochAddress(this.port);
        if (environment.getParameters().getBoolean("pastry_socket_increment_port_after_construction")) {
            ++this.port;
        }
        TLPastryNode pn = this.nodeHandleHelper(nodeId, environment, proxyAddress);
        return pn;
    }

    private MultiInetSocketAddress getEpochAddress(int portNumber) {
        MultiInetSocketAddress result = null;
        result = new MultiInetSocketAddress(new InetSocketAddress(this.localAddress, portNumber));
        return result;
    }

    public static InetSocketAddress verifyConnection(int i, InetSocketAddress addr, InetSocketAddress[] addr2, Environment env, Logger l) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TLBootstrapper
    implements Bootstrapper<InetSocketAddress> {
        TLPastryNode pn;
        TransportLayer<TransportLayerNodeHandle<MultiInetSocketAddress>, RawMessage> tl;
        SocketNodeHandleFactory handleFactory;
        ProximityNeighborSelector pns;

        public TLBootstrapper(TLPastryNode pn, TransportLayer<TransportLayerNodeHandle<MultiInetSocketAddress>, RawMessage> tl, SocketNodeHandleFactory handleFactory, ProximityNeighborSelector pns) {
            this.pn = pn;
            this.tl = tl;
            this.handleFactory = handleFactory;
            this.pns = pns;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void boot(Collection<InetSocketAddress> bootaddresses) {
            if (bootaddresses == null) {
                bootaddresses = Collections.EMPTY_LIST;
            }
            final ArrayList<SocketNodeHandle> tempBootHandles = new ArrayList<SocketNodeHandle>(bootaddresses.size());
            final HashSet<NodeHandle> bootHandles = new HashSet<NodeHandle>();
            TransportLayerNodeHandle<MultiInetSocketAddress> local = this.tl.getLocalIdentifier();
            InetSocketAddress localAddr = local.getAddress().getInnermostAddress();
            LivenessListener<NodeHandle> listener = new LivenessListener<NodeHandle>(){
                Logger logger;
                {
                    this.logger = TLBootstrapper.this.pn.getEnvironment().getLogManager().getLogger(SocketPastryNodeFactory.class, null);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void livenessChanged(NodeHandle i2, int val, Map<String, Integer> options) {
                    SocketNodeHandle i = (SocketNodeHandle)i2;
                    if (this.logger.level <= 500) {
                        this.logger.log("livenessChanged(" + i + "," + val + ")");
                    }
                    if (val <= 2 && i.getEpoch() != 0L) {
                        Collection collection = bootHandles;
                        synchronized (collection) {
                            bootHandles.add(i);
                            if (bootHandles.size() == tempBootHandles.size()) {
                                bootHandles.notify();
                            }
                        }
                    }
                }
            };
            this.pn.getLivenessProvider().addLivenessListener(listener);
            for (InetSocketAddress addr : bootaddresses) {
                if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level <= 400) {
                    SocketPastryNodeFactory.this.logger.log("addr:" + addr + " local:" + localAddr);
                }
                if (addr.equals(localAddr)) continue;
                tempBootHandles.add(this.handleFactory.getNodeHandle(new MultiInetSocketAddress(addr), 0L, Id.build()));
            }
            for (SocketNodeHandle h : tempBootHandles) {
                this.pn.getLivenessProvider().checkLiveness(h, null);
            }
            HashSet<NodeHandle> hashSet = bootHandles;
            synchronized (hashSet) {
                try {
                    if (bootHandles.size() < tempBootHandles.size()) {
                        bootHandles.wait(10000L);
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
            this.pn.getLivenessProvider().removeLivenessListener(listener);
            this.pns.getNearHandles(bootHandles, new Continuation<Collection<NodeHandle>, Exception>(){

                @Override
                public void receiveResult(Collection<NodeHandle> result) {
                    TLBootstrapper.this.pn.doneNode(bootHandles);
                }

                @Override
                public void receiveException(Exception exception) {
                }
            });
        }
    }
}

