/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mpisws.p2p.transport.commonapi.TransportLayerNodeHandle;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.transport.TLPastryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketNodeHandleFactory
implements NodeHandleFactory {
    TLPastryNode pn;
    Map<MultiInetSocketAddress, SocketNodeHandle> handles;
    Map<SocketNodeHandle, SocketNodeHandle> handleSet;
    Logger logger;

    public SocketNodeHandleFactory(TLPastryNode pn) {
        this.pn = pn;
        this.logger = pn.getEnvironment().getLogManager().getLogger(SocketNodeHandleFactory.class, null);
        this.handles = new HashMap<MultiInetSocketAddress, SocketNodeHandle>();
        this.handleSet = new HashMap<SocketNodeHandle, SocketNodeHandle>();
    }

    public SocketNodeHandle getNodeHandle(MultiInetSocketAddress i, long epoch, Id id) {
        if (this.handles.containsKey(i)) {
            SocketNodeHandle ret = this.handles.get(i);
            if (ret.getEpoch() == epoch && ret.getId().equals(id)) {
                return ret;
            }
            if (this.logger.level <= 900) {
                this.logger.log("getNodeHandle(" + i + "," + epoch + "," + id + ") replacing " + ret);
            }
        }
        SocketNodeHandle handle = new SocketNodeHandle(i, epoch, id, this.pn);
        this.handleSet.put(handle, handle);
        this.handles.put(i, handle);
        return handle;
    }

    @Override
    public NodeHandle readNodeHandle(InputBuffer buf) throws IOException {
        return this.coalesce(SocketNodeHandle.build(buf, this.pn));
    }

    @Override
    public NodeHandle coalesce(NodeHandle h) {
        SocketNodeHandle handle = (SocketNodeHandle)h;
        if (this.handleSet.containsKey(handle)) {
            return this.handleSet.get(handle);
        }
        handle.setLocalNode(this.pn);
        this.handles.put(handle.eaddress, handle);
        this.handleSet.put(handle, handle);
        return handle;
    }

    public TransportLayerNodeHandle<MultiInetSocketAddress> lookupNodeHandle(MultiInetSocketAddress i) {
        return this.handles.get(i);
    }
}

