/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.pns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.mpisws.p2p.transport.proximity.ProximityListener;
import rice.Continuation;
import rice.environment.Environment;
import rice.p2p.commonapi.Cancellable;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.pns.messages.LeafSetRequest;
import rice.pastry.pns.messages.LeafSetResponse;
import rice.pastry.pns.messages.RouteRowRequest;
import rice.pastry.pns.messages.RouteRowResponse;
import rice.pastry.routing.RouteSet;
import rice.pastry.standard.ProximityNeighborSelector;
import rice.pastry.transport.PMessageNotification;
import rice.pastry.transport.PMessageReceipt;
import rice.selector.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PNSApplication
extends PastryAppl
implements ProximityNeighborSelector,
ProximityListener<NodeHandle> {
    public static final int DEFAULT_PROXIMITY = 3600000;
    protected Hashtable<NodeHandle, Integer> pingCache = new Hashtable();
    protected final byte rtBase;
    protected Environment environment;
    protected Timer timer;
    final short depth;
    Map<NodeHandle, Collection<Continuation<LeafSet, Exception>>> waitingForLeafSet = new HashMap<NodeHandle, Collection<Continuation<LeafSet, Exception>>>();
    Map<NodeHandle, Collection<Continuation<RouteSet[], Exception>>[]> waitingForRouteRow = new HashMap<NodeHandle, Collection<Continuation<RouteSet[], Exception>>[]>();
    Map<NodeHandle, Collection<Continuation<Integer, IOException>>> waitingForPing = new HashMap<NodeHandle, Collection<Continuation<Integer, IOException>>>();

    public PNSApplication(PastryNode pn) {
        super(pn, null, 0, null, pn.getEnvironment().getLogManager().getLogger(PNSApplication.class, null));
        this.setDeserializer(new PNSDeserializer());
        this.environment = pn.getEnvironment();
        this.rtBase = (byte)this.environment.getParameters().getInt("pastry_rtBaseBitLength");
        this.depth = (short)(160 / this.rtBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageForAppl(Message msg) {
        if (this.logger.level <= 400) {
            this.logger.log("messageForAppl(" + msg + ")");
        }
        if (msg instanceof LeafSetRequest) {
            LeafSetRequest req = (LeafSetRequest)msg;
            this.thePastryNode.send(req.getSender(), new LeafSetResponse(this.thePastryNode.getLeafSet(), this.getAddress()), null, null);
            return;
        }
        if (msg instanceof LeafSetResponse) {
            LeafSetResponse response = (LeafSetResponse)msg;
            Map<NodeHandle, Collection<Continuation<LeafSet, Exception>>> map = this.waitingForLeafSet;
            synchronized (map) {
                LeafSet ls = response.leafset;
                Collection<Continuation<LeafSet, Exception>> waiters = this.waitingForLeafSet.remove(ls.get(0));
                if (waiters != null) {
                    for (Continuation<LeafSet, Exception> w : waiters) {
                        w.receiveResult(ls);
                    }
                }
            }
            return;
        }
        if (msg instanceof RouteRowRequest) {
            RouteRowRequest req = (RouteRowRequest)msg;
            this.thePastryNode.send(req.getSender(), new RouteRowResponse(this.thePastryNode.getLocalHandle(), req.index, this.thePastryNode.getRoutingTable().getRow(req.index), this.getAddress()), null, null);
            return;
        }
        if (msg instanceof RouteRowResponse) {
            RouteRowResponse response = (RouteRowResponse)msg;
            Map<NodeHandle, Collection<Continuation<RouteSet[], Exception>>[]> map = this.waitingForRouteRow;
            synchronized (map) {
                Collection<Continuation<RouteSet[], Exception>>[] waiters = this.waitingForRouteRow.get(response.getSender());
                if (waiters != null && waiters[response.index] != null) {
                    for (Continuation<RouteSet[], Exception> w : waiters[response.index]) {
                        w.receiveResult(response.row);
                    }
                    waiters[response.index] = null;
                    boolean deleteIt = true;
                    for (int i = 0; i < this.depth; ++i) {
                        if (waiters[i] == null) continue;
                        deleteIt = false;
                        break;
                    }
                    if (deleteIt) {
                        this.waitingForRouteRow.remove(response.getSender());
                    }
                }
            }
            return;
        }
        if (this.logger.level <= 900) {
            this.logger.log("unrecognized message in messageForAppl(" + msg + ")");
        }
    }

    @Override
    public void getNearHandles(Collection<NodeHandle> bootHandles, Continuation<Collection<NodeHandle>, Exception> deliverResultToMe) {
        if (bootHandles == null || bootHandles.size() == 0 || bootHandles.iterator().next() == null) {
            deliverResultToMe.receiveResult(bootHandles);
            return;
        }
        this.thePastryNode.addProximityListener(this);
        NodeHandle f = bootHandles.iterator().next();
        List<NodeHandle> ret = Arrays.asList(this.getNearest(f));
        this.thePastryNode.removeProximityListener(this);
        deliverResultToMe.receiveResult(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LeafSet getLeafSet(NodeHandle handle) throws IOException {
        LeafSet[] container;
        if (this.logger.level <= 400) {
            this.logger.log("getLeafSet(" + handle + ")");
        }
        LeafSet[] leafSetArray = container = new LeafSet[1];
        synchronized (container) {
            this.getLeafSet(handle, new Continuation<LeafSet, Exception>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void receiveResult(LeafSet result) {
                    LeafSet[] leafSetArray = container;
                    synchronized (container) {
                        container[0] = result;
                        container.notify();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void receiveException(Exception exception) {
                    LeafSet[] leafSetArray = container;
                    synchronized (container) {
                        container.notify();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
            try {
                container.wait(20000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.logger.level <= 500) {
                this.logger.log("getLeafSet(" + handle + ") returning " + container[0]);
            }
            return container[0];
        }
    }

    public Cancellable getLeafSet(final NodeHandle handle, final Continuation<LeafSet, Exception> c) {
        final Cancellable[] subCancellable = new Cancellable[1];
        Cancellable ret = new Cancellable(){

            public boolean cancel() {
                if (subCancellable[0] != null) {
                    subCancellable[0].cancel();
                }
                return PNSApplication.this.removeFromWaitingForLeafSet(handle, c);
            }
        };
        this.addToWaitingForLeafSet(handle, c);
        subCancellable[0] = this.thePastryNode.send(handle, new LeafSetRequest(this.getNodeHandle(), this.getAddress()), new PMessageNotification(){

            public void sent(PMessageReceipt msg) {
            }

            public void sendFailed(PMessageReceipt msg, Exception reason) {
                PNSApplication.this.removeFromWaitingForLeafSet(handle, c);
                c.receiveException(reason);
            }
        }, null);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeFromWaitingForLeafSet(NodeHandle handle, Continuation<LeafSet, Exception> c) {
        Map<NodeHandle, Collection<Continuation<LeafSet, Exception>>> map = this.waitingForLeafSet;
        synchronized (map) {
            Collection<Continuation<LeafSet, Exception>> waiters = this.waitingForLeafSet.get(handle);
            if (waiters == null) {
                return false;
            }
            boolean ret = waiters.remove(c);
            if (waiters.isEmpty()) {
                this.waitingForLeafSet.remove(handle);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToWaitingForLeafSet(NodeHandle handle, Continuation<LeafSet, Exception> c) {
        Map<NodeHandle, Collection<Continuation<LeafSet, Exception>>> map = this.waitingForLeafSet;
        synchronized (map) {
            Collection<Continuation<LeafSet, Exception>> waiters = this.waitingForLeafSet.get(handle);
            if (waiters == null) {
                waiters = new ArrayList<Continuation<LeafSet, Exception>>();
                this.waitingForLeafSet.put(handle, waiters);
            }
            waiters.add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouteSet[] getRouteRow(NodeHandle handle, short row) throws IOException {
        RouteSet[][] container;
        if (this.logger.level <= 400) {
            this.logger.log("getRouteRow(" + handle + ")");
        }
        RouteSet[][] routeSetArray = container = new RouteSet[1][0];
        synchronized (container) {
            this.getRouteRow(handle, row, new Continuation<RouteSet[], Exception>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void receiveResult(RouteSet[] result) {
                    RouteSet[][] routeSetArray = container;
                    synchronized (container) {
                        container[0] = result;
                        container.notify();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void receiveException(Exception exception) {
                    RouteSet[][] routeSetArray = container;
                    synchronized (container) {
                        container.notify();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
            try {
                container.wait(20000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.logger.level <= 500) {
                this.logger.log("getRouteRow(" + handle + ") returning " + container[0]);
            }
            return container[0];
        }
    }

    public Cancellable getRouteRow(final NodeHandle handle, final short row, final Continuation<RouteSet[], Exception> c) {
        final Cancellable[] subCancellable = new Cancellable[1];
        Cancellable ret = new Cancellable(){

            public boolean cancel() {
                if (subCancellable[0] != null) {
                    subCancellable[0].cancel();
                }
                return PNSApplication.this.removeFromWaitingForRouteRow(handle, row, c);
            }
        };
        this.addToWaitingForRouteRow(handle, row, c);
        subCancellable[0] = this.thePastryNode.send(handle, new RouteRowRequest(this.getNodeHandle(), row, this.getAddress()), new PMessageNotification(){

            public void sent(PMessageReceipt msg) {
            }

            public void sendFailed(PMessageReceipt msg, Exception reason) {
                PNSApplication.this.removeFromWaitingForRouteRow(handle, row, c);
                c.receiveException(reason);
            }
        }, null);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToWaitingForRouteRow(NodeHandle handle, int row, Continuation<RouteSet[], Exception> c) {
        Map<NodeHandle, Collection<Continuation<RouteSet[], Exception>>[]> map = this.waitingForRouteRow;
        synchronized (map) {
            Collection<Continuation<RouteSet[], Exception>>[] waiters = this.waitingForRouteRow.get(handle);
            if (waiters == null) {
                waiters = new Collection[this.depth];
                this.waitingForRouteRow.put(handle, waiters);
            }
            if (waiters[row] == null) {
                waiters[row] = new ArrayList<Continuation<RouteSet[], Exception>>();
            }
            waiters[row].add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeFromWaitingForRouteRow(NodeHandle handle, int row, Continuation<RouteSet[], Exception> c) {
        Map<NodeHandle, Collection<Continuation<RouteSet[], Exception>>[]> map = this.waitingForRouteRow;
        synchronized (map) {
            Collection<Continuation<RouteSet[], Exception>>[] waiters = this.waitingForRouteRow.get(handle);
            if (waiters == null) {
                return false;
            }
            if (waiters[row] == null) {
                return false;
            }
            boolean ret = waiters[row].remove(c);
            if (waiters[row].isEmpty()) {
                waiters[row] = null;
            }
            boolean deleteIt = true;
            for (int i = 0; i < this.depth; ++i) {
                if (waiters[i] == null) continue;
                deleteIt = false;
                break;
            }
            if (deleteIt) {
                this.waitingForRouteRow.remove(handle);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProximity(NodeHandle handle) {
        final int[] container = new int[]{3600000};
        int[] nArray = container;
        synchronized (container) {
            this.getProximity(handle, new Continuation<Integer, IOException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void receiveResult(Integer result) {
                    int[] nArray = container;
                    synchronized (container) {
                        container[0] = result;
                        container.notify();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void receiveException(IOException exception) {
                    int[] nArray = container;
                    synchronized (container) {
                        container.notify();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
            if (container[0] == 3600000) {
                try {
                    container.wait(5000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (this.logger.level <= 500) {
                this.logger.log("getProximity(handle) returning " + container[0]);
            }
            return container[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getProximity(NodeHandle handle, Continuation<Integer, IOException> c) {
        int prox;
        Map<NodeHandle, Collection<Continuation<Integer, IOException>>> map = this.waitingForPing;
        synchronized (map) {
            prox = this.thePastryNode.proximity(handle);
            if (prox == 3600000) {
                Collection<Continuation<Integer, IOException>> waiters = this.waitingForPing.get(handle);
                if (waiters == null) {
                    waiters = new ArrayList<Continuation<Integer, IOException>>();
                    this.waitingForPing.put(handle, waiters);
                }
                waiters.add(c);
                return;
            }
        }
        c.receiveResult(prox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proximityChanged(NodeHandle i, int newProximity, Map<String, Integer> options) {
        Map<NodeHandle, Collection<Continuation<Integer, IOException>>> map = this.waitingForPing;
        synchronized (map) {
            if (this.waitingForPing.containsKey(i)) {
                Collection<Continuation<Integer, IOException>> waiting = this.waitingForPing.remove(i);
                for (Continuation<Integer, IOException> c : waiting) {
                    c.receiveResult(newProximity);
                }
            }
        }
    }

    protected int proximity(NodeHandle handle) {
        Hashtable<NodeHandle, Integer> localTable = this.pingCache;
        if (this.pingCache.get(handle) == null) {
            int value = this.getProximity(handle);
            this.pingCache.put(handle, value);
            return value;
        }
        return this.pingCache.get(handle);
    }

    private void purgeProximityCache() {
        this.pingCache.clear();
    }

    public NodeHandle[] sortedProximityCache() {
        ArrayList<NodeHandle> handles = new ArrayList<NodeHandle>(this.pingCache.keySet());
        Collections.sort(handles, new Comparator<NodeHandle>(){

            @Override
            public int compare(NodeHandle a, NodeHandle b) {
                return PNSApplication.this.pingCache.get(a) - PNSApplication.this.pingCache.get(b);
            }
        });
        return handles.toArray(new NodeHandle[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeHandle[] getNearest(NodeHandle seed) {
        try {
            if (seed == null) {
                NodeHandle[] nodeHandleArray = null;
                return nodeHandleArray;
            }
            NodeHandle currentClosest = seed;
            NodeHandle nearNode = seed;
            nearNode = this.closestToMe(nearNode, this.getLeafSet(nearNode));
            short i = 0;
            if (!this.environment.getParameters().getString("pns_num_rows_to_use").equalsIgnoreCase("all")) {
                i = (short)(this.depth - (short)this.environment.getParameters().getInt("pns_num_rows_to_use"));
            }
            if (i < 0) {
                i = 0;
            }
            while (i < this.depth) {
                nearNode = this.closestToMe(nearNode, this.getRouteRow(nearNode, i));
                i = (short)(i + 1);
            }
            while (!(currentClosest = nearNode).equals(nearNode = this.closestToMe(nearNode, this.getRouteRow(nearNode, (short)(this.depth - 1))))) {
            }
            if (nearNode.getLocalNode() == null && this.thePastryNode != null) {
                nearNode = this.thePastryNode.coalesce(nearNode);
            }
            NodeHandle[] nodeHandleArray = this.sortedProximityCache();
            return nodeHandleArray;
        }
        catch (IOException e) {
            if (this.logger.level <= 900) {
                this.logger.logException("ERROR occured while finding best bootstrap.", e);
            }
            NodeHandle[] nodeHandleArray = new NodeHandle[]{seed};
            return nodeHandleArray;
        }
        finally {
            this.purgeProximityCache();
        }
    }

    private NodeHandle closestToMe(NodeHandle handle, LeafSet leafSet) {
        int i;
        if (leafSet == null) {
            return handle;
        }
        Vector<NodeHandle> handles = new Vector<NodeHandle>();
        for (i = 1; i <= leafSet.cwSize(); ++i) {
            handles.add(leafSet.get(i));
        }
        for (i = -leafSet.ccwSize(); i < 0; ++i) {
            handles.add(leafSet.get(i));
        }
        return this.closestToMe(handle, handles.toArray(new NodeHandle[0]));
    }

    private NodeHandle closestToMe(NodeHandle handle, RouteSet[] routeSets) {
        Vector<NodeHandle> handles = new Vector<NodeHandle>();
        for (int i = 0; i < routeSets.length; ++i) {
            RouteSet set = routeSets[i];
            if (set == null) continue;
            for (int j = 0; j < set.size(); ++j) {
                handles.add(set.get(j));
            }
        }
        return this.closestToMe(handle, handles.toArray(new NodeHandle[0]));
    }

    private NodeHandle closestToMe(NodeHandle handle, NodeHandle[] handles) {
        NodeHandle closestNode = handle;
        int nearestdist = this.proximity(closestNode);
        for (int i = 0; i < handles.length; ++i) {
            NodeHandle tempNode = handles[i];
            int prox = this.proximity(tempNode);
            if (prox <= 0 || prox >= nearestdist || !tempNode.isAlive()) continue;
            nearestdist = prox;
            closestNode = tempNode;
        }
        return closestNode;
    }

    class PNSDeserializer
    implements MessageDeserializer {
        PNSDeserializer() {
        }

        public rice.p2p.commonapi.Message deserialize(InputBuffer buf, short type, int priority, rice.p2p.commonapi.NodeHandle sender) throws IOException {
            switch (type) {
                case 1: {
                    return LeafSetRequest.build(buf, (NodeHandle)sender, PNSApplication.this.getAddress());
                }
                case 2: {
                    return LeafSetResponse.build(buf, PNSApplication.this.thePastryNode, PNSApplication.this.getAddress());
                }
                case 3: {
                    return RouteRowRequest.build(buf, (NodeHandle)sender, PNSApplication.this.getAddress());
                }
                case 4: {
                    return new RouteRowResponse(buf, PNSApplication.this.thePastryNode, (NodeHandle)sender, PNSApplication.this.getAddress());
                }
            }
            return null;
        }
    }
}

