/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.dist;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.UnresolvedAddressException;
import java.util.ArrayList;
import java.util.Random;
import rice.Continuation;
import rice.environment.Environment;
import rice.p2p.commonapi.CancellableTask;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.socket.SocketPastryNodeFactory;

public abstract class DistPastryNodeFactory
extends PastryNodeFactory {
    public static int PROTOCOL_SOCKET;
    public static int PROTOCOL_DEFAULT;

    protected DistPastryNodeFactory(Environment env) {
        super(env);
    }

    public final NodeHandle getNodeHandle(InetSocketAddress address) {
        return this.generateNodeHandle(address, 0);
    }

    public final NodeHandle getNodeHandle(InetSocketAddress address, int timeout) {
        return this.generateNodeHandle(address, timeout);
    }

    public final CancellableTask getNodeHandle(InetSocketAddress address, Continuation c) {
        return this.generateNodeHandle(address, c);
    }

    public final NodeHandle getNodeHandle(InetSocketAddress[] addresses) {
        return this.getNodeHandle(addresses, 0);
    }

    public final NodeHandle getNodeHandle(InetSocketAddress[] addresses, int timeoutMillis) {
        int i;
        Random r = new Random();
        for (i = 0; i < addresses.length; ++i) {
            int j = r.nextInt(addresses.length);
            InetSocketAddress tmp = addresses[j];
            addresses[j] = addresses[i];
            addresses[i] = tmp;
        }
        for (i = 0; i < addresses.length; ++i) {
            NodeHandle result;
            block6: {
                result = this.getNodeHandle(addresses[i], timeoutMillis);
                if (result != null) {
                    return result;
                }
                try {
                    InetSocketAddress newAddress = new InetSocketAddress(addresses[i].getAddress().getHostName(), addresses[i].getPort());
                    if (!newAddress.getAddress().equals(addresses[i].getAddress())) {
                        result = this.getNodeHandle(newAddress, timeoutMillis);
                    }
                }
                catch (UnresolvedAddressException uae) {
                    if (this.logger.level > 800) break block6;
                    this.logger.log("getNodeHandle: Could not resolve hostname " + addresses[i]);
                }
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public final CancellableTask getNodeHandle(InetSocketAddress[] addresses, Continuation c) {
        Random r = new Random();
        for (int i = 0; i < addresses.length; ++i) {
            int j = r.nextInt(addresses.length);
            InetSocketAddress tmp = addresses[j];
            addresses[j] = addresses[i];
            addresses[i] = tmp;
        }
        GNHContinuation gnh = new GNHContinuation(addresses, c, this.environment.getParameters().getInt("pastry_factory_bootsInParallel"));
        gnh.tryNext();
        return gnh;
    }

    public abstract NodeHandle generateNodeHandle(InetSocketAddress var1, int var2);

    public abstract CancellableTask generateNodeHandle(InetSocketAddress var1, Continuation var2);

    public abstract PastryNode newNode(NodeHandle var1);

    public abstract PastryNode newNode(NodeHandle var1, Id var2);

    public abstract PastryNode newNode(NodeHandle var1, Id var2, InetSocketAddress var3);

    public abstract PastryNode newNode(NodeHandle var1, InetSocketAddress var2);

    public static SocketPastryNodeFactory getFactory(NodeIdFactory nf, int protocol, int port, Environment env) throws IOException {
        if (protocol == PROTOCOL_SOCKET) {
            return new SocketPastryNodeFactory(nf, port, env);
        }
        throw new IllegalArgumentException("Unsupported Protocol " + protocol);
    }

    static {
        PROTOCOL_DEFAULT = PROTOCOL_SOCKET = 2;
    }

    class GNHContinuation
    implements Continuation,
    CancellableTask {
        int index;
        int numInParallel;
        int outstandingRequests;
        InetSocketAddress[] addresses;
        Continuation subContinuation;
        ArrayList outstandingTasks = new ArrayList();
        boolean done = false;

        public GNHContinuation(InetSocketAddress[] addresses, Continuation subContinuation, int numInParallel) {
            this.addresses = addresses;
            this.subContinuation = subContinuation;
            if (numInParallel < 1) {
                numInParallel = 1;
            }
            this.numInParallel = numInParallel;
            this.index = 0;
        }

        public synchronized void receiveResult(Object result) {
            if (this.done) {
                return;
            }
            --this.outstandingRequests;
            if (result != null) {
                this.cancel();
                this.subContinuation.receiveResult(result);
                return;
            }
            this.tryNext();
        }

        public synchronized void receiveException(Exception result) {
            if (this.done) {
                return;
            }
            if (((DistPastryNodeFactory)DistPastryNodeFactory.this).logger.level <= 900) {
                DistPastryNodeFactory.this.logger.logException("Received exception while booting, trying next bootstap address", result);
            }
            --this.outstandingRequests;
            this.tryNext();
        }

        private synchronized void tryNext() {
            if (this.done) {
                return;
            }
            while (this.outstandingRequests < this.numInParallel && this.index < this.addresses.length) {
                ++this.outstandingRequests;
                ++this.index;
                this.outstandingTasks.add(DistPastryNodeFactory.this.getNodeHandle(this.addresses[this.index - 1], (Continuation)this));
            }
            if (this.outstandingRequests == 0) {
                this.subContinuation.receiveResult(null);
                this.done = true;
            }
        }

        public void run() {
        }

        public synchronized boolean cancel() {
            if (this.done) {
                return false;
            }
            for (CancellableTask ct : this.outstandingTasks) {
                ct.cancel();
            }
            this.done = true;
            return true;
        }

        public long scheduledExecutionTime() {
            return 0L;
        }
    }
}

