/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct.proximitygenerators;

import rice.environment.random.RandomSource;
import rice.pastry.direct.NodeRecord;
import rice.pastry.direct.ProximityGenerator;

public class EuclideanProximityGenerator
implements ProximityGenerator {
    int side;
    RandomSource random;

    public EuclideanProximityGenerator(int maxDiameter) {
        this.side = (int)((double)maxDiameter / Math.sqrt(2.0));
    }

    public NodeRecord generateNodeRecord() {
        return new EuclideanNodeRecord();
    }

    public void setRandom(RandomSource random) {
        this.random = random;
    }

    private class EuclideanNodeRecord
    implements NodeRecord {
        public int x;
        public int y;
        public boolean alive;

        public EuclideanNodeRecord() {
            this.x = EuclideanProximityGenerator.this.random.nextInt() % EuclideanProximityGenerator.this.side;
            this.y = EuclideanProximityGenerator.this.random.nextInt() % EuclideanProximityGenerator.this.side;
            this.alive = true;
        }

        public float proximity(NodeRecord that) {
            return Math.round((double)this.networkDelay(that) * 2.0);
        }

        public float networkDelay(NodeRecord that) {
            EuclideanNodeRecord nr = (EuclideanNodeRecord)that;
            int dx = this.x - nr.x;
            int dy = this.y - nr.y;
            float ret = (float)Math.sqrt(dx * dx + dy * dy);
            if ((double)ret < 2.0 && !this.equals(that)) {
                return 2.0f;
            }
            return ret;
        }

        public String toString() {
            return "ENR(" + this.x + "," + this.y + ")";
        }

        public void markDead() {
        }
    }
}

