/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.util.ArrayList;
import java.util.List;
import org.mpisws.p2p.transport.liveness.LivenessProvider;
import rice.environment.Environment;
import rice.environment.params.Parameters;
import rice.environment.random.RandomSource;
import rice.environment.random.simple.SimpleRandomSource;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.pastry.NodeHandle;
import rice.pastry.direct.BasicNetworkSimulator;
import rice.pastry.direct.Delivery;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.GenericNetworkSimulator;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.NodeRecord;
import rice.pastry.direct.ProximityGenerator;
import rice.pastry.direct.SimulatorListener;
import rice.pastry.direct.TestRecord;
import rice.pastry.messaging.Message;
import rice.pastry.transport.TLPastryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkSimulatorImpl
implements NetworkSimulator {
    protected BasicNetworkSimulator<NodeHandle, RawMessage> simulator;
    protected RandomSource random;
    protected ProximityGenerator generator;
    protected LivenessProvider<NodeHandle> livenessProvider;
    private TestRecord testRecord;
    List<SimulatorListener> listeners = new ArrayList<SimulatorListener>();

    public NetworkSimulatorImpl(Environment env, ProximityGenerator generator) {
        Parameters params = env.getParameters();
        this.random = params.contains("pastry_direct_use_own_random") && params.getBoolean("pastry_direct_use_own_random") ? (params.contains("pastry_direct_random_seed") && !params.getString("pastry_direct_random_seed").equalsIgnoreCase("clock") ? new SimpleRandomSource(params.getLong("pastry_direct_random_seed"), env.getLogManager(), "direct") : new SimpleRandomSource(env.getLogManager(), "direct")) : env.getRandomSource();
        generator.setRandom(this.random);
        this.generator = generator;
        this.simulator = new BasicNetworkSimulator(env, this.random);
        this.livenessProvider = this.simulator;
    }

    @Override
    public Environment getEnvironment() {
        return this.simulator.getEnvironment();
    }

    @Override
    public void setFullSpeed() {
        this.simulator.setFullSpeed();
    }

    @Override
    public void setMaxSpeed(float rate) {
        this.simulator.setMaxSpeed(rate);
    }

    @Override
    public void start() {
        this.simulator.start();
    }

    @Override
    public void stop() {
        this.simulator.stop();
    }

    @Override
    public TestRecord getTestRecord() {
        return this.testRecord;
    }

    @Override
    public void setTestRecord(TestRecord tr) {
        this.testRecord = tr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addSimulatorListener(SimulatorListener sl) {
        List<SimulatorListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(sl)) {
                return false;
            }
            this.listeners.add(sl);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSimulatorListener(SimulatorListener sl) {
        List<SimulatorListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.remove(sl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySimulatorListenersSent(Message m, NodeHandle from, NodeHandle to, int delay) {
        ArrayList<SimulatorListener> temp;
        List<SimulatorListener> list = this.listeners;
        synchronized (list) {
            temp = new ArrayList<SimulatorListener>(this.listeners);
        }
        for (SimulatorListener listener : temp) {
            listener.messageSent(m, from, to, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySimulatorListenersReceived(Message m, NodeHandle from, NodeHandle to) {
        ArrayList<SimulatorListener> temp;
        List<SimulatorListener> list = this.listeners;
        synchronized (list) {
            temp = new ArrayList<SimulatorListener>(this.listeners);
        }
        for (SimulatorListener listener : temp) {
            listener.messageReceived(m, from, to);
        }
    }

    @Override
    public void destroy(DirectPastryNode dpn) {
    }

    @Override
    public CancellableTask enqueueDelivery(Delivery del, int delay) {
        return null;
    }

    @Override
    public NodeRecord generateNodeRecord() {
        return this.generator.generateNodeRecord();
    }

    @Override
    public DirectNodeHandle getClosest(DirectNodeHandle nh) {
        return null;
    }

    @Override
    public boolean isAlive(DirectNodeHandle nh) {
        return this.simulator.isAlive(nh);
    }

    @Override
    public float networkDelay(DirectNodeHandle a, DirectNodeHandle b) {
        return this.simulator.networkDelay(a, b);
    }

    @Override
    public float proximity(DirectNodeHandle a, DirectNodeHandle b) {
        return this.simulator.proximity(a, b);
    }

    @Override
    public void removeNode(TLPastryNode node) {
    }

    @Override
    public NodeRecord getNodeRecord(DirectNodeHandle handle) {
        return this.simulator.getNodeRecord(handle);
    }

    @Override
    public LivenessProvider<NodeHandle> getLivenessProvider() {
        return this.livenessProvider;
    }

    @Override
    public GenericNetworkSimulator<NodeHandle, RawMessage> getGenericSimulator() {
        return this.simulator;
    }

    public void registerNode(TLPastryNode dpn, NodeRecord nr) {
        this.simulator.registerIdentifier(dpn.getLocalHandle(), dpn.getTL(), nr);
    }
}

