/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.io.IOException;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.exception.NodeIsFaultyException;
import org.mpisws.p2p.transport.liveness.LivenessProvider;
import org.mpisws.p2p.transport.util.MessageRequestHandleImpl;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Cancellable;
import rice.pastry.direct.DirectAppSocket;
import rice.pastry.direct.GenericNetworkSimulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectTransportLayer<Identifier, MessageType>
implements TransportLayer<Identifier, MessageType> {
    protected boolean acceptMessages = true;
    protected boolean acceptSockets = true;
    protected Identifier localIdentifier;
    protected TransportLayerCallback<Identifier, MessageType> callback;
    protected GenericNetworkSimulator<Identifier, MessageType> simulator;
    protected ErrorHandler<Identifier> errorHandler;
    protected LivenessProvider<Identifier> livenessProvider;
    protected Environment environment;
    protected Logger logger;
    int seq = Integer.MIN_VALUE;

    public DirectTransportLayer(Identifier local, GenericNetworkSimulator<Identifier, MessageType> simulator, LivenessProvider<Identifier> liveness, Environment env) {
        this.localIdentifier = local;
        this.simulator = simulator;
        this.livenessProvider = liveness;
        this.environment = env;
        this.logger = this.environment.getLogManager().getLogger(DirectTransportLayer.class, null);
    }

    @Override
    public void acceptMessages(boolean b) {
        this.acceptMessages = b;
    }

    @Override
    public void acceptSockets(boolean b) {
        this.acceptSockets = b;
    }

    @Override
    public Identifier getLocalIdentifier() {
        return this.localIdentifier;
    }

    @Override
    public SocketRequestHandle<Identifier> openSocket(Identifier i, SocketCallback<Identifier> deliverSocketToMe, Map<String, Integer> options) {
        SocketRequestHandleImpl<Identifier> handle = new SocketRequestHandleImpl<Identifier>(i, options);
        DirectAppSocket<Identifier, MessageType> socket = new DirectAppSocket<Identifier, MessageType>(i, this.localIdentifier, deliverSocketToMe, this.simulator, handle, options);
        CancelAndClose cancelAndClose = new CancelAndClose();
        handle.setSubCancellable(cancelAndClose);
        cancelAndClose.cancelMe = this.simulator.enqueueDelivery(socket.getAcceptorDelivery(), Math.round(this.simulator.networkDelay(this.localIdentifier, i)));
        return handle;
    }

    @Override
    public MessageRequestHandle<Identifier, MessageType> sendMessage(Identifier i, MessageType m, MessageCallback<Identifier, MessageType> deliverAckToMe, Map<String, Integer> options) {
        MessageRequestHandleImpl<Identifier, MessageType> handle = new MessageRequestHandleImpl<Identifier, MessageType>(i, m, options);
        if (this.livenessProvider.getLiveness(i, null) >= 3) {
            if (this.logger.level <= 500) {
                this.logger.log("Attempt to send message " + m + " to a dead node " + i + "!");
            }
            if (deliverAckToMe != null) {
                deliverAckToMe.sendFailed(handle, new NodeIsFaultyException(i));
            }
        } else {
            int delay = Math.round(this.simulator.networkDelay(this.localIdentifier, i));
            handle.setSubCancellable(this.simulator.deliverMessage(m, i, this.localIdentifier, delay));
            if (deliverAckToMe != null) {
                deliverAckToMe.ack(handle);
            }
        }
        return handle;
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, MessageType> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identifier> handler) {
        this.errorHandler = handler;
    }

    @Override
    public void destroy() {
        this.simulator.remove(this.getLocalIdentifier());
    }

    public boolean canReceiveSocket() {
        return this.acceptSockets;
    }

    public void finishReceiveSocket(P2PSocket<Identifier> acceptorEndpoint) {
        block2: {
            try {
                this.callback.incomingSocket(acceptorEndpoint);
            }
            catch (IOException ioe) {
                if (this.logger.level > 900) break block2;
                this.logger.logException("Exception in " + this.callback, ioe);
            }
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public synchronized int getNextSeq() {
        return this.seq++;
    }

    public void incomingMessage(Identifier i, MessageType m, Map<String, Integer> options) throws IOException {
        this.callback.messageReceived(i, m, options);
    }

    public void clearState(Identifier i) {
    }

    static class CancelAndClose
    implements Cancellable {
        DirectAppSocket closeMe;
        Cancellable cancelMe;

        CancelAndClose() {
        }

        public boolean cancel() {
            this.closeMe.connectorEndpoint.close();
            return this.cancelMe.cancel();
        }
    }
}

