/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.mpisws.p2p.transport.proximity.ProximityListener;
import org.mpisws.p2p.transport.proximity.ProximityProvider;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.CloneableLogManager;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.boot.Bootstrapper;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectTransportLayer;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.NetworkSimulatorImpl;
import rice.pastry.direct.NodeRecord;
import rice.pastry.leafset.LeafSet;
import rice.pastry.routing.RouteSet;
import rice.pastry.standard.ProximityNeighborSelector;
import rice.pastry.transport.NodeHandleAdapter;
import rice.pastry.transport.TLDeserializer;
import rice.pastry.transport.TLPastryNode;
import rice.pastry.transport.TransportPastryNodeFactory;

public class DirectPastryNodeFactory
extends TransportPastryNodeFactory {
    protected NodeIdFactory nidFactory;
    protected NetworkSimulator simulator;
    boolean guaranteeConsistency;
    Hashtable recordTable = new Hashtable();

    public DirectPastryNodeFactory(NodeIdFactory nf, NetworkSimulator sim, Environment env) {
        super(env);
        env.getParameters().setInt("pastry_protocol_consistentJoin_max_time_to_be_scheduled", 120000);
        this.guaranteeConsistency = env.getParameters().getBoolean("pastry_direct_guarantee_consistency");
        this.nidFactory = nf;
        this.simulator = sim;
    }

    public NetworkSimulator getNetworkSimulator() {
        return this.simulator;
    }

    public PastryNode newNode(NodeHandle bootstrap) {
        return this.newNode(bootstrap, this.nidFactory.generateNodeId());
    }

    public PastryNode newNode(NodeHandle bootstrap, Id nodeId) {
        try {
            NodeRecord nr;
            if (bootstrap == null && this.logger.level <= 900) {
                this.logger.log("No bootstrap node provided, starting a new ring...");
            }
            Environment environment = this.environment;
            if (this.environment.getParameters().getBoolean("pastry_factory_multipleNodes") && this.environment.getLogManager() instanceof CloneableLogManager) {
                environment = new Environment(this.environment.getSelectorManager(), this.environment.getProcessor(), this.environment.getRandomSource(), this.environment.getTimeSource(), ((CloneableLogManager)this.environment.getLogManager()).clone("0x" + nodeId.toStringBare()), this.environment.getParameters(), this.environment.getExceptionStrategy());
            }
            if ((nr = (NodeRecord)this.recordTable.get(nodeId)) == null) {
                nr = this.simulator.generateNodeRecord();
                this.recordTable.put(nodeId, nr);
            }
            TLPastryNode pn = this.nodeHandleHelper(nodeId, environment, nr);
            ((NetworkSimulatorImpl)this.simulator).registerNode(pn, nr);
            pn.getBootstrapper().boot(Collections.singleton(bootstrap));
            return pn;
        }
        catch (IOException ioe) {
            this.logger.logException("Couldn't construct node.", ioe);
            return null;
        }
    }

    public LeafSet getLeafSet(NodeHandle handle) throws IOException {
        DirectNodeHandle dHandle = (DirectNodeHandle)handle;
        return dHandle.getRemote().getLeafSet();
    }

    public CancellableTask getLeafSet(NodeHandle handle, Continuation c) {
        DirectNodeHandle dHandle = (DirectNodeHandle)handle;
        c.receiveResult(dHandle.getRemote().getLeafSet());
        return new NullCancellableTask();
    }

    public RouteSet[] getRouteRow(NodeHandle handle, int row) throws IOException {
        DirectNodeHandle dHandle = (DirectNodeHandle)handle;
        return dHandle.getRemote().getRoutingTable().getRow(row);
    }

    public CancellableTask getRouteRow(NodeHandle handle, int row, Continuation c) {
        DirectNodeHandle dHandle = (DirectNodeHandle)handle;
        c.receiveResult(dHandle.getRemote().getRoutingTable().getRow(row));
        return new NullCancellableTask();
    }

    public int getProximity(NodeHandle local, NodeHandle remote) {
        return (int)this.simulator.proximity((DirectNodeHandle)local, (DirectNodeHandle)remote);
    }

    protected NodeHandle getLocalHandle(TLPastryNode pn, NodeHandleFactory handleFactory, Object localNodeData) throws IOException {
        DirectNodeHandle localhandle = new DirectNodeHandle(pn, pn, this.simulator);
        return localhandle;
    }

    protected NodeHandleFactory getNodeHandleFactory(TLPastryNode pn) throws IOException {
        return new NodeHandleFactory(){

            public NodeHandle readNodeHandle(InputBuffer buf) throws IOException {
                return null;
            }

            public NodeHandle coalesce(NodeHandle handle) {
                return null;
            }
        };
    }

    protected NodeHandleAdapter getNodeHanldeAdapter(final TLPastryNode pn, NodeHandleFactory handleFactory, TLDeserializer deserializer) throws IOException {
        DirectTransportLayer<NodeHandle, RawMessage> tl = new DirectTransportLayer<NodeHandle, RawMessage>(pn.getLocalHandle(), this.simulator.getGenericSimulator(), this.simulator.getLivenessProvider(), pn.getEnvironment());
        return new NodeHandleAdapter(tl, this.simulator.getLivenessProvider(), new ProximityProvider<NodeHandle>(){
            List<ProximityListener<NodeHandle>> proxListeners = new ArrayList<ProximityListener<NodeHandle>>();

            @Override
            public int proximity(NodeHandle i) {
                return (int)DirectPastryNodeFactory.this.simulator.proximity((DirectNodeHandle)pn.getLocalHandle(), (DirectNodeHandle)i);
            }

            @Override
            public void addProximityListener(ProximityListener<NodeHandle> name) {
                this.proxListeners.add(name);
            }

            @Override
            public boolean removeProximityListener(ProximityListener<NodeHandle> name) {
                return this.proxListeners.remove(name);
            }
        });
    }

    protected Bootstrapper getBootstrapper(final TLPastryNode pn, NodeHandleAdapter tl, NodeHandleFactory handleFactory, final ProximityNeighborSelector pns) {
        return new Bootstrapper<NodeHandle>(){

            @Override
            public void boot(Collection<NodeHandle> bootaddresses) {
                pns.getNearHandles(bootaddresses, new Continuation<Collection<NodeHandle>, Exception>(){

                    @Override
                    public void receiveResult(Collection<NodeHandle> result) {
                        pn.doneNode(result);
                    }

                    @Override
                    public void receiveException(Exception exception) {
                    }
                });
            }
        };
    }

    static class NullCancellableTask
    implements CancellableTask {
        NullCancellableTask() {
        }

        public void run() {
        }

        public boolean cancel() {
            return false;
        }

        public long scheduledExecutionTime() {
            return 0L;
        }
    }
}

