/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.exception.NodeIsFaultyException;
import rice.environment.logging.Logger;
import rice.pastry.direct.Delivery;
import rice.pastry.direct.DirectTransportLayer;
import rice.pastry.direct.GenericNetworkSimulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectAppSocket<Identifier, MessageType> {
    public static final byte[] EOF = new byte[0];
    private static final int MAX_BYTES_IN_FLIGHT = 10000;
    Identifier acceptor;
    Identifier connector;
    SocketCallback<Identifier> connectorReceiver;
    GenericNetworkSimulator<Identifier, MessageType> simulator;
    DirectAppSocketEndpoint acceptorEndpoint;
    DirectAppSocketEndpoint connectorEndpoint;
    SocketRequestHandle<Identifier> connectorHandle;
    Logger logger;
    Map<String, Integer> options;

    public DirectAppSocket(Identifier acceptor, Identifier connector, SocketCallback<Identifier> connectorCallback, GenericNetworkSimulator<Identifier, MessageType> simulator, SocketRequestHandle<Identifier> handle, Map<String, Integer> options) {
        this.options = options;
        this.acceptor = acceptor;
        this.connector = connector;
        this.connectorReceiver = connectorCallback;
        this.simulator = simulator;
        this.logger = simulator.getEnvironment().getLogManager().getLogger(DirectAppSocket.class, "");
        this.acceptorEndpoint = new DirectAppSocketEndpoint(acceptor);
        this.connectorEndpoint = new DirectAppSocketEndpoint(connector);
        this.acceptorEndpoint.setCounterpart(this.connectorEndpoint);
        this.connectorEndpoint.setCounterpart(this.acceptorEndpoint);
    }

    public Delivery getAcceptorDelivery() {
        return new AcceptorDelivery();
    }

    public String toString() {
        return "DAS{" + this.connector + "[" + this.connectorReceiver + "]->" + this.acceptor + "}";
    }

    class ConnectorExceptionDelivery
    implements Delivery {
        IOException e;

        public ConnectorExceptionDelivery(IOException e) {
            this.e = e;
        }

        public void deliver() {
            DirectAppSocket.this.connectorReceiver.receiveException(DirectAppSocket.this.connectorHandle, this.e);
        }

        public int getSeq() {
            return -1;
        }
    }

    class ConnectorDelivery
    implements Delivery {
        ConnectorDelivery() {
        }

        public void deliver() {
            if (DirectAppSocket.this.simulator.isAlive(DirectAppSocket.this.connector)) {
                DirectAppSocket.this.connectorReceiver.receiveResult(DirectAppSocket.this.connectorHandle, DirectAppSocket.this.connectorEndpoint);
            } else {
                System.out.println("NOT IMPLEMENTED: Connector died during application socket initiation.");
            }
        }

        public int getSeq() {
            return -1;
        }
    }

    class AcceptorDelivery
    implements Delivery {
        AcceptorDelivery() {
        }

        public void deliver() {
            if (DirectAppSocket.this.simulator.isAlive(DirectAppSocket.this.acceptor)) {
                DirectTransportLayer acceptorTL = DirectAppSocket.this.simulator.getTL(DirectAppSocket.this.acceptor);
                if (acceptorTL.canReceiveSocket()) {
                    acceptorTL.finishReceiveSocket(DirectAppSocket.this.acceptorEndpoint);
                    DirectAppSocket.this.simulator.enqueueDelivery(new ConnectorDelivery(), Math.round(DirectAppSocket.this.simulator.networkDelay(DirectAppSocket.this.acceptor, DirectAppSocket.this.connector)));
                } else {
                    DirectAppSocket.this.simulator.enqueueDelivery(new ConnectorExceptionDelivery(new SocketTimeoutException()), Math.round(DirectAppSocket.this.simulator.networkDelay(DirectAppSocket.this.acceptor, DirectAppSocket.this.connector)));
                }
            } else {
                DirectAppSocket.this.simulator.enqueueDelivery(new ConnectorExceptionDelivery(new NodeIsFaultyException(DirectAppSocket.this.acceptor)), Math.round(DirectAppSocket.this.simulator.networkDelay(DirectAppSocket.this.acceptor, DirectAppSocket.this.connector)));
            }
        }

        public int getSeq() {
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DirectAppSocketEndpoint
    implements P2PSocket<Identifier> {
        DirectAppSocketEndpoint counterpart;
        P2PSocketReceiver<Identifier> reader;
        P2PSocketReceiver<Identifier> writer;
        Identifier localNodeHandle;
        int seq = 0;
        boolean outputClosed;
        int bytesInFlight = 0;
        LinkedList byteDeliveries = new LinkedList();
        int firstOffset = 0;

        public DirectAppSocketEndpoint(Identifier localNodeHandle) {
            this.localNodeHandle = localNodeHandle;
        }

        public void setCounterpart(DirectAppSocketEndpoint counterpart) {
            this.counterpart = counterpart;
        }

        public Identifier getRemoteNodeHandle() {
            return this.counterpart.localNodeHandle;
        }

        @Override
        public long read(ByteBuffer dsts) throws IOException {
            ByteBuffer[] foo = new ByteBuffer[]{dsts};
            return this.read(foo, 0, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) {
            int lengthRead = 0;
            DirectAppSocketEndpoint directAppSocketEndpoint = this;
            synchronized (directAppSocketEndpoint) {
                if (this.byteDeliveries.getFirst() == EOF) {
                    return -1L;
                }
                Iterator i = this.byteDeliveries.iterator();
                while (i.hasNext()) {
                    byte[] msg = (byte[])i.next();
                    for (int dstCtr = offset; dstCtr < offset + length; ++dstCtr) {
                        ByteBuffer curBuffer = dsts[dstCtr];
                        int lengthToPut = curBuffer.remaining();
                        if (lengthToPut > msg.length - this.firstOffset) {
                            lengthToPut = msg.length - this.firstOffset;
                        }
                        curBuffer.put(msg, this.firstOffset, lengthToPut);
                        this.firstOffset += lengthToPut;
                        lengthRead += lengthToPut;
                        if (this.firstOffset == msg.length) break;
                        offset = dstCtr + 1;
                    }
                    if (this.firstOffset != msg.length) break;
                    i.remove();
                    this.firstOffset = 0;
                }
            }
            this.bytesInFlight -= lengthRead;
            DirectAppSocket.this.simulator.enqueueDelivery(new Delivery(){

                public void deliver() {
                    DirectAppSocketEndpoint.this.counterpart.notifyCanWrite();
                }

                public int getSeq() {
                    return 0;
                }
            }, 0);
            return lengthRead;
        }

        @Override
        public long write(ByteBuffer srcs) throws IOException {
            ByteBuffer[] foo = new ByteBuffer[]{srcs};
            return this.write(foo, 0, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            int lengthToWrite;
            if (this.outputClosed) {
                throw new ClosedChannelException();
            }
            int availableToWrite = 0;
            for (int i = offset; i < offset + length; ++i) {
                availableToWrite += srcs[i].remaining();
            }
            DirectAppSocketEndpoint directAppSocketEndpoint = this.counterpart;
            synchronized (directAppSocketEndpoint) {
                lengthToWrite = 10000 - this.counterpart.bytesInFlight;
                if (lengthToWrite > availableToWrite) {
                    lengthToWrite = availableToWrite;
                }
                this.counterpart.bytesInFlight += lengthToWrite;
            }
            final byte[] msg = new byte[lengthToWrite];
            int remaining = lengthToWrite;
            int i = offset;
            while (remaining > 0) {
                int lengthToReadFromBuffer = srcs[i].remaining();
                if (remaining < lengthToReadFromBuffer) {
                    lengthToReadFromBuffer = remaining;
                }
                srcs[i].get(msg, lengthToWrite - remaining, lengthToReadFromBuffer);
                remaining -= lengthToReadFromBuffer;
                ++i;
            }
            if (DirectAppSocket.this.logger.level <= 400) {
                DirectAppSocket.this.logger.log(this + ".write(" + lengthToWrite + ")");
            }
            DirectAppSocket.this.simulator.enqueueDelivery(new Delivery(){
                int mySeq;
                {
                    this.mySeq = DirectAppSocketEndpoint.this.seq++;
                }

                public void deliver() {
                    DirectAppSocketEndpoint.this.counterpart.addToReadQueue(msg);
                }

                public int getSeq() {
                    return this.mySeq;
                }
            }, Math.round(DirectAppSocket.this.simulator.networkDelay(this.localNodeHandle, this.counterpart.localNodeHandle)));
            return lengthToWrite;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addToReadQueue(byte[] msg) {
            DirectAppSocketEndpoint directAppSocketEndpoint = this;
            synchronized (directAppSocketEndpoint) {
                if (DirectAppSocket.this.logger.level <= 500) {
                    if (msg == EOF) {
                        DirectAppSocket.this.logger.log(this + ": addToReadQueue(EOF)");
                    } else {
                        DirectAppSocket.this.logger.log(this + ": addToReadQueue(" + msg.length + ")");
                    }
                }
                this.byteDeliveries.addLast(msg);
            }
            this.notifyCanRead();
        }

        protected void notifyCanWrite() {
            if (this.writer == null) {
                return;
            }
            if (this.counterpart.bytesInFlight < 10000) {
                P2PSocketReceiver temp = this.writer;
                this.writer = null;
                try {
                    temp.receiveSelectResult(this, false, true);
                }
                catch (IOException ioe) {
                    DirectAppSocket.this.logger.logException("Error in " + temp, ioe);
                }
            }
        }

        protected void notifyCanRead() {
            if (this.byteDeliveries.isEmpty()) {
                return;
            }
            if (this.reader != null) {
                P2PSocketReceiver temp = this.reader;
                this.reader = null;
                try {
                    temp.receiveSelectResult(this, true, false);
                }
                catch (IOException ioe) {
                    DirectAppSocket.this.logger.logException("Error in " + temp, ioe);
                }
            }
        }

        @Override
        public void register(boolean wantToRead, boolean wantToWrite, P2PSocketReceiver<Identifier> receiver) {
            if (wantToWrite) {
                this.writer = receiver;
                DirectAppSocket.this.simulator.enqueueDelivery(new Delivery(){

                    public void deliver() {
                        DirectAppSocketEndpoint.this.notifyCanWrite();
                    }

                    public int getSeq() {
                        return 0;
                    }
                }, 0);
            }
            if (wantToRead) {
                this.reader = receiver;
                DirectAppSocket.this.simulator.enqueueDelivery(new Delivery(){

                    public void deliver() {
                        DirectAppSocketEndpoint.this.notifyCanRead();
                    }

                    public int getSeq() {
                        return 0;
                    }
                }, 0);
            }
        }

        @Override
        public void shutdownOutput() {
            if (DirectAppSocket.this.logger.level <= 400) {
                DirectAppSocket.this.logger.log(this + ".shutdownOutput()");
            }
            this.outputClosed = true;
            DirectAppSocket.this.simulator.enqueueDelivery(new Delivery(){
                int mySeq;
                {
                    this.mySeq = DirectAppSocketEndpoint.this.seq++;
                }

                public void deliver() {
                    DirectAppSocketEndpoint.this.counterpart.addToReadQueue(EOF);
                }

                public int getSeq() {
                    return this.mySeq;
                }
            }, Math.round(DirectAppSocket.this.simulator.networkDelay(this.localNodeHandle, this.counterpart.localNodeHandle)));
        }

        public void shutdownInput() {
        }

        @Override
        public void close() {
            this.shutdownOutput();
            this.shutdownInput();
        }

        public String toString() {
            return "DAS{" + this.localNodeHandle + ":" + this.writer + "->" + this.counterpart.localNodeHandle + ":" + this.reader + "}";
        }

        @Override
        public Identifier getIdentifier() {
            return this.getRemoteNodeHandle();
        }

        @Override
        public Map<String, Integer> getOptions() {
            return DirectAppSocket.this.options;
        }
    }
}

