/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.liveness.LivenessListener;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.environment.random.RandomSource;
import rice.environment.time.TimeSource;
import rice.environment.time.simulated.DirectTimeSource;
import rice.p2p.commonapi.Cancellable;
import rice.p2p.commonapi.CancellableTask;
import rice.pastry.direct.Delivery;
import rice.pastry.direct.DeliveryTimerTask;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectTimerTask;
import rice.pastry.direct.DirectTransportLayer;
import rice.pastry.direct.GenericNetworkSimulator;
import rice.pastry.direct.MessageDelivery;
import rice.pastry.direct.NodeRecord;
import rice.pastry.transport.NodeHandleAdapter;
import rice.selector.SelectorManager;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicNetworkSimulator<Identifier, MessageType>
implements GenericNetworkSimulator<Identifier, MessageType> {
    Map<Identifier, Tupel> nodes = new HashMap<Identifier, Tupel>();
    Environment environment;
    TimeSource timeSource;
    private boolean isDirectTimeSource = false;
    protected Logger logger;
    protected RandomSource random;
    protected int MIN_DELAY = 1;
    protected SelectorManager manager;
    protected final int maxDiameter;
    protected final int minDelay;
    boolean running = false;
    long maxSpeedRequestSystemTime = 0L;
    long maxSpeedRequestSimTime = 0L;
    float maxSpeed = 0.0f;
    boolean printedDirectTimeSourceWarning = false;
    List<LivenessListener<Identifier>> livenessListeners = new ArrayList<LivenessListener<Identifier>>();

    public BasicNetworkSimulator(Environment env, RandomSource random) {
        this.environment = env;
        this.manager = this.environment.getSelectorManager();
        this.manager.useLoopListeners(false);
        Parameters params = env.getParameters();
        this.maxDiameter = params.getInt("pastry_direct_max_diameter");
        this.minDelay = params.getInt("pastry_direct_min_delay");
        this.random = random;
        this.logger = env.getLogManager().getLogger(this.getClass(), null);
        this.timeSource = env.getTimeSource();
        if (this.timeSource instanceof DirectTimeSource) {
            this.isDirectTimeSource = true;
        }
        this.manager.setSelect(false);
        this.start();
    }

    @Override
    public void start() {
        this.manager.invoke(new Runnable(){

            public void run() {
                if (BasicNetworkSimulator.this.running) {
                    return;
                }
                BasicNetworkSimulator.this.running = true;
                BasicNetworkSimulator.this.manager.invoke(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (!BasicNetworkSimulator.this.running) {
                            return;
                        }
                        try {
                            if (!BasicNetworkSimulator.this.simulate()) {
                                SelectorManager selectorManager = BasicNetworkSimulator.this.manager;
                                synchronized (selectorManager) {
                                    try {
                                        BasicNetworkSimulator.this.manager.wait(100L);
                                    }
                                    catch (InterruptedException ie) {
                                        BasicNetworkSimulator.this.logger.logException("BasicNetworkSimulator interrupted.", ie);
                                    }
                                }
                            }
                            BasicNetworkSimulator.this.manager.invoke(this);
                        }
                        catch (InterruptedException ie) {
                            if (BasicNetworkSimulator.this.logger.level <= 1000) {
                                BasicNetworkSimulator.this.logger.logException("BasicNetworkSimulator.start()", ie);
                            }
                            BasicNetworkSimulator.this.stop();
                        }
                    }
                });
            }
        });
    }

    @Override
    public void stop() {
        this.manager.invoke(new Runnable(){

            public void run() {
                BasicNetworkSimulator.this.running = false;
            }
        });
    }

    private void addTask(TimerTask dtt) {
        if (this.logger.level <= 500) {
            this.logger.log("addTask(" + dtt + ")");
        }
        this.manager.getTimer().schedule(dtt);
    }

    @Override
    public CancellableTask enqueueDelivery(Delivery d, int delay) {
        long time = this.timeSource.currentTimeMillis() + (long)delay;
        if (this.logger.level <= 500) {
            this.logger.log("BNS: enqueueDelivery " + d + ":" + time);
        }
        DeliveryTimerTask dtt = null;
        dtt = new DeliveryTimerTask(d, time, d.getSeq());
        this.addTask(dtt);
        return dtt;
    }

    public Cancellable deliverMessage(MessageType msg, Identifier node, Identifier from) {
        return this.deliverMessage(msg, node, from, 0);
    }

    @Override
    public Cancellable deliverMessage(MessageType msg, Identifier node, Identifier from, int delay) {
        return this.deliverMessage(msg, node, from, delay, 0);
    }

    public Cancellable deliverMessageFixedRate(MessageType msg, Identifier node, Identifier from, int delay, int period) {
        return this.deliverMessage(msg, node, from, delay, period);
    }

    public Cancellable deliverMessage(MessageType msg, Identifier node, Identifier from, int delay, int period) {
        if (this.logger.level <= 500) {
            this.logger.log("BNS: deliver " + msg + " to " + node);
        }
        DirectTimerTask dtt = null;
        if (from == null || this.isAlive(from)) {
            MessageDelivery<Identifier, MessageType> md = new MessageDelivery<Identifier, MessageType>(msg, node, from, null, this);
            dtt = new DirectTimerTask(md, this.timeSource.currentTimeMillis() + (long)delay, period);
            this.addTask(dtt);
        }
        return dtt;
    }

    @Override
    public void setMaxSpeed(float speed) {
        if (!this.isDirectTimeSource && !this.printedDirectTimeSourceWarning) {
            if (this.logger.level <= 900) {
                this.logger.log("Invalid TimeSource for setMaxSpeed()/setFullSpeed().  Use Environment.directEnvironment() to construct your Environment.");
            }
            this.printedDirectTimeSourceWarning = true;
        }
        this.maxSpeedRequestSystemTime = System.currentTimeMillis();
        this.maxSpeedRequestSimTime = this.timeSource.currentTimeMillis();
        this.maxSpeed = speed;
    }

    @Override
    public void setFullSpeed() {
        this.setMaxSpeed(-1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean simulate() throws InterruptedException {
        if (!this.isDirectTimeSource) {
            return true;
        }
        if (!this.environment.getSelectorManager().isSelectorThread()) {
            throw new RuntimeException("Must be on selector thread");
        }
        SelectorManager selectorManager = this.manager;
        synchronized (selectorManager) {
            long scheduledExecutionTime = this.manager.getNextTaskExecutionTime();
            if (scheduledExecutionTime < 0L) {
                if (this.logger.level <= 500) {
                    this.logger.log("taskQueue is empty");
                }
                return false;
            }
            if (scheduledExecutionTime > this.timeSource.currentTimeMillis()) {
                long neededSysDelay;
                long sysTime;
                long sysTimeDiff;
                long maxSimTime;
                long newSimTime = scheduledExecutionTime;
                if (this.maxSpeed > 0.0f && (maxSimTime = (long)((float)this.maxSpeedRequestSimTime + (float)(sysTimeDiff = (sysTime = System.currentTimeMillis()) - this.maxSpeedRequestSystemTime) * this.maxSpeed)) < newSimTime && (neededSysDelay = (long)((float)(newSimTime - maxSimTime) / this.maxSpeed)) >= 1L) {
                    this.manager.wait(neededSysDelay);
                    long now = System.currentTimeMillis();
                    long delay = now - sysTime;
                    if (delay < neededSysDelay) {
                        return true;
                    }
                }
                if (this.logger.level <= 400) {
                    this.logger.log("the time is now " + newSimTime);
                }
                ((DirectTimeSource)this.timeSource).setTime(newSimTime);
            }
        }
        return true;
    }

    public void registerIdentifier(Identifier i, TransportLayer<Identifier, MessageType> dtl, NodeRecord record) {
        this.nodes.put(i, new Tupel(i, dtl, record));
    }

    @Override
    public void remove(Identifier i) {
        this.nodes.remove(i);
        this.notifyLivenessListeners(i, 3, null);
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public RandomSource getRandomSource() {
        return this.random;
    }

    @Override
    public boolean isAlive(Identifier i) {
        return this.nodes.containsKey(i);
    }

    @Override
    public DirectTransportLayer<Identifier, MessageType> getTL(Identifier i) {
        Tupel t = this.nodes.get(i);
        if (t == null) {
            return null;
        }
        NodeHandleAdapter nha = (NodeHandleAdapter)t.tl;
        return (DirectTransportLayer)nha.getTL();
    }

    @Override
    public float networkDelay(Identifier a, Identifier b) {
        Tupel ta = this.nodes.get(a);
        Tupel tb = this.nodes.get(b);
        if (ta == null) {
            throw new RuntimeException("asking about node proximity for unknown node " + a);
        }
        if (tb == null) {
            throw new RuntimeException("asking about node proximity for unknown node " + b);
        }
        NodeRecord nra = ta.record;
        NodeRecord nrb = tb.record;
        return nra.networkDelay(nrb);
    }

    public float proximity(Identifier a, Identifier b) {
        Tupel ta = this.nodes.get(a);
        Tupel tb = this.nodes.get(b);
        if (ta == null) {
            throw new RuntimeException("asking about node proximity for unknown node " + a);
        }
        if (tb == null) {
            throw new RuntimeException("asking about node proximity for unknown node " + b);
        }
        NodeRecord nra = ta.record;
        NodeRecord nrb = tb.record;
        return nra.proximity(nrb);
    }

    public NodeRecord getNodeRecord(DirectNodeHandle handle) {
        Tupel t = this.nodes.get(handle);
        if (t == null) {
            return null;
        }
        return t.record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLivenessListener(LivenessListener<Identifier> name) {
        List<LivenessListener<Identifier>> list = this.livenessListeners;
        synchronized (list) {
            this.livenessListeners.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLivenessListener(LivenessListener<Identifier> name) {
        List<LivenessListener<Identifier>> list = this.livenessListeners;
        synchronized (list) {
            return this.livenessListeners.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLivenessListeners(Identifier i, int liveness, Map<String, Integer> options) {
        ArrayList<LivenessListener<Identifier>> temp;
        if (this.logger.level <= 400) {
            this.logger.log("notifyLivenessListeners(" + i + "," + liveness + "):" + this.livenessListeners.get(0));
        }
        List<LivenessListener<Identifier>> list = this.livenessListeners;
        synchronized (list) {
            temp = new ArrayList<LivenessListener<Identifier>>(this.livenessListeners);
        }
        for (LivenessListener livenessListener : temp) {
            livenessListener.livenessChanged(i, liveness, options);
        }
    }

    @Override
    public boolean checkLiveness(Identifier i, Map<String, Integer> options) {
        return false;
    }

    @Override
    public int getLiveness(Identifier i, Map<String, Integer> options) {
        if (this.nodes.containsKey(i)) {
            return 1;
        }
        return 3;
    }

    @Override
    public void clearState(Identifier i) {
        throw new IllegalStateException("not implemented");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Tupel {
        Identifier i;
        TransportLayer<Identifier, MessageType> tl;
        NodeRecord record;

        public Tupel(Identifier i, TransportLayer<Identifier, MessageType> tl, NodeRecord record) {
            this.i = i;
            this.tl = tl;
            this.record = record;
        }
    }
}

