/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.liveness.LivenessProvider;
import org.mpisws.p2p.transport.proximity.ProximityProvider;
import rice.Continuation;
import rice.Destructable;
import rice.Executable;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.appsocket.AppSocketReceiver;
import rice.pastry.Id;
import rice.pastry.JoinFailedException;
import rice.pastry.NetworkListener;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.NodeSetListener;
import rice.pastry.ReadyStrategy;
import rice.pastry.ScheduledMessage;
import rice.pastry.boot.Bootstrapper;
import rice.pastry.client.PastryAppl;
import rice.pastry.commonapi.PastryEndpoint;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.messaging.RawMessageDelivery;
import rice.pastry.routing.Router;
import rice.pastry.routing.RoutingTable;
import rice.pastry.transport.PMessageNotification;
import rice.pastry.transport.PMessageReceipt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PastryNode
extends Observable
implements Node,
Destructable,
NodeHandleFactory,
LivenessProvider<NodeHandle>,
ProximityProvider<NodeHandle> {
    protected Id myNodeId;
    private Environment myEnvironment;
    private MessageDispatch myMessageDispatch;
    protected LeafSet leafSet;
    protected RoutingTable routeSet;
    protected NodeHandle localhandle;
    protected Vector apps;
    protected Logger logger;
    ReadyStrategy readyStrategy;
    protected boolean joinFailed = false;
    protected boolean isDestroyed = false;
    protected Router router;
    private boolean neverBeenReady = true;
    HashSet<Destructable> destructables = new HashSet();
    protected JoinFailedException joinFailedReason;

    @Override
    public abstract NodeHandle coalesce(NodeHandle var1);

    protected PastryNode(Id id, Environment e) {
        this.myEnvironment = e;
        this.myNodeId = id;
        this.readyStrategy = this.getDefaultReadyStrategy();
        this.apps = new Vector();
        this.logger = e.getLogManager().getLogger(this.getClass(), null);
    }

    public ReadyStrategy getDefaultReadyStrategy() {
        return new ReadyStrategy(){
            private boolean ready = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setReady(boolean r) {
                if (r != this.ready) {
                    PastryNode pastryNode = PastryNode.this;
                    synchronized (pastryNode) {
                        this.ready = r;
                    }
                    PastryNode.this.notifyReadyObservers();
                }
            }

            public boolean isReady() {
                return this.ready;
            }

            public void start() {
            }

            public void stop() {
            }
        };
    }

    public void setReadyStrategy(ReadyStrategy rs) {
        this.readyStrategy = rs;
    }

    public void setElements(NodeHandle lh, MessageDispatch md, LeafSet ls, RoutingTable rt, Router router) {
        this.localhandle = lh;
        this.setMessageDispatch(md);
        this.leafSet = ls;
        this.routeSet = rt;
        this.router = router;
    }

    @Override
    public rice.p2p.commonapi.NodeHandle getLocalNodeHandle() {
        return this.localhandle;
    }

    @Override
    public Environment getEnvironment() {
        return this.myEnvironment;
    }

    public NodeHandle getLocalHandle() {
        return this.localhandle;
    }

    public Id getNodeId() {
        return this.myNodeId;
    }

    public boolean isReady() {
        return this.readyStrategy.isReady();
    }

    public MessageDispatch getMessageDispatch() {
        return this.myMessageDispatch;
    }

    public void setMessageDispatch(MessageDispatch md) {
        this.myMessageDispatch = md;
        this.addDestructable(this.myMessageDispatch);
    }

    public Destructable addDestructable(Destructable d) {
        this.destructables.add(d);
        return d;
    }

    public boolean removeDestructable(Destructable d) {
        return this.destructables.remove(d);
    }

    public abstract void nodeIsReady();

    public void nodeIsReady(boolean state) {
    }

    public abstract void initiateJoin(NodeHandle[] var1);

    public void setReady() {
        this.setReady(true);
    }

    public void setReady(boolean ready) {
        this.readyStrategy.setReady(ready);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReadyObservers() {
        boolean ready = this.readyStrategy.isReady();
        if (this.logger.level <= 800) {
            this.logger.log("PastryNode.notifyReadyObservers(" + ready + ")");
        }
        if (ready) {
            this.nodeIsReady();
            this.nodeIsReady(true);
            this.setChanged();
            this.notifyObservers(true);
            if (this.neverBeenReady) {
                Vector tmpApps = new Vector(this.apps);
                Iterator it = tmpApps.iterator();
                while (it.hasNext()) {
                    ((PastryAppl)it.next()).notifyReady();
                }
                this.neverBeenReady = false;
            }
            PastryNode pastryNode = this;
            synchronized (pastryNode) {
                this.notifyAll();
            }
        } else {
            this.nodeIsReady(false);
            this.setChanged();
            this.notifyObservers(new Boolean(false));
        }
    }

    public boolean isClosest(Id key) {
        return this.leafSet.mostSimilar(key) == 0;
    }

    public LeafSet getLeafSet() {
        return this.leafSet;
    }

    public RoutingTable getRoutingTable() {
        return this.routeSet;
    }

    public void addLeafSetObserver(Observer o) {
        this.leafSet.addObserver(o);
    }

    public void deleteLeafSetObserver(Observer o) {
        this.leafSet.deleteObserver(o);
    }

    public void addLeafSetListener(NodeSetListener listener) {
        this.leafSet.addNodeSetListener(listener);
    }

    public void deleteLeafSetListener(NodeSetListener listener) {
        this.leafSet.deleteNodeSetListener(listener);
    }

    public void addRouteSetObserver(Observer o) {
        this.routeSet.addObserver(o);
    }

    public void deleteRouteSetObserver(Observer o) {
        this.routeSet.deleteObserver(o);
    }

    public void addRouteSetListener(NodeSetListener listener) {
        this.routeSet.addNodeSetListener(listener);
    }

    public void removeRouteSetListener(NodeSetListener listener) {
        this.routeSet.removeNodeSetListener(listener);
    }

    public synchronized void receiveMessage(Message msg) {
        if (this.isDestroyed) {
            return;
        }
        if (this.logger.level <= 500) {
            this.logger.log("receiveMessage(" + msg + ")");
        }
        this.myMessageDispatch.dispatchMessage(msg);
    }

    public synchronized void receiveMessage(RawMessageDelivery delivery) {
        this.myMessageDispatch.dispatchMessage(delivery);
    }

    public void registerReceiver(int address, PastryAppl receiver) {
        this.myMessageDispatch.registerReceiver(address, receiver);
    }

    public void registerApp(PastryAppl app) {
        if (this.isReady()) {
            app.notifyReady();
        }
        this.apps.add(app);
    }

    public abstract ScheduledMessage scheduleMsg(Message var1, long var2);

    public abstract ScheduledMessage scheduleMsg(Message var1, long var2, long var4);

    public abstract ScheduledMessage scheduleMsgAtFixedRate(Message var1, long var2, long var4);

    public String toString() {
        return "Pastry node " + this.myNodeId.toString();
    }

    @Override
    public Endpoint registerApplication(Application application, String instance) {
        return new PastryEndpoint(this, application, instance, true);
    }

    @Override
    public Endpoint buildEndpoint(Application application, String instance) {
        return new PastryEndpoint(this, application, instance, false);
    }

    @Override
    public rice.p2p.commonapi.Id getId() {
        return this.getNodeId();
    }

    @Override
    public IdFactory getIdFactory() {
        return new PastryIdFactory(this.getEnvironment());
    }

    public void process(Executable task, Continuation command) {
        try {
            this.myEnvironment.getProcessor().process(task, command, this.myEnvironment.getSelectorManager(), this.myEnvironment.getTimeSource(), this.myEnvironment.getLogManager());
        }
        catch (Exception e) {
            command.receiveException(e);
        }
    }

    @Override
    public void destroy() {
        if (this.isDestroyed) {
            return;
        }
        if (this.logger.level <= 800) {
            this.logger.log("Destroying " + this);
        }
        this.isDestroyed = true;
        for (Destructable d : this.destructables) {
            if (this.logger.level <= 795) {
                this.logger.log("Destroying " + d);
            }
            d.destroy();
        }
        this.getEnvironment().removeDestructable(this);
    }

    public abstract PMessageReceipt send(NodeHandle var1, Message var2, PMessageNotification var3, Map<String, Integer> var4);

    public abstract SocketRequestHandle connect(NodeHandle var1, AppSocketReceiver var2, PastryAppl var3, int var4);

    @Override
    public abstract int proximity(NodeHandle var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinFailed(JoinFailedException cje) {
        if (this.logger.level <= 900) {
            this.logger.log("joinFailed(" + cje + ")");
        }
        this.joinFailedReason = cje;
        PastryNode pastryNode = this;
        synchronized (pastryNode) {
            this.joinFailed = true;
            this.notifyAll();
        }
        this.setChanged();
        this.notifyObservers(cje);
    }

    public boolean joinFailed() {
        return this.joinFailed;
    }

    public JoinFailedException joinFailedReason() {
        return this.joinFailedReason;
    }

    public abstract Bootstrapper getBootstrapper();

    public Router getRouter() {
        return this.router;
    }

    public void addNetworkListener(NetworkListener nl) {
    }
}

