/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import rice.environment.random.RandomSource;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeHandleFactory;
import rice.pastry.NodeSetI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeSet
implements NodeSetI,
Serializable {
    public static final short TYPE = 1;
    static final long serialVersionUID = 4410658508346287677L;
    private Vector<NodeHandle> set;

    public NodeSet() {
        this.set = new Vector();
    }

    public NodeSet(Vector<NodeHandle> s) {
        this.set = s;
    }

    public NodeSet(NodeSet o) {
        this.set = new Vector<NodeHandle>(o.set);
    }

    @Override
    public boolean put(NodeHandle handle) {
        if (this.set.contains(handle)) {
            return false;
        }
        this.set.add(handle);
        return true;
    }

    public void randomize(RandomSource random) {
        for (int i = 0; i < this.set.size(); ++i) {
            int a = random.nextInt(this.set.size());
            int b = random.nextInt(this.set.size());
            NodeHandle tmp = this.set.elementAt(a);
            this.set.setElementAt(this.set.elementAt(b), a);
            this.set.setElementAt(tmp, b);
        }
    }

    @Override
    public NodeHandle get(Id nid) {
        try {
            return this.set.elementAt(this.getIndex(nid));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public NodeHandle get(int i) {
        NodeHandle h;
        try {
            h = this.set.elementAt(i);
        }
        catch (Exception e) {
            return null;
        }
        return h;
    }

    private boolean memberId(rice.p2p.commonapi.Id id) {
        return this.getIndexId(id) >= 0;
    }

    public NodeHandle remove(Id nid) {
        try {
            return this.set.remove(this.getIndex(nid));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public int getIndex(Id nid) {
        return this.getIndexId(nid);
    }

    @Override
    public int getIndex(NodeHandle nh) {
        for (int i = 0; i < this.set.size(); ++i) {
            try {
                NodeHandle h = this.set.elementAt(i);
                if (!h.equals(nh)) continue;
                return i;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return -1;
    }

    private int getIndexId(rice.p2p.commonapi.Id nid) {
        for (int i = 0; i < this.set.size(); ++i) {
            try {
                NodeHandle h = this.set.elementAt(i);
                if (!h.getNodeId().equals(nid)) continue;
                return i;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean insert(int index, NodeHandle handle) {
        if (this.set.contains(handle)) {
            return false;
        }
        this.set.add(index, handle);
        return true;
    }

    @Override
    public NodeHandle remove(NodeHandle handle) {
        if (this.set.remove(handle)) {
            return handle;
        }
        return null;
    }

    public void remove(int index) {
        this.set.remove(index);
    }

    public int indexOf(NodeHandle handle) {
        return this.set.indexOf(handle);
    }

    @Override
    public boolean member(NodeHandle handle) {
        return this.set.contains(handle);
    }

    NodeSet subSet(int from, int to) {
        NodeSet res;
        try {
            res = new NodeSet(new Vector<NodeHandle>(this.set.subList(from, to)));
        }
        catch (Exception e) {
            return null;
        }
        return res;
    }

    public Iterator getIterator() {
        return this.set.iterator();
    }

    public String toString() {
        String s = "NodeSet: ";
        for (int i = 0; i < this.size(); ++i) {
            s = s + this.get(i).getNodeId();
        }
        return s;
    }

    @Override
    public boolean putHandle(rice.p2p.commonapi.NodeHandle handle) {
        return this.put((NodeHandle)handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public rice.p2p.commonapi.NodeHandle getHandle(rice.p2p.commonapi.Id id) {
        Vector<NodeHandle> vector = this.set;
        synchronized (vector) {
            for (NodeHandle nh : this.set) {
                if (!nh.getId().equals(id)) continue;
                return nh;
            }
        }
        return null;
    }

    @Override
    public rice.p2p.commonapi.NodeHandle getHandle(int i) {
        return this.get(i);
    }

    @Override
    public boolean memberHandle(rice.p2p.commonapi.Id id) {
        return this.memberId(id);
    }

    @Override
    public rice.p2p.commonapi.NodeHandle removeHandle(rice.p2p.commonapi.Id id) {
        return this.remove((Id)id);
    }

    @Override
    public int getIndexHandle(rice.p2p.commonapi.Id id) throws NoSuchElementException {
        return this.getIndex((Id)id);
    }

    public Iterator<NodeHandle> iterator() {
        return this.set.iterator();
    }

    public NodeSet(InputBuffer buf, NodeHandleFactory nhf) throws IOException {
        int numNodes = buf.readShort();
        this.set = new Vector(numNodes);
        for (int i = 0; i < numNodes; ++i) {
            this.set.add(nhf.readNodeHandle(buf));
        }
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeShort((short)this.set.size());
        for (NodeHandle nh : this.set) {
            nh.serialize(buf);
        }
    }

    @Override
    public short getType() {
        return 1;
    }
}

