/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.util.BloomFilter;

public class IdBloomFilter
implements Serializable {
    private static final long serialVersionUID = -9122948172786936161L;
    public static int NUM_BITS_PER_KEY = 4;
    public static int NUM_HASH_FUNCTIONS = 2;
    protected transient byte[] array;
    protected BloomFilter filter;

    public IdBloomFilter(IdSet set) {
        int size = set.numElements() < 64 ? 64 : set.numElements();
        this.filter = new BloomFilter(NUM_HASH_FUNCTIONS, NUM_BITS_PER_KEY * size);
        Iterator i = set.getIterator();
        while (i.hasNext()) {
            this.addId((Id)i.next());
        }
    }

    protected void checkArray(Id id) {
        if (this.array == null) {
            this.array = id.toByteArray();
        } else {
            id.toByteArray(this.array, 0);
        }
    }

    protected void addId(Id id) {
        this.checkArray(id);
        this.filter.add(this.array);
    }

    public boolean check(Id id) {
        this.checkArray(id);
        return this.filter.check(this.array);
    }

    public void check(IdSet set, IdSet result, int max) {
        Iterator it = set.getIterator();
        int count = 0;
        while (it.hasNext() && count < max) {
            Id next = (Id)it.next();
            if (this.check(next)) continue;
            result.addId(next);
            ++count;
        }
    }

    public IdBloomFilter(InputBuffer buf) throws IOException {
        this.filter = new BloomFilter(buf);
    }

    public void serialize(OutputBuffer buf) throws IOException {
        this.filter.serialize(buf);
    }
}

