/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.glacier;

import java.util.Random;
import java.util.SortedMap;
import java.util.StringTokenizer;
import rice.environment.random.RandomSource;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.glacier.FragmentKey;
import rice.p2p.glacier.FragmentKeyRange;
import rice.p2p.glacier.FragmentKeySet;
import rice.p2p.glacier.VersionKey;
import rice.p2p.multiring.MultiringIdFactory;
import rice.p2p.multiring.RingId;

public class FragmentKeyFactory
implements IdFactory {
    private MultiringIdFactory FACTORY;

    public FragmentKeyFactory(MultiringIdFactory factory) {
        this.FACTORY = factory;
    }

    public Id buildId(byte[] material) {
        throw new RuntimeException("FragmentKeyFactory.buildId(byte[]) is not supported!");
    }

    public Id buildId(int[] material) {
        throw new RuntimeException("FragmentKeyFactory.buildId(byte[]) is not supported!");
    }

    public Id buildId(String string) {
        throw new RuntimeException("FragmentKeyFactory.buildId(String) is not supported!");
    }

    public Id buildRandomId(Random rng) {
        return new FragmentKey(new VersionKey(this.FACTORY.buildRandomId(rng), rng.nextLong()), rng.nextInt());
    }

    public Id buildRandomId(RandomSource rng) {
        return new FragmentKey(new VersionKey(this.FACTORY.buildRandomId(rng), rng.nextLong()), rng.nextInt());
    }

    public Id buildIdFromToString(String string) {
        StringTokenizer stok = new StringTokenizer(string, "(,) :v#");
        if (stok.countTokens() < 4) {
            return null;
        }
        String keyRingS = stok.nextToken();
        String keyNodeS = stok.nextToken();
        String versionS = stok.nextToken();
        String fragmentIdS = stok.nextToken();
        RingId key = this.FACTORY.buildRingId((Id)rice.pastry.Id.build(keyRingS), rice.pastry.Id.build(keyNodeS));
        return new FragmentKey(new VersionKey(key, Long.valueOf(versionS)), Integer.valueOf(fragmentIdS));
    }

    public Id buildIdFromToString(char[] chars, int offset, int length) {
        return this.buildIdFromToString(new String(chars, offset, length));
    }

    public Id.Distance buildIdDistance(byte[] material) {
        throw new RuntimeException("FragmentKeyFactory.buildIdDistance() is not supported!");
    }

    public IdRange buildIdRange(Id cw, Id ccw) {
        throw new RuntimeException("FragmentKeyFactory.buildIdRange() is not supported!");
    }

    public IdRange buildIdRangeFromPrefix(String string) {
        return new FragmentKeyRange(this.FACTORY.buildIdRangeFromPrefix(string));
    }

    public IdSet buildIdSet() {
        return new FragmentKeySet();
    }

    public IdSet buildIdSet(SortedMap map) {
        return new FragmentKeySet(map);
    }

    public NodeHandleSet buildNodeHandleSet() {
        throw new RuntimeException("FragmentKeyFactory.buildNodeHandleSet() is not supported!");
    }

    public int getIdToStringLength() {
        return this.FACTORY.getIdToStringLength() + 4;
    }
}

