/*
 * Decompiled with CFR 0.152.
 */
package rice.p2p.aggregation;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import rice.Continuation;
import rice.Executable;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.p2p.aggregation.Aggregate;
import rice.p2p.aggregation.AggregateDescriptor;
import rice.p2p.aggregation.AggregateFactory;
import rice.p2p.aggregation.AggregateHandle;
import rice.p2p.aggregation.AggregateList;
import rice.p2p.aggregation.Aggregation;
import rice.p2p.aggregation.AggregationDefaultPolicy;
import rice.p2p.aggregation.AggregationException;
import rice.p2p.aggregation.AggregationPolicy;
import rice.p2p.aggregation.AggregationStatistics;
import rice.p2p.aggregation.ObjectDescriptor;
import rice.p2p.aggregation.messaging.AggregationMessage;
import rice.p2p.aggregation.messaging.AggregationTimeoutMessage;
import rice.p2p.aggregation.messaging.NonAggregate;
import rice.p2p.aggregation.raw.RawAggregate;
import rice.p2p.aggregation.raw.RawAggregateFactory;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdSet;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.p2p.glacier.VersionKey;
import rice.p2p.glacier.VersioningPast;
import rice.p2p.glacier.v2.DebugContent;
import rice.p2p.glacier.v2.GlacierContentHandle;
import rice.p2p.past.Past;
import rice.p2p.past.PastContent;
import rice.p2p.past.PastContentHandle;
import rice.p2p.past.PastImpl;
import rice.p2p.past.gc.GCPast;
import rice.p2p.past.gc.GCPastContent;
import rice.p2p.past.gc.GCPastContentHandle;
import rice.p2p.past.gc.rawserialization.RawGCPastContent;
import rice.p2p.past.rawserialization.JavaPastContentDeserializer;
import rice.p2p.past.rawserialization.JavaPastContentHandleDeserializer;
import rice.p2p.past.rawserialization.JavaSerializedPastContent;
import rice.p2p.past.rawserialization.PastContentDeserializer;
import rice.p2p.past.rawserialization.PastContentHandleDeserializer;
import rice.p2p.past.rawserialization.RawPastContent;
import rice.p2p.util.DebugCommandHandler;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;
import rice.persistence.StorageManager;

public class AggregationImpl
implements GCPast,
VersioningPast,
Aggregation,
Application,
DebugCommandHandler {
    protected final Past aggregateStore;
    protected final StorageManager waitingList;
    protected final AggregationPolicy policy;
    protected final AggregateList aggregateList;
    protected final Endpoint endpoint;
    protected final Past objectStore;
    protected final String instance;
    protected final IdFactory factory;
    protected final Node node;
    private final char tiFlush = '\u0001';
    private final char tiMonitor = (char)2;
    private final char tiConsolidate = (char)3;
    private final char tiStatistics = (char)4;
    private final char tiExpire = (char)5;
    protected Hashtable timers;
    protected Continuation flushWait;
    protected boolean rebuildInProgress;
    protected Vector monitorIDs;
    protected AggregationStatistics stats;
    private static final long SECONDS = 1000L;
    private static final long MINUTES = 60000L;
    private static final long HOURS = 3600000L;
    private static final long DAYS = 86400000L;
    private static final long WEEKS = 604800000L;
    private final boolean logStatistics;
    private final long flushDelayAfterJoin;
    private final long flushStressInterval;
    private long flushInterval;
    private int maxAggregateSize;
    private int maxObjectsInAggregate;
    private int maxAggregatesPerRun;
    private final boolean addMissingAfterRefresh;
    private final int maxReaggregationPerRefresh;
    private final int nominalReferenceCount;
    private final int maxPointersPerAggregate;
    private final long pointerArrayLifetime;
    private final long aggregateGracePeriod;
    private final long aggrRefreshInterval;
    private final long aggrRefreshDelayAfterJoin;
    private long expirationRenewThreshold;
    private final boolean monitorEnabled;
    private final long monitorRefreshInterval;
    private final long consolidationDelayAfterJoin;
    private long consolidationInterval;
    private long consolidationThreshold;
    private int consolidationMinObjectsInAggregate;
    private double consolidationMinComponentsAlive;
    private int reconstructionMaxConcurrentLookups;
    private final boolean aggregateLogEnabled;
    private final long statsGranularity;
    private final long statsRange;
    private final long statsInterval;
    private final double jitterRange;
    private Environment environment;
    protected Logger logger;
    protected PastContentDeserializer contentDeserializer;
    protected PastContentHandleDeserializer contentHandleDeserializer;
    protected AggregateFactory aggregateFactory;

    public AggregationImpl(Node node, Past aggregateStore, Past objectStore, StorageManager waitingList, String configFileName, IdFactory factory, String instance) throws IOException {
        this(node, aggregateStore, objectStore, waitingList, configFileName, factory, instance, null, null);
    }

    public AggregationImpl(Node node, Past aggregateStore, Past objectStore, StorageManager waitingList, String configFileName, IdFactory factory, String instance, AggregationPolicy policy, AggregateFactory aggregateFactory) throws IOException {
        this.environment = node.getEnvironment();
        this.logger = this.environment.getLogManager().getLogger(AggregationImpl.class, instance);
        Parameters p = this.environment.getParameters();
        this.logStatistics = p.getBoolean("p2p_aggregation_logStatistics");
        this.flushDelayAfterJoin = p.getLong("p2p_aggregation_flushDelayAfterJoin");
        this.flushStressInterval = p.getLong("p2p_aggregation_flushStressInterval");
        this.flushInterval = p.getLong("p2p_aggregation_flushInterval");
        this.maxAggregateSize = p.getInt("p2p_aggregation_maxAggregateSize");
        this.maxObjectsInAggregate = p.getInt("p2p_aggregation_maxObjectsInAggregate");
        this.maxAggregatesPerRun = p.getInt("p2p_aggregation_maxAggregatesPerRun");
        this.addMissingAfterRefresh = p.getBoolean("p2p_aggregation_addMissingAfterRefresh");
        this.maxReaggregationPerRefresh = p.getInt("p2p_aggregation_maxReaggregationPerRefresh");
        this.nominalReferenceCount = p.getInt("p2p_aggregation_nominalReferenceCount");
        this.maxPointersPerAggregate = p.getInt("p2p_aggregation_maxPointersPerAggregate");
        this.pointerArrayLifetime = p.getLong("p2p_aggregation_pointerArrayLifetime");
        this.aggregateGracePeriod = p.getLong("p2p_aggregation_aggregateGracePeriod");
        this.aggrRefreshInterval = p.getLong("p2p_aggregation_aggrRefreshInterval");
        this.aggrRefreshDelayAfterJoin = p.getLong("p2p_aggregation_aggrRefreshDelayAfterJoin");
        this.expirationRenewThreshold = p.getLong("p2p_aggregation_expirationRenewThreshold");
        this.monitorEnabled = p.getBoolean("p2p_aggregation_monitorEnabled");
        this.monitorRefreshInterval = p.getLong("p2p_aggregation_monitorRefreshInterval");
        this.consolidationDelayAfterJoin = p.getLong("p2p_aggregation_consolidationDelayAfterJoin");
        this.consolidationInterval = p.getLong("p2p_aggregation_consolidationInterval");
        this.consolidationThreshold = p.getLong("p2p_aggregation_consolidationThreshold");
        this.consolidationMinObjectsInAggregate = p.getInt("p2p_aggregation_consolidationMinObjectsInAggregate");
        this.consolidationMinComponentsAlive = p.getDouble("p2p_aggregation_consolidationMinComponentsAlive");
        this.reconstructionMaxConcurrentLookups = p.getInt("p2p_aggregation_reconstructionMaxConcurrentLookups");
        this.aggregateLogEnabled = p.getBoolean("p2p_aggregation_aggregateLogEnabled");
        this.statsGranularity = p.getLong("p2p_aggregation_statsGranularity");
        this.statsRange = p.getLong("p2p_aggregation_statsRange");
        this.statsInterval = p.getLong("p2p_aggregation_statsInterval");
        this.jitterRange = p.getDouble("p2p_aggregation_jitterRange");
        this.aggregateFactory = aggregateFactory;
        if (this.aggregateFactory == null) {
            this.aggregateFactory = AggregationImpl.getDefaultAggregateFactory();
        }
        this.endpoint = node.buildEndpoint(this, instance);
        this.endpoint.setDeserializer(new MessageDeserializer(){

            public Message deserialize(InputBuffer buf, short type, int priority, NodeHandle sender) throws IOException {
                return null;
            }
        });
        this.waitingList = waitingList;
        this.instance = instance;
        this.contentDeserializer = new JavaPastContentDeserializer();
        this.contentHandleDeserializer = new JavaPastContentHandleDeserializer();
        this.aggregateStore = aggregateStore;
        this.aggregateStore.setContentDeserializer(new PastContentDeserializer(){

            public PastContent deserializePastContent(InputBuffer buf, Endpoint endpoint, short contentType) throws IOException {
                switch (contentType) {
                    case 1: {
                        return new RawAggregate(buf, endpoint, AggregationImpl.this.contentDeserializer);
                    }
                    case 2: {
                        short subType = buf.readShort();
                        return AggregationImpl.this.contentDeserializer.deserializePastContent(buf, endpoint, subType);
                    }
                }
                throw new IllegalArgumentException("Unknown Type:" + contentType);
            }
        });
        this.aggregateStore.setContentHandleDeserializer(new PastContentHandleDeserializer(){

            public PastContentHandle deserializePastContentHandle(InputBuffer buf, Endpoint endpoint, short contentType) throws IOException {
                switch (contentType) {
                    case 1: {
                        return new AggregateHandle(buf, endpoint);
                    }
                }
                throw new IllegalArgumentException("Unknown Type:" + contentType);
            }
        });
        this.objectStore = objectStore;
        this.node = node;
        this.timers = new Hashtable();
        this.aggregateList = new AggregateList(configFileName, this.getLocalNodeHandle().getId().toString(), factory, this.aggregateLogEnabled, instance, this.environment);
        this.stats = this.aggregateList.getStatistics(this.statsGranularity, this.statsRange, this.nominalReferenceCount);
        this.policy = policy == null ? AggregationImpl.getDefaultPolicy() : policy;
        this.factory = factory;
        this.flushWait = null;
        this.rebuildInProgress = false;
        this.monitorIDs = new Vector();
        if (!this.aggregateList.readOK()) {
            if (this.logger.level <= 900) {
                this.logger.log("Failed to read configuration file; aggregate list must be rebuilt!");
            } else if (this.logger.level <= 800) {
                this.logger.log("Aggregate list read OK -- current root: " + (this.aggregateList.getRoot() == null ? "null" : this.aggregateList.getRoot().toStringFull()));
            }
        }
        this.removeDeadAggregates();
        this.addTimer(this.jitterTerm(this.flushDelayAfterJoin), '\u0001');
        this.addTimer(this.jitterTerm(this.aggrRefreshDelayAfterJoin), '\u0005');
        this.addTimer(this.jitterTerm(this.consolidationDelayAfterJoin), '\u0003');
        this.addTimer(this.statsInterval, '\u0004');
        if (this.monitorEnabled) {
            this.addTimer(this.monitorRefreshInterval, '\u0002');
        }
        this.endpoint.register();
    }

    private static AggregationPolicy getDefaultPolicy() {
        return new AggregationDefaultPolicy();
    }

    private static AggregateFactory getDefaultAggregateFactory() {
        return new RawAggregateFactory();
    }

    private long jitterTerm(long basis) {
        return (long)((1.0 - this.jitterRange) * (double)basis) + (long)this.environment.getRandomSource().nextInt((int)(2.0 * this.jitterRange * (double)basis));
    }

    private void addTimer(long timeoutMsec, char timeoutID) {
        CancellableTask timer = this.endpoint.scheduleMessage(new AggregationTimeoutMessage(timeoutID, this.getLocalNodeHandle()), timeoutMsec);
        this.timers.put(new Integer(timeoutID), timer);
    }

    private void removeTimer(int timeoutID) {
        CancellableTask timer = (CancellableTask)this.timers.remove(new Integer(timeoutID));
        if (timer != null) {
            timer.cancel();
        }
    }

    private void panic(String s) throws Error {
        Error err = new Error("Panic " + s);
        if (this.logger.level <= 1000) {
            this.logger.logException("PANIC: " + s, err);
        }
        throw err;
    }

    public String handleDebugCommand(String command) {
        if (command.indexOf(" ") < 0) {
            return null;
        }
        String requestedInstance = command.substring(0, command.indexOf(" "));
        String myInstance = "aggr." + this.instance.substring(this.instance.lastIndexOf("-") + 1);
        String cmd = command.substring(requestedInstance.length() + 1);
        if (!requestedInstance.equals(myInstance) && !requestedInstance.equals("a")) {
            String subResult = null;
            if (subResult == null && this.aggregateStore instanceof DebugCommandHandler) {
                subResult = ((DebugCommandHandler)((Object)this.aggregateStore)).handleDebugCommand(command);
            }
            if (subResult == null && this.objectStore instanceof DebugCommandHandler) {
                subResult = ((DebugCommandHandler)((Object)this.objectStore)).handleDebugCommand(command);
            }
            return subResult;
        }
        if (this.logger.level <= 800) {
            this.logger.log("Debug command: " + cmd);
        }
        if (cmd.startsWith("status")) {
            return this.stats.numObjectsTotal + " objects total\n" + this.stats.numObjectsAlive + " objects alive\n" + this.stats.numAggregatesTotal + " aggregates total\n" + this.stats.numPointerArrays + " pointer arrays\n" + this.stats.criticalAggregates + " critical aggregates\n" + this.stats.orphanedAggregates + " orphaned aggregates\n";
        }
        if (cmd.startsWith("insert")) {
            int numObjects = Integer.parseInt(cmd.substring(7));
            String result = "";
            for (int i = 0; i < numObjects; ++i) {
                Id randomID = this.factory.buildRandomId(this.environment.getRandomSource());
                result = result + randomID.toStringFull() + "\n";
                this.insert(new DebugContent(randomID, false, 0L, new byte[0]), this.environment.getTimeSource().currentTimeMillis() + 120000L, new Continuation(){

                    public void receiveResult(Object o) {
                    }

                    public void receiveException(Exception e) {
                    }
                });
            }
            return result + numObjects + " object(s) created\n";
        }
        if (cmd.startsWith("show config")) {
            return "flushDelayAfterJoin = " + (int)(this.flushDelayAfterJoin / 1000L) + " sec\n" + "flushInterval = " + (int)(this.flushInterval / 1000L) + " sec\n" + "maxAggregateSize = " + this.maxAggregateSize + " bytes\n" + "maxObjectsInAggregate = " + this.maxObjectsInAggregate + " objects\n" + "maxAggregatesPerRun = " + this.maxAggregatesPerRun + " aggregates\n" + "addMissingAfterRefresh = " + this.addMissingAfterRefresh + "\n" + "nominalReferenceCount = " + this.nominalReferenceCount + "\n" + "maxPointersPerAggregate = " + this.maxPointersPerAggregate + "\n" + "pointerArrayLifetime = " + (int)(this.pointerArrayLifetime / 86400000L) + " days\n" + "aggrRefreshInterval = " + (int)(this.aggrRefreshInterval / 1000L) + " sec\n" + "aggrRefreshDelayAfterJoin = " + (int)(this.aggrRefreshDelayAfterJoin / 1000L) + " sec\n" + "expirationRenewThreshold = " + (int)(this.expirationRenewThreshold / 3600000L) + " hrs\n" + "consolidationDelayAfterJoin = " + (int)(this.consolidationDelayAfterJoin / 1000L) + " sec\n" + "consolidationInterval = " + (int)(this.consolidationInterval / 1000L) + " sec\n" + "consolidationThreshold = " + (int)(this.consolidationThreshold / 3600000L) + " hrs\n" + "consolidationMinObjectsInAggregate = " + this.consolidationMinObjectsInAggregate + "\n" + "consolidationMinComponentsAlive = " + this.consolidationMinComponentsAlive + "\n";
        }
        if (cmd.startsWith("ls")) {
            Enumeration enumeration = this.aggregateList.elements();
            StringBuffer result = new StringBuffer();
            int numAggr = 0;
            int numObj = 0;
            long now = this.environment.getTimeSource().currentTimeMillis();
            if (cmd.indexOf("-r") < 0) {
                now = 0L;
            }
            this.aggregateList.recalculateReferenceCounts(null);
            this.aggregateList.resetMarkers();
            while (enumeration.hasMoreElements()) {
                int i;
                AggregateDescriptor aggr = (AggregateDescriptor)enumeration.nextElement();
                if (aggr.marker) continue;
                result.append("***" + aggr.key.toStringFull() + " (" + aggr.objects.length + " obj, " + aggr.pointers.length + " ptr, " + aggr.referenceCount + " ref, exp=" + (aggr.currentLifetime - now) + ")\n");
                for (i = 0; i < aggr.objects.length; ++i) {
                    result.append("    #" + i + " " + aggr.objects[i].key.toStringFull() + "v" + aggr.objects[i].version + ", lt=" + (aggr.objects[i].currentLifetime - now) + ", rt=" + (aggr.objects[i].refreshedLifetime - now) + ", size=" + aggr.objects[i].size + " bytes\n");
                }
                for (i = 0; i < aggr.pointers.length; ++i) {
                    result.append("    Ref " + aggr.pointers[i].toStringFull() + "\n");
                }
                result.append("\n");
                aggr.marker = true;
                ++numAggr;
                numObj += aggr.objects.length;
            }
            result.append(numAggr + " aggregate(s), " + numObj + " object(s)");
            return result.toString();
        }
        if (cmd.startsWith("write list")) {
            this.aggregateList.writeToDisk();
            return "Done, new root is " + (this.aggregateList.getRoot() == null ? "null" : this.aggregateList.getRoot().toStringFull());
        }
        if (cmd.length() >= 5 && cmd.substring(0, 5).equals("reset")) {
            final String[] ret = new String[]{null};
            this.reset(new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.yield();
            }
            return ret[0];
        }
        if (cmd.startsWith("flush")) {
            final String[] ret = new String[]{null};
            this.flush(new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.yield();
            }
            return ret[0];
        }
        if (cmd.startsWith("get root")) {
            return "root=" + (this.aggregateList.getRoot() == null ? "null" : this.aggregateList.getRoot().toStringFull());
        }
        if (cmd.startsWith("set root")) {
            final String[] ret = new String[]{null};
            this.setHandle(this.factory.buildIdFromToString(cmd.substring(9)), new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.yield();
            }
            return ret[0];
        }
        if (cmd.startsWith("lookup")) {
            Id id = this.factory.buildIdFromToString(cmd.substring(7));
            final String[] ret = new String[]{null};
            this.lookup(id, false, new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.yield();
            }
            return "lookup(" + id + ")=" + ret[0];
        }
        if (cmd.startsWith("handles")) {
            String args = cmd.substring(8);
            Id id = this.factory.buildIdFromToString(args.substring(args.indexOf(32) + 1));
            int max = Integer.parseInt(args.substring(0, args.indexOf(32)));
            final String[] ret = new String[]{null};
            this.lookupHandles(id, max, new Continuation(){

                public void receiveResult(Object o) {
                    if (o instanceof PastContentHandle[]) {
                        PastContentHandle[] oA = (PastContentHandle[])o;
                        ret[0] = "";
                        for (int i = 0; i < oA.length; ++i) {
                            ret[0] = ret[0] + "#" + i + " " + oA[i] + "\n";
                        }
                        ret[0] = ret[0] + oA.length + " handle(s) returned\n";
                    } else {
                        ret[0] = "result(" + o + ") -- no handles returned!";
                    }
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.yield();
            }
            return "Handles(" + max + "," + id + "):\n" + ret[0];
        }
        if (cmd.startsWith("refresh all")) {
            String result;
            int i;
            long expiration = this.environment.getTimeSource().currentTimeMillis() + Long.parseLong(cmd.substring(12));
            TreeSet<Id> ids = new TreeSet<Id>();
            this.aggregateList.resetMarkers();
            Enumeration enumeration = this.aggregateList.elements();
            while (enumeration.hasMoreElements()) {
                AggregateDescriptor aggr = (AggregateDescriptor)enumeration.nextElement();
                if (aggr.marker) continue;
                aggr.marker = true;
                for (i = 0; i < aggr.objects.length; ++i) {
                    ids.add(aggr.objects[i].key);
                }
            }
            if (!ids.isEmpty()) {
                Id[] allIds = ids.toArray(new Id[0]);
                result = "Refreshing " + allIds.length + " keys...\n";
                for (i = 0; i < allIds.length; ++i) {
                    result = result + "#" + i + " " + allIds[i].toStringFull() + "\n";
                }
                final String[] ret = new String[]{null};
                this.refresh(allIds, expiration, new Continuation(){

                    public void receiveResult(Object o) {
                        ret[0] = "result(" + o + ")";
                    }

                    public void receiveException(Exception e) {
                        ret[0] = "exception(" + e + ")";
                    }
                });
                while (ret[0] == null) {
                    Thread.yield();
                }
                result = result + ret[0];
            } else {
                result = "Aggregate list is empty; nothing to refresh!";
            }
            return result;
        }
        if (cmd.startsWith("refresh")) {
            String args = cmd.substring(8);
            String expirationArg = args.substring(args.lastIndexOf(32) + 1);
            String keyArg = args.substring(0, args.lastIndexOf(32));
            Id id = this.factory.buildIdFromToString(keyArg);
            long expiration = this.environment.getTimeSource().currentTimeMillis() + Long.parseLong(expirationArg);
            final String[] ret = new String[]{null};
            this.refresh(new Id[]{id}, expiration, new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.yield();
            }
            return "refresh(" + id + ", " + expiration + ")=" + ret[0];
        }
        if (cmd.startsWith("monitor remove") && this.monitorEnabled) {
            String[] args = cmd.substring(15).split(" ");
            if (args.length == 1) {
                int howMany = Integer.parseInt(args[0]);
                if (howMany > this.monitorIDs.size()) {
                    howMany = this.monitorIDs.size();
                }
                for (int i = 0; i < howMany; ++i) {
                    this.monitorIDs.removeElementAt(this.environment.getRandomSource().nextInt(this.monitorIDs.size()));
                }
                return "Removed " + howMany + " elements; " + this.monitorIDs.size() + " elements left";
            }
            return "Syntax: monitor remove <howMany>";
        }
        if (cmd.startsWith("monitor status") && this.monitorEnabled) {
            return "Monitor is " + (this.monitorEnabled ? "enabled, monitoring " + this.monitorIDs.size() + " objects" : "disabled");
        }
        if (cmd.startsWith("monitor ls") && this.monitorEnabled) {
            StringBuffer result = new StringBuffer();
            Enumeration enumeration = this.monitorIDs.elements();
            while (enumeration.hasMoreElements()) {
                result.append(((Id)enumeration.nextElement()).toStringFull() + "\n");
            }
            result.append(this.monitorIDs.size() + " object(s)");
            return result.toString();
        }
        if (cmd.startsWith("monitor check") && this.monitorEnabled) {
            final StringBuffer result = new StringBuffer();
            final String[] ret = new String[]{null};
            if (this.monitorIDs.isEmpty()) {
                return "Add objects first!";
            }
            final long now = this.environment.getTimeSource().currentTimeMillis();
            Continuation c = new Continuation(){
                int currentLookup = 0;
                boolean lookupInAggrStore = false;

                public void receiveResult(Object o) {
                    if (AggregationImpl.this.logger.level <= 500) {
                        AggregationImpl.this.logger.log("Monitor: Retr " + this.currentLookup + " a=" + this.lookupInAggrStore + " got " + o);
                    }
                    Id currentId = (Id)AggregationImpl.this.monitorIDs.elementAt(this.currentLookup);
                    PastContentHandle[] handles = (PastContentHandle[])o;
                    GCPastContentHandle handle = null;
                    boolean skipToNext = true;
                    for (int i = 0; i < handles.length; ++i) {
                        if (handles[i] == null) continue;
                        handle = (GCPastContentHandle)handles[i];
                    }
                    if (!this.lookupInAggrStore) {
                        result.append(currentId.toStringFull() + " - OS ");
                        result.append(handle == null ? "--" : "" + (handle.getExpiration() - now));
                        AggregateDescriptor adc = AggregationImpl.this.aggregateList.getADC(currentId);
                        if (adc != null) {
                            result.append(" AD " + (adc.currentLifetime - now));
                            int objDescIndex = adc.lookupNewest(currentId);
                            if (objDescIndex >= 0) {
                                ObjectDescriptor odc = adc.objects[objDescIndex];
                                result.append(" OD " + (odc.currentLifetime - now));
                                this.lookupInAggrStore = true;
                                skipToNext = false;
                                AggregationImpl.this.aggregateStore.lookupHandles(adc.key, 1, this);
                            } else {
                                result.append(" OD ??\n");
                            }
                        } else {
                            result.append(" AD ??\n");
                        }
                    } else {
                        result.append(" AS " + (handle == null ? "--\n" : "" + (handle.getExpiration() - now) + "\n"));
                        this.lookupInAggrStore = false;
                    }
                    if (skipToNext) {
                        ++this.currentLookup;
                        if (this.currentLookup < AggregationImpl.this.monitorIDs.size()) {
                            if (AggregationImpl.this.logger.level <= 500) {
                                AggregationImpl.this.logger.log("Monitor: Continuing with element " + this.currentLookup);
                            }
                            AggregationImpl.this.objectStore.lookupHandles((Id)AggregationImpl.this.monitorIDs.elementAt(this.currentLookup), 1, this);
                        } else {
                            if (AggregationImpl.this.logger.level <= 500) {
                                AggregationImpl.this.logger.log("Monitor: Done");
                            }
                            ret[0] = "done";
                        }
                    }
                }

                public void receiveException(Exception e) {
                    if (AggregationImpl.this.logger.level <= 900) {
                        AggregationImpl.this.logger.logException("Montior: Failed, e=", e);
                    }
                    ret[0] = "done";
                }
            };
            this.objectStore.lookupHandles((Id)this.monitorIDs.elementAt(0), 1, c);
            while (ret[0] == null) {
                Thread.yield();
            }
            return result.toString();
        }
        if (cmd.startsWith("monitor add") && this.monitorEnabled) {
            String[] args = cmd.substring(12).split(" ");
            if (args.length == 6) {
                final int numFiles = Integer.parseInt(args[0]);
                final int avgBurstSize = Integer.parseInt(args[1]);
                final double sizeSkew = Double.parseDouble(args[2]);
                final int smallSize = Integer.parseInt(args[3]);
                final int largeSize = Integer.parseInt(args[4]);
                final long expiration = this.environment.getTimeSource().currentTimeMillis() + Long.parseLong(args[5]);
                Continuation c = new Continuation(){
                    int remainingTotal;
                    {
                        this.remainingTotal = numFiles;
                    }

                    public void receiveResult(Object o) {
                        if (this.remainingTotal > 0) {
                            final int burstSize = Math.min((int)((double)avgBurstSize * 0.3 + (double)AggregationImpl.this.environment.getRandomSource().nextInt((int)(1.4 * (double)avgBurstSize))), this.remainingTotal);
                            final 13 outerContinuation = this;
                            this.remainingTotal -= burstSize;
                            if (AggregationImpl.this.logger.level <= 500) {
                                AggregationImpl.this.logger.log("Inserting burst of size " + burstSize + ", remaining objects: " + this.remainingTotal);
                            }
                            Continuation c2 = new Continuation(){
                                long remainingHere;
                                {
                                    this.remainingHere = burstSize;
                                }

                                public void receiveResult(Object o) {
                                    if (this.remainingHere > 0L) {
                                        if (AggregationImpl.this.logger.level <= 500) {
                                            AggregationImpl.this.logger.log("Continuing burst insert, " + this.remainingHere + " remaining");
                                        }
                                        int thisAvgSize = 0.001 * (double)AggregationImpl.this.environment.getRandomSource().nextInt(1000) < sizeSkew ? smallSize : largeSize;
                                        int thisSize = (int)(0.3 * (double)thisAvgSize + (double)AggregationImpl.this.environment.getRandomSource().nextInt((int)(1.4 * (double)thisAvgSize)));
                                        Id randomID = AggregationImpl.this.factory.buildRandomId(AggregationImpl.this.environment.getRandomSource());
                                        --this.remainingHere;
                                        AggregationImpl.this.monitorIDs.add(randomID);
                                        AggregationImpl.this.insert(new DebugContent(randomID, false, 0L, new byte[thisSize]), expiration, this);
                                    } else {
                                        if (AggregationImpl.this.logger.level <= 500) {
                                            AggregationImpl.this.logger.log("Burst insertion complete, flushing...");
                                        }
                                        AggregationImpl.this.flush(outerContinuation);
                                    }
                                }

                                public void receiveException(Exception e) {
                                    if (AggregationImpl.this.logger.level <= 900) {
                                        AggregationImpl.this.logger.logException("Monitor.add component insertion failed: ", e);
                                    }
                                    this.receiveResult(e);
                                }
                            };
                            c2.receiveResult(new Boolean(true));
                        } else if (AggregationImpl.this.logger.level <= 800) {
                            AggregationImpl.this.logger.log("Monitor add completed, " + numFiles + " objects created successfully");
                        }
                    }

                    public void receiveException(Exception e) {
                        if (AggregationImpl.this.logger.level <= 900) {
                            AggregationImpl.this.logger.logException("Monitor.add aggregate insertion failed: ", e);
                        }
                        this.receiveResult(e);
                    }
                };
                c.receiveResult(new Boolean(true));
                return "In progress...";
            }
            return "Syntax: monitor add <#files> <avgBurstSize> <sizeSkew> <smallSize> <largeSize> <lifetime>";
        }
        if (cmd.startsWith("killall")) {
            String args = cmd.substring(8);
            String expirationArg = args.substring(args.lastIndexOf(32) + 1);
            String keyArg = args.substring(0, args.lastIndexOf(32));
            Id id = this.factory.buildIdFromToString(keyArg);
            long expiration = this.environment.getTimeSource().currentTimeMillis() + Long.parseLong(expirationArg);
            AggregateDescriptor aggr = this.aggregateList.getADC(id);
            if (aggr != null) {
                this.aggregateList.setAggregateLifetime(aggr, Math.min(aggr.currentLifetime, expiration));
                for (int i = 0; i < aggr.objects.length; ++i) {
                    this.aggregateList.setObjectCurrentLifetime(aggr, i, Math.min(aggr.objects[i].currentLifetime, expiration));
                    this.aggregateList.setObjectRefreshedLifetime(aggr, i, Math.min(aggr.objects[i].refreshedLifetime, expiration));
                }
                return "OK";
            }
            return "Aggregate " + id + " not found in aggregate list";
        }
        if (cmd.startsWith("waiting")) {
            Iterator iter = this.waitingList.scan().getIterator();
            String result = "";
            result = result + this.waitingList.scan().numElements() + " object(s) waiting\n";
            while (iter.hasNext()) {
                Id thisId = (Id)iter.next();
                result = result + thisId.toStringFull() + " " + this.waitingList.getMetadata(thisId) + "\n";
            }
            return result;
        }
        if (cmd.startsWith("vlookup")) {
            String[] vkeyS = cmd.substring(8).split("v");
            Id key = this.factory.buildIdFromToString(vkeyS[0]);
            long version = Long.parseLong(vkeyS[1]);
            final String[] ret = new String[]{null};
            this.lookup(key, version, new Continuation(){

                public void receiveResult(Object o) {
                    ret[0] = "result(" + o + ")";
                }

                public void receiveException(Exception e) {
                    ret[0] = "exception(" + e + ")";
                }
            });
            while (ret[0] == null) {
                Thread.yield();
            }
            return "vlookup(" + key + "v" + version + ")=" + ret[0];
        }
        return null;
    }

    private void removeDeadAggregates() {
        Vector<AggregateDescriptor> toRemove = new Vector<AggregateDescriptor>();
        Enumeration enumeration = this.aggregateList.elements();
        long now = this.environment.getTimeSource().currentTimeMillis();
        while (enumeration.hasMoreElements()) {
            AggregateDescriptor adc = (AggregateDescriptor)enumeration.nextElement();
            if (adc.currentLifetime >= now - this.aggregateGracePeriod) continue;
            if (!toRemove.contains(adc)) {
                toRemove.add(adc);
            }
            if (this.logger.level > 900) continue;
            this.logger.log("Scheduling dead aggregate for removal: " + adc.key.toStringFull() + "(expired " + adc.currentLifetime + ")");
        }
        if (toRemove.size() > 0) {
            if (this.logger.level <= 800) {
                this.logger.log("Removing " + toRemove.size() + " dead aggregates...");
            }
            Enumeration rem = toRemove.elements();
            while (rem.hasMoreElements()) {
                this.aggregateList.removeAggregateDescriptor((AggregateDescriptor)rem.nextElement());
            }
        }
    }

    private void storeAggregate(final Aggregate aggr, final long expiration, final ObjectDescriptor[] desc, final Id[] pointers, final Continuation command) {
        if (this.logger.level <= 500) {
            this.logger.log("storeAggregate() schedules content hash computation...");
        }
        this.endpoint.process(new Executable(){

            public Object execute() {
                if (AggregationImpl.this.logger.level <= 500) {
                    AggregationImpl.this.logger.log("storeAggregate() starts working on content hash...");
                }
                return AggregationImpl.this.factory.buildId(aggr.getContentHash());
            }
        }, new Continuation(){

            public void receiveResult(Object o) {
                if (o instanceof Id) {
                    aggr.setId((Id)o);
                    if (AggregationImpl.this.logger.level <= 800) {
                        AggregationImpl.this.logger.log("Storing aggregate, CH=" + aggr.getId() + ", expiration=" + expiration + " (rel " + (expiration - AggregationImpl.this.environment.getTimeSource().currentTimeMillis()) + ") with " + desc.length + " objects:");
                    }
                    for (int j = 0; j < desc.length; ++j) {
                        if (AggregationImpl.this.logger.level > 800) continue;
                        AggregationImpl.this.logger.log("#" + j + ": " + desc[j]);
                    }
                    Continuation c = new Continuation(){

                        public void receiveResult(Object o) {
                            AggregateDescriptor adc = new AggregateDescriptor(aggr.getId(), expiration, desc, pointers);
                            if (o instanceof Boolean[]) {
                                AggregationImpl.this.aggregateList.addAggregateDescriptor(adc);
                                AggregationImpl.this.aggregateList.setRoot(aggr.getId());
                                AggregationImpl.this.aggregateList.writeToDisk();
                                if (AggregationImpl.this.logger.level <= 500) {
                                    AggregationImpl.this.logger.log("Aggregate inserted successfully");
                                }
                                command.receiveResult(new Boolean(true));
                            } else {
                                if (AggregationImpl.this.logger.level <= 900) {
                                    AggregationImpl.this.logger.log("Unexpected result in aggregate insert (commit): " + o);
                                }
                                command.receiveException(new AggregationException("Unexpected result (commit): " + o));
                            }
                        }

                        public void receiveException(Exception e) {
                            command.receiveException(e);
                        }
                    };
                    if (AggregationImpl.this.aggregateStore instanceof GCPast) {
                        ((GCPast)AggregationImpl.this.aggregateStore).insert(aggr, expiration, c);
                    } else {
                        AggregationImpl.this.aggregateStore.insert(aggr, c);
                    }
                } else {
                    if (AggregationImpl.this.logger.level <= 900) {
                        AggregationImpl.this.logger.log("storeAggregate() cannot determine content hash, received " + o);
                    }
                    command.receiveException(new AggregationException("storeAggregate() cannot determine content hash"));
                }
            }

            public void receiveException(Exception e) {
                if (AggregationImpl.this.logger.level <= 900) {
                    AggregationImpl.this.logger.logException("storeAggregate() cannot determine content hash, exception ", e);
                }
                command.receiveException(e);
            }
        });
    }

    private void flushComplete(Object o) {
        if (this.flushWait != null) {
            Continuation c = this.flushWait;
            this.flushWait = null;
            if (o instanceof Exception) {
                c.receiveException((Exception)o);
            } else {
                c.receiveResult(o);
            }
        }
    }

    private void formAggregates(final Continuation command) {
        ObjectDescriptor[] desc;
        if (this.flushWait != null) {
            if (this.logger.level <= 800) {
                this.logger.log("Flush in progress... daisy-chaining continuation");
            }
            final Continuation parent = this.flushWait;
            this.flushWait = new Continuation(){

                public void receiveResult(Object o) {
                    if (AggregationImpl.this.logger.level <= 800) {
                        AggregationImpl.this.logger.log("Daisy-chain receiveResult(), restarting " + command);
                    }
                    parent.receiveResult(o);
                    AggregationImpl.this.formAggregates(command);
                }

                public void receiveException(Exception e) {
                    if (AggregationImpl.this.logger.level <= 800) {
                        AggregationImpl.this.logger.log("Daisy-chain receiveException(), restarting " + command);
                    }
                    parent.receiveException(e);
                    AggregationImpl.this.formAggregates(command);
                }
            };
            return;
        }
        this.flushWait = command;
        IdSet waitingKeys = this.waitingList.scan();
        if (waitingKeys.numElements() == 0) {
            if (this.logger.level <= 800) {
                this.logger.log("NO BINS TO PACK");
            }
            this.flushComplete(new Boolean(true));
            return;
        }
        if (this.logger.level <= 800) {
            this.logger.log("BIN PACKING STARTED");
        }
        Vector<ObjectDescriptor> currentAggregate = new Vector<ObjectDescriptor>();
        Vector<ObjectDescriptor[]> aggregates = new Vector<ObjectDescriptor[]>();
        Vector<Id> deletionVector = new Vector<Id>();
        Iterator iter = waitingKeys.getIterator();
        long currentAggregateSize = 0L;
        int currentObjectsInAggregate = 0;
        while (true) {
            int numObjectsInAggregate;
            ObjectDescriptor thisObject = null;
            boolean mustAddObject = false;
            if (aggregates.size() >= this.maxAggregatesPerRun) break;
            while (iter.hasNext()) {
                Id thisId = (Id)iter.next();
                thisObject = (ObjectDescriptor)this.waitingList.getMetadata(thisId);
                if (thisObject != null) {
                    thisObject = new ObjectDescriptor(thisObject.key, thisObject.version, thisObject.currentLifetime, thisObject.refreshedLifetime, thisObject.size);
                    if ((currentAggregateSize + (long)thisObject.size <= (long)this.maxAggregateSize || currentAggregate.isEmpty()) && currentObjectsInAggregate < this.maxObjectsInAggregate) {
                        currentAggregateSize += (long)thisObject.size;
                        ++currentObjectsInAggregate;
                        currentAggregate.add(thisObject);
                        continue;
                    }
                    mustAddObject = true;
                    break;
                }
                if (this.logger.level <= 900) {
                    this.logger.log("Metadata in waiting object " + thisId.toStringFull() + " appears to be damaged. Scheduling for deletion...");
                }
                deletionVector.add(thisId);
            }
            if ((numObjectsInAggregate = currentAggregate.size()) < 1) {
                if (this.logger.level <= 900) {
                    this.logger.log("Waiting list seems to consist entirely of damaged objects -- please remove!");
                }
                this.flushComplete(new Boolean(true));
                return;
            }
            desc = new ObjectDescriptor[numObjectsInAggregate];
            for (int i = 0; i < numObjectsInAggregate; ++i) {
                desc[i] = (ObjectDescriptor)currentAggregate.elementAt(i);
                if (this.logger.level > 500) continue;
                this.logger.log("#" + i + ": " + desc[i].key + " " + desc[i].size + " bytes");
            }
            aggregates.add(desc);
            currentAggregate.clear();
            currentObjectsInAggregate = 0;
            currentAggregateSize = 0L;
            if (mustAddObject) {
                currentAggregate.add(thisObject);
                currentAggregateSize += (long)thisObject.size;
                continue;
            }
            if (!iter.hasNext()) break;
        }
        Enumeration delenda = deletionVector.elements();
        while (delenda.hasMoreElements()) {
            final Id thisId = (Id)delenda.nextElement();
            if (this.logger.level <= 800) {
                this.logger.log("Deleting object " + thisId.toStringFull() + " from waiting list (broken metadata)");
            }
            this.waitingList.unstore(thisId, new Continuation(){

                public void receiveResult(Object o) {
                    if (AggregationImpl.this.logger.level <= 500) {
                        AggregationImpl.this.logger.log("Successfully deleted: " + thisId);
                    }
                }

                public void receiveException(Exception e) {
                    if (AggregationImpl.this.logger.level <= 900) {
                        AggregationImpl.this.logger.logException("Cannot delete: " + thisId + ", e=", e);
                    }
                }
            });
        }
        Continuation.MultiContinuation c = new Continuation.MultiContinuation(new Continuation(){

            public void receiveResult(Object o) {
                AggregationImpl.this.flushComplete(new Boolean(true));
            }

            public void receiveException(Exception e) {
                AggregationImpl.this.flushComplete(e);
            }
        }, aggregates.size());
        for (int i = 0; i < aggregates.size(); ++i) {
            desc = (ObjectDescriptor[])aggregates.elementAt(i);
            final GCPastContent[] obj = new GCPastContent[desc.length];
            final long aggrExpirationF = this.chooseAggregateLifetime(desc, this.environment.getTimeSource().currentTimeMillis(), 0L);
            final Continuation thisContinuation = c.getSubContinuation(i);
            final int iF = i;
            if (this.logger.level <= 500) {
                this.logger.log("Retrieving #" + i + ".0: " + desc[0].key);
            }
            this.waitingList.getObject(new VersionKey(desc[0].key, desc[0].version), new Continuation(){
                int currentQuery = 0;

                public void receiveResult(Object o) {
                    if (o != null && o instanceof GCPastContent) {
                        obj[this.currentQuery++] = (GCPastContent)o;
                        if (this.currentQuery < desc.length) {
                            if (AggregationImpl.this.logger.level <= 500) {
                                AggregationImpl.this.logger.log("Retrieving #" + iF + "." + this.currentQuery + ": " + desc[this.currentQuery].key);
                            }
                            AggregationImpl.this.waitingList.getObject(new VersionKey(desc[this.currentQuery].key, desc[this.currentQuery].version), this);
                        } else {
                            Id[] pointers = AggregationImpl.this.aggregateList.getSomePointers(AggregationImpl.this.nominalReferenceCount, AggregationImpl.this.maxPointersPerAggregate, null);
                            AggregationImpl.this.storeAggregate(AggregationImpl.this.aggregateFactory.buildAggregate(obj, pointers), aggrExpirationF, desc, pointers, new Continuation(){

                                public void receiveResult(Object o) {
                                    Continuation.MultiContinuation c2 = new Continuation.MultiContinuation(thisContinuation, desc.length);
                                    for (int i = 0; i < desc.length; ++i) {
                                        final Continuation c2s = c2.getSubContinuation(i);
                                        AggregationImpl.this.waitingList.unstore(new VersionKey(desc[i].key, desc[i].version), new Continuation(){

                                            public void receiveResult(Object o) {
                                                c2s.receiveResult(o);
                                            }

                                            public void receiveException(Exception e) {
                                                if (AggregationImpl.this.logger.level <= 900) {
                                                    AggregationImpl.this.logger.logException("Exception while unstoring aggregate component: ", e);
                                                }
                                                c2s.receiveException(e);
                                            }
                                        });
                                    }
                                }

                                public void receiveException(Exception e) {
                                    if (AggregationImpl.this.logger.level <= 900) {
                                        AggregationImpl.this.logger.logException("Exception while storing new aggregate: ", e);
                                    }
                                    thisContinuation.receiveException(e);
                                }
                            });
                        }
                    } else {
                        if (AggregationImpl.this.logger.level <= 900) {
                            AggregationImpl.this.logger.log("Aggregation cannot retrieve " + desc[this.currentQuery].key + " (found o=" + o + ")");
                        }
                        thisContinuation.receiveException(new AggregationException("Cannot retrieve object from waiting list: " + desc[this.currentQuery].key));
                    }
                }

                public void receiveException(Exception e) {
                    if (AggregationImpl.this.logger.level <= 900) {
                        AggregationImpl.this.logger.log("Exception while building aggregate: " + e);
                    }
                    thisContinuation.receiveException(e);
                }
            });
        }
    }

    private long chooseAggregateLifetime(ObjectDescriptor[] components, long now, long currentLifetime) {
        long maxLifetime = 0L;
        for (int i = 0; i < components.length; ++i) {
            if (components[i].refreshedLifetime <= maxLifetime) continue;
            maxLifetime = components[i].refreshedLifetime;
        }
        return maxLifetime;
    }

    private void refreshAggregates() {
        Enumeration enumeration = this.aggregateList.elements();
        long now = this.environment.getTimeSource().currentTimeMillis();
        Vector<AggregateDescriptor> removeList = new Vector<AggregateDescriptor>();
        final Vector<AggregateDescriptor> refreshAggregateList = new Vector<AggregateDescriptor>();
        final Vector<Long> refreshLifetimeList = new Vector<Long>();
        if (this.logger.level <= 800) {
            this.logger.log("Checking aggregate lifetimes");
        }
        this.aggregateList.resetMarkers();
        while (enumeration.hasMoreElements()) {
            long newLifetime;
            AggregateDescriptor aggr = (AggregateDescriptor)enumeration.nextElement();
            if (aggr.marker) continue;
            aggr.marker = true;
            boolean isBeingRefreshed = false;
            if (aggr.currentLifetime < now + this.expirationRenewThreshold && (newLifetime = this.chooseAggregateLifetime(aggr.objects, now, aggr.currentLifetime)) > aggr.currentLifetime) {
                if (this.logger.level <= 800) {
                    this.logger.log("Refreshing aggregate " + aggr.key.toStringFull() + ", new expiration is " + newLifetime);
                }
                isBeingRefreshed = true;
                refreshAggregateList.add(aggr);
                refreshLifetimeList.add(new Long(newLifetime));
            }
            if (aggr.currentLifetime >= now || isBeingRefreshed) continue;
            if (this.logger.level <= 500) {
                this.logger.log("Adding expired aggregate " + aggr.key + " to remove list");
            }
            removeList.add(aggr);
        }
        boolean deletedOne = false;
        while (!removeList.isEmpty()) {
            AggregateDescriptor aggr = (AggregateDescriptor)removeList.elementAt(0);
            if (this.logger.level <= 800) {
                this.logger.log("Removing expired aggregate " + aggr.key.toStringFull() + " from list");
            }
            removeList.removeElementAt(0);
            deletedOne = true;
            this.aggregateList.removeAggregateDescriptor(aggr);
        }
        if (deletedOne) {
            this.aggregateList.writeToDisk();
        }
        if (!refreshAggregateList.isEmpty()) {
            if (this.logger.level <= 800) {
                this.logger.log("Refreshing " + refreshAggregateList.size() + " aggregate(s)");
            }
            if (this.aggregateStore instanceof GCPast) {
                Id[] ids = new Id[refreshAggregateList.size()];
                long[] lifetimes = new long[refreshAggregateList.size()];
                for (int i = 0; i < refreshAggregateList.size(); ++i) {
                    ids[i] = ((AggregateDescriptor)refreshAggregateList.elementAt((int)i)).key;
                    lifetimes[i] = (Long)refreshLifetimeList.elementAt(i);
                }
                ((GCPast)this.aggregateStore).refresh(ids, lifetimes, new Continuation(){

                    public void receiveResult(Object o) {
                        Object[] results = (Object[])o;
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("Received refresh results for " + results.length + " aggregates");
                        }
                        int numOk = 0;
                        for (int i = 0; i < results.length; ++i) {
                            AggregateDescriptor aggr;
                            if (results[i] instanceof Boolean) {
                                aggr = (AggregateDescriptor)refreshAggregateList.elementAt(i);
                                long newLifetime = (Long)refreshLifetimeList.elementAt(i);
                                if (AggregationImpl.this.logger.level <= 500) {
                                    AggregationImpl.this.logger.log("Aggregate #" + i + " (" + aggr.key.toStringFull() + "): OK, new lifetime is " + newLifetime);
                                }
                                AggregationImpl.this.aggregateList.refreshAggregate(aggr, newLifetime);
                                ++numOk;
                                continue;
                            }
                            aggr = (AggregateDescriptor)refreshAggregateList.elementAt(i);
                            Exception e = (Exception)results[i];
                            if (AggregationImpl.this.logger.level > 900) continue;
                            AggregationImpl.this.logger.logException("Aggregate #" + i + " (" + aggr.key.toStringFull() + "): Refresh failed, e=", e);
                        }
                        AggregationImpl.this.aggregateList.writeToDisk();
                        if (AggregationImpl.this.logger.level <= 800) {
                            AggregationImpl.this.logger.log("Refresh complete, " + numOk + "/" + results.length + " aggregates refreshed OK");
                        }
                    }

                    public void receiveException(Exception e) {
                        if (AggregationImpl.this.logger.level <= 900) {
                            AggregationImpl.this.logger.logException("Interface contract broken; exception " + e + " returned directly", e);
                        }
                    }
                });
            } else {
                if (this.logger.level <= 500) {
                    this.logger.log("Aggregate store does not support GC; refreshing directly");
                }
                for (int i = 0; i < refreshAggregateList.size(); ++i) {
                    AggregateDescriptor aggr = (AggregateDescriptor)refreshAggregateList.elementAt(i);
                    long newLifetime = (Long)refreshLifetimeList.elementAt(i);
                    this.aggregateList.refreshAggregate(aggr, newLifetime);
                }
            }
        }
    }

    private void consolidateAggregates() {
        AggregateDescriptor[] adc;
        final long now = this.environment.getTimeSource().currentTimeMillis();
        Enumeration enumeration = this.aggregateList.elements();
        Vector<AggregateDescriptor> candidateList = new Vector<AggregateDescriptor>();
        if (this.logger.level <= 800) {
            this.logger.log("Looking for aggregates to consolidate");
        }
        this.aggregateList.resetMarkers();
        while (enumeration.hasMoreElements()) {
            AggregateDescriptor aggr = (AggregateDescriptor)enumeration.nextElement();
            if (aggr.marker) continue;
            aggr.marker = true;
            if (aggr.currentLifetime <= now + this.expirationRenewThreshold || aggr.currentLifetime >= now + this.consolidationThreshold || aggr.objectsAliveAt(now) <= 0) continue;
            float fractionAlive = (float)aggr.objectsAliveAt(now) / (float)aggr.objects.length;
            if (aggr.objects.length >= this.consolidationMinObjectsInAggregate && !((double)fractionAlive < this.consolidationMinComponentsAlive)) continue;
            if (this.logger.level <= 500) {
                this.logger.log("Can consolidate: " + aggr.key.toStringFull() + ", " + aggr.objectsAliveAt(now) + "/" + aggr.objects.length + " alive");
            }
            candidateList.add(aggr);
        }
        if (candidateList.isEmpty()) {
            if (this.logger.level <= 800) {
                this.logger.log("No candidates for consolidation");
            }
            return;
        }
        if (this.logger.level <= 500) {
            this.logger.log(candidateList.size() + " candidate(s) for consolidation");
        }
        final Vector<AggregateDescriptor[]> componentList = new Vector<AggregateDescriptor[]>();
        int objectsSoFar = 0;
        int bytesSoFar = 0;
        while (!candidateList.isEmpty()) {
            adc = (AggregateDescriptor[])candidateList.remove(this.environment.getRandomSource().nextInt(candidateList.size()));
            componentList.add(adc);
            if (this.logger.level <= 500) {
                this.logger.log("Picked candidate " + adc.key.toStringFull() + " (" + adc.objectsAliveAt(now) + "/" + adc.objects.length + " objects, " + adc.bytesAliveAt(now) + " bytes alive)");
            }
            objectsSoFar += adc.objectsAliveAt(now);
            bytesSoFar += adc.bytesAliveAt(now);
            int p = 0;
            while (p < candidateList.size()) {
                AggregateDescriptor adx = (AggregateDescriptor)candidateList.elementAt(p);
                if (adx.objectsAliveAt(now) + objectsSoFar > this.maxObjectsInAggregate || adx.bytesAliveAt(now) + bytesSoFar > this.maxAggregateSize) {
                    candidateList.removeElementAt(p);
                    continue;
                }
                ++p;
            }
        }
        if (componentList.isEmpty() || objectsSoFar < this.consolidationMinObjectsInAggregate) {
            if (this.logger.level <= 800) {
                this.logger.log("Not enough objects (" + objectsSoFar + " found, " + this.consolidationMinObjectsInAggregate + " required), postponing...");
            }
            return;
        }
        if (this.logger.level <= 500) {
            this.logger.log("Consolidation: Decided to consolidate " + objectsSoFar + " objects from " + componentList.size() + " aggregates (" + bytesSoFar + " bytes)");
        }
        adc = componentList.toArray(new AggregateDescriptor[0]);
        final Aggregate[] aggr = new Aggregate[adc.length];
        final int objectsTotal = objectsSoFar;
        Id firstKey = adc[0].key;
        if (this.logger.level <= 500) {
            this.logger.log("Consolidation: Fetching aggregate #0: " + firstKey.toStringFull());
        }
        this.aggregateStore.lookup(firstKey, new Continuation(){
            int currentLookup = 0;

            public void receiveResult(Object o) {
                if (o instanceof Aggregate) {
                    aggr[this.currentLookup] = (Aggregate)o;
                    ++this.currentLookup;
                    if (this.currentLookup >= componentList.size()) {
                        RawGCPastContent[] components = new RawGCPastContent[objectsTotal];
                        ObjectDescriptor[] desc = new ObjectDescriptor[objectsTotal];
                        int componentIndex = 0;
                        if (AggregationImpl.this.logger.level <= 800) {
                            AggregationImpl.this.logger.log("Consolidation: All aggregates fetched OK, forming new aggregate...");
                        }
                        for (int i = 0; i < adc.length; ++i) {
                            for (int j = 0; j < adc[i].objects.length; ++j) {
                                if (adc[i].objects[j].isAliveAt(now)) {
                                    GCPastContent temp = aggr[i].getComponent(j);
                                    components[componentIndex] = (RawGCPastContent)temp;
                                    desc[componentIndex] = adc[i].objects[j];
                                    if (AggregationImpl.this.logger.level <= 500) {
                                        AggregationImpl.this.logger.log("  #" + componentIndex + ": " + adc[i].objects[j].key.toStringFull());
                                    }
                                    ++componentIndex;
                                    continue;
                                }
                                if (AggregationImpl.this.logger.level > 500) continue;
                                AggregationImpl.this.logger.log("Skipped (dead): " + adc[i].objects[j].key.toStringFull());
                            }
                        }
                        Id[] obsoleteAggregates = new Id[adc.length];
                        for (int i = 0; i < adc.length; ++i) {
                            obsoleteAggregates[i] = adc[i].key;
                        }
                        Id[] pointers = AggregationImpl.this.aggregateList.getSomePointers(AggregationImpl.this.nominalReferenceCount, AggregationImpl.this.maxPointersPerAggregate, obsoleteAggregates);
                        long aggrExpirationF = AggregationImpl.this.chooseAggregateLifetime(desc, AggregationImpl.this.environment.getTimeSource().currentTimeMillis(), 0L);
                        AggregationImpl.this.storeAggregate(AggregationImpl.this.aggregateFactory.buildAggregate(components, pointers), aggrExpirationF, desc, pointers, new Continuation(){

                            public void receiveResult(Object o) {
                                if (AggregationImpl.this.logger.level <= 800) {
                                    AggregationImpl.this.logger.log("Consolidated Aggregate stored OK, removing old descriptors...");
                                }
                                for (int i = 0; i < adc.length; ++i) {
                                    if (AggregationImpl.this.logger.level <= 500) {
                                        AggregationImpl.this.logger.log("Removing " + adc[i].key.toStringFull() + " ...");
                                    }
                                    AggregationImpl.this.aggregateList.removeAggregateDescriptor(adc[i]);
                                }
                                AggregationImpl.this.aggregateList.writeToDisk();
                                if (AggregationImpl.this.logger.level <= 800) {
                                    AggregationImpl.this.logger.log("Consolidation completed, " + objectsTotal + " objects from " + aggr.length + " aggregates consolidated");
                                }
                            }

                            public void receiveException(Exception e) {
                                if (AggregationImpl.this.logger.level <= 900) {
                                    AggregationImpl.this.logger.logException("Exception during consolidation store: e=" + e + " -- aborting", e);
                                }
                            }
                        });
                    } else {
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("Consolidation: Fetching aggregate #" + this.currentLookup + ": " + adc[this.currentLookup].key.toStringFull());
                        }
                        AggregationImpl.this.aggregateStore.lookup(adc[this.currentLookup].key, this);
                    }
                }
            }

            public void receiveException(Exception e) {
                if (AggregationImpl.this.logger.level <= 900) {
                    AggregationImpl.this.logger.logException("Exception during consolidation lookup " + adc[this.currentLookup].key.toStringFull() + ": " + e + " -- aborting", e);
                }
            }
        });
    }

    private void reconnectTree() {
        Id[] disconnected;
        if (this.rebuildInProgress) {
            if (this.logger.level <= 800) {
                this.logger.log("Skipping connectivity check (rebuild in progress)");
            }
            return;
        }
        if (this.logger.level <= 800) {
            this.logger.log("Checking for disconnections");
        }
        if ((disconnected = this.aggregateList.getSomePointers(1, this.maxPointersPerAggregate, null)).length < 2) {
            Id newRoot = disconnected.length == 1 ? disconnected[0] : null;
            Id currentRoot = this.aggregateList.getRoot();
            if (newRoot == null && currentRoot != null || newRoot != null && currentRoot == null || newRoot != null && currentRoot != null && !newRoot.equals(currentRoot)) {
                this.aggregateList.setRoot(newRoot);
            }
            if (this.logger.level <= 800) {
                this.logger.log("No aggregates disconnected (n=" + disconnected.length + ")");
            }
            if (this.logger.level <= 500) {
                this.logger.log("root=" + (this.aggregateList.getRoot() == null ? "null" : this.aggregateList.getRoot().toStringFull()));
            }
            return;
        }
        if (this.logger.level <= 800) {
            this.logger.log("Found " + disconnected.length + " disconnected aggregates; inserting pointer array");
        }
        this.storeAggregate(this.aggregateFactory.buildAggregate(new GCPastContent[0], disconnected), this.environment.getTimeSource().currentTimeMillis() + this.pointerArrayLifetime, new ObjectDescriptor[0], disconnected, new Continuation(){

            public void receiveResult(Object o) {
                if (AggregationImpl.this.logger.level <= 500) {
                    AggregationImpl.this.logger.log("Successfully inserted pointer array");
                }
            }

            public void receiveException(Exception e) {
                if (AggregationImpl.this.logger.level <= 900) {
                    AggregationImpl.this.logger.logException("Error while inserting pointer array: ", e);
                }
            }
        });
    }

    private void timerExpired(char timerID) {
        if (this.logger.level <= 500) {
            this.logger.log("TIMER EXPIRED: #" + timerID);
        }
        switch (timerID) {
            case '\u0001': {
                if (this.logger.level <= 800) {
                    this.logger.log("Scheduled flush, waiting list: " + this.waitingList.getSize());
                }
                this.formAggregates(new Continuation(){

                    public void receiveResult(Object o) {
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("Scheduled flush: Success (o=" + o + ")");
                        }
                    }

                    public void receiveException(Exception e) {
                        if (AggregationImpl.this.logger.level <= 900) {
                            AggregationImpl.this.logger.logException("Scheduled flush: Failure (e=" + e + ")", e);
                        }
                    }
                });
                if (this.logger.level <= 800) {
                    this.logger.log("Waiting list: " + this.waitingList.getSize() + " Scan: " + this.getNumObjectsWaiting() + " Max: " + this.maxObjectsInAggregate * this.maxAggregatesPerRun);
                }
                if (this.getNumObjectsWaiting() >= this.maxObjectsInAggregate * this.maxAggregatesPerRun) {
                    if (this.logger.level <= 800) {
                        this.logger.log("Retrying later");
                    }
                    this.addTimer(this.jitterTerm(this.flushStressInterval), '\u0001');
                    break;
                }
                if (this.logger.level <= 800) {
                    this.logger.log("OK, waiting for next deadline");
                }
                this.addTimer(this.jitterTerm(this.flushInterval), '\u0001');
                break;
            }
            case '\u0005': {
                this.refreshAggregates();
                this.reconnectTree();
                this.addTimer(this.jitterTerm(this.aggrRefreshInterval), '\u0005');
                break;
            }
            case '\u0003': {
                this.consolidateAggregates();
                this.addTimer(this.jitterTerm(this.consolidationInterval), '\u0003');
                break;
            }
            case '\u0002': {
                Id[] ids = this.monitorIDs.toArray(new Id[0]);
                if (this.logger.level <= 800) {
                    this.logger.log("Monitor: Refreshing " + ids.length + " objects");
                }
                this.refresh(ids, this.environment.getTimeSource().currentTimeMillis() + 3L * this.monitorRefreshInterval, new Continuation(){

                    public void receiveResult(Object o) {
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("Monitor: Refresh completed, result=" + o);
                        }
                    }

                    public void receiveException(Exception e) {
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.logException("Monitor: Refresh failed, exception=", e);
                        }
                    }
                });
                this.addTimer(this.monitorRefreshInterval, '\u0002');
                break;
            }
            case '\u0004': {
                this.stats = this.aggregateList.getStatistics(this.statsGranularity, this.statsRange, this.nominalReferenceCount);
                this.stats.dump(this.environment.getLogManager().getLogger(AggregationStatistics.class, this.instance));
                this.addTimer(this.statsInterval, '\u0004');
                break;
            }
            default: {
                this.panic("Unknown timer expired: " + timerID);
            }
        }
    }

    private void refreshInObjectStore(Id[] ids, long[] expirations, Continuation command) {
        if (this.objectStore instanceof GCPast) {
            ((GCPast)this.objectStore).refresh(ids, expirations, command);
        } else {
            command.receiveResult(new Boolean(true));
        }
    }

    public void refresh(Id[] ids, long expiration, Continuation command) {
        long[] expirations = new long[ids.length];
        Arrays.fill(expirations, expiration);
        this.refresh(ids, expirations, command);
    }

    public void refresh(final Id[] ids, final long[] expirations, final Continuation command) {
        if (ids.length < 1) {
            command.receiveResult(new Boolean[0]);
            return;
        }
        if (this.logger.level <= 800) {
            this.logger.log("Refreshing " + ids.length + " keys");
        }
        this.refreshInObjectStore(ids, expirations, new Continuation(){
            Object[] result;

            public void receiveResult(Object o) {
                if (o instanceof Object[]) {
                    this.result = (Object[])o;
                } else {
                    if (AggregationImpl.this.logger.level <= 900) {
                        AggregationImpl.this.logger.log("refresh: ObjectStore result is of incorrect type; expected Object[], got " + o);
                    }
                    this.result = new Object[ids.length];
                    for (int i = 0; i < ids.length; ++i) {
                        this.result[i] = o;
                    }
                }
                this.refreshInAggregates();
            }

            public void receiveException(Exception e) {
                this.result = new Object[ids.length];
                for (int i = 0; i < ids.length; ++i) {
                    this.result[i] = e;
                }
                if (AggregationImpl.this.logger.level <= 900) {
                    AggregationImpl.this.logger.logException("", e);
                }
                this.refreshInAggregates();
            }

            private void refreshInAggregates() {
                Continuation c = new Continuation(){

                    public void receiveResult(Object o) {
                        AggregationImpl.this.aggregateList.writeToDisk();
                        command.receiveResult(o);
                    }

                    public void receiveException(Exception e) {
                        if (AggregationImpl.this.logger.level <= 900) {
                            AggregationImpl.this.logger.logException("", e);
                        }
                        command.receiveException(e);
                    }
                };
                AggregationImpl.this.refreshInternal(ids, expirations, this.result, c);
            }
        });
    }

    public void refresh(Id[] ids, long[] versions, long[] expirations, final Continuation command) {
        final Object[] result = new Object[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            AggregateDescriptor adc;
            if (this.logger.level <= 800) {
                this.logger.log("Refresh(" + ids[i] + "v" + versions[i] + ", expiration=" + expirations[i] + ")");
            }
            if ((adc = this.aggregateList.getADC(new VersionKey(ids[i], versions[i]))) != null) {
                int objDescIndex = adc.lookupSpecific(ids[i], versions[i]);
                if (objDescIndex < 0) {
                    result[i] = new AggregationException("Inconsistency detected in aggregate list -- try restarting the application");
                    continue;
                }
                if (adc.objects[objDescIndex].refreshedLifetime < expirations[i]) {
                    this.aggregateList.setObjectRefreshedLifetime(adc, objDescIndex, expirations[i]);
                }
                result[i] = new Boolean(true);
                continue;
            }
            result[i] = new AggregationException("Not found");
        }
        if (this.objectStore instanceof VersioningPast) {
            ((VersioningPast)((Object)this.objectStore)).refresh(ids, versions, expirations, new Continuation(){

                public void receiveResult(Object o) {
                    if (o instanceof Object[]) {
                        Object[] subresult = (Object[])o;
                        for (int i = 0; i < result.length; ++i) {
                            if (!(result[i] instanceof Boolean) || subresult[i] instanceof Boolean) continue;
                            result[i] = subresult[i];
                        }
                    } else {
                        AggregationException e = new AggregationException("Object store returns unexpected result: " + o);
                        for (int i = 0; i < result.length; ++i) {
                            result[i] = e;
                        }
                    }
                    command.receiveResult(result);
                }

                public void receiveException(Exception e) {
                    command.receiveException(e);
                }
            });
        } else {
            command.receiveResult(result);
        }
    }

    private void refreshInternal(final Id[] ids, final long[] expirations, final Object[] result, final Continuation command) {
        if (this.logger.level <= 800) {
            this.logger.log("refreshInternal: Accepted " + ids.length + " keys, starting with first key...");
        }
        Continuation theContinuation = new Continuation(){
            int objectsMissing = 0;
            int objectsFetched = 0;
            int currentIndex = -1;

            public void receiveResult(Object o) {
                Object lastResult = o;
                while (true) {
                    AggregateDescriptor adc;
                    if (this.currentIndex >= 0) {
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("receiveResult(" + lastResult + ") for index " + this.currentIndex + ", length=" + ids.length);
                        }
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("Internal refresh of " + ids[this.currentIndex].toStringFull() + " returned " + lastResult);
                        }
                        result[this.currentIndex] = lastResult;
                    }
                    ++this.currentIndex;
                    if (this.currentIndex >= ids.length) {
                        int i;
                        if (this.objectsMissing > 0 && AggregationImpl.this.logger.level <= 900) {
                            AggregationImpl.this.logger.log("refresh: " + this.objectsMissing + "/" + ids.length + " objects not in aggregate list, fetched " + this.objectsFetched + " (max " + AggregationImpl.this.maxReaggregationPerRefresh + ")");
                        }
                        int nOK = 0;
                        for (i = 0; i < ids.length; ++i) {
                            if (!(result[i] instanceof Boolean)) continue;
                            ++nOK;
                        }
                        if (AggregationImpl.this.logger.level <= 800) {
                            AggregationImpl.this.logger.log("refreshInternal: Processed " + ids.length + " keys, completed " + nOK);
                        }
                        for (i = 0; i < ids.length; ++i) {
                            if (AggregationImpl.this.logger.level > 400) continue;
                            AggregationImpl.this.logger.log(" - " + ids[i].toStringFull() + ": " + result[i]);
                        }
                        command.receiveResult(result);
                        return;
                    }
                    final Id id = ids[this.currentIndex];
                    final long expiration = expirations[this.currentIndex];
                    if (AggregationImpl.this.logger.level <= 800) {
                        AggregationImpl.this.logger.log("Refresh(" + id.toStringFull() + ", expiration=" + expiration + ") started");
                    }
                    if ((adc = AggregationImpl.this.aggregateList.getADC(id)) != null) {
                        int objDescIndex = adc.lookupNewest(id);
                        if (objDescIndex < 0) {
                            if (AggregationImpl.this.logger.level <= 900) {
                                AggregationImpl.this.logger.log("NL: Aggregate found, but object not found in aggregate?!? -- aborted");
                            }
                            command.receiveException(new AggregationException("Inconsistency detected in aggregate list -- try restarting the application"));
                            return;
                        }
                        if (adc.objects[objDescIndex].refreshedLifetime < expiration) {
                            if (AggregationImpl.this.logger.level <= 500) {
                                AggregationImpl.this.logger.log("Changing expiration date from " + adc.objects[objDescIndex].refreshedLifetime + " to " + expiration);
                            }
                            AggregationImpl.this.aggregateList.setObjectRefreshedLifetime(adc, objDescIndex, expiration);
                        } else if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("Expiration is " + adc.objects[objDescIndex].refreshedLifetime + " already, no update needed");
                        }
                        lastResult = new Boolean(true);
                        continue;
                    }
                    IdSet waitingIds = AggregationImpl.this.waitingList.scan();
                    Iterator iter = waitingIds.getIterator();
                    while (iter.hasNext()) {
                        final VersionKey vkey = (VersionKey)iter.next();
                        if (!vkey.getId().equals(id)) continue;
                        ObjectDescriptor thisObject = (ObjectDescriptor)AggregationImpl.this.waitingList.getMetadata(vkey);
                        if (AggregationImpl.this.logger.level <= 800) {
                            AggregationImpl.this.logger.log("Refreshing in waiting list: " + vkey.toStringFull());
                        }
                        if (thisObject == null) {
                            if (AggregationImpl.this.logger.level <= 900) {
                                AggregationImpl.this.logger.log("Broken object in waiting list: " + vkey.toStringFull() + ", removing...");
                            }
                            final 28 myParent = this;
                            AggregationImpl.this.waitingList.unstore(vkey, new Continuation(){

                                public void receiveResult(Object o) {
                                    if (AggregationImpl.this.logger.level <= 800) {
                                        AggregationImpl.this.logger.log("Broken object " + vkey.toStringFull() + " removed successfully");
                                    }
                                    myParent.receiveResult(new AggregationException("Object in waiting list, but broken: " + vkey.toStringFull()));
                                }

                                public void receiveException(Exception e) {
                                    if (AggregationImpl.this.logger.level <= 900) {
                                        AggregationImpl.this.logger.logException("Cannot remove broken object " + vkey.toStringFull() + " from waiting list (exception: " + e + ")", e);
                                    }
                                    myParent.receiveResult(new AggregationException("Object broken, in waiting list, and cannot remove: " + vkey.toStringFull() + " (e=" + e + ")"));
                                }
                            });
                            return;
                        }
                        if (thisObject.refreshedLifetime < expiration) {
                            ObjectDescriptor newDescriptor = new ObjectDescriptor(thisObject.key, thisObject.version, thisObject.currentLifetime, expiration, thisObject.size);
                            final 28 myParent = this;
                            AggregationImpl.this.waitingList.setMetadata(vkey, newDescriptor, new Continuation(){

                                public void receiveResult(Object o) {
                                    if (AggregationImpl.this.logger.level <= 500) {
                                        AggregationImpl.this.logger.log("Refreshed metadata written ok for " + vkey.toStringFull());
                                    }
                                    myParent.receiveResult(new Boolean(true));
                                }

                                public void receiveException(Exception e) {
                                    if (AggregationImpl.this.logger.level <= 900) {
                                        AggregationImpl.this.logger.logException("Cannot refresh waiting object " + vkey.toStringFull() + ", e=", e);
                                    }
                                    myParent.receiveResult(new AggregationException("Cannot refresh waiting object " + vkey.toStringFull() + ", setMetadata() failed (e=" + e + ")"));
                                }
                            });
                            return;
                        }
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("Object found in waiting list and no update needed: " + vkey.toStringFull());
                        }
                        this.receiveResult(new Boolean(true));
                        return;
                    }
                    ++this.objectsMissing;
                    if (AggregationImpl.this.addMissingAfterRefresh) {
                        if (this.objectsFetched < AggregationImpl.this.maxReaggregationPerRefresh) {
                            ++this.objectsFetched;
                            final 28 myParent = this;
                            AggregationImpl.this.objectStore.lookup(id, false, new Continuation(){

                                public void receiveResult(Object o) {
                                    if (o instanceof PastContent) {
                                        final PastContent obj = (PastContent)o;
                                        if (AggregationImpl.this.logger.level <= 900) {
                                            AggregationImpl.this.logger.log("Refresh: Found in PAST, but not in aggregate list: " + id.toStringFull());
                                        }
                                        long theVersion = o instanceof GCPastContent ? ((GCPastContent)obj).getVersion() : 0L;
                                        VersionKey vkey = new VersionKey(obj.getId(), theVersion);
                                        long theVersionF = theVersion;
                                        int theSize = AggregationImpl.this.getSize(obj);
                                        if (AggregationImpl.this.policy.shouldBeAggregated(obj, theSize)) {
                                            if (!AggregationImpl.this.waitingList.exists(vkey)) {
                                                if (AggregationImpl.this.logger.level <= 500) {
                                                    AggregationImpl.this.logger.log("ADDING MISSING OBJECT AFTER REFRESH: " + obj.getId());
                                                }
                                                AggregationImpl.this.waitingList.store(vkey, new ObjectDescriptor(obj.getId(), theVersionF, expiration, expiration, theSize), obj, new Continuation(){

                                                    public void receiveResult(Object o) {
                                                        ((PastImpl)AggregationImpl.this.objectStore).cache(obj, new Continuation(){

                                                            public void receiveResult(Object o) {
                                                                if (AggregationImpl.this.logger.level <= 500) {
                                                                    AggregationImpl.this.logger.log("Refresh: Missing object " + id.toStringFull() + " added ok");
                                                                }
                                                                myParent.receiveResult(new Boolean(true));
                                                            }

                                                            public void receiveException(Exception e) {
                                                                if (AggregationImpl.this.logger.level <= 900) {
                                                                    AggregationImpl.this.logger.logException("Refresh: Exception while precaching object: " + id.toStringFull() + " (e=" + e + ")", e);
                                                                }
                                                                myParent.receiveResult(new Boolean(true));
                                                            }
                                                        });
                                                    }

                                                    public void receiveException(Exception e) {
                                                        if (AggregationImpl.this.logger.level <= 900) {
                                                            AggregationImpl.this.logger.logException("Refresh: Exception while refreshing aggregate: " + id.toStringFull() + " (e=" + e + ")", e);
                                                        }
                                                        myParent.receiveResult(new AggregationException("Cannot store reaggregated object in waiting list: " + id.toStringFull()));
                                                    }
                                                });
                                                return;
                                            }
                                            if (AggregationImpl.this.logger.level <= 500) {
                                                AggregationImpl.this.logger.log("Refresh: Missing object already in waiting list: " + id.toStringFull());
                                            }
                                            myParent.receiveResult(new Boolean(true));
                                            return;
                                        }
                                        if (AggregationImpl.this.logger.level <= 500) {
                                            AggregationImpl.this.logger.log("Refresh: Missing object should not be aggregated: " + id.toStringFull());
                                        }
                                        myParent.receiveResult(new Boolean(true));
                                        return;
                                    }
                                    if (AggregationImpl.this.logger.level <= 900) {
                                        AggregationImpl.this.logger.log("Refresh: Cannot find refreshed object " + id.toStringFull() + ", lookup returns " + o);
                                    }
                                    myParent.receiveException(new AggregationException("Object not found during reaggregation: " + id.toStringFull()));
                                }

                                public void receiveException(Exception e) {
                                    if (AggregationImpl.this.logger.level <= 900) {
                                        AggregationImpl.this.logger.log("Refresh: Exception received while reaggregating " + id.toStringFull() + ", e=" + e);
                                    }
                                    myParent.receiveException(e);
                                }
                            });
                            return;
                        }
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("Refresh: Limit of " + AggregationImpl.this.maxReaggregationPerRefresh + " reaggregations exceeded; postponing id=" + id.toStringFull());
                        }
                        lastResult = new Boolean(true);
                        continue;
                    }
                    if (AggregationImpl.this.logger.level <= 900) {
                        AggregationImpl.this.logger.log("Refresh: Refreshed object not found in any aggregate: " + id.toStringFull());
                    }
                    lastResult = new Boolean(true);
                }
            }

            public void receiveException(Exception e) {
                if (AggregationImpl.this.logger.level <= 900) {
                    AggregationImpl.this.logger.logException("Exception while refreshing " + ids[this.currentIndex].toStringFull() + ", e=", e);
                }
                this.receiveResult(e);
            }
        };
        theContinuation.receiveResult(null);
    }

    private int getSize(PastContent obj) {
        try {
            RawPastContent rpc = obj instanceof RawPastContent ? (RawPastContent)obj : new JavaSerializedPastContent(obj);
            SimpleOutputBuffer buf = new SimpleOutputBuffer();
            buf.writeShort(rpc.getType());
            rpc.serialize(buf);
            return buf.getWritten();
        }
        catch (IOException ioe) {
            if (this.logger.level <= 900) {
                this.logger.log("Cannot serialize object, size unknown: " + ioe);
            }
            return 0;
        }
    }

    public Serializable getHandle() {
        return this.aggregateList.getRoot();
    }

    public void setHandle(Serializable handle, Continuation command) {
        if (this.logger.level <= 800) {
            this.logger.log("setHandle(" + handle + ")");
        }
        if (!(handle instanceof Id)) {
            command.receiveException(new AggregationException("Illegal handle"));
            return;
        }
        if (this.aggregateList.getADC((Id)handle) != null) {
            if (this.logger.level <= 800) {
                this.logger.log("Rebuild: Handle " + handle + " is already covered by current root");
            }
            command.receiveResult(new Boolean(true));
        }
        this.aggregateList.setRoot((Id)handle);
        this.rebuildAggregateList(command);
    }

    private void rebuildRecursive(final Id fromKey, final Vector keysInProgress, final Vector keysPostponed, final Vector keysDone, final Continuation command) {
        keysInProgress.add(fromKey);
        if (this.logger.level <= 800) {
            this.logger.log("Rebuild: Fetching handles for aggregate " + fromKey.toStringFull());
        }
        this.aggregateStore.lookupHandles(fromKey, 999, new Continuation(){

            public void receiveResult(Object o) {
                if (AggregationImpl.this.logger.level <= 500) {
                    AggregationImpl.this.logger.log("Got handles for " + fromKey);
                }
                if (o instanceof PastContentHandle[]) {
                    PastContentHandle[] pch = (PastContentHandle[])o;
                    PastContentHandle bestHandle = null;
                    for (int i = 0; i < pch.length; ++i) {
                        if (pch[i] == null || pch[i] instanceof GCPastContentHandle && ((GCPastContentHandle)pch[i]).getVersion() != 0L || bestHandle != null) continue;
                        bestHandle = pch[i];
                    }
                    if (bestHandle != null) {
                        final PastContentHandle thisHandle = bestHandle;
                        final 29 outerContinuation = this;
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("Fetching " + thisHandle);
                        }
                        AggregationImpl.this.aggregateStore.fetch(thisHandle, new Continuation(){

                            public void receiveResult(Object o) {
                                if (o instanceof Aggregate) {
                                    keysInProgress.remove(fromKey);
                                    keysDone.add(fromKey);
                                    if (AggregationImpl.this.logger.level <= 800) {
                                        AggregationImpl.this.logger.log("Rebuild: Got aggregate " + fromKey.toStringFull());
                                    }
                                    Aggregate aggr = (Aggregate)o;
                                    ObjectDescriptor[] objects = new ObjectDescriptor[aggr.numComponents()];
                                    long aggregateExpiration = thisHandle instanceof GCPastContentHandle ? ((GCPastContentHandle)thisHandle).getExpiration() : Long.MAX_VALUE;
                                    for (int i = 0; i < aggr.numComponents(); ++i) {
                                        objects[i] = new ObjectDescriptor(aggr.getComponent(i).getId(), aggr.getComponent(i).getVersion(), aggregateExpiration, aggregateExpiration, AggregationImpl.this.getSize(aggr.getComponent(i)));
                                        final GCPastContent objData = aggr.getComponent(i);
                                        if (AggregationImpl.this.logger.level <= 500) {
                                            AggregationImpl.this.logger.log("Checking whether " + objData.getId() + "v" + objData.getVersion() + " is in object store...");
                                        }
                                        AggregationImpl.this.objectStore.lookupHandles(objData.getId(), 1, new Continuation(){

                                            public void receiveResult(Object o) {
                                                PastContentHandle[] result;
                                                PastContentHandle[] pastContentHandleArray = result = o instanceof PastContentHandle[] ? (PastContentHandle[])o : new PastContentHandle[]{};
                                                if (AggregationImpl.this.logger.level <= 500) {
                                                    AggregationImpl.this.logger.log("Handles for " + objData.getId() + "v" + objData.getVersion() + ": " + result + " (" + result.length + ", PCH=" + (o instanceof PastContentHandle[]) + ")");
                                                }
                                                boolean gotOne = false;
                                                for (int i = 0; i < result.length; ++i) {
                                                    if (result[i] == null) continue;
                                                    if (AggregationImpl.this.logger.level <= 500) {
                                                        AggregationImpl.this.logger.log("Have v" + ((GCPastContentHandle)result[i]).getVersion());
                                                    }
                                                    if (((GCPastContentHandle)result[i]).getVersion() < objData.getVersion()) continue;
                                                    gotOne = true;
                                                }
                                                if (gotOne) {
                                                    if (AggregationImpl.this.logger.level <= 500) {
                                                        AggregationImpl.this.logger.log("Got it");
                                                    }
                                                } else {
                                                    if (AggregationImpl.this.logger.level <= 500) {
                                                        AggregationImpl.this.logger.log("Ain't got it... reinserting");
                                                    }
                                                    AggregationImpl.this.objectStore.insert(objData, new Continuation(){

                                                        public void receiveResult(Object o) {
                                                            if (AggregationImpl.this.logger.level <= 500) {
                                                                AggregationImpl.this.logger.log("Reinsert " + objData.getId() + "v" + objData.getVersion() + " ok, result=" + o);
                                                            }
                                                        }

                                                        public void receiveException(Exception e) {
                                                            if (AggregationImpl.this.logger.level <= 500) {
                                                                AggregationImpl.this.logger.logException("Reinsert " + objData.getId() + "v" + objData.getVersion() + " failed, exception=", e);
                                                            }
                                                        }
                                                    });
                                                }
                                            }

                                            public void receiveException(Exception e) {
                                                if (AggregationImpl.this.logger.level <= 500) {
                                                    AggregationImpl.this.logger.logException("Cannot retrieve handles for object " + objData.getId() + "v" + objData.getVersion() + " to be restored; e=", e);
                                                }
                                            }
                                        });
                                    }
                                    AggregationImpl.this.aggregateList.addAggregateDescriptor(new AggregateDescriptor(fromKey, aggregateExpiration, objects, aggr.getPointers()));
                                    Id[] pointers = aggr.getPointers();
                                    int numAdded = 0;
                                    if (pointers != null) {
                                        for (int i = 0; i < pointers.length; ++i) {
                                            Id thisPointer;
                                            if (!(pointers[i] instanceof Id) || keysDone.contains(thisPointer = pointers[i]) || keysPostponed.contains(thisPointer) || keysInProgress.contains(thisPointer)) continue;
                                            if (keysInProgress.size() >= AggregationImpl.this.reconstructionMaxConcurrentLookups) {
                                                keysPostponed.add(thisPointer);
                                            } else {
                                                AggregationImpl.this.rebuildRecursive(thisPointer, keysInProgress, keysPostponed, keysDone, command);
                                            }
                                            ++numAdded;
                                        }
                                    }
                                    if (AggregationImpl.this.logger.level <= 500) {
                                        AggregationImpl.this.logger.log("Rebuild: Added " + numAdded + " keys, now " + keysInProgress.size() + " in progress, " + keysPostponed.size() + " postponed and " + keysDone.size() + " done");
                                    }
                                    if (!keysInProgress.isEmpty() || !keysPostponed.isEmpty()) {
                                        if (AggregationImpl.this.logger.level <= 800) {
                                            AggregationImpl.this.logger.log("Rebuild: " + keysInProgress.size() + " keys in progress, " + keysPostponed.size() + " postponed, " + keysDone.size() + " done");
                                        }
                                        while (keysInProgress.size() < AggregationImpl.this.reconstructionMaxConcurrentLookups && keysPostponed.size() > 0) {
                                            Id nextKey = (Id)keysPostponed.firstElement();
                                            if (AggregationImpl.this.logger.level <= 500) {
                                                AggregationImpl.this.logger.log("Rebuild: Resuming lookup for postponed key " + nextKey.toStringFull());
                                            }
                                            keysPostponed.remove(nextKey);
                                            AggregationImpl.this.rebuildRecursive(nextKey, keysInProgress, keysPostponed, keysDone, command);
                                        }
                                    } else {
                                        AggregationImpl.this.aggregateList.writeToDisk();
                                        AggregationImpl.this.rebuildInProgress = false;
                                        if (AggregationImpl.this.logger.level <= 800) {
                                            AggregationImpl.this.logger.log("Rebuild: Completed; " + keysDone.size() + " aggregates checked");
                                        }
                                        command.receiveResult(new Boolean(true));
                                    }
                                } else {
                                    this.receiveException(new AggregationException("Fetch failed: " + fromKey + ", returned " + o));
                                }
                            }

                            public void receiveException(Exception e) {
                                outerContinuation.receiveException(e);
                            }
                        });
                    } else {
                        this.receiveException(new AggregationException("LookupHandles did not return any valid handles for " + fromKey));
                    }
                } else {
                    this.receiveException(new AggregationException("LookupHandles for " + fromKey + " failed, returned o=" + o));
                }
            }

            public void receiveException(Exception e) {
                if (AggregationImpl.this.logger.level <= 900) {
                    AggregationImpl.this.logger.logException("Rebuild: Exception ", e);
                }
                keysInProgress.remove(fromKey);
                keysDone.add(fromKey);
                if (keysInProgress.isEmpty() && keysPostponed.isEmpty()) {
                    AggregationImpl.this.rebuildInProgress = false;
                    if (AggregationImpl.this.aggregateList.isEmpty()) {
                        command.receiveException(new AggregationException("Cannot read root aggregate! -- retry later"));
                    } else {
                        AggregationImpl.this.aggregateList.writeToDisk();
                        command.receiveResult(new Boolean(true));
                    }
                }
                while (keysInProgress.size() < AggregationImpl.this.reconstructionMaxConcurrentLookups && keysPostponed.size() > 0) {
                    Id nextKey = (Id)keysPostponed.firstElement();
                    if (AggregationImpl.this.logger.level <= 500) {
                        AggregationImpl.this.logger.log("Rebuild: Resuming lookup for postponed key " + nextKey.toStringFull());
                    }
                    keysPostponed.remove(nextKey);
                    AggregationImpl.this.rebuildRecursive(nextKey, keysInProgress, keysPostponed, keysDone, command);
                }
            }
        });
    }

    private void rebuildAggregateList(Continuation command) {
        Vector keysInProgress = new Vector();
        Vector keysPostponed = new Vector();
        Vector keysDone = new Vector();
        if (this.logger.level <= 800) {
            this.logger.log("rebuildAggregateList(" + this.aggregateList.getRoot() + ")");
        }
        if (this.aggregateList.getRoot() == null) {
            if (this.logger.level <= 900) {
                this.logger.log("rebuildAggregateList invoked while rootKey is null");
            }
            command.receiveException(new AggregationException("Set handle first!"));
            return;
        }
        this.rebuildInProgress = true;
        this.rebuildRecursive(this.aggregateList.getRoot(), keysInProgress, keysPostponed, keysDone, command);
    }

    public void insert(PastContent obj, Continuation command) {
        this.insert(obj, Long.MAX_VALUE, command);
    }

    public void insert(final PastContent obj, long lifetime, final Continuation command) {
        long theVersion = obj instanceof GCPastContent ? ((GCPastContent)obj).getVersion() : 0L;
        VersionKey vkey = new VersionKey(obj.getId(), theVersion);
        long theVersionF = theVersion;
        int theSize = this.getSize(obj);
        if (this.policy.shouldBeAggregated(obj, theSize)) {
            if (this.logger.level <= 800) {
                this.logger.log("AGGREGATE INSERT: " + obj.getId() + " version=" + theVersion + " size=" + theSize + " class=" + obj.getClass().getName());
            }
            if (this.objectStore instanceof GCPast) {
                ((GCPast)this.objectStore).insert(obj, lifetime, command);
            } else {
                this.objectStore.insert(obj, command);
            }
            this.waitingList.store(vkey, new ObjectDescriptor(obj.getId(), theVersionF, lifetime, lifetime, theSize), obj, new Continuation(){

                public void receiveResult(Object o) {
                }

                public void receiveException(Exception e) {
                    if (AggregationImpl.this.logger.level <= 900) {
                        AggregationImpl.this.logger.logException("Exception while storing aggregate: " + obj.getId() + " (e=" + e + ")", e);
                    }
                }
            });
        } else {
            if (this.logger.level <= 800) {
                this.logger.log("INSERT WITHOUT AGGREGATION: " + obj.getId() + " version=" + theVersionF + " size=" + theSize + " class=" + obj.getClass().getName());
            }
            Continuation c = new Continuation(){
                boolean otherSucceeded = false;
                boolean otherFailed = false;

                public void receiveResult(Object o) {
                    if (AggregationImpl.this.logger.level <= 500) {
                        AggregationImpl.this.logger.log("INSERT " + obj.getId() + " receiveResult(" + o + "), otherSucc=" + this.otherSucceeded + " otherFail=" + this.otherFailed);
                    }
                    if (this.otherSucceeded) {
                        if (!this.otherFailed) {
                            if (AggregationImpl.this.logger.level <= 500) {
                                AggregationImpl.this.logger.log("--reporting Success");
                            }
                            command.receiveResult(new Boolean[]{new Boolean(true)});
                        }
                    } else {
                        this.otherSucceeded = true;
                    }
                }

                public void receiveException(Exception e) {
                    if (AggregationImpl.this.logger.level <= 500) {
                        AggregationImpl.this.logger.log("INSERT " + obj.getId() + " receiveException(" + e + "), otherSucc=" + this.otherSucceeded + " otherFail=" + this.otherFailed);
                    }
                    if (AggregationImpl.this.logger.level <= 500) {
                        AggregationImpl.this.logger.log("--reporting Failure");
                    }
                    command.receiveException(e);
                    this.otherFailed = true;
                }
            };
            if (this.objectStore instanceof GCPast) {
                ((GCPast)this.objectStore).insert(obj, lifetime, c);
            } else {
                this.objectStore.insert(obj, c);
            }
            if (this.aggregateStore instanceof GCPast) {
                ((GCPast)this.aggregateStore).insert(new NonAggregate(obj), lifetime, c);
            } else {
                this.aggregateStore.insert(new NonAggregate(obj), c);
            }
        }
    }

    private void retrieveObjectFromAggregate(final AggregateDescriptor adc, final int objDescIndex, final Continuation command) {
        this.aggregateStore.lookup(adc.key, new Continuation(){

            public void receiveResult(Object o) {
                if (o instanceof Aggregate) {
                    final Aggregate aggr = (Aggregate)o;
                    AggregationImpl.this.endpoint.process(new Executable(){

                        public Object execute() {
                            return AggregationImpl.this.factory.buildId(aggr.getContentHash());
                        }
                    }, new Continuation(){

                        public void receiveResult(Object o) {
                            if (o instanceof Id) {
                                Id aggrNominalKey = (Id)o;
                                if (!aggrNominalKey.equals(adc.key)) {
                                    if (AggregationImpl.this.logger.level <= 900) {
                                        AggregationImpl.this.logger.log("Cannot validate aggregate " + adc.key + ", hash=" + aggrNominalKey);
                                    }
                                    command.receiveException(new AggregationException("Cannot validate aggregate -- retry?"));
                                    return;
                                }
                                if (AggregationImpl.this.logger.level <= 500) {
                                    AggregationImpl.this.logger.log("Object " + adc.objects[objDescIndex].key + " (#" + objDescIndex + ") successfully retrieved from " + adc.key);
                                }
                                AggregationImpl.this.objectStore.insert(aggr.getComponent(objDescIndex), new Continuation(){

                                    public void receiveResult(Object o) {
                                    }

                                    public void receiveException(Exception e) {
                                    }
                                });
                                command.receiveResult(aggr.getComponent(objDescIndex));
                            } else {
                                if (AggregationImpl.this.logger.level <= 900) {
                                    AggregationImpl.this.logger.log("retrieveObjectFromAggregate cannot determine content hash, received " + o);
                                }
                                command.receiveException(new AggregationException("retrieveObjectFromAggregate cannot determine content hash"));
                            }
                        }

                        public void receiveException(Exception e) {
                            if (AggregationImpl.this.logger.level <= 900) {
                                AggregationImpl.this.logger.logException("retrieveObjectFromAggregate cannot determine content hash, exception ", e);
                            }
                            command.receiveException(e);
                        }
                    });
                } else {
                    if (AggregationImpl.this.logger.level <= 900) {
                        AggregationImpl.this.logger.log("retrieveObjectFromAggregate failed; receiveResult(" + o + ")");
                    }
                    command.receiveResult(null);
                }
            }

            public void receiveException(Exception e) {
                if (AggregationImpl.this.logger.level <= 900) {
                    AggregationImpl.this.logger.logException("retrieveObjectFromAggregate failed; receiveException(" + e + ")", e);
                }
                command.receiveException(e);
            }
        });
    }

    public void lookup(final Id id, boolean cache, final Continuation command) {
        if (this.logger.level <= 800) {
            this.logger.log("lookup(" + id + ", cache=" + cache + ")");
        }
        this.objectStore.lookup(id, cache, new Continuation(){

            public void receiveResult(Object o) {
                if (o != null) {
                    if (AggregationImpl.this.logger.level <= 500) {
                        AggregationImpl.this.logger.log("NL: Found in PAST: " + id);
                    }
                    command.receiveResult(o);
                } else {
                    AggregateDescriptor adc = AggregationImpl.this.aggregateList.getADC(id);
                    if (adc != null) {
                        int objDescIndex;
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("NL: Must retrieve from aggregate");
                        }
                        if ((objDescIndex = adc.lookupNewest(id)) < 0) {
                            if (AggregationImpl.this.logger.level <= 900) {
                                AggregationImpl.this.logger.log("NL: Aggregate found, but object not found in aggregate?!? -- aborted");
                            }
                            command.receiveException(new AggregationException("Inconsistency detected in aggregate list -- try restarting the application"));
                            return;
                        }
                        AggregationImpl.this.retrieveObjectFromAggregate(adc, objDescIndex, command);
                    } else {
                        if (AggregationImpl.this.logger.level <= 900) {
                            AggregationImpl.this.logger.log("NL: LOOKUP FAILED, OBJECT NOT FOUND: " + id);
                        }
                        command.receiveResult(null);
                    }
                }
            }

            public void receiveException(Exception e) {
                command.receiveException(e);
            }
        });
    }

    public void lookup(final Id id, final long version, final Continuation command) {
        AggregateDescriptor adc;
        if (this.logger.level <= 800) {
            this.logger.log("lookup(" + id + ", version=" + version + ")");
        }
        if ((adc = this.aggregateList.getADC(new VersionKey(id, version))) != null) {
            int objDescIndex;
            if (this.logger.level <= 500) {
                this.logger.log("VL: Retrieving from aggregate");
            }
            if ((objDescIndex = adc.lookupSpecific(id, version)) < 0) {
                if (this.logger.level <= 900) {
                    this.logger.log("VL: Aggregate found, but object not found in aggregate?!? -- aborted");
                }
                command.receiveException(new AggregationException("Inconsistency detected in aggregate list -- try restarting the application"));
                return;
            }
            this.retrieveObjectFromAggregate(adc, objDescIndex, command);
        } else {
            if (this.logger.level <= 500) {
                this.logger.log("VL: Not found in aggregate list: " + id + "v" + version);
            }
            if (this.aggregateStore instanceof VersioningPast) {
                VersioningPast vaggr = (VersioningPast)((Object)this.aggregateStore);
                vaggr.lookup(id, version, new Continuation(){

                    public void receiveResult(Object o) {
                        if (o != null) {
                            if (AggregationImpl.this.logger.level <= 500) {
                                AggregationImpl.this.logger.log("VL: Found in Aggregate.VersioningPAST: " + id + "v" + version);
                            }
                            command.receiveResult(o);
                        } else {
                            if (AggregationImpl.this.logger.level <= 500) {
                                AggregationImpl.this.logger.log("VL: Not found in Aggregate.VersioningPAST: " + id + "v" + version);
                            }
                            if (AggregationImpl.this.objectStore instanceof VersioningPast) {
                                VersioningPast vpast = (VersioningPast)((Object)AggregationImpl.this.objectStore);
                                vpast.lookup(id, version, new Continuation(){

                                    public void receiveResult(Object o) {
                                        if (o != null) {
                                            if (AggregationImpl.this.logger.level <= 500) {
                                                AggregationImpl.this.logger.log("VL: Found in Object.VersioningPAST: " + id + "v" + version);
                                            }
                                            command.receiveResult(o);
                                        } else {
                                            if (AggregationImpl.this.logger.level <= 900) {
                                                AggregationImpl.this.logger.log("VL: LOOKUP FAILED, OBJECT NOT FOUND: " + id + "v" + version);
                                            }
                                            command.receiveResult(null);
                                        }
                                    }

                                    public void receiveException(Exception e) {
                                        command.receiveException(e);
                                    }
                                });
                            } else {
                                if (AggregationImpl.this.logger.level <= 500) {
                                    AggregationImpl.this.logger.log("VL: Object store does not support versioning");
                                }
                                command.receiveException(new AggregationException("Cannot find " + id + "v" + version + " -- try rebuilding aggregate list?"));
                            }
                        }
                    }

                    public void receiveException(Exception e) {
                        if (AggregationImpl.this.logger.level <= 900) {
                            AggregationImpl.this.logger.logException("Aggregate.VersioningPAST returned exception for " + id + "v" + version + ": ", e);
                        }
                        command.receiveException(new AggregationException("Aggregate.VersioningPAST returned exception for " + id + "v" + version + ": " + e));
                    }
                });
            } else {
                if (this.logger.level <= 500) {
                    this.logger.log("VL: Aggregate store does not support versioning");
                }
                if (this.objectStore instanceof VersioningPast) {
                    VersioningPast vpast = (VersioningPast)((Object)this.objectStore);
                    vpast.lookup(id, version, new Continuation(){

                        public void receiveResult(Object o) {
                            if (o != null) {
                                if (AggregationImpl.this.logger.level <= 500) {
                                    AggregationImpl.this.logger.log("VL: Found in Object.VersioningPAST: " + id + "v" + version);
                                }
                                command.receiveResult(o);
                            } else {
                                if (AggregationImpl.this.logger.level <= 900) {
                                    AggregationImpl.this.logger.log("VL: LOOKUP FAILED, OBJECT NOT FOUND: " + id + "v" + version);
                                }
                                command.receiveResult(null);
                            }
                        }

                        public void receiveException(Exception e) {
                            command.receiveException(e);
                        }
                    });
                }
                if (this.logger.level <= 500) {
                    this.logger.log("VL: Object store does not support versioning");
                }
                command.receiveResult(null);
            }
        }
    }

    public void lookup(Id id, Continuation command) {
        this.lookup(id, true, command);
    }

    public void lookupHandles(Id id, long version, int max, Continuation command) {
        ((VersioningPast)((Object)this.aggregateStore)).lookupHandles(id, version, max, command);
    }

    public void lookupHandle(Id id, NodeHandle handle, Continuation command) {
        command.receiveException(new UnsupportedOperationException("LookupHandle() is not supported on Aggregation"));
    }

    public void lookupHandles(final Id id, final int max, final Continuation command) {
        if (this.logger.level <= 800) {
            this.logger.log("lookupHandles(" + id + "," + max + ")");
        }
        this.objectStore.lookupHandles(id, max, new Continuation(){

            public void receiveResult(Object o) {
                PastContentHandle[] result = o instanceof PastContentHandle[] ? (PastContentHandle[])o : new PastContentHandle[]{};
                boolean foundHandle = false;
                for (int i = 0; i < result.length; ++i) {
                    if (result[i] == null) continue;
                    foundHandle = true;
                }
                if (foundHandle) {
                    if (AggregationImpl.this.logger.level <= 500) {
                        AggregationImpl.this.logger.log("lookupHandles(" + id + "," + max + ") handled by PAST; ret=" + o);
                    }
                    command.receiveResult(o);
                } else {
                    AggregateDescriptor adc;
                    if (AggregationImpl.this.logger.level <= 800) {
                        AggregationImpl.this.logger.log("lookupHandles(" + id + "," + max + ") failed, ret=" + o);
                    }
                    if ((adc = AggregationImpl.this.aggregateList.getADC(id)) != null) {
                        int objDescIndex;
                        if (AggregationImpl.this.logger.level <= 500) {
                            AggregationImpl.this.logger.log("lookupHandles: Retrieving from aggregate");
                        }
                        if ((objDescIndex = adc.lookupNewest(id)) < 0) {
                            if (AggregationImpl.this.logger.level <= 900) {
                                AggregationImpl.this.logger.log("lookupHandles: Aggregate found, but object not found in aggregate?!? -- aborted");
                            }
                            command.receiveException(new AggregationException("Inconsistency detected in aggregate list -- try restarting the application"));
                            return;
                        }
                        if (adc.objects[objDescIndex].refreshedLifetime < AggregationImpl.this.environment.getTimeSource().currentTimeMillis()) {
                            if (AggregationImpl.this.logger.level <= 500) {
                                AggregationImpl.this.logger.log("Object " + id + " exists, but has expired -- ignoring");
                            }
                            command.receiveResult(new PastContentHandle[]{null});
                            return;
                        }
                        AggregationImpl.this.retrieveObjectFromAggregate(adc, objDescIndex, new Continuation(){

                            public void receiveResult(Object o) {
                                if (AggregationImpl.this.logger.level <= 500) {
                                    AggregationImpl.this.logger.log("lookupHandles: Retrieved from aggregate: " + id + ", result=" + o);
                                }
                                AggregationImpl.this.objectStore.lookupHandles(id, max, command);
                            }

                            public void receiveException(Exception e) {
                                if (AggregationImpl.this.logger.level <= 900) {
                                    AggregationImpl.this.logger.log("lookupHandles: Cannot retrieve from aggregate, exception " + e);
                                }
                                command.receiveException(e);
                            }
                        });
                    } else {
                        if (AggregationImpl.this.logger.level <= 800) {
                            AggregationImpl.this.logger.log("lookupHandles: " + id + " is neither in object store nor in aggregate list");
                        }
                        command.receiveResult(new PastContentHandle[]{null});
                    }
                }
            }

            public void receiveException(Exception e) {
                if (AggregationImpl.this.logger.level <= 900) {
                    AggregationImpl.this.logger.log("Exception in lookupHandles: " + e);
                }
                command.receiveException(e);
            }
        });
    }

    public void fetch(PastContentHandle handle, Continuation command) {
        if (handle instanceof GlacierContentHandle) {
            this.aggregateStore.fetch(handle, command);
        } else {
            this.objectStore.fetch(handle, command);
        }
    }

    public void flush(Id id, Continuation command) {
        Iterator iter = this.waitingList.scan().getIterator();
        boolean objectIsWaiting = false;
        if (this.logger.level <= 800) {
            this.logger.log("flush(" + id + ") invoked");
        }
        while (iter.hasNext()) {
            VersionKey thisKey = (VersionKey)iter.next();
            if (!thisKey.getId().equals(id)) continue;
            objectIsWaiting = true;
            break;
        }
        if (objectIsWaiting) {
            this.formAggregates(command);
        } else {
            command.receiveResult(new Boolean(true));
        }
    }

    public void flush(Continuation command) {
        this.formAggregates(command);
    }

    public void rollback(Id id, Continuation command) {
        AggregateDescriptor adc = this.aggregateList.getADC(id);
        if (adc != null) {
            int objDescIndex = adc.lookupNewest(id);
            if (objDescIndex < 0) {
                if (this.logger.level <= 900) {
                    this.logger.log("Rollback: Aggregate found, but object not found in aggregate?!? -- aborted");
                }
                command.receiveException(new AggregationException("Inconsistency detected in aggregate list -- try restarting the application"));
                return;
            }
            if (this.logger.level <= 500) {
                this.logger.log("Rollback: Found " + adc.objects[objDescIndex].key + "v" + adc.objects[objDescIndex].version);
            }
            this.retrieveObjectFromAggregate(adc, objDescIndex, command);
        }
        if (this.logger.level <= 500) {
            this.logger.log("Rollback: No version of " + id + " found");
        }
        command.receiveResult(null);
    }

    public void reset(Continuation command) {
        this.aggregateList.clear();
        Iterator iter = this.waitingList.scan().getIterator();
        while (iter.hasNext()) {
            VersionKey thisKey = (VersionKey)iter.next();
            this.waitingList.unstore(thisKey, new Continuation(){

                public void receiveResult(Object o) {
                }

                public void receiveException(Exception e) {
                }
            });
        }
        command.receiveResult(new Boolean(true));
    }

    public NodeHandle getLocalNodeHandle() {
        return this.objectStore.getLocalNodeHandle();
    }

    public int getReplicationFactor() {
        return this.objectStore.getReplicationFactor();
    }

    public boolean forward(RouteMessage message) {
        return true;
    }

    public void update(NodeHandle handle, boolean joined) {
    }

    public void deliver(Id id, Message message) {
        AggregationMessage msg = (AggregationMessage)message;
        if (this.logger.level <= 500) {
            this.logger.log("Received message " + msg + " with destination " + id + " from " + msg.getSource().getId());
        }
        if (msg instanceof AggregationTimeoutMessage) {
            AggregationTimeoutMessage gtm = (AggregationTimeoutMessage)msg;
            this.timerExpired((char)gtm.getUID());
            return;
        }
        this.panic("AGGREGATION ERROR - Received message " + msg + " of unknown type.");
    }

    public void setFlushInterval(int flushIntervalSec) {
        this.flushInterval = (long)flushIntervalSec * 1000L;
    }

    public void setMaxAggregateSize(int maxAggregateSize) {
        this.maxAggregateSize = maxAggregateSize;
    }

    public void setMaxObjectsInAggregate(int maxObjectsInAggregate) {
        this.maxObjectsInAggregate = maxObjectsInAggregate;
    }

    public void setRenewThreshold(int expirationRenewThresholdHrs) {
        this.expirationRenewThreshold = (long)expirationRenewThresholdHrs * 3600000L;
    }

    public void setConsolidationInterval(long consolidationIntervalSec) {
        this.consolidationInterval = consolidationIntervalSec * 1000L;
    }

    public void setConsolidationThreshold(long consolidationThresholdSec) {
        this.consolidationThreshold = consolidationThresholdSec * 1000L;
    }

    public void setConsolidationMinObjectsPerAggregate(int minObjectsInAggregateArg) {
        this.consolidationMinObjectsInAggregate = minObjectsInAggregateArg;
    }

    public void setConsolidationMinUtilization(double minUtilization) {
        this.consolidationMinComponentsAlive = minUtilization;
    }

    public Past getAggregateStore() {
        return this.aggregateStore;
    }

    public Past getObjectStore() {
        return this.objectStore;
    }

    public int getNumObjectsWaiting() {
        return this.waitingList.scan().numElements();
    }

    public AggregationStatistics getStatistics() {
        return this.stats;
    }

    public String getInstance() {
        return this.instance;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setContentDeserializer(PastContentDeserializer deserializer) {
        this.contentDeserializer = deserializer;
        this.objectStore.setContentDeserializer(this.contentDeserializer);
    }

    public void setContentHandleDeserializer(PastContentHandleDeserializer deserializer) {
        this.contentHandleDeserializer = deserializer;
        this.objectStore.setContentHandleDeserializer(deserializer);
    }
}

