/*
 * Decompiled with CFR 0.152.
 */
package rice.environment.processing.simple;

import rice.Continuation;
import rice.Executable;
import rice.environment.logging.LogManager;
import rice.environment.processing.Processor;
import rice.environment.processing.WorkRequest;
import rice.environment.processing.simple.BlockingIOThread;
import rice.environment.processing.simple.ProcessingQueue;
import rice.environment.processing.simple.ProcessingRequest;
import rice.environment.processing.simple.ProcessingThread;
import rice.environment.processing.simple.WorkQueue;
import rice.environment.time.TimeSource;
import rice.selector.SelectorManager;

public class SimpleProcessor
implements Processor {
    private ProcessingQueue QUEUE = new ProcessingQueue();
    private ProcessingThread THREAD;
    private WorkQueue workQueue;
    private BlockingIOThread bioThread;

    public SimpleProcessor(String name) {
        this.THREAD = new ProcessingThread(name + ".ProcessingThread", this.QUEUE);
        this.THREAD.start();
        this.THREAD.setPriority(1);
        this.workQueue = new WorkQueue();
        this.bioThread = new BlockingIOThread(this.workQueue);
        this.bioThread.start();
    }

    public void process(Executable task, Continuation command, SelectorManager selector, TimeSource ts, LogManager log) {
        this.QUEUE.enqueue(new ProcessingRequest(task, command, log, ts, selector));
    }

    public void processBlockingIO(WorkRequest workRequest) {
        this.workQueue.enqueue(workRequest);
    }

    public ProcessingQueue getQueue() {
        return this.QUEUE;
    }

    public void destroy() {
        this.THREAD.destroy();
        this.QUEUE.destroy();
        this.bioThread.destroy();
        this.workQueue.destroy();
    }

    public WorkQueue getIOQueue() {
        return this.workQueue;
    }
}

