/*
 * Decompiled with CFR 0.152.
 */
package rice.environment.processing.simple;

import java.util.LinkedList;
import java.util.List;
import rice.environment.processing.simple.ProcessingRequest;

public class ProcessingQueue {
    List q = new LinkedList();
    int capacity = -1;
    volatile boolean running = true;

    public ProcessingQueue() {
    }

    public ProcessingQueue(int capacity) {
        this.capacity = capacity;
    }

    public synchronized int getLength() {
        return this.q.size();
    }

    public synchronized void enqueue(ProcessingRequest request) {
        if (this.capacity < 0 || this.q.size() < this.capacity) {
            this.q.add(request);
            this.notifyAll();
        } else {
            request.returnError(new ProcessingQueueOverflowException());
        }
    }

    public synchronized ProcessingRequest dequeue() {
        while (this.q.isEmpty() && this.running) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.running) {
            return null;
        }
        return (ProcessingRequest)this.q.remove(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.running = false;
        ProcessingQueue processingQueue = this;
        synchronized (processingQueue) {
            this.notifyAll();
        }
    }

    public class ProcessingQueueOverflowException
    extends Exception {
    }
}

