/*
 * Decompiled with CFR 0.152.
 */
package rice.environment;

import java.io.IOException;
import java.util.HashSet;
import rice.Destructable;
import rice.environment.exception.ExceptionStrategy;
import rice.environment.exception.simple.SimpleExceptionStrategy;
import rice.environment.logging.LogManager;
import rice.environment.logging.Logger;
import rice.environment.logging.file.FileLogManager;
import rice.environment.logging.simple.SimpleLogManager;
import rice.environment.params.Parameters;
import rice.environment.params.simple.SimpleParameters;
import rice.environment.processing.Processor;
import rice.environment.processing.sim.SimProcessor;
import rice.environment.processing.simple.SimpleProcessor;
import rice.environment.random.RandomSource;
import rice.environment.random.simple.SimpleRandomSource;
import rice.environment.time.TimeSource;
import rice.environment.time.simple.SimpleTimeSource;
import rice.environment.time.simulated.DirectTimeSource;
import rice.selector.SelectorManager;

public class Environment
implements Destructable {
    public static final String[] defaultParamFileArray = new String[]{"freepastry"};
    private SelectorManager selectorManager;
    private Processor processor;
    private RandomSource randomSource;
    private TimeSource time;
    private LogManager logManager;
    private Parameters params;
    private Logger logger;
    private ExceptionStrategy exceptionStrategy;
    private HashSet destructables = new HashSet();

    public Environment(SelectorManager sm, Processor proc, RandomSource rs, TimeSource time, LogManager lm, Parameters params, ExceptionStrategy strategy) {
        this.selectorManager = sm;
        this.randomSource = rs;
        this.time = time;
        this.logManager = lm;
        this.params = params;
        this.processor = proc;
        this.exceptionStrategy = strategy;
        if (params == null) {
            throw new IllegalArgumentException("params cannot be null");
        }
        this.chooseDefaults();
        this.selectorManager.setEnvironment(this);
        this.logger = this.logManager.getLogger(this.getClass(), null);
    }

    public Environment(String[] orderedDefaultFiles, String paramFileName) {
        this(null, null, null, null, null, new SimpleParameters(orderedDefaultFiles, paramFileName), null);
    }

    public static Environment directEnvironment(int randomSeed) {
        SimpleRandomSource srs = new SimpleRandomSource(randomSeed, null);
        Environment env = Environment.directEnvironment(srs);
        srs.setLogManager(env.getLogManager());
        return env;
    }

    public static Environment directEnvironment() {
        return Environment.directEnvironment(null);
    }

    public static Environment directEnvironment(RandomSource rs) {
        SimpleParameters params = new SimpleParameters(defaultParamFileArray, null);
        DirectTimeSource dts = new DirectTimeSource(params);
        LogManager lm = Environment.generateDefaultLogManager(dts, params);
        dts.setLogManager(lm);
        SelectorManager selector = Environment.generateDefaultSelectorManager(dts, lm);
        dts.setSelectorManager(selector);
        SimProcessor proc = new SimProcessor(selector);
        Environment ret = new Environment(selector, proc, rs, dts, lm, params, Environment.generateDefaultExceptionStrategy(lm));
        return ret;
    }

    public Environment(String paramFileName) {
        this(defaultParamFileArray, paramFileName);
    }

    public Environment() {
        this(null);
    }

    protected void chooseDefaults() {
        if (this.time == null) {
            this.time = Environment.generateDefaultTimeSource();
        }
        if (this.logManager == null) {
            this.logManager = Environment.generateDefaultLogManager(this.time, this.params);
        }
        if (this.randomSource == null) {
            this.randomSource = Environment.generateDefaultRandomSource(this.params, this.logManager);
        }
        if (this.selectorManager == null) {
            this.selectorManager = Environment.generateDefaultSelectorManager(this.time, this.logManager);
        }
        if (this.processor == null) {
            this.processor = this.params.contains("environment_use_sim_processor") && this.params.getBoolean("environment_use_sim_processor") ? new SimProcessor(this.selectorManager) : Environment.generateDefaultProcessor();
        }
        if (this.exceptionStrategy == null) {
            this.exceptionStrategy = Environment.generateDefaultExceptionStrategy(this.logManager);
        }
    }

    public static ExceptionStrategy generateDefaultExceptionStrategy(LogManager manager) {
        return new SimpleExceptionStrategy(manager);
    }

    public static RandomSource generateDefaultRandomSource(Parameters params, LogManager logging) {
        SimpleRandomSource randomSource = params.getString("random_seed").equalsIgnoreCase("clock") ? new SimpleRandomSource(logging) : new SimpleRandomSource(params.getLong("random_seed"), logging);
        return randomSource;
    }

    public static TimeSource generateDefaultTimeSource() {
        return new SimpleTimeSource();
    }

    public static LogManager generateDefaultLogManager(TimeSource time, Parameters params) {
        if (params.getBoolean("environment_logToFile")) {
            return new FileLogManager(time, params);
        }
        return new SimpleLogManager(time, params);
    }

    public static SelectorManager generateDefaultSelectorManager(TimeSource time, LogManager logging) {
        return new SelectorManager("Default", time, logging);
    }

    public static Processor generateDefaultProcessor() {
        return new SimpleProcessor("Default");
    }

    public SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public RandomSource getRandomSource() {
        return this.randomSource;
    }

    public TimeSource getTimeSource() {
        return this.time;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public Parameters getParameters() {
        return this.params;
    }

    public void destroy() {
        block4: {
            try {
                this.params.store();
            }
            catch (IOException ioe) {
                if (this.logger.level > 900) break block4;
                this.logger.logException("Error during shutdown", ioe);
            }
        }
        if (this.getSelectorManager().isSelectorThread()) {
            this.callDestroyOnDestructables();
        } else {
            this.getSelectorManager().invoke(new Runnable(){

                public void run() {
                    Environment.this.callDestroyOnDestructables();
                }
            });
        }
    }

    private void callDestroyOnDestructables() {
        for (Destructable d : this.destructables) {
            d.destroy();
        }
        this.selectorManager.destroy();
        this.processor.destroy();
    }

    public void addDestructable(Destructable destructable) {
        this.destructables.add(destructable);
    }

    public void removeDestructable(Destructable destructable) {
        this.destructables.remove(destructable);
    }

    public ExceptionStrategy getExceptionStrategy() {
        return this.exceptionStrategy;
    }

    public ExceptionStrategy setExceptionStrategy(ExceptionStrategy newStrategy) {
        ExceptionStrategy ret = this.exceptionStrategy;
        this.exceptionStrategy = newStrategy;
        return ret;
    }
}

