/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.wire.magicnumber;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.util.DefaultCallback;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.util.MessageRequestHandleImpl;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import org.mpisws.p2p.transport.wire.exception.StalledSocketException;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MagicNumberTransportLayer<Identity>
implements TransportLayer<Identity, ByteBuffer>,
TransportLayerCallback<Identity, ByteBuffer> {
    protected Logger logger;
    protected Environment environment;
    protected TransportLayerCallback<Identity, ByteBuffer> callback;
    protected ErrorHandler<Identity> errorHandler;
    protected TransportLayer<Identity, ByteBuffer> wire;
    public byte[] HEADER;
    public int SOCKET_TIMEOUT;

    public MagicNumberTransportLayer(TransportLayer<Identity, ByteBuffer> wtl, Environment env, ErrorHandler<Identity> errorHandler, byte[] header, int timeOut) {
        this.logger = env.getLogManager().getLogger(MagicNumberTransportLayer.class, null);
        this.environment = env;
        this.wire = wtl;
        this.HEADER = header;
        this.SOCKET_TIMEOUT = timeOut;
        this.errorHandler = errorHandler;
        this.callback = new DefaultCallback<Identity, ByteBuffer>(this.logger);
        if (this.errorHandler == null) {
            this.errorHandler = new DefaultErrorHandler<Identity>(this.logger);
        }
        this.wire.setCallback(this);
    }

    @Override
    public void setCallback(TransportLayerCallback<Identity, ByteBuffer> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identity> handler) {
        this.wire.setErrorHandler(handler);
        if (handler == null) {
            this.errorHandler = new DefaultErrorHandler<Identity>(this.logger);
            return;
        }
        this.errorHandler = handler;
    }

    @Override
    public void acceptMessages(boolean b) {
        this.wire.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.wire.acceptSockets(b);
    }

    @Override
    public Identity getLocalIdentifier() {
        return this.wire.getLocalIdentifier();
    }

    @Override
    public SocketRequestHandle openSocket(final Identity i, final SocketCallback<Identity> deliverSocketToMe, Map<String, Integer> options) {
        if (deliverSocketToMe == null) {
            throw new IllegalArgumentException("deliverSocketToMe must be non-null!");
        }
        final SocketRequestHandleImpl<Identity> cancellable = new SocketRequestHandleImpl<Identity>(i, options);
        cancellable.setSubCancellable(this.wire.openSocket(i, new SocketCallback<Identity>(){

            @Override
            public void receiveResult(SocketRequestHandle<Identity> c, P2PSocket<Identity> result) {
                if (c != cancellable.getSubCancellable()) {
                    throw new RuntimeException("c != cancellable.getSubCancellable() (indicates a bug in the code) c:" + c + " sub:" + cancellable.getSubCancellable());
                }
                result.register(false, true, new P2PSocketReceiver<Identity>(){
                    ByteBuffer buf;
                    {
                        this.buf = ByteBuffer.wrap(MagicNumberTransportLayer.this.HEADER);
                    }

                    @Override
                    public void receiveSelectResult(P2PSocket<Identity> socket, boolean canRead, boolean canWrite) throws IOException {
                        if (canRead) {
                            throw new IOException("Never asked to read!");
                        }
                        if (!canWrite) {
                            throw new IOException("Can't write!");
                        }
                        socket.write(this.buf);
                        if (this.buf.hasRemaining()) {
                            socket.register(false, true, this);
                        } else {
                            deliverSocketToMe.receiveResult(cancellable, socket);
                        }
                    }

                    @Override
                    public void receiveException(P2PSocket<Identity> socket, IOException e) {
                        deliverSocketToMe.receiveException(cancellable, e);
                    }
                });
            }

            @Override
            public void receiveException(SocketRequestHandle<Identity> c, IOException exception) {
                if (c != cancellable.getSubCancellable()) {
                    throw new RuntimeException("c != cancellable.getSubCancellable() (indicates a bug in the code) c:" + c + " sub:" + cancellable.getSubCancellable());
                }
                MagicNumberTransportLayer.this.errorHandler.receivedException(i, exception);
            }
        }, options));
        return cancellable;
    }

    @Override
    public MessageRequestHandle<Identity, ByteBuffer> sendMessage(final Identity i, ByteBuffer m, final MessageCallback<Identity, ByteBuffer> deliverAckToMe, Map<String, Integer> options) {
        byte[] msgWithHeader = new byte[this.HEADER.length + m.remaining()];
        System.arraycopy(this.HEADER, 0, msgWithHeader, 0, this.HEADER.length);
        m.get(msgWithHeader, this.HEADER.length, m.remaining());
        if (this.logger.level <= 500) {
            this.logger.log("sendMessage(" + i + "," + m + ")");
        }
        final MessageRequestHandleImpl<Identity, ByteBuffer> cancellable = new MessageRequestHandleImpl<Identity, ByteBuffer>(i, m, options);
        ByteBuffer buf = ByteBuffer.wrap(msgWithHeader);
        cancellable.setSubCancellable(this.wire.sendMessage(i, buf, new MessageCallback<Identity, ByteBuffer>(){

            @Override
            public void ack(MessageRequestHandle<Identity, ByteBuffer> msg) {
                if (msg != cancellable.getSubCancellable()) {
                    throw new RuntimeException("msg != cancellable.getSubCancellable() (indicates a bug in the code) msg:" + msg + " sub:" + cancellable.getSubCancellable());
                }
                if (deliverAckToMe != null) {
                    deliverAckToMe.ack(cancellable);
                }
            }

            @Override
            public void sendFailed(MessageRequestHandle<Identity, ByteBuffer> msg, IOException ex) {
                if (msg != cancellable.getSubCancellable()) {
                    throw new RuntimeException("msg != cancellable.getSubCancellable() (indicates a bug in the code) msg:" + msg + " sub:" + cancellable.getSubCancellable());
                }
                if (deliverAckToMe == null) {
                    MagicNumberTransportLayer.this.errorHandler.receivedException(i, ex);
                } else {
                    deliverAckToMe.sendFailed(cancellable, ex);
                }
            }
        }, options));
        return cancellable;
    }

    @Override
    public void destroy() {
        this.wire.destroy();
    }

    @Override
    public void incomingSocket(P2PSocket<Identity> s) throws IOException {
        s.register(true, false, new VerifyHeaderReceiver(s));
    }

    @Override
    public void messageReceived(Identity i, ByteBuffer m, Map<String, Integer> options) throws IOException {
        if (this.logger.level <= 500) {
            this.logger.log("messageReceived(" + i + "," + m + ")");
        }
        if (m.remaining() < this.HEADER.length) {
            this.errorHandler.receivedUnexpectedData(i, m.array(), 0, null);
            return;
        }
        byte[] hdr = new byte[this.HEADER.length];
        m.get(hdr);
        if (Arrays.equals(this.HEADER, hdr)) {
            this.callback.messageReceived(i, m, options);
            return;
        }
        this.errorHandler.receivedUnexpectedData(i, m.array(), 0, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VerifyHeaderReceiver
    extends TimerTask
    implements P2PSocketReceiver<Identity> {
        ByteBuffer buf;
        P2PSocket<Identity> socket;

        public VerifyHeaderReceiver(P2PSocket<Identity> s) {
            this.buf = ByteBuffer.allocate(MagicNumberTransportLayer.this.HEADER.length);
            this.socket = s;
            MagicNumberTransportLayer.this.environment.getSelectorManager().getTimer().schedule(this, MagicNumberTransportLayer.this.SOCKET_TIMEOUT);
        }

        @Override
        public void receiveException(P2PSocket<Identity> socket, IOException ioe) {
            MagicNumberTransportLayer.this.errorHandler.receivedException(socket.getIdentifier(), ioe);
        }

        @Override
        public void receiveSelectResult(P2PSocket<Identity> socket, boolean canRead, boolean canWrite) throws IOException {
            if (canWrite) {
                throw new IOException("Never asked to write!");
            }
            if (!canRead) {
                throw new IOException("Can't read!");
            }
            socket.read(this.buf);
            if (this.buf.hasRemaining()) {
                socket.register(true, false, this);
            } else if (Arrays.equals(MagicNumberTransportLayer.this.HEADER, this.buf.array())) {
                this.cancel();
                MagicNumberTransportLayer.this.callback.incomingSocket(socket);
            } else {
                this.cancel();
                MagicNumberTransportLayer.this.errorHandler.receivedUnexpectedData(socket.getIdentifier(), this.buf.array(), 0, null);
            }
        }

        @Override
        public void run() {
            this.socket.close();
            MagicNumberTransportLayer.this.errorHandler.receivedException(this.socket.getIdentifier(), new StalledSocketException(this.socket.getIdentifier(), "Timeout expired."));
        }
    }
}

