/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.wire;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.util.DefaultCallback;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.wire.TCPLayer;
import org.mpisws.p2p.transport.wire.UDPLayer;
import org.mpisws.p2p.transport.wire.WireTransportLayer;
import rice.environment.Environment;
import rice.environment.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireTransportLayerImpl
implements WireTransportLayer {
    protected InetSocketAddress bindAddress;
    protected UDPLayer udp;
    protected TCPLayer tcp;
    protected Logger logger;
    protected Environment environment;
    private TransportLayerCallback<InetSocketAddress, ByteBuffer> callback;
    protected ErrorHandler<InetSocketAddress> errorHandler;

    public WireTransportLayerImpl(InetSocketAddress bindAddress, Environment env, ErrorHandler<InetSocketAddress> errorHandler) throws IOException {
        this.logger = env.getLogManager().getLogger(WireTransportLayer.class, null);
        this.bindAddress = bindAddress;
        this.environment = env;
        this.callback = new DefaultCallback<InetSocketAddress, ByteBuffer>(this.logger);
        this.errorHandler = errorHandler;
        if (this.errorHandler == null) {
            this.errorHandler = new DefaultErrorHandler<InetSocketAddress>(this.logger);
        }
        this.udp = new UDPLayer(this);
        try {
            this.tcp = new TCPLayer(this);
        }
        catch (IOException ioe) {
            this.udp.destroy();
            throw ioe;
        }
    }

    @Override
    public void setCallback(TransportLayerCallback<InetSocketAddress, ByteBuffer> callback) {
        this.callback = callback;
    }

    @Override
    public SocketRequestHandle<InetSocketAddress> openSocket(InetSocketAddress destination, SocketCallback<InetSocketAddress> deliverSocketToMe, Map<String, Integer> options) {
        return this.tcp.openSocket(destination, deliverSocketToMe, options);
    }

    @Override
    public MessageRequestHandle<InetSocketAddress, ByteBuffer> sendMessage(InetSocketAddress destination, ByteBuffer m, MessageCallback<InetSocketAddress, ByteBuffer> deliverAckToMe, Map<String, Integer> options) {
        if (this.logger.level <= 500) {
            this.logger.log("sendMessage(" + destination + "," + m + ")");
        }
        return this.udp.sendMessage(destination, m, deliverAckToMe, options);
    }

    @Override
    public InetSocketAddress getLocalIdentifier() {
        return this.bindAddress;
    }

    @Override
    public void destroy() {
        if (this.logger.level <= 800) {
            this.logger.log("destroy()");
        }
        this.udp.destroy();
        this.tcp.destroy();
    }

    @Override
    public void setErrorHandler(ErrorHandler<InetSocketAddress> handler) {
        if (handler == null) {
            this.errorHandler = new DefaultErrorHandler<InetSocketAddress>(this.logger);
            return;
        }
        this.errorHandler = handler;
    }

    @Override
    public void acceptMessages(boolean b) {
        this.udp.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.tcp.acceptSockets(b);
    }

    protected void messageReceived(InetSocketAddress address, ByteBuffer buffer) throws IOException {
        this.callback.messageReceived(address, buffer, UDPLayer.OPTIONS);
    }

    protected void incomingSocket(P2PSocket<InetSocketAddress> sm) throws IOException {
        this.callback.incomingSocket(sm);
    }
}

