/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.wire;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.wire.WireTransportLayerImpl;
import rice.Destructable;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.selector.SelectionKeyHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDPLayer
extends SelectionKeyHandler
implements Destructable {
    public static final Map<String, Integer> OPTIONS;
    Logger logger;
    private DatagramChannel channel;
    private SelectionKey key;
    public int DATAGRAM_RECEIVE_BUFFER_SIZE;
    public int DATAGRAM_SEND_BUFFER_SIZE;
    List<Envelope> pendingMsgs;
    WireTransportLayerImpl wire;
    ByteBuffer readBuffer;
    long lastTimePrinted = 0L;

    public UDPLayer(WireTransportLayerImpl wire) throws IOException {
        this.wire = wire;
        this.logger = wire.environment.getLogManager().getLogger(UDPLayer.class, null);
        this.pendingMsgs = new LinkedList<Envelope>();
        this.openServerSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageRequestHandle<InetSocketAddress, ByteBuffer> sendMessage(InetSocketAddress destination, ByteBuffer msg, MessageCallback<InetSocketAddress, ByteBuffer> deliverAckToMe, Map<String, Integer> options) {
        if (this.logger.level <= 397) {
            this.logger.log("sendMessage(" + destination + "," + msg + "," + deliverAckToMe + ")");
        }
        Envelope envelope = new Envelope(destination, msg, deliverAckToMe, options);
        List<Envelope> list = this.pendingMsgs;
        synchronized (list) {
            this.pendingMsgs.add(envelope);
        }
        this.wire.environment.getSelectorManager().modifyKey(this.key);
        return envelope;
    }

    protected void openServerSocket() throws IOException {
        Parameters p = this.wire.environment.getParameters();
        this.DATAGRAM_RECEIVE_BUFFER_SIZE = p.getInt("transport_wire_datagram_receive_buffer_size");
        this.DATAGRAM_SEND_BUFFER_SIZE = p.getInt("transport_wire_datagram_send_buffer_size");
        this.readBuffer = ByteBuffer.allocateDirect(this.DATAGRAM_SEND_BUFFER_SIZE);
        this.channel = DatagramChannel.open();
        this.channel.configureBlocking(false);
        this.channel.socket().setReuseAddress(true);
        this.channel.socket().bind(this.wire.bindAddress);
        this.channel.socket().setSendBufferSize(this.DATAGRAM_SEND_BUFFER_SIZE);
        this.channel.socket().setReceiveBufferSize(this.DATAGRAM_RECEIVE_BUFFER_SIZE);
        this.key = this.wire.environment.getSelectorManager().register(this.channel, this, 0);
        this.key.interestOps(1);
        if (this.logger.level <= 800) {
            this.logger.log("UDPLayer binding to " + this.wire.bindAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(SelectionKey key) {
        try {
            InetSocketAddress address = null;
            while ((address = (InetSocketAddress)this.channel.receive(this.readBuffer)) != null) {
                this.readBuffer.flip();
                if (this.readBuffer.remaining() > 0) {
                    this.readHeader(address);
                    this.readBuffer.clear();
                    continue;
                }
                if (this.logger.level <= 800) {
                    this.logger.log("(PM) Read from datagram channel, but no bytes were there - no bad, but wierd.");
                }
                break;
            }
        }
        catch (IOException e) {
            this.wire.errorHandler.receivedException(null, e);
        }
        finally {
            this.readBuffer.clear();
        }
    }

    protected void readHeader(InetSocketAddress address) throws IOException {
        if (this.logger.level <= 500) {
            this.logger.log("readheader(" + address + "," + this.readBuffer.remaining() + ")");
        }
        byte[] remaining = new byte[this.readBuffer.remaining()];
        this.readBuffer.get(remaining);
        this.wire.messageReceived(address, ByteBuffer.wrap(remaining));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(SelectionKey key) {
        Envelope write = null;
        try {
            List<Envelope> list = this.pendingMsgs;
            synchronized (list) {
                Iterator<Envelope> i = this.pendingMsgs.iterator();
                while (i.hasNext()) {
                    write = i.next();
                    try {
                        int len = write.msg.remaining();
                        if (this.logger.level <= 300) {
                            this.logger.log("writing " + len + " to " + write.destination);
                        }
                        if (this.channel.send(write.msg, write.destination) != len) return;
                        if (write.continuation != null) {
                            write.continuation.ack(write);
                        }
                        i.remove();
                    }
                    catch (IOException e) {
                        if (write.continuation == null) {
                            this.wire.errorHandler.receivedException(write.destination, e);
                        } else {
                            write.continuation.sendFailed(write, e);
                        }
                        i.remove();
                        // MONITOREXIT @DISABLED, blocks:[0, 6, 7, 11] lbl23 : MonitorExitStatement: MONITOREXIT : var3_3
                        if (!this.pendingMsgs.isEmpty()) return;
                        key.interestOps(key.interestOps() & 0xFFFFFFFB);
                        return;
                    }
                }
                return;
            }
        }
        catch (Exception e) {
            if (this.logger.level > 900) return;
            this.logger.logException("ERROR (datagrammanager:write) to " + write.destination, e);
            return;
        }
        finally {
            if (this.pendingMsgs.isEmpty()) {
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyKey(SelectionKey key) {
        List<Envelope> list = this.pendingMsgs;
        synchronized (list) {
            if (!this.pendingMsgs.isEmpty()) {
                key.interestOps(key.interestOps() | 4);
            }
        }
    }

    @Override
    public void destroy() {
        if (this.logger.level <= 800) {
            this.logger.log("destroy()");
        }
        Runnable r = new Runnable(){

            public void run() {
                block4: {
                    try {
                        if (UDPLayer.this.key != null) {
                            if (UDPLayer.this.key.channel() != null) {
                                UDPLayer.this.key.channel().close();
                            }
                            UDPLayer.this.key.cancel();
                            UDPLayer.this.key.attach(null);
                        }
                    }
                    catch (IOException ioe) {
                        if (UDPLayer.this.logger.level > 900) break block4;
                        UDPLayer.this.logger.logException("Error destroying UDPLayer", ioe);
                    }
                }
            }
        };
        if (this.wire.environment.getSelectorManager().isSelectorThread()) {
            r.run();
        } else {
            this.wire.environment.getSelectorManager().invoke(r);
        }
    }

    public void acceptMessages(final boolean b) {
        Runnable r = new Runnable(){

            public void run() {
                if (b) {
                    UDPLayer.this.key.interestOps(UDPLayer.this.key.interestOps() | 1);
                } else {
                    UDPLayer.this.key.interestOps(UDPLayer.this.key.interestOps() & 0xFFFFFFFE);
                }
            }
        };
        if (this.wire.environment.getSelectorManager().isSelectorThread()) {
            r.run();
        } else {
            this.wire.environment.getSelectorManager().invoke(r);
        }
    }

    static {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("transport_type", 0);
        OPTIONS = Collections.unmodifiableMap(map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Envelope
    implements MessageRequestHandle<InetSocketAddress, ByteBuffer> {
        protected InetSocketAddress destination;
        protected ByteBuffer msg;
        protected MessageCallback<InetSocketAddress, ByteBuffer> continuation;
        Map<String, Integer> options;

        public Envelope(InetSocketAddress destination, ByteBuffer msg, MessageCallback<InetSocketAddress, ByteBuffer> deliverAckToMe, Map<String, Integer> options) {
            this.destination = destination;
            this.msg = msg;
            this.continuation = deliverAckToMe;
            this.options = options;
        }

        @Override
        public boolean cancel() {
            return UDPLayer.this.pendingMsgs.remove(this);
        }

        @Override
        public InetSocketAddress getIdentifier() {
            return this.destination;
        }

        @Override
        public ByteBuffer getMessage() {
            return this.msg;
        }

        @Override
        public Map<String, Integer> getOptions() {
            return this.options;
        }
    }
}

