/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.wire;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Map;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.wire.TCPLayer;
import rice.environment.logging.Logger;
import rice.selector.SelectionKeyHandler;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketManager
extends SelectionKeyHandler
implements P2PSocket<InetSocketAddress>,
SocketRequestHandle<InetSocketAddress> {
    protected SelectionKey key;
    protected SocketChannel channel;
    protected TimerTask timer;
    protected TCPLayer tcp;
    Logger logger;
    InetSocketAddress addr;
    Map<String, Integer> options;
    protected P2PSocketReceiver reader;
    protected P2PSocketReceiver writer;

    public SocketManager(TCPLayer tcp, SelectionKey serverKey) throws IOException {
        this.tcp = tcp;
        this.logger = tcp.logger;
        this.channel = ((ServerSocketChannel)serverKey.channel()).accept();
        this.channel.socket().setSendBufferSize(tcp.SOCKET_BUFFER_SIZE);
        this.channel.socket().setReceiveBufferSize(tcp.SOCKET_BUFFER_SIZE);
        this.channel.configureBlocking(false);
        this.addr = (InetSocketAddress)this.channel.socket().getRemoteSocketAddress();
        if (this.logger.level <= 500) {
            this.logger.log("(SA) Accepted incoming connection from " + this.addr);
        }
        this.key = tcp.wire.environment.getSelectorManager().register(this.channel, this, 0);
    }

    public SocketManager(final TCPLayer tcp, final InetSocketAddress addr, final SocketCallback<InetSocketAddress> c, Map<String, Integer> options) throws IOException {
        this.tcp = tcp;
        this.options = options;
        this.logger = tcp.logger;
        this.addr = addr;
        this.channel = SocketChannel.open();
        this.channel.socket().setSendBufferSize(tcp.SOCKET_BUFFER_SIZE);
        this.channel.socket().setReceiveBufferSize(tcp.SOCKET_BUFFER_SIZE);
        this.channel.configureBlocking(false);
        if (this.logger.level <= 500) {
            this.logger.log("(SM) Initiating socket connection to " + addr);
        }
        if (this.channel.connect(addr)) {
            this.key = tcp.wire.environment.getSelectorManager().register(this.channel, this, 0);
            c.receiveResult(this, this);
        } else {
            this.key = tcp.wire.environment.getSelectorManager().register(this.channel, new SelectionKeyHandler(){

                public void write(SelectionKey key) {
                    SocketManager.this.write(key);
                }

                public void read(SelectionKey key) {
                    SocketManager.this.read(key);
                }

                public void modifyKey(SelectionKey key) {
                    SocketManager.this.modifyKey(key);
                }

                public void connect(SelectionKey key) {
                    try {
                        if (SocketManager.this.channel.finishConnect()) {
                            key = tcp.wire.environment.getSelectorManager().register(SocketManager.this.channel, SocketManager.this, key.interestOps() & 0xFFFFFFF7);
                            c.receiveResult(SocketManager.this, SocketManager.this);
                        }
                    }
                    catch (IOException e) {
                        if (c == null) {
                            tcp.wire.errorHandler.receivedException(addr, e);
                        } else {
                            c.receiveException(SocketManager.this, e);
                        }
                        SocketManager.this.close();
                    }
                }
            }, 8);
        }
    }

    public String toString() {
        return "SM " + this.channel;
    }

    @Override
    public void close() {
        block5: {
            try {
                if (this.logger.level <= 500) {
                    this.logger.log("Closing connection to " + this.addr);
                }
                if (this.key != null) {
                    this.key.cancel();
                    this.key.attach(null);
                    this.key = null;
                }
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (IOException e) {
                if (this.logger.level > 1000) break block5;
                this.logger.log("ERROR: Recevied exception " + e + " while closing socket!");
            }
        }
    }

    @Override
    public synchronized void modifyKey(SelectionKey key) {
        int flag = 0;
        if (this.reader != null) {
            flag |= 1;
        }
        if (this.writer != null) {
            flag |= 4;
        }
        key.interestOps(flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(SelectionKey key) {
        P2PSocketReceiver temp = null;
        SocketManager socketManager = this;
        synchronized (socketManager) {
            if (this.reader == null) {
                key.interestOps(key.interestOps() & 0xFFFFFFFE);
                return;
            }
            temp = this.reader;
            this.reader = null;
        }
        try {
            temp.receiveSelectResult(this, true, false);
        }
        catch (IOException ioe) {
            temp.receiveException(this, ioe);
        }
        this.tcp.wire.environment.getSelectorManager().modifyKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(SelectionKey key) {
        P2PSocketReceiver temp = null;
        SocketManager socketManager = this;
        synchronized (socketManager) {
            if (this.writer == null) {
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
                return;
            }
            temp = this.writer;
            this.writer = null;
        }
        try {
            temp.receiveSelectResult(this, false, true);
        }
        catch (IOException ioe) {
            temp.receiveException(this, ioe);
        }
        this.tcp.wire.environment.getSelectorManager().modifyKey(key);
    }

    @Override
    public synchronized void register(boolean wantToRead, boolean wantToWrite, P2PSocketReceiver receiver) {
        if (this.key == null) {
            throw new IllegalStateException("Socket " + this + " is already closed.");
        }
        if (wantToWrite && this.writer != null && this.writer != receiver) {
            throw new IllegalStateException("Already registered " + this.writer + " for writing, you can't register " + receiver + " for writing as well!");
        }
        if (wantToRead) {
            if (this.reader != null && this.reader != receiver) {
                throw new IllegalStateException("Already registered " + this.reader + " for reading, you can't register " + receiver + " for reading as well!");
            }
            this.reader = receiver;
        }
        if (wantToWrite) {
            this.writer = receiver;
        }
        this.tcp.wire.environment.getSelectorManager().modifyKey(this.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownOutput() {
        boolean closeMe = false;
        SocketManager socketManager = this;
        synchronized (socketManager) {
            if (this.key == null) {
                throw new IllegalStateException("Socket already closed.");
            }
            try {
                if (this.logger.level <= 500) {
                    this.logger.log("Shutting down output on app connection " + this);
                }
                if (this.channel != null) {
                    this.channel.socket().shutdownOutput();
                } else if (this.logger.level <= 1000) {
                    this.logger.log("ERROR: Unable to shutdown output on channel; channel is null!");
                }
            }
            catch (IOException e) {
                if (this.logger.level <= 1000) {
                    this.logger.log("ERROR: Received exception " + e + " while shutting down output.");
                }
                closeMe = true;
            }
        }
        this.tcp.wire.environment.getSelectorManager().modifyKey(this.key);
        if (closeMe) {
            this.close();
        }
    }

    @Override
    public long read(ByteBuffer dst) throws IOException {
        long ret = this.channel.read(dst);
        if (this.logger.level <= 400) {
            if (this.logger.level <= 300) {
                this.logger.log(this + "read(" + ret + "):" + Arrays.toString(dst.array()));
            } else {
                this.logger.log(this + "read(" + ret + ")");
            }
        }
        return ret;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.channel.read(dsts, offset, length);
    }

    @Override
    public long write(ByteBuffer src) throws IOException {
        long ret = this.channel.write(src);
        if (this.logger.level <= 400) {
            if (this.logger.level <= 300) {
                this.logger.log(this + "write(" + ret + "):" + Arrays.toString(src.array()));
            } else {
                this.logger.log(this + "write(" + ret + ")");
            }
        }
        return ret;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.channel.write(srcs, offset, length);
    }

    @Override
    public boolean cancel() {
        if (this.key == null) {
            return false;
        }
        this.close();
        return true;
    }

    private void exceptionAndClose(IOException e) {
        this.tcp.wire.errorHandler.receivedException(this.addr, e);
        this.close();
    }

    @Override
    public InetSocketAddress getIdentifier() {
        return this.addr;
    }

    @Override
    public Map<String, Integer> getOptions() {
        return this.options;
    }
}

