/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import rice.environment.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketWrapperSocket<Identifier, SubIdentifier>
implements P2PSocket<Identifier> {
    protected Identifier identifier;
    protected P2PSocket<SubIdentifier> socket;
    protected Logger logger;
    protected Map<String, Integer> options;

    public SocketWrapperSocket(Identifier identifier, P2PSocket<SubIdentifier> socket, Logger logger, Map<String, Integer> options) {
        this.identifier = identifier;
        this.socket = socket;
        this.logger = logger;
        this.options = options;
    }

    @Override
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public void close() {
        this.socket.close();
    }

    @Override
    public long read(ByteBuffer dsts) throws IOException {
        long ret = this.socket.read(dsts);
        if (this.logger.level <= 300) {
            this.logger.log(this + "read():" + ret);
        }
        return ret;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.socket.read(dsts, offset, length);
    }

    @Override
    public void register(boolean wantToRead, boolean wantToWrite, final P2PSocketReceiver<Identifier> receiver) {
        if (this.logger.level <= 300) {
            this.logger.log(this + "register(" + wantToRead + "," + wantToWrite + "," + receiver + ")");
        }
        this.socket.register(wantToRead, wantToWrite, new P2PSocketReceiver<SubIdentifier>(){

            @Override
            public void receiveSelectResult(P2PSocket<SubIdentifier> socket, boolean canRead, boolean canWrite) throws IOException {
                if (SocketWrapperSocket.this.logger.level <= 300) {
                    SocketWrapperSocket.this.logger.log(SocketWrapperSocket.this + "rsr(" + socket + "," + canRead + "," + canWrite + ")");
                }
                receiver.receiveSelectResult(SocketWrapperSocket.this, canRead, canWrite);
            }

            @Override
            public void receiveException(P2PSocket<SubIdentifier> socket, IOException e) {
                receiver.receiveException(SocketWrapperSocket.this, e);
            }
        });
    }

    @Override
    public void shutdownOutput() {
        this.socket.shutdownOutput();
    }

    @Override
    public long write(ByteBuffer srcs) throws IOException {
        long ret = this.socket.write(srcs);
        if (this.logger.level <= 300) {
            this.logger.log(this + "write():" + ret);
        }
        return ret;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.socket.write(srcs, offset, length);
    }

    public String toString() {
        return "Socket<" + this.identifier + ">";
    }

    @Override
    public Map<String, Integer> getOptions() {
        return this.options;
    }
}

