/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.util.InsufficientBytesException;
import rice.p2p.commonapi.rawserialization.InputBuffer;

public class SocketInputBuffer
implements InputBuffer {
    P2PSocket socket;
    ByteBuffer readBB;
    ByteBuffer writeBB;
    byte[] cache;
    ByteBuffer one;
    ByteBuffer two;
    ByteBuffer four;
    ByteBuffer eight;
    int initialSize;
    DataInputStream dis;

    public SocketInputBuffer(P2PSocket socket, int size) {
        this.socket = socket;
        this.initialSize = size;
        this.cache = new byte[size];
        this.readBB = ByteBuffer.wrap(this.cache);
        this.writeBB = ByteBuffer.wrap(this.cache);
        this.dis = new DataInputStream(new InputStream(){

            public int read(byte[] b) throws IOException {
                return SocketInputBuffer.this.readInternal(b);
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return SocketInputBuffer.this.readInternal(b, off, len);
            }

            public int read() throws IOException {
                return SocketInputBuffer.this.readInternal();
            }
        });
    }

    public int bytesRemaining() {
        return -2;
    }

    public void reset() {
        this.readBB.clear();
    }

    public int size() {
        return this.writeBB.position();
    }

    public int readInternal(byte[] b, int off, int len) throws IOException {
        int bytesToRead = this.needBytes(len, false);
        this.readBB.get(b, off, bytesToRead);
        return bytesToRead;
    }

    public int readInternal(byte[] b) throws IOException {
        int bytesToRead = this.needBytes(b.length, false);
        this.readBB.get(b, 0, bytesToRead);
        return bytesToRead;
    }

    public int readInternal() throws IOException {
        this.needBytes(1, true);
        return this.readBB.get() & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.dis.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.dis.read(b);
    }

    public byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    public char readChar() throws IOException {
        return this.dis.readChar();
    }

    public double readDouble() throws IOException {
        return this.dis.readDouble();
    }

    public float readFloat() throws IOException {
        return this.dis.readFloat();
    }

    public int readInt() throws IOException {
        return this.dis.readInt();
    }

    public long readLong() throws IOException {
        return this.dis.readLong();
    }

    public short readShort() throws IOException {
        return this.dis.readShort();
    }

    public String readUTF() throws IOException {
        return this.dis.readUTF();
    }

    private int needBytes(int num, boolean fail) throws IOException {
        int ret;
        int bytesToReadIntoCache = num - (this.writeBB.position() - this.readBB.position());
        if (bytesToReadIntoCache > 0) {
            this.readBytesIntoCache(bytesToReadIntoCache);
        }
        if ((ret = this.readBB.remaining()) > num) {
            ret = num;
        }
        if (fail && ret < num) {
            throw new InsufficientBytesException(num, ret);
        }
        return ret;
    }

    private int readBytesIntoCache(int num) throws IOException {
        ByteBuffer in;
        switch (num) {
            case 0: {
                return 0;
            }
            case 1: {
                if (this.one == null) {
                    this.one = ByteBuffer.allocate(num);
                }
                this.one.clear();
                in = this.one;
                break;
            }
            case 2: {
                if (this.two == null) {
                    this.two = ByteBuffer.allocate(num);
                }
                this.two.clear();
                in = this.two;
                break;
            }
            case 4: {
                if (this.four == null) {
                    this.four = ByteBuffer.allocate(num);
                }
                this.four.clear();
                in = this.four;
                break;
            }
            case 8: {
                if (this.eight == null) {
                    this.eight = ByteBuffer.allocate(num);
                }
                this.eight.clear();
                in = this.eight;
                break;
            }
            default: {
                in = ByteBuffer.allocate(num);
            }
        }
        int ret = (int)this.socket.read(in);
        if (ret == -1) {
            throw new ClosedChannelException();
        }
        in.flip();
        while (this.writeBB.remaining() < ret) {
            this.grow();
        }
        this.writeBB.put(in);
        return ret;
    }

    public void clear() throws IOException {
        if (this.cache.length > this.initialSize) {
            this.cache = new byte[this.initialSize];
        }
        this.readBB = ByteBuffer.wrap(this.cache);
        this.writeBB = ByteBuffer.wrap(this.cache);
        this.dis.reset();
    }

    private void grow() {
        byte[] newCache = new byte[this.cache.length];
        System.arraycopy(this.cache, 0, newCache, 0, this.cache.length);
        ByteBuffer newReadBB = ByteBuffer.wrap(newCache);
        ByteBuffer newWriteBB = ByteBuffer.wrap(newCache);
        newReadBB.position(this.readBB.position());
        newWriteBB.position(this.writeBB.position());
        this.cache = newCache;
        this.readBB = newReadBB;
        this.writeBB = newWriteBB;
    }
}

