/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.sourceroute.manager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.sourceroute.SourceRoute;
import rice.environment.Environment;
import rice.environment.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceRouteManagerP2PSocket<Identifier>
implements P2PSocket<Identifier> {
    P2PSocket<SourceRoute<Identifier>> socket;
    Logger logger;

    public SourceRouteManagerP2PSocket(P2PSocket<SourceRoute<Identifier>> socket, Environment env) {
        this.socket = socket;
        this.logger = env.getLogManager().getLogger(SourceRouteManagerP2PSocket.class, null);
    }

    @Override
    public void close() {
        this.socket.close();
    }

    @Override
    public Identifier getIdentifier() {
        return this.socket.getIdentifier().getLastHop();
    }

    @Override
    public long read(ByteBuffer dsts) throws IOException {
        return this.socket.read(dsts);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.socket.read(dsts, offset, length);
    }

    @Override
    public void register(boolean wantToRead, boolean wantToWrite, final P2PSocketReceiver<Identifier> receiver) {
        if (this.logger.level <= 300) {
            this.logger.log(this + "register(" + wantToRead + "," + wantToWrite + "," + receiver + ")");
        }
        this.socket.register(wantToRead, wantToWrite, new P2PSocketReceiver<SourceRoute<Identifier>>(){

            @Override
            public void receiveSelectResult(P2PSocket<SourceRoute<Identifier>> socket, boolean canRead, boolean canWrite) throws IOException {
                if (socket != SourceRouteManagerP2PSocket.this.socket) {
                    throw new IllegalStateException("socket != this.socket" + socket + "," + SourceRouteManagerP2PSocket.this.socket);
                }
                receiver.receiveSelectResult(SourceRouteManagerP2PSocket.this, canRead, canWrite);
            }

            @Override
            public void receiveException(P2PSocket<SourceRoute<Identifier>> socket, IOException e) {
                if (socket != SourceRouteManagerP2PSocket.this.socket) {
                    throw new IllegalStateException("socket != this.socket" + socket + "," + SourceRouteManagerP2PSocket.this.socket);
                }
                receiver.receiveException(SourceRouteManagerP2PSocket.this, e);
            }
        });
    }

    @Override
    public void shutdownOutput() {
        this.socket.shutdownOutput();
    }

    @Override
    public long write(ByteBuffer srcs) throws IOException {
        return this.socket.write(srcs);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.socket.write(srcs, offset, length);
    }

    @Override
    public Map<String, Integer> getOptions() {
        return this.socket.getOptions();
    }

    public String toString() {
        return "SRMSocket(" + this.socket.getIdentifier() + ":" + this.getOptions() + ")";
    }
}

