/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.sourceroute.factory;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.mpisws.p2p.transport.sourceroute.SourceRoute;
import rice.p2p.commonapi.rawserialization.OutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireSourceRoute
extends SourceRoute<InetSocketAddress> {
    WireSourceRoute(InetSocketAddress local, InetSocketAddress remote) {
        super(local, remote);
    }

    WireSourceRoute(List<InetSocketAddress> path) {
        super(path);
    }

    WireSourceRoute(InetSocketAddress address) {
        super(address);
    }

    @Override
    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)this.path.size());
        for (InetSocketAddress i : this.path) {
            buf.write(i.getAddress().getAddress(), 0, 4);
            buf.writeShort((short)i.getPort());
        }
    }

    @Override
    public int getSerializedLength() {
        int ret = 5;
        return ret += this.path.size() * 6;
    }

    List<InetSocketAddress> getPath() {
        return this.path;
    }
}

