/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.peerreview;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.mpisws.p2p.transport.peerreview.Hash;
import org.mpisws.p2p.transport.peerreview.SecureHistory;
import org.mpisws.p2p.transport.util.FileInputBuffer;
import org.mpisws.p2p.transport.util.FileOutputBuffer;
import rice.environment.logging.Logger;
import rice.p2p.commonapi.rawserialization.OutputBuffer;

public class SecureHistoryImpl
implements SecureHistory {
    Logger logger;
    boolean pointerAtEnd;
    IndexEntry topEntry;
    long baseSeq;
    long nextSeq;
    int numEntries;
    File indexFile;
    File dataFile;
    boolean readOnly;
    FileOutputBuffer indexFileWriter;
    FileOutputBuffer dataFileWriter;
    FileInputBuffer indexFileReader;
    FileInputBuffer dataFileReader;

    public SecureHistoryImpl(String baseFileName, boolean readOnly, Logger logger) throws FileNotFoundException {
        this.logger = logger;
        this.readOnly = readOnly;
        this.indexFile = new File(baseFileName + ".index");
        this.dataFile = new File(baseFileName + ".data");
        if (readOnly) {
            if (!this.indexFile.exists()) {
                throw new IllegalArgumentException("File " + this.indexFile + " doesn't exist.");
            }
            if (!this.dataFile.exists()) {
                throw new IllegalArgumentException("File " + this.dataFile + " doesn't exist.");
            }
        }
        this.initializeFileBuffers();
    }

    private void initializeFileBuffers() throws FileNotFoundException {
        this.indexFileReader = new FileInputBuffer(this.indexFile, this.logger);
        this.dataFileReader = new FileInputBuffer(this.dataFile, this.logger);
        if (!this.readOnly) {
            this.indexFileWriter = new FileOutputBuffer(this.indexFile);
            this.dataFileWriter = new FileOutputBuffer(this.dataFile);
        }
    }

    public void reset(long baseSeq, Hash nodeHash) throws IOException {
        if (this.indexFile.exists()) {
            this.indexFile.delete();
        }
        if (this.dataFile.exists()) {
            this.dataFile.delete();
        }
        this.initializeFileBuffers();
        IndexEntry entry = new IndexEntry(baseSeq, 0, 0, -1, null, nodeHash);
        this.writeEntry(entry, this.indexFileWriter);
    }

    private void writeEntry(IndexEntry entry, OutputBuffer fileWriter) throws IOException {
        entry.serialize(fileWriter);
    }

    public long getBaseSeq() {
        return this.baseSeq;
    }

    public long getLastSeq() {
        return this.topEntry.seq;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    class IndexEntry {
        long seq;
        short fileIndex;
        short sizeInFile;
        short type;
        Hash contentHash;
        Hash nodeHash;

        public IndexEntry(long seq, short type, short index, short size, Hash contentHash, Hash nodeHash) {
            this.seq = seq;
            this.type = type;
            this.fileIndex = index;
            this.sizeInFile = size;
            this.contentHash = contentHash;
            this.nodeHash = nodeHash;
        }

        public void serialize(OutputBuffer buf) throws IOException {
            buf.writeLong(this.seq);
            buf.writeInt(this.fileIndex);
            buf.writeInt(this.sizeInFile);
            buf.writeInt(this.type);
            this.contentHash.serialize(buf);
            this.nodeHash.serialize(buf);
        }
    }
}

