/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.multiaddress;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;

public class MultiInetSocketAddress
implements Serializable {
    protected InetSocketAddress[] address;

    public MultiInetSocketAddress(InetSocketAddress address) {
        this(new InetSocketAddress[]{address});
    }

    private MultiInetSocketAddress(InetSocketAddress[] addressList) {
        this.address = addressList;
    }

    public int hashCode() {
        int result = 31173;
        for (int i = 0; i < this.address.length; ++i) {
            result ^= this.address[i].hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof MultiInetSocketAddress)) {
            return false;
        }
        MultiInetSocketAddress that = (MultiInetSocketAddress)o;
        return this.addressEquals(that);
    }

    public boolean addressEquals(MultiInetSocketAddress that) {
        if (this.address.length != that.address.length) {
            return false;
        }
        for (int ctr = 0; ctr < this.address.length; ++ctr) {
            if (this.address[ctr].equals(that.address[ctr])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String s = "";
        for (int ctr = 0; ctr < this.address.length; ++ctr) {
            s = s + this.address[ctr];
            if (ctr >= this.address.length - 1) continue;
            s = s + ":";
        }
        return s;
    }

    public void toStringShort(StringBuffer result) {
        for (int ctr = 0; ctr < this.address.length; ++ctr) {
            InetSocketAddress theAddr = this.address[ctr];
            InetAddress theAddr2 = theAddr.getAddress();
            if (theAddr2 == null) {
                result.append(theAddr.toString());
            } else {
                String ha = theAddr2.getHostAddress();
                result.append(ha + ":" + theAddr.getPort());
            }
            if (ctr >= this.address.length - 1) continue;
            result.append(";");
        }
    }

    public InetSocketAddress getInnermostAddress() {
        return this.address[this.address.length - 1];
    }

    public int getNumAddresses() {
        return this.address.length;
    }

    public InetSocketAddress getAddress(int index) {
        return this.address[index];
    }

    public static MultiInetSocketAddress build(InputBuffer buf) throws IOException {
        int numAddresses = buf.readByte();
        InetSocketAddress[] saddr = new InetSocketAddress[numAddresses];
        for (int ctr = 0; ctr < numAddresses; ++ctr) {
            byte[] addrBytes = new byte[4];
            buf.read(addrBytes);
            InetAddress addr = InetAddress.getByAddress(addrBytes);
            short port = buf.readShort();
            saddr[ctr] = new InetSocketAddress(addr, 0xFFFF & port);
        }
        return new MultiInetSocketAddress(saddr);
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeByte((byte)this.address.length);
        for (int ctr = 0; ctr < this.address.length; ++ctr) {
            buf.write(this.address[ctr].getAddress().getAddress(), 0, 4);
            buf.writeShort((short)this.address[ctr].getPort());
        }
    }

    public short getSerializedLength() {
        return (short)(9 + this.address.length * 6);
    }
}

