/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.multiaddress;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.multiaddress.AddressStrategy;
import org.mpisws.p2p.transport.multiaddress.MultiInetAddressTransportLayer;
import org.mpisws.p2p.transport.multiaddress.MultiInetSocketAddress;
import org.mpisws.p2p.transport.multiaddress.SimpleAddressStrategy;
import org.mpisws.p2p.transport.util.DefaultCallback;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.util.InsufficientBytesException;
import org.mpisws.p2p.transport.util.MessageRequestHandleImpl;
import org.mpisws.p2p.transport.util.SocketInputBuffer;
import org.mpisws.p2p.transport.util.SocketRequestHandleImpl;
import org.mpisws.p2p.transport.util.SocketWrapperSocket;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.p2p.util.rawserialization.SimpleInputBuffer;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiInetAddressTransportLayerImpl
implements MultiInetAddressTransportLayer,
TransportLayerCallback<InetSocketAddress, ByteBuffer> {
    int MAX_NUM_ADDRESSES;
    TransportLayer<InetSocketAddress, ByteBuffer> wire;
    MultiInetSocketAddress localAddress;
    TransportLayerCallback<MultiInetSocketAddress, ByteBuffer> callback;
    ErrorHandler<MultiInetSocketAddress> errorHandler;
    Logger logger;
    AddressStrategy strategy;
    private boolean sendIdentifier = true;

    public MultiInetAddressTransportLayerImpl(MultiInetSocketAddress localAddress, TransportLayer<InetSocketAddress, ByteBuffer> wire, Environment env, ErrorHandler<MultiInetSocketAddress> handler, AddressStrategy strategy) {
        this.logger = env.getLogManager().getLogger(MultiInetAddressTransportLayerImpl.class, null);
        this.wire = wire;
        this.errorHandler = handler;
        this.localAddress = localAddress;
        this.strategy = strategy;
        this.MAX_NUM_ADDRESSES = env.getParameters().getInt("transport_epoch_max_num_addresses");
        if (wire == null) {
            throw new IllegalArgumentException("TransportLayer<InetSocketAddress, ByteBuffer> wire must be non-null");
        }
        if (localAddress == null) {
            throw new IllegalArgumentException("EpochInetSocketAddress localAddress must be non-null");
        }
        this.callback = new DefaultCallback<MultiInetSocketAddress, ByteBuffer>(env);
        if (this.errorHandler == null) {
            this.errorHandler = new DefaultErrorHandler<MultiInetSocketAddress>(this.logger);
        }
        if (this.strategy == null) {
            this.strategy = new SimpleAddressStrategy(localAddress);
        }
        wire.setCallback(this);
    }

    @Override
    public SocketRequestHandle<MultiInetSocketAddress> openSocket(final MultiInetSocketAddress i, final SocketCallback<MultiInetSocketAddress> deliverSocketToMe, Map<String, Integer> options) {
        if (deliverSocketToMe == null) {
            throw new IllegalArgumentException("deliverSocketToMe must be non-null!");
        }
        final SocketRequestHandleImpl<MultiInetSocketAddress> handle = new SocketRequestHandleImpl<MultiInetSocketAddress>(i, options);
        if (this.logger.level <= 500) {
            this.logger.log("openSocket(" + i + ")");
        }
        SimpleOutputBuffer sob = new SimpleOutputBuffer(this.localAddress.getSerializedLength());
        try {
            this.localAddress.serialize(sob);
        }
        catch (IOException ioe) {
            deliverSocketToMe.receiveException(handle, ioe);
            return null;
        }
        final ByteBuffer b = this.sendIdentifier ? ByteBuffer.wrap(sob.getBytes()) : null;
        InetSocketAddress addr = this.strategy.getAddress(i);
        handle.setSubCancellable(this.wire.openSocket(addr, new SocketCallback<InetSocketAddress>(){

            @Override
            public void receiveResult(SocketRequestHandle<InetSocketAddress> c, P2PSocket<InetSocketAddress> result) {
                if (c != handle.getSubCancellable()) {
                    throw new RuntimeException("c != cancellable.getSubCancellable() (indicates a bug in the code) c:" + c + " sub:" + handle.getSubCancellable());
                }
                if (MultiInetAddressTransportLayerImpl.this.logger.level <= 400) {
                    MultiInetAddressTransportLayerImpl.this.logger.log("openSocket(" + i + "):receiveResult(" + result + ")");
                }
                if (MultiInetAddressTransportLayerImpl.this.sendIdentifier) {
                    result.register(false, true, new P2PSocketReceiver<InetSocketAddress>(){

                        @Override
                        public void receiveSelectResult(P2PSocket<InetSocketAddress> socket, boolean canRead, boolean canWrite) throws IOException {
                            if (canRead || !canWrite) {
                                throw new IOException("Expected to write! " + canRead + "," + canWrite);
                            }
                            socket.write(b);
                            if (b.hasRemaining()) {
                                socket.register(false, true, this);
                            } else {
                                deliverSocketToMe.receiveResult(handle, new SocketWrapperSocket<MultiInetSocketAddress, InetSocketAddress>(i, socket, MultiInetAddressTransportLayerImpl.this.logger, socket.getOptions()));
                            }
                        }

                        @Override
                        public void receiveException(P2PSocket<InetSocketAddress> socket, IOException e) {
                            deliverSocketToMe.receiveException(handle, e);
                        }
                    });
                } else {
                    deliverSocketToMe.receiveResult(handle, new SocketWrapperSocket<MultiInetSocketAddress, InetSocketAddress>(i, result, MultiInetAddressTransportLayerImpl.this.logger, result.getOptions()));
                }
            }

            @Override
            public void receiveException(SocketRequestHandle<InetSocketAddress> c, IOException exception) {
                if (c != handle.getSubCancellable()) {
                    throw new RuntimeException("c != cancellable.getSubCancellable() (indicates a bug in the code) c:" + c + " sub:" + handle.getSubCancellable());
                }
                deliverSocketToMe.receiveException(handle, exception);
            }
        }, options));
        return handle;
    }

    @Override
    public void incomingSocket(P2PSocket<InetSocketAddress> s) throws IOException {
        if (this.logger.level <= 500) {
            this.logger.log("incomingSocket(" + s + "):" + this.sendIdentifier);
        }
        if (this.sendIdentifier) {
            final SocketInputBuffer sib = new SocketInputBuffer(s, 1024);
            s.register(true, false, new P2PSocketReceiver<InetSocketAddress>(){

                @Override
                public void receiveSelectResult(P2PSocket<InetSocketAddress> socket, boolean canRead, boolean canWrite) throws IOException {
                    if (MultiInetAddressTransportLayerImpl.this.logger.level <= 400) {
                        MultiInetAddressTransportLayerImpl.this.logger.log("incomingSocket(" + socket + "):receiveSelectResult()");
                    }
                    if (canWrite || !canRead) {
                        throw new IOException("Expected to read! " + canRead + "," + canWrite);
                    }
                    try {
                        MultiInetSocketAddress eisa = MultiInetSocketAddress.build(sib);
                        if (MultiInetAddressTransportLayerImpl.this.logger.level <= 300) {
                            MultiInetAddressTransportLayerImpl.this.logger.log("Read " + eisa);
                        }
                        MultiInetAddressTransportLayerImpl.this.callback.incomingSocket(new SocketWrapperSocket<MultiInetSocketAddress, InetSocketAddress>(eisa, socket, MultiInetAddressTransportLayerImpl.this.logger, socket.getOptions()));
                    }
                    catch (InsufficientBytesException ibe) {
                        socket.register(true, false, this);
                    }
                    catch (IOException e) {
                        MultiInetAddressTransportLayerImpl.this.errorHandler.receivedException(new MultiInetSocketAddress(socket.getIdentifier()), e);
                    }
                }

                @Override
                public void receiveException(P2PSocket<InetSocketAddress> socket, IOException e) {
                    MultiInetAddressTransportLayerImpl.this.errorHandler.receivedException(new MultiInetSocketAddress(socket.getIdentifier()), e);
                }
            });
        } else {
            this.callback.incomingSocket(new SocketWrapperSocket<MultiInetSocketAddress, InetSocketAddress>(new MultiInetSocketAddress(s.getIdentifier()), s, this.logger, s.getOptions()));
        }
    }

    @Override
    public MessageRequestHandle<MultiInetSocketAddress, ByteBuffer> sendMessage(final MultiInetSocketAddress i, ByteBuffer m, final MessageCallback<MultiInetSocketAddress, ByteBuffer> deliverAckToMe, Map<String, Integer> options) {
        ByteBuffer buf;
        if (this.logger.level <= 500) {
            this.logger.log("sendMessage(" + i + "," + m + ")");
        }
        final MessageRequestHandleImpl<MultiInetSocketAddress, ByteBuffer> handle = new MessageRequestHandleImpl<MultiInetSocketAddress, ByteBuffer>(i, m, options);
        if (this.sendIdentifier) {
            SimpleOutputBuffer sob = new SimpleOutputBuffer(m.remaining() + this.localAddress.getSerializedLength());
            try {
                this.localAddress.serialize(sob);
                sob.write(m.array(), m.position(), m.remaining());
            }
            catch (IOException ioe) {
                if (deliverAckToMe == null) {
                    this.errorHandler.receivedException(i, ioe);
                } else {
                    deliverAckToMe.sendFailed(handle, ioe);
                }
                return handle;
            }
            buf = ByteBuffer.wrap(sob.getBytes());
        } else {
            buf = m;
        }
        handle.setSubCancellable(this.wire.sendMessage(this.strategy.getAddress(i), buf, new MessageCallback<InetSocketAddress, ByteBuffer>(){

            @Override
            public void ack(MessageRequestHandle<InetSocketAddress, ByteBuffer> msg) {
                if (handle.getSubCancellable() != null && msg != handle.getSubCancellable()) {
                    throw new RuntimeException("msg != cancellable.getSubCancellable() (indicates a bug in the code) msg:" + msg + " sub:" + handle.getSubCancellable());
                }
                if (deliverAckToMe != null) {
                    deliverAckToMe.ack(handle);
                }
            }

            @Override
            public void sendFailed(MessageRequestHandle<InetSocketAddress, ByteBuffer> msg, IOException ex) {
                if (handle.getSubCancellable() != null && msg != handle.getSubCancellable()) {
                    throw new RuntimeException("msg != cancellable.getSubCancellable() (indicates a bug in the code) msg:" + msg + " sub:" + handle.getSubCancellable());
                }
                if (deliverAckToMe == null) {
                    MultiInetAddressTransportLayerImpl.this.errorHandler.receivedException(i, ex);
                } else {
                    deliverAckToMe.sendFailed(handle, ex);
                }
            }
        }, options));
        return handle;
    }

    @Override
    public void messageReceived(InetSocketAddress i, ByteBuffer m, Map<String, Integer> options) throws IOException {
        if (this.logger.level <= 500) {
            this.logger.log("messageReceived(" + i + "," + m + ")");
        }
        if (this.sendIdentifier) {
            MultiInetSocketAddress eisa;
            int pos = m.position();
            SimpleInputBuffer sib = new SimpleInputBuffer(m.array(), pos);
            try {
                eisa = MultiInetSocketAddress.build(sib);
            }
            catch (IOException ioe) {
                this.errorHandler.receivedUnexpectedData(new MultiInetSocketAddress(i), m.array(), pos, null);
                return;
            }
            m.position(m.array().length - sib.bytesRemaining());
            this.callback.messageReceived(eisa, m, options);
        } else {
            this.callback.messageReceived(new MultiInetSocketAddress(i), m, options);
        }
    }

    @Override
    public MultiInetSocketAddress getLocalIdentifier() {
        return this.localAddress;
    }

    @Override
    public void acceptMessages(boolean b) {
        this.wire.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.wire.acceptSockets(b);
    }

    @Override
    public void destroy() {
        this.wire.destroy();
    }

    @Override
    public void setCallback(TransportLayerCallback<MultiInetSocketAddress, ByteBuffer> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<MultiInetSocketAddress> handler) {
        this.errorHandler = handler;
    }

    public void setSendIdentifier(boolean sendIdentifier) {
        this.sendIdentifier = sendIdentifier;
    }

    public boolean isSendIdentifier() {
        return this.sendIdentifier;
    }
}

