/*
 * Decompiled with CFR 0.152.
 */
package org.mpisws.p2p.transport.liveness;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.mpisws.p2p.transport.ErrorHandler;
import org.mpisws.p2p.transport.MessageCallback;
import org.mpisws.p2p.transport.MessageRequestHandle;
import org.mpisws.p2p.transport.P2PSocket;
import org.mpisws.p2p.transport.P2PSocketReceiver;
import org.mpisws.p2p.transport.SocketCallback;
import org.mpisws.p2p.transport.SocketRequestHandle;
import org.mpisws.p2p.transport.TransportLayer;
import org.mpisws.p2p.transport.TransportLayerCallback;
import org.mpisws.p2p.transport.exception.NodeIsFaultyException;
import org.mpisws.p2p.transport.liveness.LivenessListener;
import org.mpisws.p2p.transport.liveness.LivenessTransportLayer;
import org.mpisws.p2p.transport.liveness.PingListener;
import org.mpisws.p2p.transport.liveness.PingMessage;
import org.mpisws.p2p.transport.liveness.PongMessage;
import org.mpisws.p2p.transport.util.DefaultErrorHandler;
import org.mpisws.p2p.transport.util.MessageRequestHandleImpl;
import org.mpisws.p2p.transport.util.SocketWrapperSocket;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.environment.time.TimeSource;
import rice.p2p.util.rawserialization.SimpleOutputBuffer;
import rice.selector.Timer;
import rice.selector.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LivenessTransportLayerImpl<Identifier>
implements LivenessTransportLayer<Identifier, ByteBuffer>,
TransportLayerCallback<Identifier, ByteBuffer> {
    public final int PING_DELAY;
    public final float PING_JITTER;
    public final int NUM_PING_TRIES;
    public final long BACKOFF_INITIAL;
    public final int BACKOFF_LIMIT;
    public long CHECK_DEAD_THROTTLE;
    public int DEFAULT_RTO;
    int RTO_UBOUND;
    int RTO_LBOUND;
    double gainH;
    double gainG;
    protected TransportLayer<Identifier, ByteBuffer> tl;
    protected Logger logger;
    protected Environment environment;
    protected TimeSource time;
    protected Timer timer;
    protected Random random;
    public static final byte HDR_NORMAL = 0;
    public static final byte HDR_PING = 1;
    public static final byte HDR_PONG = 2;
    Map<Identifier, EntityManager> managers;
    private TransportLayerCallback<Identifier, ByteBuffer> callback;
    private ErrorHandler<Identifier> errorHandler;
    boolean connectionExceptionMeansFaulty = true;
    List<LivenessListener<Identifier>> livenessListeners;
    List<PingListener<Identifier>> pingListeners;

    public LivenessTransportLayerImpl(TransportLayer<Identifier, ByteBuffer> tl, Environment env, ErrorHandler<Identifier> errorHandler, int checkDeadThrottle) {
        this.tl = tl;
        this.environment = env;
        this.logger = env.getLogManager().getLogger(LivenessTransportLayerImpl.class, null);
        this.time = env.getTimeSource();
        this.timer = env.getSelectorManager().getTimer();
        this.random = new Random();
        this.livenessListeners = new ArrayList<LivenessListener<Identifier>>();
        this.pingListeners = new ArrayList<PingListener<Identifier>>();
        this.managers = new HashMap<Identifier, EntityManager>();
        Parameters p = env.getParameters();
        this.PING_DELAY = p.getInt("pastry_socket_scm_ping_delay");
        this.PING_JITTER = p.getFloat("pastry_socket_scm_ping_jitter");
        this.NUM_PING_TRIES = p.getInt("pastry_socket_scm_num_ping_tries");
        this.BACKOFF_INITIAL = p.getInt("pastry_socket_scm_backoff_initial");
        this.BACKOFF_LIMIT = p.getInt("pastry_socket_scm_backoff_limit");
        this.CHECK_DEAD_THROTTLE = checkDeadThrottle;
        this.DEFAULT_RTO = p.getInt("pastry_socket_srm_default_rto");
        this.RTO_UBOUND = p.getInt("pastry_socket_srm_rto_ubound");
        this.RTO_LBOUND = p.getInt("pastry_socket_srm_rto_lbound");
        this.gainH = p.getDouble("pastry_socket_srm_gain_h");
        this.gainG = p.getDouble("pastry_socket_srm_gain_g");
        tl.setCallback(this);
        this.errorHandler = errorHandler;
        if (this.errorHandler == null) {
            this.errorHandler = new DefaultErrorHandler(this.logger);
        }
    }

    @Override
    public void clearState(Identifier i) {
        if (this.logger.level <= 500) {
            this.logger.log("clearState(" + i + ")");
        }
        this.deleteManager(i);
    }

    @Override
    public boolean checkLiveness(Identifier i, Map<String, Integer> options) {
        return this.getManager(i).checkLiveness(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManager getManager(Identifier i) {
        Map<Identifier, EntityManager> map = this.managers;
        synchronized (map) {
            EntityManager manager = this.managers.get(i);
            if (manager == null) {
                manager = new EntityManager(i);
                this.managers.put(i, manager);
            }
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManager deleteManager(Identifier i) {
        Map<Identifier, EntityManager> map = this.managers;
        synchronized (map) {
            EntityManager manager = this.managers.remove(i);
            if (manager.pending != null) {
                manager.pending.cancel();
            }
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLiveness(Identifier i, Map<String, Integer> options) {
        if (this.logger.level <= 500) {
            this.logger.log("getLiveness(" + i + "," + options + ")");
        }
        Map<Identifier, EntityManager> map = this.managers;
        synchronized (map) {
            if (this.managers.containsKey(i)) {
                return this.managers.get(i).liveness;
            }
        }
        return 2;
    }

    @Override
    public void acceptMessages(boolean b) {
        this.tl.acceptMessages(b);
    }

    @Override
    public void acceptSockets(boolean b) {
        this.tl.acceptSockets(b);
    }

    @Override
    public Identifier getLocalIdentifier() {
        return this.tl.getLocalIdentifier();
    }

    public void connectionExceptionMeansFaulty(boolean b) {
        this.connectionExceptionMeansFaulty = b;
    }

    @Override
    public SocketRequestHandle<Identifier> openSocket(final Identifier i, final SocketCallback<Identifier> deliverSocketToMe, final Map<String, Integer> options) {
        return this.tl.openSocket(i, new SocketCallback<Identifier>(){

            @Override
            public void receiveException(SocketRequestHandle<Identifier> s, IOException ex) {
                if (LivenessTransportLayerImpl.this.connectionExceptionMeansFaulty) {
                    if (LivenessTransportLayerImpl.this.logger.level <= 500) {
                        LivenessTransportLayerImpl.this.logger.logException("Marking " + s + " dead due to exception opening socket.", ex);
                    }
                    LivenessTransportLayerImpl.this.getManager(i).markDead(options);
                }
                deliverSocketToMe.receiveException(s, ex);
            }

            @Override
            public void receiveResult(SocketRequestHandle<Identifier> cancellable, P2PSocket<Identifier> sock) {
                deliverSocketToMe.receiveResult(cancellable, new LSocket(LivenessTransportLayerImpl.this.getManager(i), sock));
            }
        }, options);
    }

    @Override
    public MessageRequestHandle<Identifier, ByteBuffer> sendMessage(final Identifier i, ByteBuffer m, final MessageCallback<Identifier, ByteBuffer> deliverAckToMe, Map<String, Integer> options) {
        final MessageRequestHandleImpl<Identifier, ByteBuffer> handle = new MessageRequestHandleImpl<Identifier, ByteBuffer>(i, m, options);
        EntityManager mgr = this.getManager(i);
        if (mgr != null && mgr.liveness >= 3) {
            if (deliverAckToMe != null) {
                deliverAckToMe.sendFailed(handle, new NodeIsFaultyException(i, m));
            }
            return handle;
        }
        byte[] msgBytes = new byte[m.remaining() + 1];
        msgBytes[0] = 0;
        m.get(msgBytes, 1, m.remaining());
        ByteBuffer myMsg = ByteBuffer.wrap(msgBytes);
        handle.setSubCancellable(this.tl.sendMessage(i, myMsg, new MessageCallback<Identifier, ByteBuffer>(){

            @Override
            public void ack(MessageRequestHandle<Identifier, ByteBuffer> msg) {
                if (handle.getSubCancellable() != null && msg != handle.getSubCancellable()) {
                    throw new RuntimeException("msg != handle.getSubCancelable() (indicates a bug in the code) msg:" + msg + " sub:" + handle.getSubCancellable());
                }
                if (deliverAckToMe != null) {
                    deliverAckToMe.ack(handle);
                }
            }

            @Override
            public void sendFailed(MessageRequestHandle<Identifier, ByteBuffer> msg, IOException ex) {
                if (handle.getSubCancellable() != null && msg != handle.getSubCancellable()) {
                    throw new RuntimeException("msg != handle.getSubCancelable() (indicates a bug in the code) msg:" + msg + " sub:" + handle.getSubCancellable());
                }
                if (deliverAckToMe == null) {
                    LivenessTransportLayerImpl.this.errorHandler.receivedException(i, ex);
                } else {
                    deliverAckToMe.sendFailed(handle, ex);
                }
            }
        }, options));
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(Identifier i, ByteBuffer m, Map<String, Integer> options) throws IOException {
        byte hdr = m.get();
        switch (hdr) {
            case 0: {
                if (this.logger.level <= 300) {
                    this.logger.log("messageReceived(" + i + "," + m + ")");
                }
                this.callback.messageReceived(i, m, options);
                return;
            }
            case 1: {
                if (this.logger.level <= 300) {
                    this.logger.log("messageReceived(" + i + ", PING)");
                }
                this.pong(i, m.getLong());
                this.notifyPingListenersPing(i);
                return;
            }
            case 2: {
                if (this.logger.level <= 300) {
                    this.logger.log("messageReceived(" + i + ", PONG)");
                }
                EntityManager manager = this.getManager(i);
                long sendTime = m.getLong();
                int rtt = (int)(this.time.currentTimeMillis() - sendTime);
                manager.updateRTO(rtt);
                if (manager != null) {
                    EntityManager entityManager = manager;
                    synchronized (entityManager) {
                        if (manager.pending != null) {
                            manager.pending.pingResponse(sendTime, options);
                        }
                    }
                } else {
                    this.errorHandler.receivedUnexpectedData(i, m.array(), 0, null);
                }
                this.notifyPingListenersPong(i, rtt);
                return;
            }
        }
        this.errorHandler.receivedUnexpectedData(i, m.array(), 0, null);
    }

    @Override
    public boolean ping(Identifier i, Map<String, Integer> options) {
        if (this.logger.level <= 400) {
            this.logger.log("ping(" + i + ")");
        }
        if (i.equals(this.tl.getLocalIdentifier())) {
            return false;
        }
        try {
            SimpleOutputBuffer sob = new SimpleOutputBuffer(1024);
            sob.writeByte((byte)1);
            new PingMessage(this.time.currentTimeMillis()).serialize(sob);
            this.tl.sendMessage(i, ByteBuffer.wrap(sob.getBytes()), null, options);
            return true;
        }
        catch (IOException ioe) {
            this.errorHandler.receivedException(i, ioe);
            return false;
        }
    }

    public void pong(Identifier i, long senderTime) {
        if (this.logger.level <= 300) {
            this.logger.log("pong(" + i + "," + senderTime + ")");
        }
        try {
            SimpleOutputBuffer sob = new SimpleOutputBuffer(1024);
            sob.writeByte((byte)2);
            new PongMessage(senderTime).serialize(sob);
            this.tl.sendMessage(i, ByteBuffer.wrap(sob.getBytes()), null, null);
        }
        catch (IOException ioe) {
            this.errorHandler.receivedException(i, ioe);
        }
    }

    @Override
    public void setCallback(TransportLayerCallback<Identifier, ByteBuffer> callback) {
        this.callback = callback;
    }

    @Override
    public void setErrorHandler(ErrorHandler<Identifier> handler) {
        this.errorHandler = this.errorHandler = handler;
        if (this.errorHandler == null) {
            this.errorHandler = new DefaultErrorHandler(this.logger);
        }
    }

    @Override
    public void destroy() {
        if (this.logger.level <= 800) {
            this.logger.log("destroy()");
        }
        this.tl.destroy();
        this.livenessListeners.clear();
        this.livenessListeners = null;
        this.pingListeners.clear();
        this.pingListeners = null;
        for (EntityManager em : this.managers.values()) {
            em.destroy();
        }
        this.managers.clear();
        this.managers = null;
    }

    @Override
    public void incomingSocket(P2PSocket<Identifier> s) throws IOException {
        this.callback.incomingSocket(new LSocket(this.getManager(s.getIdentifier()), s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLivenessListener(LivenessListener<Identifier> name) {
        List<LivenessListener<Identifier>> list = this.livenessListeners;
        synchronized (list) {
            this.livenessListeners.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLivenessListener(LivenessListener<Identifier> name) {
        List<LivenessListener<Identifier>> list = this.livenessListeners;
        synchronized (list) {
            return this.livenessListeners.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLivenessListeners(Identifier i, int liveness, Map<String, Integer> options) {
        ArrayList<LivenessListener<Identifier>> temp;
        if (this.logger.level <= 400) {
            this.logger.log("notifyLivenessListeners(" + i + "," + liveness + ")");
        }
        List<LivenessListener<Identifier>> list = this.livenessListeners;
        synchronized (list) {
            temp = new ArrayList<LivenessListener<Identifier>>(this.livenessListeners);
        }
        for (LivenessListener livenessListener : temp) {
            livenessListener.livenessChanged(i, liveness, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPingListener(PingListener<Identifier> name) {
        List<PingListener<Identifier>> list = this.pingListeners;
        synchronized (list) {
            this.pingListeners.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removePingListener(PingListener<Identifier> name) {
        List<PingListener<Identifier>> list = this.pingListeners;
        synchronized (list) {
            return this.pingListeners.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPingListenersPing(Identifier i) {
        ArrayList<PingListener<Identifier>> temp;
        List<PingListener<Identifier>> list = this.pingListeners;
        synchronized (list) {
            temp = new ArrayList<PingListener<Identifier>>(this.pingListeners);
        }
        for (PingListener pingListener : temp) {
            pingListener.pingReceived(i, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPingListenersPong(Identifier i, int rtt) {
        ArrayList<PingListener<Identifier>> temp;
        List<PingListener<Identifier>> list = this.pingListeners;
        synchronized (list) {
            temp = new ArrayList<PingListener<Identifier>>(this.pingListeners);
        }
        for (PingListener pingListener : temp) {
            pingListener.pingResponse(i, rtt, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LSocket
    extends SocketWrapperSocket<Identifier, Identifier> {
        EntityManager manager;
        TimerTask livenessCheckerTimer;

        public LSocket(EntityManager manager, P2PSocket<Identifier> socket) {
            super(socket.getIdentifier(), socket, LivenessTransportLayerImpl.this.logger, socket.getOptions());
            this.manager = manager;
        }

        @Override
        public void register(boolean wantToRead, boolean wantToWrite, final P2PSocketReceiver<Identifier> receiver) {
            if (wantToWrite) {
                this.startLivenessCheckerTimer();
            }
            super.register(wantToRead, wantToWrite, new P2PSocketReceiver<Identifier>(){

                @Override
                public void receiveException(P2PSocket<Identifier> socket, IOException ioe) {
                    receiver.receiveException(socket, ioe);
                }

                @Override
                public void receiveSelectResult(P2PSocket<Identifier> socket, boolean canRead, boolean canWrite) throws IOException {
                    if (canWrite) {
                        LSocket.this.stopLivenessCheckerTimer();
                    }
                    receiver.receiveSelectResult(socket, canRead, canWrite);
                }
            });
        }

        public void startLivenessCheckerTimer() {
            this.stopLivenessCheckerTimer();
            this.livenessCheckerTimer = new TimerTask(){

                public void run() {
                    LSocket.this.manager.checkLiveness(LSocket.this.options);
                }
            };
            LivenessTransportLayerImpl.this.timer.schedule(this.livenessCheckerTimer, this.manager.rto() * 4);
        }

        public void stopLivenessCheckerTimer() {
            if (this.livenessCheckerTimer != null) {
                this.livenessCheckerTimer.cancel();
            }
            this.livenessCheckerTimer = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntityManager {
        int RTO;
        double RTT;
        double standardD;
        protected Identifier identifier;
        protected int liveness;
        protected long updated;
        protected DeadChecker pending;
        long start;
        int ctr;

        public EntityManager(Identifier identifier) {
            this.RTO = LivenessTransportLayerImpl.this.DEFAULT_RTO;
            this.RTT = 0.0;
            this.standardD = (double)this.RTO / 4.0;
            this.start = 0L;
            this.ctr = 0;
            if (identifier == null) {
                throw new IllegalArgumentException("identifier is null");
            }
            this.identifier = identifier;
            this.liveness = 2;
            this.pending = null;
            this.updated = 0L;
        }

        public int rto() {
            return this.RTO;
        }

        protected void markAlive(Map<String, Integer> options) {
            boolean notify = false;
            if (this.liveness != 1) {
                notify = true;
            }
            this.liveness = 1;
            if (notify) {
                LivenessTransportLayerImpl.this.notifyLivenessListeners(this.identifier, this.liveness, options);
            }
        }

        protected void markSuspected(Map<String, Integer> options) {
            boolean notify = false;
            if (this.liveness != 2) {
                notify = true;
            }
            this.liveness = 2;
            if (notify) {
                if (LivenessTransportLayerImpl.this.logger.level <= 500) {
                    LivenessTransportLayerImpl.this.logger.log(this + ".markSuspected() notify = true");
                }
                LivenessTransportLayerImpl.this.notifyLivenessListeners(this.identifier, this.liveness, options);
            }
        }

        protected void markDead(Map<String, Integer> options) {
            boolean notify = false;
            if (this.liveness != 3) {
                notify = true;
            }
            if (LivenessTransportLayerImpl.this.logger.level <= 400) {
                LivenessTransportLayerImpl.this.logger.log(this + ".markDead() notify:" + notify);
            }
            this.liveness = 3;
            if (this.pending != null) {
                this.pending.cancel();
            }
            if (notify) {
                LivenessTransportLayerImpl.this.notifyLivenessListeners(this.identifier, this.liveness, options);
            }
        }

        private void updateRTO(long m) {
            if (m < 0L) {
                throw new IllegalArgumentException("rtt must be >= 0, was:" + m);
            }
            double err = (double)m - this.RTT;
            double absErr = err;
            if (absErr < 0.0) {
                absErr *= -1.0;
            }
            this.RTT += LivenessTransportLayerImpl.this.gainG * err;
            this.standardD += LivenessTransportLayerImpl.this.gainH * (absErr - this.standardD);
            this.RTO = (int)(this.RTT + 4.0 * this.standardD);
            if (this.RTO > LivenessTransportLayerImpl.this.RTO_UBOUND) {
                this.RTO = LivenessTransportLayerImpl.this.RTO_UBOUND;
            }
            if (this.RTO < LivenessTransportLayerImpl.this.RTO_LBOUND) {
                this.RTO = LivenessTransportLayerImpl.this.RTO_LBOUND;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean checkLiveness(Map<String, Integer> options) {
            if (LivenessTransportLayerImpl.this.logger.level <= 400) {
                LivenessTransportLayerImpl.this.logger.log(this + ".checkLiveness()");
            }
            ++this.ctr;
            if (this.ctr % 100 == 0) {
                this.ctr = 0;
                long time_now = LivenessTransportLayerImpl.this.time.currentTimeMillis();
                if (time_now - this.start < 1000L) {
                    LivenessTransportLayerImpl.this.logger.logException("great scotts! " + this.start + " " + this + " " + this.liveness, new Exception("Stack Trace"));
                    System.exit(1);
                }
                this.start = time_now;
            }
            boolean ret = false;
            int rto = LivenessTransportLayerImpl.this.DEFAULT_RTO;
            EntityManager entityManager = this;
            synchronized (entityManager) {
                if (this.pending != null) {
                    return true;
                }
                long now = LivenessTransportLayerImpl.this.time.currentTimeMillis();
                if (this.liveness < 3 || this.updated < now - LivenessTransportLayerImpl.this.CHECK_DEAD_THROTTLE) {
                    this.updated = now;
                    rto = this.rto();
                    this.pending = new DeadChecker(this, LivenessTransportLayerImpl.this.NUM_PING_TRIES, rto, options);
                    ret = true;
                } else if (LivenessTransportLayerImpl.this.logger.level <= 500) {
                    LivenessTransportLayerImpl.this.logger.log(this + ".checkLiveness() not checking " + this.identifier + " checked to recently, can't check for " + (this.updated + LivenessTransportLayerImpl.this.CHECK_DEAD_THROTTLE - now) + " millis.");
                }
            }
            if (ret) {
                LivenessTransportLayerImpl.this.timer.schedule(this.pending, rto);
                LivenessTransportLayerImpl.this.ping(this.identifier, options);
            }
            return ret;
        }

        public String toString() {
            return this.identifier.toString();
        }

        public void destroy() {
            if (this.pending != null) {
                this.pending.cancel();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DeadChecker
    extends TimerTask {
        protected int tries = 1;
        protected int numTries;
        protected EntityManager manager;
        long startTime;
        int initialDelay;
        Map<String, Integer> options;

        public DeadChecker(EntityManager manager, int numTries, int initialDelay, Map<String, Integer> options) {
            if (LivenessTransportLayerImpl.this.logger.level <= 500) {
                LivenessTransportLayerImpl.this.logger.log("CHECKING DEATH OF PATH " + manager.identifier + " rto:" + initialDelay + " options:" + options);
            }
            this.manager = manager;
            this.numTries = numTries;
            this.options = options;
            this.initialDelay = initialDelay;
            this.startTime = LivenessTransportLayerImpl.this.time.currentTimeMillis();
        }

        public void pingResponse(long RTT, Map<String, Integer> options) {
            if (!this.cancelled && this.tries > 1) {
                long delay = LivenessTransportLayerImpl.this.time.currentTimeMillis() - this.startTime;
                if (LivenessTransportLayerImpl.this.logger.level <= 800) {
                    LivenessTransportLayerImpl.this.logger.log("DeadChecker.pingResponse(" + this.manager.identifier + ") tries=" + this.tries + " estimated=" + this.initialDelay + " totalDelay=" + delay);
                }
            }
            if (LivenessTransportLayerImpl.this.logger.level <= 500) {
                LivenessTransportLayerImpl.this.logger.log("Terminated DeadChecker(" + this.manager.identifier + ") due to ping.");
            }
            this.manager.markAlive(options);
            this.cancel();
        }

        @Override
        public void run() {
            if (this.tries < this.numTries) {
                ++this.tries;
                this.manager.markSuspected(this.options);
                LivenessTransportLayerImpl.this.ping(this.manager.identifier, this.options);
                int absPD = (int)((double)LivenessTransportLayerImpl.this.PING_DELAY * Math.pow(2.0, this.tries - 1));
                int jitterAmt = (int)((float)absPD * LivenessTransportLayerImpl.this.PING_JITTER);
                int scheduledTime = absPD - jitterAmt + LivenessTransportLayerImpl.this.random.nextInt(jitterAmt * 2);
                LivenessTransportLayerImpl.this.timer.schedule(this, scheduledTime);
            } else {
                if (LivenessTransportLayerImpl.this.logger.level <= 500) {
                    LivenessTransportLayerImpl.this.logger.log("DeadChecker(" + this.manager.identifier + ") expired - marking as dead.");
                }
                this.manager.markDead(this.options);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            EntityManager entityManager = this.manager;
            synchronized (entityManager) {
                this.manager.pending = null;
            }
            return super.cancel();
        }

        public String toString() {
            return "DeadChecker(" + this.manager.identifier + " #" + System.identityHashCode(this) + "):" + this.tries + "/" + this.numTries;
        }
    }
}

